
"""
    DragonPy - Dragon 64 Memory Info
    ================================

    information from:
        https://github.com/6809/rom-info

    :copyleft: 2014 by the DragonPy team, see AUTHORS for more details.
    :license: GNU GPL v3 or above, see LICENSE for more details.
"""

from __future__ import absolute_import, division, print_function


from MC6809.core.memory_info import BaseMemoryInfo
from dragonpy.utils.humanize import nice_hex
import logging

log=logging.getLogger(__name__)


class Dragon64MemInfo(BaseMemoryInfo):
    MEM_INFO = (
        (0x0151, 0x0151, "Keyboard matrix state PB0"),
        (0x0152, 0x0152, "Keyboard matrix state PB1"),
        (0x0153, 0x0153, "Keyboard matrix state PB2"),
        (0x0154, 0x0154, "Keyboard matrix state PB3"),
        (0x0155, 0x0155, "Keyboard matrix state PB4"),
        (0x0156, 0x0156, "Keyboard matrix state PB5"),
        (0x0157, 0x0157, "Keyboard matrix state PB6"),
        (0x0158, 0x0158, "Keyboard matrix state PB7"),
        (0x0159, 0x0159, "Keyboard matrix state PB8"),
        (0x8000, 0x8012, "standard JMP vectors"),
        (0x8000, 0x8012, "hardware routines"),
        (0x8000, 0x8000, "reset"),
        (0x8003, 0x8003, "set up $8f - $9b"),
        (0x8006, 0x8006, "scan keyboard (A)"),
        (0x8009, 0x8009, "blink cursor"),
        (0x800c, 0x800c, "write to VDU (A)"),
        (0x800f, 0x800f, "write to printer (A)"),
        (0x8012, 0x8012, "update joysticks"),
        (0x8015, 0x8027, "tape routines"),
        (0x8015, 0x8015, "motoron"),
        (0x8018, 0x8018, "motoroff"),
        (0x801b, 0x801b, "write leader"),
        (0x801e, 0x801e, "byte out (A)"),
        (0x8021, 0x8021, "read leader"),
        (0x8024, 0x8024, "byte in (A)"),
        (0x8027, 0x8027, "bit in (C)"),
        (0x802a, 0x8030, "serial routines"),
        (0x802a, 0x802a, "read serial (A)"),
        (0x802d, 0x802d, "write serial (A)"),
        (0x8030, 0x8030, "baud rate select"),
        (0x8033, 0x814f, "command table : last byte of each string has MSB set"),
        (0x8033, 0x814f, "(token in final column)"),
        (0x8033, 0x8033, "FOR     80"),
        (0x8036, 0x8036, "GO      81"),
        (0x8038, 0x8038, "REM     82"),
        (0x803b, 0x803b, "'       83"),
        (0x803c, 0x803c, "ELSE    84"),
        (0x8040, 0x8040, "IF      85"),
        (0x8042, 0x8042, "DATA    86"),
        (0x8046, 0x8046, "PRINT   87"),
        (0x804b, 0x804b, "ON      88"),
        (0x804d, 0x804d, "INPUT   89"),
        (0x8052, 0x8052, "END     8A"),
        (0x8055, 0x8055, "NEXT    8B"),
        (0x8059, 0x8059, "DIM     8C"),
        (0x805c, 0x805c, "READ    8D"),
        (0x8060, 0x8060, "LET     8E"),
        (0x8063, 0x8063, "RUN     8F"),
        (0x8066, 0x8066, "RESTORE 90"),
        (0x806d, 0x806d, "RETURN  91"),
        (0x8073, 0x8073, "STOP    92"),
        (0x8077, 0x8077, "POKE    93"),
        (0x807b, 0x807b, "CONT    94"),
        (0x807f, 0x807f, "LIST    95"),
        (0x8083, 0x8083, "CLEAR   96"),
        (0x8088, 0x8088, "NEW     97"),
        (0x808b, 0x808b, "DEF     98"),
        (0x808e, 0x808e, "CLOAD   99"),
        (0x8093, 0x8093, "CSAVE   9A"),
        (0x8098, 0x8098, "OPEN    9B"),
        (0x809c, 0x809c, "CLOSE   9C"),
        (0x80a1, 0x80a1, "LLIST   9D"),
        (0x80a6, 0x80a6, "SET     9E"),
        (0x80a9, 0x80a9, "RESET   9F"),
        (0x80ae, 0x80ae, "CLS     A0"),
        (0x80b1, 0x80b1, "MOTOR   A1"),
        (0x80b6, 0x80b6, "SOUND   A2"),
        (0x80bb, 0x80bb, "AUDIO   A3"),
        (0x80c0, 0x80c0, "EXEC    A4"),
        (0x80c4, 0x80c4, "SKIPF   A5"),
        (0x80c9, 0x80c9, "DEL     A6"),
        (0x80cc, 0x80cc, "EDIT    A7"),
        (0x80d0, 0x80d0, "TRON    A8"),
        (0x80d4, 0x80d4, "TROFF   A9"),
        (0x80d9, 0x80d9, "LINE    AA"),
        (0x80dd, 0x80dd, "PCLS    AB"),
        (0x80e1, 0x80e1, "PSET    AC"),
        (0x80e5, 0x80e5, "PRESET  AD"),
        (0x80eb, 0x80eb, "SCREEN  AE"),
        (0x80f1, 0x80f1, "PCLEAR  AF"),
        (0x80f7, 0x80f7, "COLOR   B0"),
        (0x80fc, 0x80fc, "CIRCLE  B1"),
        (0x8102, 0x8102, "PAINT   B2"),
        (0x8107, 0x8107, "GET     B3"),
        (0x810a, 0x810a, "PUT     B4"),
        (0x810d, 0x810d, "DRAW    B5"),
        (0x8111, 0x8111, "PCOPY   B6"),
        (0x8116, 0x8116, "PMODE   B7"),
        (0x811b, 0x811b, "PLAY    B8"),
        (0x811f, 0x811f, "DLOAD   B9"),
        (0x8124, 0x8124, "RENUM   BA"),
        (0x8129, 0x8129, "TAB(    BB"),
        (0x812d, 0x812d, "TO      BC"),
        (0x812f, 0x812f, "SUB     BD"),
        (0x8132, 0x8132, "FN      BE"),
        (0x8134, 0x8134, "THEN    BF"),
        (0x8138, 0x8138, "NOT     C0"),
        (0x813b, 0x813b, "STEP    C1"),
        (0x813f, 0x813f, "OFF     C2"),
        (0x8142, 0x8142, "+       C3"),
        (0x8143, 0x8143, "-       C4"),
        (0x8144, 0x8144, "C5"),
        (0x8145, 0x8145, "/       C6"),
        (0x8146, 0x8146, "^       C7"),
        (0x8147, 0x8147, "AND     C8"),
        (0x814a, 0x814a, "OR      C9"),
        (0x814c, 0x814c, ">       CA"),
        (0x814d, 0x814d, "=       CB"),
        (0x814e, 0x814e, "<       CC"),
        (0x814f, 0x814f, "USING   CD"),
        (0x8154, 0x81c4, "command vectors"),
        (0x8154, 0x8154, "for go rem '"),
        (0x815c, 0x815c, "else if data print"),
        (0x8164, 0x8164, "on input end next"),
        (0x816c, 0x816c, "dim read let run"),
        (0x8174, 0x8174, "restore return stop poke"),
        (0x817c, 0x817c, "cont list clear new"),
        (0x8184, 0x8184, "def cload csave open"),
        (0x818c, 0x818c, "close llist set reset"),
        (0x8194, 0x8194, "cls motor sound audio"),
        (0x819c, 0x819c, "exec skipf del edit"),
        (0x81a4, 0x81a4, "tron troff line pcls"),
        (0x81ac, 0x81ac, "pset preset screen pclear"),
        (0x81b4, 0x81b4, "color circle paint get"),
        (0x81bc, 0x81bc, "put draw pcopy pmode"),
        (0x81c4, 0x81c4, "play dload renum"),
        (0x81ca, 0x824d, "function table : last byte of each string has MSB set"),
        (0x81ca, 0x824d, "(token in final column)"),
        (0x81ca, 0x81ca, "SGN     FF80"),
        (0x81cd, 0x81cd, "INT     FF81"),
        (0x81d0, 0x81d0, "ABS     FF82"),
        (0x81d3, 0x81d3, "POS     FF83"),
        (0x81d6, 0x81d6, "RND     FF84"),
        (0x81d9, 0x81d9, "SQR     FF85"),
        (0x81dc, 0x81dc, "LOG     FF86"),
        (0x81df, 0x81df, "EXP     FF87"),
        (0x81e2, 0x81e2, "SIN     FF88"),
        (0x81e5, 0x81e5, "COS     FF89"),
        (0x81e8, 0x81e8, "TAN     FF8A"),
        (0x81eb, 0x81eb, "ATN     FF8B"),
        (0x81ee, 0x81ee, "PEEK    FF8C"),
        (0x81f2, 0x81f2, "LEN     FF8D"),
        (0x81f5, 0x81f5, "STR$    FF8E"),
        (0x81f9, 0x81f9, "VAL     FF8F"),
        (0x81fc, 0x81fc, "ASC     FF90"),
        (0x81ff, 0x81ff, "CHR$    FF91"),
        (0x8203, 0x8203, "EOF     FF92"),
        (0x8206, 0x8206, "JOYSTK  FF93"),
        (0x820c, 0x820c, "FIX     FF94"),
        (0x820f, 0x820f, "HEX$    FF95"),
        (0x8213, 0x8213, "LEFT$   FF96"),
        (0x8218, 0x8218, "RIGHT$  FF97"),
        (0x821e, 0x821e, "MID$    FF98"),
        (0x8222, 0x8222, "POINT   FF99"),
        (0x8227, 0x8227, "INKEY$  FF9A"),
        (0x822d, 0x822d, "MEM     FF9B"),
        (0x8230, 0x8230, "VARPTR  FF9C"),
        (0x8236, 0x8236, "INSTR   FF9D"),
        (0x823b, 0x823b, "TIMER   FF9E"),
        (0x8240, 0x8240, "PPOINT  FF9F"),
        (0x8246, 0x8246, "STRING$ FFA0"),
        (0x824d, 0x824d, "USR     FFA1"),
        (0x8250, 0x8290, "function vectors"),
        (0x8250, 0x8250, "sgn int abs pos"),
        (0x8258, 0x8258, "rnd sqr log exp"),
        (0x8260, 0x8260, "sin cos tan atn"),
        (0x8268, 0x8268, "peek len str$ val"),
        (0x8270, 0x8270, "asc chr$ eof joystk"),
        (0x8278, 0x8278, "fix hex$ left$ right$"),
        (0x8280, 0x8280, "mid$ point inkey$ mem"),
        (0x8288, 0x8288, "varptr instr timer ppoint"),
        (0x8290, 0x8290, "string$ usr"),
        (0x8294, 0x82a6, "binary operator table used during expression evaluation"),
        (0x8294, 0x82a6, "(1st byte is precedence level followed by address of handler)"),
        (0x8294, 0x8294, "+"),
        (0x8297, 0x8297, "-"),
        (0x829a, 0x829a, ""),
        (0x829d, 0x829d, "/"),
        (0x82a0, 0x82a0, "^"),
        (0x82a3, 0x82a3, "AND"),
        (0x82a6, 0x82a6, "OR"),
        (0x82a9, 0x82dd, "error code strings"),
        (0x82df, 0x82f0, "misc strings"),
        (0x82df, 0x82df, "/ERROR /"),
        (0x82e6, 0x82e6, "/ IN /"),
        (0x82eb, 0x82eb, "CR/OK/CR"),
        (0x82f0, 0x82f0, "CR/BREAK/"),
        (0x82f7, 0x831b, "examine BASIC stack (maintained 'under' machine return addresses)"),
        (0x82f7, 0x831b, "$3b = varptr of FOR control variable to search for (zero if none)"),
        (0x82f7, 0x831b, "set $3b to #$ff to skip all FOR entries"),
        (0x82f7, 0x831b, "returns X = $0f = pointer to matching entry for FOR / NEXT"),
        (0x82f7, 0x831b, "$3b = varptr of control variable for unspecified NEXT"),
        (0x82f7, 0x831b, "Z = 0 if matching FOR entry not found"),
        (0x82f7, 0x82f7, "point X past 2 return addresses"),
        (0x82f9, 0x82f9, "size of FOR stack entry"),
        (0x82fb, 0x82fb, "$0f = this entry"),
        (0x8301, 0x8301, "not a FOR entry"),
        (0x8305, 0x8305, "varptr of control variable"),
        (0x8309, 0x8309, "we were called by NEXT with no variable"),
        (0x830d, 0x830d, "found a matching entry"),
        (0x8311, 0x8311, "point X to next stack entry"),
        (0x8312, 0x8312, "examine next entry"),
        (0x8314, 0x8314, "set $3b up with varptr of control variable"),
        (0x8316, 0x8316, "for unspecified NEXT"),
        (0x831c, 0x8330, "move memory contents up"),
        (0x831c, 0x8330, "start address   - $47"),
        (0x831c, 0x8330, "end address     - $43"),
        (0x831c, 0x8330, "new end address - $41 (D = new end address for memory check)"),
        (0x831c, 0x8330, "returns $45 = U = start of relocated block"),
        (0x831c, 0x831c, "memory check"),
        (0x8331, 0x8342, "check if there are B free words of storage left"),
        (0x8333, 0x8333, "end of BASIC storage"),
        (0x8338, 0x8338, "?OM ERROR"),
        (0x8340, 0x8340, "RTS"),
        (0x8342, 0x8342, "?OM ERROR"),
        (0x8344, 0x836e, "?xx ERROR - error code in B"),
        (0x8344, 0x8344, "user error trap"),
        (0x8347, 0x8347, "system error trap"),
        (0x834a, 0x834a, "cassette relay off"),
        (0x834d, 0x834d, "disable audio"),
        (0x8350, 0x8350, "reset stack & bits & pieces"),
        (0x8353, 0x8353, "DEVN"),
        (0x8355, 0x8355, "initialise virtual DEVN device & new line"),
        (0x8358, 0x8358, "print '?' to DEVN"),
        (0x835b, 0x835b, "error string table"),
        (0x835f, 0x835f, "output to DEVN from ,X+"),
        (0x8361, 0x8361, "output to DEVN from ,X+"),
        (0x8363, 0x8363, "'ERROR'"),
        (0x8366, 0x8366, "print string to DEVN"),
        (0x8369, 0x8369, "current line number"),
        (0x836c, 0x836c, "command mode"),
        (0x836e, 0x836e, "print 'IN xxxx' (current line number)"),
        (0x8371, 0x839b, "command mode"),
        (0x8371, 0x8371, "initialise virtual DEVN device & new line"),
        (0x8377, 0x8377, "print 'OK'"),
        (0x837a, 0x837a, "line input from DEVN"),
        (0x8380, 0x8380, "current line number"),
        (0x8382, 0x8382, "command mode without 'OK'"),
        (0x8384, 0x8384, "eof flag"),
        (0x8386, 0x8386, "close file & return to command mode"),
        (0x838a, 0x838a, "BASIC source pointer"),
        (0x838c, 0x838c, "get next character from BASIC source"),
        (0x838e, 0x838e, "command mode without 'OK'"),
        (0x8390, 0x8390, "enter BASIC line"),
        (0x8392, 0x8392, "?DS ERROR"),
        (0x8394, 0x8394, "DEVN"),
        (0x8396, 0x8396, "cause error"),
        (0x8398, 0x8398, "tokenize BASIC line"),
        (0x839b, 0x839b, "enter interpreter loop"),
        (0x839e, 0x83a0, "used by error routine to print error code"),
        (0x83a0, 0x83a0, "output character to DEVN"),
        (0x83a3, 0x83eb, "enter a BASIC line"),
        (0x83a3, 0x83a3, "read line number & store in $2b"),
        (0x83ab, 0x83ab, "tokenize BASIC line"),
        (0x83ae, 0x83ae, "line length"),
        (0x83b0, 0x83b0, "search program for line number in <$2b"),
        (0x83b2, 0x83b2, "line number doesn't exist"),
        (0x83b4, 0x83b4, "address where line needs to go"),
        (0x83b6, 0x83b6, "subtract next line pointer (-ve result)"),
        (0x83b8, 0x83b8, "start of simple variables"),
        (0x83ba, 0x83ba, "new end of program"),
        (0x83be, 0x83be, "move program down, erasing existing line"),
        (0x83c2, 0x83c2, "start of simple variables"),
        (0x83c9, 0x83c9, "new line is empty"),
        (0x83cb, 0x83cb, "start of simple variables"),
        (0x83cf, 0x83cf, "new line length"),
        (0x83d5, 0x83d5, "move memory contents up"),
        (0x83dd, 0x83dd, "copy new line into space just created"),
        (0x83e5, 0x83e5, "new end of program"),
        (0x83e7, 0x83e7, "clear variables and reset stack & cmd ptr"),
        (0x83e9, 0x83e9, "set up next line pointers in BASIC program"),
        (0x83eb, 0x83eb, "command mode without 'OK'"),
        (0x83ed, 0x83fd, "set up next line pointers in BASIC program"),
        (0x83ed, 0x83ed, "start of BASIC program"),
        (0x83f1, 0x83f1, "RTS"),
        (0x83ff, 0x8401, "search program for line number in <$2b"),
        (0x8401, 0x8401, "start of BASIC program"),
        (0x8403, 0x8414, "scan ahead for line in D & store address in $47"),
        (0x8403, 0x8414, "(first line after if it doesn't exist - carry clear if found)"),
        (0x8405, 0x8405, "end of program"),
        (0x8407, 0x8407, "scan program until line no. is greater"),
        (0x840a, 0x840a, "than D"),
        (0x840c, 0x840c, "next line"),
        (0x8415, 0x8446, "NEW"),
        (0x8417, 0x8417, "start of BASIC program"),
        (0x841d, 0x841d, "start of simple variables"),
        (0x841f, 0x841f, "start of BASIC program"),
        (0x8421, 0x8421, "subtract 1 from X & store in $a6"),
        (0x8424, 0x8424, "PATCH - reset BASIC memory"),
        (0x8427, 0x8427, "top of BASIC RAM"),
        (0x8429, 0x8429, "top of free string space"),
        (0x842b, 0x842b, "RESTORE"),
        (0x842e, 0x842e, "start of simple variables"),
        (0x8430, 0x8430, "start of array variables"),
        (0x8432, 0x8432, "end of BASIC storage"),
        (0x843b, 0x843b, "stack root / string storage start"),
        (0x8440, 0x8440, "CONT source address"),
        (0x8448, 0x849d, "FOR"),
        (0x8448, 0x849d, "creates following 18 byte stack entry:"),
        (0x8448, 0x849d, ",S   #$80"),
        (0x8448, 0x849d, "1,S   varptr of control variable"),
        (0x8448, 0x849d, "3,S   STEP value (unsigned FP)"),
        (0x8448, 0x849d, "8,S   sign of STEP value (-1, 0 ,1)"),
        (0x8448, 0x849d, "9,S   TO value (signed FP)"),
        (0x8448, 0x849d, "14,S   line number of FOR statement"),
        (0x8448, 0x849d, "16,S   address of statement after FOR"),
        (0x844a, 0x844a, "array illegal flag"),
        (0x844c, 0x844c, "LET"),
        (0x844f, 0x844f, "examine BASIC stack"),
        (0x8452, 0x8452, "lose return address"),
        (0x8454, 0x8454, "no FOR with same control variable already"),
        (0x8458, 0x8458, "overwrite duplicate FOR entry"),
        (0x845c, 0x845c, "memory check"),
        (0x845f, 0x845f, "find end of statement"),
        (0x8462, 0x8462, "current line number"),
        (0x8464, 0x8464, "push next statement ptr & current line no."),
        (0x8466, 0x8466, "token TO"),
        (0x8468, 0x8468, "skip character in B"),
        (0x846b, 0x846b, "validate numeric expression"),
        (0x846e, 0x846e, "read numeric expression into FPA1"),
        (0x8473, 0x8473, "convert FPA1 back to standard variable"),
        (0x847d, 0x847d, "push FPA1 onto stack & JMP ,Y"),
        (0x8480, 0x8480, "FP constant 1"),
        (0x8483, 0x8483, "load variable into FPA1 (X is varptr)"),
        (0x8486, 0x8486, "get current character from BASIC source"),
        (0x8488, 0x8488, "token STEP"),
        (0x848a, 0x848a, "no STEP value specified"),
        (0x848c, 0x848c, "get next character from BASIC source"),
        (0x848e, 0x848e, "read numeric expression into FPA1"),
        (0x8491, 0x8491, "sets B to -1, 0 or 1 as per sign of FPA1"),
        (0x8494, 0x8494, "push B then FPA1 onto stack"),
        (0x8497, 0x8497, "varptr of control variable"),
        (0x849b, 0x849b, "FOR signature on stack"),
        (0x849f, 0x84da, "interpreter loop"),
        (0x849f, 0x849f, "PATCH - get command"),
        (0x84a2, 0x84a2, "unmask interrupts"),
        (0x84a4, 0x84a4, "scan for BREAK / pause"),
        (0x84a6, 0x84a6, "BASIC source pointer"),
        (0x84a8, 0x84a8, "address of current BASIC statement"),
        (0x84ac, 0x84ac, "end of line"),
        (0x84b2, 0x84b2, "?SN ERROR"),
        (0x84b7, 0x84b7, "this will be zero when end reached"),
        (0x84b9, 0x84b9, "end of program"),
        (0x84bf, 0x84bf, "current line number"),
        (0x84c1, 0x84c1, "BASIC source pointer"),
        (0x84c3, 0x84c3, "trace flag"),
        (0x84c5, 0x84c5, "trace off"),
        (0x84c9, 0x84c9, "output character to DEVN"),
        (0x84cc, 0x84cc, "current line number"),
        (0x84ce, 0x84ce, "print unsigned number in D"),
        (0x84d3, 0x84d3, "output character to DEVN"),
        (0x84d6, 0x84d6, "get next character from BASIC source"),
        (0x84d8, 0x84d8, "interpret statement"),
        (0x84da, 0x84da, "interpreter loop"),
        (0x84dc, 0x8512, "interpret statement"),
        (0x84dc, 0x84dc, "RTS"),
        (0x84de, 0x84de, "PATCH - interpreter"),
        (0x84e2, 0x84e2, "variable on LHS (LET)"),
        (0x84e8, 0x84e8, "not a BASIC command"),
        (0x84ea, 0x84ea, "command JMP table"),
        (0x84f1, 0x84f1, "get next character from BASIC source"),
        (0x84f7, 0x84f7, "function"),
        (0x84fb, 0x84fb, "?SN ERROR"),
        (0x84fd, 0x84fd, "must be disk command"),
        (0x8501, 0x8501, "get next character from BASIC source"),
        (0x8505, 0x8505, "MID$ on LHS"),
        (0x850b, 0x850b, "TIMER on LHS"),
        (0x850f, 0x850f, "PATCH - CLS GET PUT ???"),
        (0x8512, 0x8512, "?SN ERROR"),
        (0x8514, 0x851a, "RESTORE"),
        (0x8514, 0x8514, "start of BASIC program"),
        (0x8518, 0x8518, "READ pointer"),
        (0x851b, 0x8530, "scan keyboard for break & pause"),
        (0x851b, 0x851b, "scan keyboard"),
        (0x8522, 0x8522, "BREAK"),
        (0x8526, 0x8526, "SHIFT + @"),
        (0x852b, 0x852b, "scan keyboard"),
        (0x8532, 0x8537, "END"),
        (0x8532, 0x8532, "close cassette stream"),
        (0x8535, 0x8535, "get current character from BASIC source"),
        (0x8539, 0x855d, "STOP"),
        (0x853b, 0x853b, "RTS"),
        (0x853d, 0x853d, "BASIC source pointer"),
        (0x853f, 0x853f, "address of current BASIC statement"),
        (0x8541, 0x8541, "make -ve for STOP"),
        (0x8543, 0x8543, "lose return address"),
        (0x8545, 0x8545, "current line number"),
        (0x854a, 0x854a, "already in command mode"),
        (0x854c, 0x854c, "CONT line number"),
        (0x854e, 0x854e, "address of current BASIC statement"),
        (0x8550, 0x8550, "CONT source address"),
        (0x8552, 0x8552, "DEVN"),
        (0x8554, 0x8554, "/BREAK/"),
        (0x8559, 0x8559, "command mode"),
        (0x855d, 0x855d, "print BREAK message"),
        (0x8560, 0x8570, "CONT"),
        (0x8560, 0x8560, "RTS"),
        (0x8562, 0x8562, "?CN ERROR"),
        (0x8564, 0x8564, "CONT source address"),
        (0x8566, 0x8566, "cause error"),
        (0x856a, 0x856a, "BASIC source pointer"),
        (0x856c, 0x856c, "CONT line number"),
        (0x856e, 0x856e, "current line number"),
        (0x8571, 0x85a2, "CLEAR"),
        (0x8571, 0x8571, "clear variables & reset stack"),
        (0x8573, 0x8573, "read unsigned number into $52 & D"),
        (0x8578, 0x8578, "top of BASIC RAM"),
        (0x857a, 0x857a, "get current character from BASIC source"),
        (0x857e, 0x857e, "skip comma"),
        (0x8581, 0x8581, "read 16 bit number into X"),
        (0x8586, 0x8586, "top of RAM"),
        (0x8588, 0x8588, "?OM ERROR"),
        (0x858e, 0x858e, "?OM ERROR"),
        (0x8595, 0x8595, "?OM ERROR"),
        (0x8597, 0x8597, "start of simple variables"),
        (0x8599, 0x8599, "?OM ERROR"),
        (0x859b, 0x859b, "new stack address"),
        (0x859d, 0x859d, "new top of BASIC RAM"),
        (0x859f, 0x859f, "clear variables & reset stack"),
        (0x85a2, 0x85a2, "?OM ERROR"),
        (0x85a5, 0x85b7, "RUN"),
        (0x85a5, 0x85a5, "PATCH - run"),
        (0x85a8, 0x85a8, "set up sound & graphics variables"),
        (0x85ab, 0x85ab, "close cassette stream"),
        (0x85ae, 0x85ae, "get current character from BASIC source"),
        (0x85b0, 0x85b0, "clear variables and reset stack & cmd ptr"),
        (0x85b4, 0x85b4, "clear variables & reset stack"),
        (0x85b7, 0x85b7, "perform GOTO"),
        (0x85b9, 0x85d4, "GO  (TO/SUB)"),
        (0x85b9, 0x85d4, "GOSUB creates following 5 byte stack entry:"),
        (0x85b9, 0x85d4, ",S     #$BD"),
        (0x85b9, 0x85d4, "1,S     line number of GOSUB statement"),
        (0x85b9, 0x85d4, "3,S     address of GOSUB statement (points to SUB token)"),
        (0x85bb, 0x85bb, "get next character from BASIC source"),
        (0x85bd, 0x85bd, "token TO"),
        (0x85bf, 0x85bf, "perform GOTO"),
        (0x85c1, 0x85c1, "token SUB"),
        (0x85c3, 0x85c3, "?SN ERROR"),
        (0x85c7, 0x85c7, "memory check"),
        (0x85ca, 0x85ca, "BASIC source pointer"),
        (0x85cc, 0x85cc, "current line number"),
        (0x85ce, 0x85ce, "token SUB"),
        (0x85d2, 0x85d2, "perform GOTO"),
        (0x85d4, 0x85d4, "interpreter loop"),
        (0x85d7, 0x85f2, "perform GOTO"),
        (0x85d7, 0x85d7, "get current character from BASIC source"),
        (0x85d9, 0x85d9, "read line number & store in $2b"),
        (0x85dc, 0x85dc, "find end of line"),
        (0x85e2, 0x85e2, "current line number"),
        (0x85e7, 0x85e7, "start of BASIC program"),
        (0x85e9, 0x85e9, "scan for line D"),
        (0x85ec, 0x85ec, "?UL ERROR"),
        (0x85f0, 0x85f0, "BASIC source pointer"),
        (0x85f3, 0x8604, "RETURN"),
        (0x85f3, 0x85f3, "RTS"),
        (0x85f7, 0x85f7, "set $3b to skip all FOR entries"),
        (0x85f9, 0x85f9, "examine BASIC stack"),
        (0x85fc, 0x85fc, "point stack to this entry"),
        (0x8600, 0x8600, "GOSUB signature (#$BD - #$80)"),
        (0x8602, 0x8602, "?RG ERROR"),
        (0x8607, 0x8611, "(8605 C60E       LDB   #$0E)    ;?UL ERROR"),
        (0x8607, 0x8607, "cause error"),
        (0x860a, 0x860a, "?SN ERROR"),
        (0x860f, 0x860f, "current line number"),
        (0x8611, 0x8611, "BASIC source pointer"),
        (0x8613, 0x8615, "DATA"),
        (0x8613, 0x8615, "(simply skips to next statement)"),
        (0x8613, 0x8613, "find end of statement"),
        (0x8618, 0x861a, "REM / ELSE"),
        (0x8618, 0x861a, "(8616 8D06       BSR   $861E)   ;find end of line"),
        (0x8618, 0x8618, "BASIC source pointer"),
        (0x861b, 0x861d, "find end of statement"),
        (0x861f, 0x8645, "(861E 5F         CLRB)"),
        (0x8622, 0x8622, "BASIC source pointer"),
        (0x862c, 0x862c, "RTS"),
        (0x8632, 0x8632, "RTS"),
        (0x863f, 0x863f, "token IF (+1)"),
        (0x8643, 0x8643, "increment for each IF token encountered"),
        (0x8647, 0x8672, "IF"),
        (0x8647, 0x8672, "IF condition (THEN/GOTO) [IF...THEN [IF...THEN...ELSE] ELSE] ELSE"),
        (0x8647, 0x8672, "--                                                           ----"),
        (0x8647, 0x8672, "ELSEs are tied to previous IFs"),
        (0x8647, 0x8647, "read numeric expression into FPA1"),
        (0x864a, 0x864a, "get current character from BASIC source"),
        (0x864c, 0x864c, "token GO"),
        (0x8650, 0x8650, "token THEN"),
        (0x8652, 0x8652, "skip character in B"),
        (0x8657, 0x8657, "IF condition true"),
        (0x8659, 0x8659, "clear IF counter"),
        (0x865b, 0x865b, "skip to start of next statement"),
        (0x865e, 0x865e, "RTS"),
        (0x8660, 0x8660, "get next character from BASIC source"),
        (0x8662, 0x8662, "token ELSE"),
        (0x8664, 0x8664, "we're looking for ELSE"),
        (0x8666, 0x8666, "any IFs skipped?"),
        (0x8668, 0x8668, "this ELSE doesn't go with this IF"),
        (0x866a, 0x866a, "get next character from BASIC source"),
        (0x866c, 0x866c, "get current character from BASIC source"),
        (0x866e, 0x866e, "it's a number - perform GOTO"),
        (0x8672, 0x8672, "interpret statement"),
        (0x8675, 0x8698, "ON"),
        (0x8675, 0x8675, "get number into B"),
        (0x8678, 0x8678, "token GO"),
        (0x867a, 0x867a, "skip character in B"),
        (0x867f, 0x867f, "token SUB"),
        (0x8683, 0x8683, "token TO"),
        (0x8685, 0x8685, "?SN ERROR"),
        (0x8687, 0x8687, "control variable"),
        (0x868d, 0x868d, "GO (cmd pointer now at desired choice)"),
        (0x8690, 0x8690, "get next character from BASIC source"),
        (0x8692, 0x8692, "read line number & store in $2b"),
        (0x869a, 0x86ba, "read line number from command & store in $2b"),
        (0x869a, 0x869a, "zero"),
        (0x869e, 0x869e, "not a digit - RTS"),
        (0x86a6, 0x86a6, "D > 6399?"),
        (0x86a8, 0x86a8, "?SN ERROR"),
        (0x86ac, 0x86ac, "D = D * 10"),
        (0x86b2, 0x86b2, "add new digit"),
        (0x86b8, 0x86b8, "get next character from BASIC source"),
        (0x86ba, 0x86ba, "process another digit"),
        (0x86bc, 0x8704, "LET"),
        (0x86bc, 0x86bc, "get varptr of variable in X"),
        (0x86c1, 0x86c1, "token ="),
        (0x86c3, 0x86c3, "skip character in B"),
        (0x86c6, 0x86c6, "numeric / string flag"),
        (0x86ca, 0x86ca, "get expression"),
        (0x86cf, 0x86cf, "check that variable & expression"),
        (0x86d0, 0x86d0, "are of same type"),
        (0x86d3, 0x86d3, "assign FPA1 to varptr in <$3b"),
        (0x86d7, 0x86d7, "PATCH - assign string variable"),
        (0x86dc, 0x86dc, "stack root / string storage start"),
        (0x86e3, 0x86e3, "start of simple variables"),
        (0x86e9, 0x86e9, "reserve B bytes of string space"),
        (0x86ee, 0x86ee, "copy string (len B) from varptr X to ($25)+"),
        (0x86f6, 0x86f6, "if X is top of string stack then pull it"),
        (0x8705, 0x8705, "string used by INPUT"),
        (0x8705, 0x8705, "/?REDO/CR"),
        (0x870c, 0x872a, "take action for illegal input"),
        (0x870c, 0x870c, "?FD ERROR"),
        (0x870e, 0x870e, "DEVN"),
        (0x8712, 0x8712, "cause error"),
        (0x8719, 0x8719, "line number of current DATA statement"),
        (0x871b, 0x871b, "current line number"),
        (0x871d, 0x871d, "?SN ERROR"),
        (0x8720, 0x8720, "/?REDO/"),
        (0x8723, 0x8723, "print string to DEVN"),
        (0x8726, 0x8726, "address of current BASIC statement"),
        (0x8728, 0x8728, "BASIC source pointer"),
        (0x872b, 0x8776, "INPUT"),
        (0x872b, 0x872b, "test for command mode"),
        (0x8730, 0x8730, "DEVN"),
        (0x8737, 0x8737, "read #-n & set up DEVN"),
        (0x873a, 0x873a, "test cassette status OK for input"),
        (0x873d, 0x873d, "skip comma"),
        (0x8742, 0x8742, "no prompt"),
        (0x8744, 0x8744, "read literal string"),
        (0x8749, 0x8749, "skip character in B"),
        (0x874c, 0x874c, "print prompt"),
        (0x8754, 0x8754, "DEVN"),
        (0x8758, 0x8758, "get something into input buffer"),
        (0x875e, 0x875e, "read input into variables"),
        (0x8760, 0x8760, "print '?' to DEVN"),
        (0x8763, 0x8763, "print a space to DEVN"),
        (0x8766, 0x8766, "line input from DEVN"),
        (0x876d, 0x876d, "BREAK"),
        (0x8770, 0x8770, "?IE ERROR"),
        (0x8772, 0x8772, "eof flag"),
        (0x8777, 0x8818, "READ"),
        (0x8777, 0x8777, "READ pointer"),
        (0x877f, 0x877f, "get varptr of variable in X"),
        (0x8784, 0x8784, "BASIC source pointer"),
        (0x8792, 0x8792, "PATCH - re-request input"),
        (0x8795, 0x8795, "print '?' to DEVN"),
        (0x879a, 0x879a, "BASIC source pointer"),
        (0x879c, 0x879c, "get next character from BASIC source"),
        (0x879e, 0x879e, "numeric / string flag"),
        (0x87a2, 0x87a2, "BASIC source pointer"),
        (0x87af, 0x87af, "initialise virtual DEVN device"),
        (0x87b2, 0x87b2, "cassette IO flag"),
        (0x87b4, 0x87b4, "IO in progress"),
        (0x87be, 0x87be, "compile literal string at X"),
        (0x87c4, 0x87c4, "assign string variable"),
        (0x87c9, 0x87c9, "read numeric constant into FPA1"),
        (0x87cc, 0x87cc, "assign FPA1 to varptr in <$3b"),
        (0x87cf, 0x87cf, "get current character from BASIC source"),
        (0x87d5, 0x87d5, "take action for illegal input"),
        (0x87d9, 0x87d9, "BASIC source pointer"),
        (0x87df, 0x87df, "BASIC source pointer"),
        (0x87e1, 0x87e1, "get current character from BASIC source"),
        (0x87e5, 0x87e5, "skip comma"),
        (0x87ea, 0x87ea, "BASIC source pointer"),
        (0x87ec, 0x87ec, "find end of statement"),
        (0x87fc, 0x87fc, "line number of current DATA statement"),
        (0x8815, 0x8815, "print string to DEVN"),
        (0x8819, 0x8819, "string used by INPUT"),
        (0x8819, 0x8819, "/?EXTRA IGNORED/CR"),
        (0x8829, 0x8870, "NEXT"),
        (0x8829, 0x8829, "control variable specified"),
        (0x882b, 0x882b, "zero"),
        (0x882f, 0x882f, "get varptr of variable in X"),
        (0x8834, 0x8834, "examine BASIC stack"),
        (0x8837, 0x8837, "found match"),
        (0x8839, 0x8839, "?NF ERROR"),
        (0x883d, 0x883d, "point stack to this entry"),
        (0x883f, 0x883f, "point X to STEP value"),
        (0x8841, 0x8841, "load variable into FPA1 (X is varptr)"),
        (0x8844, 0x8844, "sign of STEP value"),
        (0x8848, 0x8848, "varptr of control variable"),
        (0x884a, 0x884a, "add varptr X to FPA1"),
        (0x884d, 0x884d, "assign FPA1 to varptr in <$3b"),
        (0x8850, 0x8850, "point X to terminating value"),
        (0x8852, 0x8852, "compare FPA1 - varptr X"),
        (0x8855, 0x8855, "test depends on step direction"),
        (0x8857, 0x8857, "terminating condition met"),
        (0x885b, 0x885b, "current line number"),
        (0x8860, 0x8860, "BASIC source pointer"),
        (0x8862, 0x8862, "interpreter loop"),
        (0x8865, 0x8865, "finished with this entry"),
        (0x8868, 0x8868, "get current character from BASIC source"),
        (0x886c, 0x886c, "no more variables after NEXT"),
        (0x886e, 0x886e, "get next character from BASIC source"),
        (0x8870, 0x8870, "BSR used for correct stack structure"),
        (0x8872, 0x8872, ";(never returns to $8872)"),
        (0x8872, 0x8872, "get numeric expression into FPA1"),
        (0x8872, 0x8872, "get expression"),
        (0x8874, 0x8876, "cause error if expression last evaluated not numeric"),
        (0x8879, 0x887f, "cause error if expression last evaluated not string"),
        (0x8879, 0x887f, "(8877 1A01       ORCC  #$01)"),
        (0x8879, 0x8879, "numeric / string flag"),
        (0x887d, 0x887d, "RTS"),
        (0x8882, 0x8884, "(8880 2B96       BMI   $8818)   ;RTS"),
        (0x8882, 0x8882, "?TM ERROR"),
        (0x8884, 0x8884, "cause error"),
        (0x8887, 0x888a, "get expression"),
        (0x8887, 0x8887, "move source pointer back one"),
        (0x888d, 0x88b0, "(888B 3404       PSHS  B)"),
        (0x8891, 0x8891, "memory check"),
        (0x8894, 0x8894, "evaluate sub-expression"),
        (0x8897, 0x8897, "flag used for relational operators"),
        (0x8899, 0x8899, "get current character from BASIC source"),
        (0x889b, 0x889b, "branch to $88B2 if token is not in the set"),
        (0x889d, 0x889d, "[ >, =, < ]"),
        (0x88a3, 0x88a3, "map [0, 1, 2] to [1, 2, 4]"),
        (0x88a6, 0x88a6, "determine valid combination of > = <"),
        (0x88aa, 0x88aa, "?SN ERROR"),
        (0x88ae, 0x88ae, "get next character from BASIC source"),
        (0x88b2, 0x88e7, ""),
        (0x88b2, 0x88b2, "$3f = [ 1, 2, 3, 4, 5, 6 ]"),
        (0x88b4, 0x88b4, "for   [ >  =  >= <  <> <= ]"),
        (0x88bc, 0x88bc, "not a binary operator"),
        (0x88be, 0x88be, "A = A + 1 + ($06)"),
        (0x88c0, 0x88c0, "'+' in a string expression"),
        (0x88c4, 0x88c4, "A = A - 1 if numeric expression"),
        (0x88c9, 0x88c9, "A = A * 3"),
        (0x88cb, 0x88cb, "binary operator precedence table"),
        (0x88d0, 0x88d0, "precedence of last operator"),
        (0x88d4, 0x88d4, "new op. has a lower precedence"),
        (0x88d6, 0x88d6, "validate numeric expression"),
        (0x88da, 0x88da, "push op handler & FPA1 / get expression"),
        (0x88e3, 0x88e3, "LDB <$4F  RTS"),
        (0x88e9, 0x88f5, "set up precedence / handler for rel. op."),
        (0x88e9, 0x88e9, "numeric / string flag"),
        (0x88ec, 0x88ec, "move source pointer back one"),
        (0x88f3, 0x88f3, "numeric / string flag"),
        (0x88f7, 0x88f9, "move source pointer back one"),
        (0x88f7, 0x88f7, "BASIC source pointer"),
        (0x88f9, 0x88f9, "subtract 1 from X & store in $a6"),
        (0x88fc, 0x8903, "rel. op. precedence & handler"),
        (0x8905, 0x8910, "push op handler & FPA1 onto stack / get expression"),
        (0x8905, 0x8905, "op handler"),
        (0x8909, 0x8909, "push FPA1 onto stack"),
        (0x890b, 0x890b, "rel. op. flag"),
        (0x890d, 0x890d, "get expression"),
        (0x8910, 0x8910, "?SN ERROR"),
        (0x8913, 0x8923, "push FPA1 onto stack"),
        (0x8925, 0x8953, "end of expression / execute operator"),
        (0x8925, 0x8925, "zero"),
        (0x8929, 0x8929, "LDB <$4F  RTS"),
        (0x892f, 0x892f, "validate numeric expression"),
        (0x8938, 0x8938, "RTS"),
        (0x893c, 0x893c, "RTS"),
        (0x893e, 0x893e, "sets carry if rel. op. was for string"),
        (0x8941, 0x8941, "pull FPA2 off stack"),
        (0x8943, 0x8943, "set $62 up with sign difference"),
        (0x8947, 0x8947, "LDB <$4F"),
        (0x894b, 0x894b, "RTS calls operator handler"),
        (0x894d, 0x894d, "(with carry from above)"),
        (0x8954, 0x89a1, "evaluate sub-expression ('+' & '-' treated as signs)"),
        (0x8954, 0x8954, "PATCH - evaluate expression"),
        (0x8957, 0x8957, "numeric / string flag"),
        (0x8959, 0x8959, "get next character from BASIC source"),
        (0x895d, 0x895d, "read numeric constant into FPA1"),
        (0x8960, 0x8960, "carry clear if A-Z"),
        (0x8963, 0x8963, "evaluate variable"),
        (0x8969, 0x8969, "token -"),
        (0x896b, 0x896b, "read expression & negate"),
        (0x896d, 0x896d, "token +"),
        (0x896f, 0x896f, "ignore +"),
        (0x8975, 0x8975, "BASIC source pointer"),
        (0x8977, 0x8977, "compile literal string at X"),
        (0x897c, 0x897c, "move source pointer to end of string"),
        (0x897f, 0x897f, "token NOT"),
        (0x8988, 0x8988, "read signed number from FPA1 to $52 & D"),
        (0x898d, 0x898d, "assign D to FPA1"),
        (0x8990, 0x8990, "token FN"),
        (0x8998, 0x8998, "read octal or hex number into $52 / $53"),
        (0x899d, 0x899d, "evaluate function"),
        (0x899f, 0x899f, "skip open bracket (only legal chr. left)"),
        (0x89a1, 0x89a1, "get expression"),
        (0x89a4, 0x89a6, "check for close bracket"),
        (0x89a9, 0x89a9, "check for open bracket"),
        (0x89a9, 0x89a9, "(89A7 C628       LDB   #$28)"),
        (0x89ac, 0x89b6, "check for comma"),
        (0x89ac, 0x89b6, "(89AA C62C       LDB   #$2C)"),
        (0x89ac, 0x89b6, "check for character in B"),
        (0x89b0, 0x89b0, "?SN ERROR"),
        (0x89b2, 0x89b2, "get next character from BASIC source"),
        (0x89b4, 0x89b4, "?SN ERROR"),
        (0x89b6, 0x89b6, "cause error"),
        (0x89b9, 0x89be, "read expression & negate FPA1"),
        (0x89be, 0x89be, "COM $54 if FPA1 non zero"),
        (0x89c1, 0x89ca, "evaluate variable"),
        (0x89c1, 0x89c1, "get varptr of variable in X"),
        (0x89c6, 0x89c6, "numeric / string flag"),
        (0x89c8, 0x89c8, "RTS (string)"),
        (0x89ca, 0x89ca, "load variable into FPA1 (X is varptr)"),
        (0x89cd, 0x8a03, "evaluate function"),
        (0x89cd, 0x89cd, "get next character from BASIC source"),
        (0x89d2, 0x89d2, "get next character from BASIC source"),
        (0x89d8, 0x89d8, "disk function despatch"),
        (0x89e0, 0x89e0, "functions with single arguments"),
        (0x89e4, 0x89e4, "functions with special or no arguments"),
        (0x89e6, 0x89e6, "skip open bracket"),
        (0x89ec, 0x89ec, "not LEFT$, RIGHT$ or MID$"),
        (0x89ee, 0x89ee, "get expression"),
        (0x89f1, 0x89f1, "skip comma"),
        (0x89f3, 0x89f3, "validate string"),
        (0x89fc, 0x89fc, "get number into B"),
        (0x8a06, 0x8a0e, "(8A04 8D99       BSR   $899F)   ;get expression inside brackets"),
        (0x8a08, 0x8a08, "function despatch table"),
        (0x8a0e, 0x8a0e, "validate numeric expression"),
        (0x8a11, 0x8a11, "OR"),
        (0x8a13, 0x8a2e, "AND"),
        (0x8a13, 0x8a2e, "(8A12 4F         CLRA)"),
        (0x8a15, 0x8a15, "read signed number from FPA1 to $52 & D"),
        (0x8a1a, 0x8a1a, "copy FPA2 to FPA1"),
        (0x8a1d, 0x8a1d, "read signed number from FPA1 to $52 & D"),
        (0x8a2e, 0x8a2e, "assign D to FPA1"),
        (0x8a31, 0x8a88, "handler for relational operators"),
        (0x8a31, 0x8a31, "validate string / numeric using carry"),
        (0x8a34, 0x8a34, "valid string"),
        (0x8a3e, 0x8a3e, "FPA2"),
        (0x8a41, 0x8a41, "compare FPA1 - varptr X"),
        (0x8a46, 0x8a46, "numeric / string flag"),
        (0x8a4a, 0x8a4a, "point X to string just compiled & len in B"),
        (0x8a53, 0x8a53, "point X to string & length in B"),
        (0x8a7c, 0x8a7c, "map [-1, 0, 1] to [1, 2, 4]"),
        (0x8a7f, 0x8a7f, "rel. op. number"),
        (0x8a85, 0x8a85, "assign B to FPA1 (result of relation)"),
        (0x8a88, 0x8a88, "skip comma"),
        (0x8a8b, 0x8a93, "DIM"),
        (0x8a8d, 0x8a8d, "create variable"),
        (0x8a8f, 0x8a8f, "get current character from BASIC source"),
        (0x8a91, 0x8a91, "skip comma & read next array"),
        (0x8a94, 0x8a95, "gets VARPTR address of following variable"),
        (0x8a94, 0x8a95, "set $08 to #$80 to exclude array variables"),
        (0x8a94, 0x8a95, "creates new variable if not found"),
        (0x8a94, 0x8a95, "returns $39 = X = varptr address"),
        (0x8a95, 0x8a95, "get current character from BASIC source"),
        (0x8a97, 0x8add, "set B to cause error if array variable already exists"),
        (0x8a9b, 0x8a9b, "get current character from BASIC source"),
        (0x8a9d, 0x8a9d, "carry clear if A-Z"),
        (0x8a9f, 0x8a9f, "?SN ERROR"),
        (0x8aa4, 0x8aa4, "numeric / string flag"),
        (0x8aa6, 0x8aa6, "get next character from BASIC source"),
        (0x8aaa, 0x8aaa, "carry clear if A-Z"),
        (0x8ab0, 0x8ab0, "get next character from BASIC source"),
        (0x8ab4, 0x8ab4, "carry clear if A-Z"),
        (0x8aba, 0x8aba, "numeric variable"),
        (0x8abc, 0x8abc, "numeric / string flag"),
        (0x8ac0, 0x8ac0, "get next character from BASIC source"),
        (0x8ac4, 0x8ac4, "set $08 to #$80 to exclude array variables"),
        (0x8ac8, 0x8ac8, "array variable"),
        (0x8ace, 0x8ace, "start of simple variables"),
        (0x8ad2, 0x8ad2, "start of array variables"),
        (0x8ad4, 0x8ad4, "not found - create variable"),
        (0x8ad9, 0x8ad9, "found existing variable - STX <$39 & RTS"),
        (0x8add, 0x8add, "keep looking"),
        (0x8adf, 0x8ae7, "clear carry if A contains 'A'-'Z'"),
        (0x8ae8, 0x8b1c, "create variable"),
        (0x8aed, 0x8aed, "if called by evaluate variable routine - RTS"),
        (0x8af1, 0x8af1, "(with X pointing to zero)"),
        (0x8af3, 0x8af3, "end of BASIC storage"),
        (0x8afc, 0x8afc, "start of array variables"),
        (0x8b00, 0x8b00, "move memory contents up"),
        (0x8b05, 0x8b05, "end of BASIC storage"),
        (0x8b09, 0x8b09, "start of array variables"),
        (0x8b0d, 0x8b0d, "variable name"),
        (0x8b1c, 0x8b1c, "FP constant -32768"),
        (0x8b21, 0x8b26, "read unsigned number into $52 & D"),
        (0x8b21, 0x8b21, "get next character from BASIC source"),
        (0x8b23, 0x8b23, "read numeric expression into FPA1"),
        (0x8b26, 0x8b26, "validate numeric expression"),
        (0x8b29, 0x8b2b, "read +ve number from FPA1 into $52 & D"),
        (0x8b2b, 0x8b2b, "?FC ERROR"),
        (0x8b2d, 0x8b43, "read signed number from FPA1 into $52 & D"),
        (0x8b2d, 0x8b2d, "validate numeric expression"),
        (0x8b36, 0x8b36, "only 16 bit number allowed is -32768"),
        (0x8b39, 0x8b39, "compare FPA1 - varptr X"),
        (0x8b3c, 0x8b3c, "?FC ERROR"),
        (0x8b3e, 0x8b3e, "denormalize FPA1 to an integer"),
        (0x8b44, 0x8b8c, "get varptr of variable continued (handle arrays)"),
        (0x8b46, 0x8b46, "numeric / string flag"),
        (0x8b4f, 0x8b4f, "read unsigned number into $52 & D"),
        (0x8b5a, 0x8b5a, "get current character from BASIC source"),
        (0x8b5e, 0x8b5e, "get next dimension"),
        (0x8b60, 0x8b60, "number of dimensions"),
        (0x8b62, 0x8b62, "skip close bracket"),
        (0x8b67, 0x8b67, "numeric / string flag"),
        (0x8b6b, 0x8b6b, "start of array variables"),
        (0x8b6d, 0x8b6d, "end of BASIC storage"),
        (0x8b6f, 0x8b6f, "not found - create new array"),
        (0x8b76, 0x8b76, "found array name"),
        (0x8b7c, 0x8b7c, "keep looking"),
        (0x8b7e, 0x8b7e, "?DD ERROR"),
        (0x8b82, 0x8b82, "cause error if array exists & $05 set"),
        (0x8b88, 0x8b88, "correct number of dimensions"),
        (0x8b8a, 0x8b8a, "?BS ERROR"),
        (0x8b8f, 0x8c10, "(8B8D C608       LDB   #$08)    ;?FC ERROR"),
        (0x8b8f, 0x8b8f, "cause error"),
        (0x8b92, 0x8b92, "bytes per element"),
        (0x8b99, 0x8b99, "array name"),
        (0x8b9d, 0x8b9d, "number of dimensions"),
        (0x8b9f, 0x8b9f, "memory check"),
        (0x8ba2, 0x8ba2, "start of array header"),
        (0x8ba4, 0x8ba4, "default number of elements"),
        (0x8bb2, 0x8bb2, "D = word at 5,X * word at $64"),
        (0x8bba, 0x8bba, "next dimension"),
        (0x8bbc, 0x8bbc, "start of array element storage"),
        (0x8bbe, 0x8bbe, "D = end of array"),
        (0x8bc0, 0x8bc0, "?OM ERROR"),
        (0x8bc6, 0x8bc6, "memory check (also adds #$3a to D)"),
        (0x8bcc, 0x8bcc, "end of BASIC storage"),
        (0x8bcf, 0x8bcf, "clear array"),
        (0x8bd7, 0x8bd7, "array header"),
        (0x8bd9, 0x8bd9, "end of BASIC storage"),
        (0x8bdd, 0x8bdd, "offset to next array (when it's created)"),
        (0x8be1, 0x8be1, "RTS"),
        (0x8bf2, 0x8bf2, "?BS ERROR"),
        (0x8bf8, 0x8bf8, "D = word at 5,X * word at $64"),
        (0x8c08, 0x8c08, "D = D * 5"),
        (0x8c11, 0x8c2e, "D = word at 5,X * word at $64"),
        (0x8c1d, 0x8c1d, "?BS ERROR"),
        (0x8c27, 0x8c27, "?BS ERROR"),
        (0x8c2e, 0x8c2e, "?BS ERROR"),
        (0x8c31, 0x8c33, "MEM"),
        (0x8c33, 0x8c33, "...continued"),
        (0x8c36, 0x8c36, "assign B to FPA1"),
        (0x8c37, 0x8c3d, "assign D to FPA1 (signed)"),
        (0x8c37, 0x8c37, "numeric / string flag"),
        (0x8c3d, 0x8c3d, "signed assign!"),
        (0x8c40, 0x8c4e, "STR$"),
        (0x8c40, 0x8c40, "validate numeric expression"),
        (0x8c46, 0x8c46, "convert FPA1 to string at U"),
        (0x8c49, 0x8c49, "lose return address"),
        (0x8c4e, 0x8c4e, "compile literal string at X"),
        (0x8c50, 0x8c58, "reserve B bytes of string space"),
        (0x8c50, 0x8c58, "returns X = $58 = start of requested block"),
        (0x8c50, 0x8c58, "B = $56 = length of block"),
        (0x8c52, 0x8c52, "reserve B bytes of string space"),
        (0x8c59, 0x8cb2, "register a delimited string pointed to by X"),
        (0x8c59, 0x8cb2, "if string is in keyboard buffer, then copy it into free string space."),
        (0x8c59, 0x8cb2, "stores string start, end & length in $62, $64 & $56"),
        (0x8c59, 0x8cb2, "string start also in $58"),
        (0x8c59, 0x8cb2, "if copied to string space, start & end also in $58 & $4d"),
        (0x8c80, 0x8c80, "PATCH - reset BASIC memory"),
        (0x8c89, 0x8c89, "push temp string onto varptr stack"),
        (0x8c8b, 0x8c8b, "reserve B bytes of string space"),
        (0x8c8f, 0x8c8f, "copy string of length B from X+ to ($25)+"),
        (0x8c99, 0x8c99, "?ST ERROR"),
        (0x8c9b, 0x8c9b, "cause error"),
        (0x8ca8, 0x8ca8, "numeric / string flag"),
        (0x8cb3, 0x8cd5, "reserve B bytes of string space"),
        (0x8cb3, 0x8cd5, "returns X = pointer to requested block & B = length"),
        (0x8cb3, 0x8cd5, "requested block also in $25"),
        (0x8cb8, 0x8cb8, "top of free string space"),
        (0x8cbc, 0x8cbc, "stack root / string storage start"),
        (0x8cbf, 0x8cbf, "not enough space"),
        (0x8cc1, 0x8cc1, "new free pointer"),
        (0x8cc7, 0x8cc7, "points to requested block"),
        (0x8ccb, 0x8ccb, "?OS ERROR"),
        (0x8ccf, 0x8ccf, "already done garbage collect - give up"),
        (0x8cd1, 0x8cd1, "string garbage collect"),
        (0x8cd5, 0x8cd5, "try to reserve space again"),
        (0x8cd7, 0x8d52, "string space garbage collect"),
        (0x8cd7, 0x8cd7, "top of BASIC RAM"),
        (0x8cd9, 0x8cd9, "top of free string space"),
        (0x8cdf, 0x8cdf, "stack root / string storage start"),
        (0x8cee, 0x8cee, "start of simple variables"),
        (0x8cf0, 0x8cf0, "start of array variables"),
        (0x8cfc, 0x8cfc, "end of BASIC storage"),
        (0x8d24, 0x8d24, "top of free string space"),
        (0x8d41, 0x8d41, "top of free string space"),
        (0x8d45, 0x8d45, "move memory contents up (no memory check)"),
        (0x8d55, 0x8d86, "handle '+' in a string expression (concatenate)"),
        (0x8d59, 0x8d59, "evaluate sub-expression"),
        (0x8d5c, 0x8d5c, "validate string expression"),
        (0x8d67, 0x8d67, "add string lengths"),
        (0x8d69, 0x8d69, "not too long"),
        (0x8d6b, 0x8d6b, "?LS ERROR"),
        (0x8d6d, 0x8d6d, "cause error"),
        (0x8d70, 0x8d70, "reserve B bytes of string space"),
        (0x8d77, 0x8d77, "copy string (len B) from varptr X to ($25)+"),
        (0x8d7b, 0x8d7b, "point X to string & length in B"),
        (0x8d7d, 0x8d7d, "copy string of length B from X+ to ($25)+"),
        (0x8d81, 0x8d81, "point X to string & length in B"),
        (0x8d83, 0x8d83, "push temp string onto varptr stack"),
        (0x8d86, 0x8d86, "back to expression handler"),
        (0x8d89, 0x8d89, "copy string of length B from varptr X to ($25)+"),
        (0x8d8b, 0x8d99, "copy string of length B from X+ to ($25)+"),
        (0x8d9a, 0x8dba, "validate result of string expression"),
        (0x8d9a, 0x8dba, "point X to 1st character & length in B"),
        (0x8d9a, 0x8dba, "(if it is the most recent temp string then delete it)"),
        (0x8d9a, 0x8d9a, "validate string expression"),
        (0x8da1, 0x8da1, "if X is top of string stack then pull it"),
        (0x8da3, 0x8da3, "normal varptr"),
        (0x8da9, 0x8da9, "top of free string space"),
        (0x8daf, 0x8daf, "top of free string space"),
        (0x8db1, 0x8db1, "top of free string space"),
        (0x8dbb, 0x8dc6, "if X is top of string stack then pull it"),
        (0x8dc7, 0x8dc9, "LEN"),
        (0x8dc7, 0x8dc7, "validate string & test length"),
        (0x8dc9, 0x8dc9, "assign B to FPA1"),
        (0x8dcc, 0x8dd1, "validate string & test length"),
        (0x8dcc, 0x8dcc, "validate string & point X to it"),
        (0x8dce, 0x8dce, "numeric / string flag"),
        (0x8dd2, 0x8de3, "CHR$"),
        (0x8dd2, 0x8dd2, "read 8 bit value into B from FPA1"),
        (0x8dd7, 0x8dd7, "reserve B bytes of string space"),
        (0x8ddc, 0x8ddc, "store string details as for temp string"),
        (0x8de3, 0x8de3, "push temp string onto varptr stack"),
        (0x8de6, 0x8de8, "ASC"),
        (0x8de6, 0x8de6, "get 1st character of string into B"),
        (0x8de8, 0x8de8, "assign B to FPA1"),
        (0x8dea, 0x8df0, "get 1st character of string into B"),
        (0x8dea, 0x8dea, "validate string & test length"),
        (0x8dec, 0x8dec, "?FC ERROR"),
        (0x8df1, 0x8e0c, "LEFT$"),
        (0x8df1, 0x8df1, "get str varptr in X & $4D, arg. in A & B"),
        (0x8df6, 0x8df6, "number of chrs <= string length"),
        (0x8dfd, 0x8dfd, "reserve B bytes of string space"),
        (0x8e02, 0x8e02, "point X to string & length in B"),
        (0x8e06, 0x8e06, "adjust string start for MID$ / RIGHT$"),
        (0x8e09, 0x8e09, "copy string of length B from X+ to ($25)+"),
        (0x8e0c, 0x8e0c, "push temp string onto varptr stack"),
        (0x8e0e, 0x8e13, "RIGHT$"),
        (0x8e0e, 0x8e0e, "get str varptr in X & $4D, arg. in A & B"),
        (0x8e12, 0x8e12, "A = string length - argument"),
        (0x8e13, 0x8e13, "create new string"),
        (0x8e15, 0x8e39, "MID$"),
        (0x8e15, 0x8e15, "default length"),
        (0x8e19, 0x8e19, "get current character from BASIC source"),
        (0x8e1d, 0x8e1d, "length not specified"),
        (0x8e1f, 0x8e1f, "skip comma"),
        (0x8e22, 0x8e22, "get number into B (& $53)"),
        (0x8e24, 0x8e24, "get str varptr in X & $4D, arg. in A & B"),
        (0x8e26, 0x8e26, "?FC ERROR"),
        (0x8e29, 0x8e29, "A = pos - 1"),
        (0x8e2c, 0x8e2c, "pos past end - create empty string"),
        (0x8e32, 0x8e32, "B = string length - pos"),
        (0x8e35, 0x8e35, "no. of chrs available <= requested length"),
        (0x8e39, 0x8e39, "use requested length"),
        (0x8e3b, 0x8e4c, "called by LEFT$, RIGHT$ & MID$"),
        (0x8e3b, 0x8e4c, "get string varptr in X & $4D, argument in A & B"),
        (0x8e3b, 0x8e3b, "skip close bracket"),
        (0x8e4c, 0x8e4c, "?FC ERROR"),
        (0x8e4f, 0x8e4f, "skip character & get 8 bit value into B"),
        (0x8e4f, 0x8e4f, "get next character from BASIC source"),
        (0x8e51, 0x8e51, "read 8 bit value into B"),
        (0x8e51, 0x8e51, "read numeric expression into FPA1"),
        (0x8e54, 0x8e5a, "read 8 bit value into B from FPA1"),
        (0x8e54, 0x8e54, "read unsigned number into $52 & D from FPA1"),
        (0x8e58, 0x8e58, "?FC ERROR"),
        (0x8e5a, 0x8e5a, "get current character from BASIC source"),
        (0x8e5c, 0x8e79, "VAL"),
        (0x8e5c, 0x8e5c, "validate string & test length"),
        (0x8e5f, 0x8e5f, "clear exponents in FPA1 ($4f & $54)"),
        (0x8e63, 0x8e63, "save source pointer"),
        (0x8e65, 0x8e65, "point source pointer to start of string"),
        (0x8e68, 0x8e68, "save byte at end of string"),
        (0x8e6c, 0x8e6c, "put a zero at end of string"),
        (0x8e6e, 0x8e6e, "get current character from BASIC source"),
        (0x8e70, 0x8e70, "read numeric expression into FPA1"),
        (0x8e75, 0x8e75, "restore byte at end of string"),
        (0x8e77, 0x8e77, "restore source pointer"),
        (0x8e7a, 0x8e81, "read pair of numbers from command"),
        (0x8e7a, 0x8e81, "1st in $2b / $2c & 2nd in B"),
        (0x8e7a, 0x8e7a, "read 16 bit number into X"),
        (0x8e7e, 0x8e7e, "skip comma"),
        (0x8e81, 0x8e81, "get number into B"),
        (0x8e83, 0x8e83, "read 16 bit unsigned number into X"),
        (0x8e83, 0x8e83, "read numeric expression into FPA1"),
        (0x8e86, 0x8e95, "read 16 bit unsigned number into X from FPA1"),
        (0x8e88, 0x8e88, "?FC ERROR"),
        (0x8e8e, 0x8e8e, "?FC ERROR"),
        (0x8e90, 0x8e90, "denormalize FPA1 to an integer"),
        (0x8e96, 0x8e9a, "PEEK"),
        (0x8e96, 0x8e96, "read 16 bit number into X from FPA1"),
        (0x8e9a, 0x8e9a, "assign B to FPA1"),
        (0x8e9d, 0x8ea3, "POKE"),
        (0x8e9d, 0x8e9d, "read pair of numbers into $2b/2c & B"),
        (0x8ea4, 0x8ea8, "LLIST"),
        (0x8ea6, 0x8ea6, "DEVN"),
        (0x8ea8, 0x8ea8, "get current character from BASIC source"),
        (0x8eaa, 0x8f06, "LIST"),
        (0x8eac, 0x8eac, "read line number & store in $2b"),
        (0x8eaf, 0x8eaf, "search program for line number in <$2b"),
        (0x8eb8, 0x8eb8, "get current character from BASIC source"),
        (0x8ebc, 0x8ebc, "token -"),
        (0x8ec0, 0x8ec0, "get next character from BASIC source"),
        (0x8ec4, 0x8ec4, "read line number & store in $2b"),
        (0x8ed3, 0x8ed3, "initialise virtual DEVN device & new line"),
        (0x8ed6, 0x8ed6, "scan for BREAK & pause if DEVN is not -1"),
        (0x8edd, 0x8edd, "close DEVN stream"),
        (0x8ee0, 0x8ee0, "DEVN"),
        (0x8ee2, 0x8ee2, "command mode"),
        (0x8eee, 0x8eee, "print unsigned number in D"),
        (0x8ef1, 0x8ef1, "print a space to DEVN"),
        (0x8ef6, 0x8ef6, "detokenize BASIC line"),
        (0x8f03, 0x8f03, "output character to DEVN"),
        (0x8f08, 0x8f66, "detokenize BASIC line"),
        (0x8f08, 0x8f08, "PATCH - detokenize"),
        (0x8f67, 0x903b, "tokenize BASIC line"),
        (0x8f67, 0x8f67, "PATCH - tokenize"),
        (0x8f6a, 0x8f6a, "BASIC source pointer"),
        (0x8f7b, 0x8f7b, "carry clear if A-Z"),
        (0x8fae, 0x8fae, "BASIC source pointer"),
        (0x9027, 0x9027, "carry clear if A-Z"),
        (0x903d, 0x909f, "PRINT"),
        (0x903d, 0x903d, "send CR to DEVN"),
        (0x9041, 0x9041, "DEVN"),
        (0x9048, 0x9048, "handle PRINT@"),
        (0x9051, 0x9051, "read #-n & set up DEVN"),
        (0x9054, 0x9054, "if DEVN = -1, test cassette OK for output"),
        (0x9057, 0x9057, "get current character from BASIC source"),
        (0x9059, 0x9059, "send CR to DEVN"),
        (0x905b, 0x905b, "skip comma"),
        (0x905e, 0x905e, "token USING"),
        (0x9064, 0x9064, "RTS"),
        (0x9066, 0x9066, "token TAB("),
        (0x9070, 0x9070, "skip semicolon"),
        (0x9072, 0x9072, "get expression"),
        (0x9075, 0x9075, "numeric / string flag"),
        (0x9079, 0x9079, "string expression"),
        (0x907b, 0x907b, "convert FPA1 to string at $3DA"),
        (0x907e, 0x907e, "register string at X"),
        (0x9081, 0x9081, "print string just compiled"),
        (0x9085, 0x9085, "initialise virtual DEVN device"),
        (0x9088, 0x9088, "cassette IO flag"),
        (0x908a, 0x908a, "no IO in progress"),
        (0x908c, 0x908c, "send CR to DEVN"),
        (0x908e, 0x908e, "get current character from BASIC source"),
        (0x9093, 0x9093, "string just printed so no space"),
        (0x9095, 0x9095, "get current character from BASIC source"),
        (0x909b, 0x909b, "print a space to DEVN"),
        (0x909d, 0x909d, "get current character from BASIC source"),
        (0x90a1, 0x90a3, "send CR to DEVN"),
        (0x90a3, 0x90a3, "output character to DEVN"),
        (0x90a5, 0x90ae, "initialise virtual DEVN device & new line"),
        (0x90a5, 0x90a5, "initialise virtual DEVN device"),
        (0x90a8, 0x90a8, "send CR to DEVN"),
        (0x90aa, 0x90aa, "device current column"),
        (0x90ac, 0x90ac, "send CR to DEVN"),
        (0x90af, 0x90c5, "called by PRINT to handle ,"),
        (0x90af, 0x90af, "initialise virtual DEVN device"),
        (0x90b4, 0x90b4, "device current column"),
        (0x90b6, 0x90b6, "device last comma field"),
        (0x90ba, 0x90ba, "send CR to DEVN"),
        (0x90be, 0x90be, "device current column"),
        (0x90c0, 0x90c0, "device comma field width"),
        (0x90c7, 0x90e2, "called by PRINT to handle TAB"),
        (0x90c7, 0x90c7, "skip character & get number in B"),
        (0x90cc, 0x90cc, "?SN ERROR"),
        (0x90d0, 0x90d0, "initialise virtual DEVN device"),
        (0x90d3, 0x90d3, "device current column"),
        (0x90d7, 0x90d7, "cassette IO flag"),
        (0x90d9, 0x90d9, "IO in progress"),
        (0x90db, 0x90db, "print a space to DEVN"),
        (0x90e0, 0x90e0, "get next character from BASIC source"),
        (0x90e5, 0x90f3, "print string to DEVN"),
        (0x90e5, 0x90e5, "compile literal string at X"),
        (0x90e8, 0x90e8, "point X to string just compiled & len in B"),
        (0x90ed, 0x90ed, "RTS"),
        (0x90f1, 0x90f1, "output character to DEVN"),
        (0x90f5, 0x90f7, "print a space to DEVN"),
        (0x90fa, 0x90fa, "print '?' to DEVN"),
        (0x90fa, 0x90fa, "(90F8 863F       LDA   #$3F)"),
        (0x90fa, 0x90fa, "output character to DEVN"),
        (0x90fd, 0x9100, "add 0.5 to FPA1"),
        (0x90fd, 0x90fd, "FP constant 0.5"),
        (0x9100, 0x9100, "add varptr X to FPA1"),
        (0x9102, 0x9109, "subtract FPA1 from varptr X"),
        (0x9102, 0x9102, "load FPA2 from varptr X"),
        (0x910b, 0x91a4, "add varptr X to FPA1"),
        (0x910b, 0x910b, "load FPA2 from varptr X"),
        (0x910e, 0x910e, "FPA1 exponent"),
        (0x910f, 0x910f, "copy FPA2 to FPA1 (because FPA1 zero)"),
        (0x9113, 0x9113, "FPA2"),
        (0x9116, 0x9116, "A = B = FPA2 exponent"),
        (0x9119, 0x9119, "RTS (FPA2 is zero)"),
        (0x911b, 0x911b, "B = FPA2 exponent - FPA1 exponent"),
        (0x911d, 0x911d, "FPA1 & FPA2 same order"),
        (0x911f, 0x911f, "FPA1 higher order"),
        (0x9127, 0x9127, "FPA1"),
        (0x912d, 0x912d, "more than 8 bits to shift"),
        (0x9132, 0x9132, "shift mantissa of varptr X right -B bits"),
        (0x9135, 0x9135, "(carries into A)"),
        (0x9137, 0x9137, "FPA1 & FPA2 same sign"),
        (0x913b, 0x913b, "2's complement FPA1"),
        (0x913d, 0x913d, "carry is picked up below"),
        (0x9148, 0x9148, "add mantissa in FPA2 to FPA1"),
        (0x915f, 0x915f, "signs were same"),
        (0x9161, 0x9161, "normalize FPA1"),
        (0x9163, 0x9163, "2's complent mantissa in FPA1"),
        (0x9168, 0x9168, "normalize bit-wise"),
        (0x9188, 0x9188, "shift mantissa of varptr X right -B bits"),
        (0x91a2, 0x91a2, "clear exponents in FPA1 ($4f & $54)"),
        (0x91a7, 0x91c1, "(91A5 2508       BCS   $91AF)"),
        (0x91b1, 0x91b1, "?OV ERROR"),
        (0x91bd, 0x91bd, "add the carry to mantissa in FPA1"),
        (0x91c2, 0x91dd, "2's complement mantissa in FPA1"),
        (0x91db, 0x91db, "?OV ERROR"),
        (0x91dd, 0x91dd, "cause error"),
        (0x91e0, 0x91f5, "shift $13 - $16 & $63 right -B bits"),
        (0x91e0, 0x91f5, "(shifts 8 bits before testing B)"),
        (0x91f7, 0x920e, "shift mantissa of varptr X right -B bits"),
        (0x91ff, 0x91ff, "RTS"),
        (0x920e, 0x920e, "FP constant 1"),
        (0x9213, 0x9237, "log series coefficients"),
        (0x9214, 0x9214, "FP constant .4342559419"),
        (0x9219, 0x9219, "FP constant .5765845412"),
        (0x921e, 0x921e, "FP constant .9618007592"),
        (0x9223, 0x9223, "FP constant 2.885390073"),
        (0x9228, 0x9228, "FP constant root 2 / 2"),
        (0x922d, 0x922d, "FP constant root 2"),
        (0x9232, 0x9232, "FP constant -0.5"),
        (0x9237, 0x9237, "FP constant ln2"),
        (0x923c, 0x9270, "LOG"),
        (0x923c, 0x923c, "sets B to -1, 0 or 1 as per sign of FPA1"),
        (0x923f, 0x923f, "?FC ERROR"),
        (0x9243, 0x9243, "FP constant root 2 / 2"),
        (0x9250, 0x9250, "add varptr X to FPA1"),
        (0x9253, 0x9253, "FP constant root 2"),
        (0x9256, 0x9256, "FPA1 = varptr X / FPA1"),
        (0x9259, 0x9259, "FP constant 1"),
        (0x925c, 0x925c, "FPA1 = varptr X - FPA1"),
        (0x925f, 0x925f, "series coefficients"),
        (0x9262, 0x9262, "calculate odd power series"),
        (0x9265, 0x9265, "FP constant -0.5"),
        (0x9268, 0x9268, "add varptr X to FPA1"),
        (0x926d, 0x926d, "add B to FPA1"),
        (0x9270, 0x9270, "FP constant ln2"),
        (0x9273, 0x92a6, "multiply FPA1 by varptr X"),
        (0x9273, 0x9273, "load FPA2 from varptr X"),
        (0x9275, 0x9275, "RTS (FPA1 zero)"),
        (0x9277, 0x9277, "add A to exponent in FPA1"),
        (0x9285, 0x9285, "multiply mantissa in FPA2 by B"),
        (0x928d, 0x928d, "multiply mantissa in FPA2 by B"),
        (0x9295, 0x9295, "multiply mantissa in FPA2 by B"),
        (0x92a3, 0x92a3, "copy mantissa from $13 - $16 to FPA1"),
        (0x92a6, 0x92a6, "normalize FPA1"),
        (0x92a9, 0x92d9, "multiply mantissa in FPA2 by B"),
        (0x92a9, 0x92d9, "accumulate result in $13 - $16 & $63 & shift result right 8 bits"),
        (0x92a9, 0x92a9, "B=0 (shift $13 - $16 & $63 right 8 bits)"),
        (0x92b1, 0x92b1, "RTS"),
        (0x92da, 0x92f2, "load FPA2 from varptr X & set $62 with FPA1 / FPA2 sign difference"),
        (0x92da, 0x92f2, "A = exponent from FPA2"),
        (0x92da, 0x92f2, "B = exponent from FPA1"),
        (0x92f3, 0x9312, "add A to exponent in FPA1"),
        (0x9300, 0x9300, "clear exponents in FPA1 ($4f & $54)"),
        (0x9302, 0x9302, "sign difference FPA1 / FPA2"),
        (0x930e, 0x930e, "clear exponents in FPA1 ($4f & $54)"),
        (0x9312, 0x9312, "?OV ERROR"),
        (0x9315, 0x9328, "multiply FPA1 by 10"),
        (0x9315, 0x9315, "copy FPA1 to FPA2"),
        (0x931a, 0x931a, "x4"),
        (0x931c, 0x931c, "?OV ERROR"),
        (0x9320, 0x9320, "add FPA2 to FPA1 (FPA1 exponent in A)"),
        (0x9323, 0x9323, "double result"),
        (0x9325, 0x9325, "?OV ERROR"),
        (0x9328, 0x9328, "FP constant 10"),
        (0x932d, 0x9339, "divide FPA1 by 10"),
        (0x932d, 0x932d, "copy FPA1 to FPA2"),
        (0x9330, 0x9330, "FP constant 10"),
        (0x9336, 0x9336, "load variable into FPA1 (X is varptr)"),
        (0x933c, 0x93b3, "divide varptr X by FPA1"),
        (0x933c, 0x93b3, "(933A 8D9E       BSR   $92DA)   ;load FPA2 from varptr X"),
        (0x933c, 0x933c, "?/0 ERROR (FPA1 zero)"),
        (0x9340, 0x9340, "add A to exponent in FPA1"),
        (0x9344, 0x9344, "?OV ERROR"),
        (0x9367, 0x9367, "identical mantissas - set carry"),
        (0x93ac, 0x93ac, "copy mantissa from $13 - $16 to FPA1"),
        (0x93ae, 0x93ae, "normalize FPA1"),
        (0x93b1, 0x93b1, "?/0 ERROR"),
        (0x93b3, 0x93b3, "cause error"),
        (0x93b6, 0x93be, "copy mantissa from $13 - $16 to FPA1"),
        (0x93bf, 0x93d3, "load variable into FPA1 (X is varptr)"),
        (0x93d5, 0x93d8, "assign FPA1 to variable store $45 - $49"),
        (0x93d8, 0x93d8, "assign FPA1 to varptr in X"),
        (0x93da, 0x93dd, "assign FPA1 to variable store $40 - $44"),
        (0x93e0, 0x93f4, "assign FPA1 to varptr in <$3b"),
        (0x93e0, 0x93f4, "(93DE 9E3B       LDX   <$3B)"),
        (0x93e0, 0x93f4, "assign FPA1 to varptr in X"),
        (0x93f5, 0x9409, "copy FPA2 to FPA1 (A = sign)"),
        (0x940a, 0x9417, "copy FPA1 to FPA2 & test for exponent = 0"),
        (0x9418, 0x9424, "sets B to -1, 0 or 1 according to sign of FPA1"),
        (0x9425, 0x943b, "SGN"),
        (0x9425, 0x9425, "sets B to -1, 0 or 1 as per sign of FPA1"),
        (0x942f, 0x942f, "set carry according to sign"),
        (0x9433, 0x9433, "zero"),
        (0x943b, 0x943b, "normalize FPA1 (if carry clear, negate 1st)"),
        (0x943e, 0x9440, "ABS"),
        (0x943e, 0x943e, "simply clear sign byte"),
        (0x9441, 0x9449, "compare FPA1 - varptr X  (set B to -1, 0 or 1)"),
        (0x9443, 0x9443, "sets B to -1, 0 or 1 as per sign of FPA1"),
        (0x9449, 0x9449, "set B to -1 or 1 as per sign of FPA1"),
        (0x944b, 0x9471, "compare FPA1 - varptr X (of same sign)"),
        (0x946e, 0x946e, "turn carry into sign"),
        (0x9471, 0x9471, "reduce B to +/- 1"),
        (0x9473, 0x9496, "denormalize FPA1 to an integer (but don't update exponent)"),
        (0x9475, 0x9475, "clear mantissa in FPA1"),
        (0x947f, 0x947f, "2's complement mantissa in FPA1 (not $54)"),
        (0x9482, 0x9482, "FPA1"),
        (0x9489, 0x9489, "shift mantissa of varptr X right -B bits"),
        (0x9496, 0x9496, "shift mantissa of varptr X right -B bits"),
        (0x9499, 0x94b1, "INT"),
        (0x949b, 0x949b, "when exponent >= $A0, no fractional part"),
        (0x949d, 0x949d, "RTS (already an integer)"),
        (0x949f, 0x949f, "denormalize FPA1 to an integer"),
        (0x94b1, 0x94b1, "normalize FPA1 (if carry clear, negate 1st)"),
        (0x94b4, 0x94bc, "clear mantissa in FPA1"),
        (0x94bd, 0x9511, "read a numeric constant into FPA1"),
        (0x94bd, 0x94bd, "zero"),
        (0x94c7, 0x94c7, "$47 & $48 = decimal exponent & sign"),
        (0x94c9, 0x94c9, "$45 & $46 decimal place counter & flag"),
        (0x94cb, 0x94cb, "read sig. figs. into FPA1"),
        (0x94cf, 0x94cf, "read hex or octal"),
        (0x94df, 0x94df, "get next character from BASIC source"),
        (0x94e1, 0x94e1, "read sig. figs. into FPA1"),
        (0x94e9, 0x94e9, "finished reading number, now finalise."),
        (0x94eb, 0x94eb, "get next character from BASIC source"),
        (0x94ed, 0x94ed, "read decimal exponent into $47"),
        (0x94ef, 0x94ef, "token -"),
        (0x94f7, 0x94f7, "token +"),
        (0x9503, 0x9503, "get next character from BASIC source"),
        (0x9505, 0x9505, "read decimal exponent into $47"),
        (0x9509, 0x9509, "finished reading number, now finalise."),
        (0x950b, 0x950b, "-ve exponent"),
        (0x950d, 0x950d, "finished reading number, now finalise."),
        (0x9511, 0x9511, "1st decimal point encountered"),
        (0x9513, 0x9531, "finished reading number, now finalise."),
        (0x951d, 0x951d, "divide FPA1 by 10"),
        (0x9526, 0x9526, "multiply FPA1 by 10"),
        (0x952f, 0x952f, "RTS"),
        (0x9531, 0x9531, "COM $54 if FPA1 non zero"),
        (0x9534, 0x9545, "read sig. figs. into FPA1"),
        (0x9534, 0x9534, "increment decimal place counter"),
        (0x9536, 0x9536, "if decimal point passed"),
        (0x953c, 0x953c, "multiply FPA1 by 10"),
        (0x9543, 0x9543, "add B to FPA1"),
        (0x9547, 0x9550, "add B to FPA1"),
        (0x9547, 0x9547, "assign FPA1 to variable store $40 - $44"),
        (0x954a, 0x954a, "assign B to FPA1"),
        (0x9550, 0x9550, "add varptr X to FPA1"),
        (0x9553, 0x9562, "read decimal exponent into $47"),
        (0x9553, 0x9562, "(note that it doesn't check for more than two digits)"),
        (0x9559, 0x9559, "B = 10 * $47"),
        (0x9564, 0x956e, "used by print number routine"),
        (0x9564, 0x9564, "FP constant 99999999.9"),
        (0x9569, 0x9569, "FP constant 999999999"),
        (0x956e, 0x956e, "FP constant 1000000000"),
        (0x9573, 0x9578, "print 'IN xxxx' (current line number)"),
        (0x9578, 0x9578, "current line number"),
        (0x957a, 0x9584, "print unsigned number in D"),
        (0x957e, 0x957e, "set carry for correct result"),
        (0x957f, 0x957f, "normalize FPA1 using exponent in B"),
        (0x9582, 0x9582, "convert FPA1 to string at $3DA"),
        (0x9584, 0x9584, "print string to DEVN"),
        (0x9587, 0x966e, "convert FPA1 to string at $3DA"),
        (0x9592, 0x9592, "print '-' for negative numbers else space"),
        (0x959c, 0x959c, "number is zero"),
        (0x95a3, 0x95a3, "number >= 1"),
        (0x95a5, 0x95a5, "FP constant 1000000000"),
        (0x95a8, 0x95a8, "multiply varptr X & FPA1"),
        (0x95ab, 0x95ab, "-9"),
        (0x95ad, 0x95ad, "decimal exponent"),
        (0x95af, 0x95af, "FP constant 999999999"),
        (0x95b2, 0x95b2, "compare FPA1 - varptr X (of same sign)"),
        (0x95b7, 0x95b7, "FP constant 99999999.9"),
        (0x95ba, 0x95ba, "compare FPA1 - varptr X (of same sign)"),
        (0x95bd, 0x95bd, "(FPA1 is now 100000000 to 999999999)"),
        (0x95bf, 0x95bf, "multiply FPA1 by 10"),
        (0x95c2, 0x95c2, "correct exponent"),
        (0x95c6, 0x95c6, "divide FPA1 by 10"),
        (0x95c9, 0x95c9, "correct exponent"),
        (0x95cd, 0x95cd, "add 0.5 to FPA1 (round it up)"),
        (0x95d0, 0x95d0, "denormalize FPA1 to an integer"),
        (0x95d3, 0x95d3, "1 digit before point for sci. notation"),
        (0x95d7, 0x95d7, "exponent now 2 more than it should be"),
        (0x95d9, 0x95d9, "actual exponent < -2 (use sci. notation)"),
        (0x95dd, 0x95dd, "actual exponent >= 9 (use sci. notation)"),
        (0x95e0, 0x95e0, "number of digits before point = exp + 1"),
        (0x95e6, 0x95e6, "decimal exponent"),
        (0x95e8, 0x95e8, "number of digits before decimal point"),
        (0x95ea, 0x95ea, "no leading decimal point"),
        (0x95f2, 0x95f2, "can only be zero or -ve here"),
        (0x95f3, 0x95f3, "no zero reqd after point & before 1st digit"),
        (0x95fc, 0x95fc, "sign bit used for zero crossing logic"),
        (0x95fe, 0x95fe, "resolves a decimal digit by adding powers"),
        (0x9600, 0x9600, "of 10 until zero is passed."),
        (0x9606, 0x9606, "On 1st pass -ve values are used to get FPA1"),
        (0x9608, 0x9608, "below zero. The digit is no. of loops - 1."),
        (0x960c, 0x960c, "On 2nd pass +ve values are used to get FPA1"),
        (0x960e, 0x960e, "above zero. The digit is 10 - no. loops."),
        (0x9612, 0x9612, "This continues with alternating signs."),
        (0x9616, 0x9616, "loop counter"),
        (0x9617, 0x9617, "logic to test if zero passed"),
        (0x961b, 0x961b, "digit = loops - 1"),
        (0x9620, 0x9620, "1 less & ASCII conversion"),
        (0x9626, 0x9626, "lose sign bit"),
        (0x962c, 0x962c, "haven't reached decimal point yet"),
        (0x9632, 0x9632, "alternates B between $00 & $80"),
        (0x963a, 0x963a, "backtrack over digits"),
        (0x963c, 0x963c, "until non-zero found"),
        (0x9642, 0x9642, "if no sig. figs. after decimal point"),
        (0x9644, 0x9644, "then lose it."),
        (0x964a, 0x964a, "normal number (no decimal exponent)"),
        (0x964c, 0x964c, "+ve exponent"),
        (0x9657, 0x9657, "convert B to ASCII number in D"),
        (0x9662, 0x9662, "terminate string"),
        (0x9668, 0x9668, "terminate string"),
        (0x966e, 0x966e, "FP constant 0.5"),
        (0x9673, 0x9693, "table of 32 bit numbers used by convert number to string routine"),
        (0x9673, 0x9693, "(to resolve decimal digits)"),
        (0x9673, 0x9673, "-100000000"),
        (0x9677, 0x9677, "10000000"),
        (0x967b, 0x967b, "-1000000"),
        (0x967f, 0x967f, "100000"),
        (0x9683, 0x9683, "-10000"),
        (0x9687, 0x9687, "1000"),
        (0x968b, 0x968b, "-100"),
        (0x968f, 0x968f, "10"),
        (0x9693, 0x9693, "-1"),
        (0x9697, 0x969a, "SQR"),
        (0x9697, 0x9697, "copy FPA1 to FPA2"),
        (0x969a, 0x969a, "FP constant 0.5"),
        (0x969d, 0x96e5, "raise FPA2 to power varptr X"),
        (0x969d, 0x969d, "load variable into FPA1 (X is varptr)"),
        (0x96a0, 0x96a0, "EXP"),
        (0x96a7, 0x96a7, "?/0 ERROR"),
        (0x96ab, 0x96ab, "clear FPA1 exponents"),
        (0x96b1, 0x96b1, "assign FPA1 to varptr in X"),
        (0x96b9, 0x96b9, "INT"),
        (0x96c1, 0x96c1, "compare FPA1 - varptr X (of same sign)"),
        (0x96c9, 0x96c9, "copy FPA2 to FPA1 & put A in $54"),
        (0x96ce, 0x96ce, "LOG"),
        (0x96d4, 0x96d4, "multiply varptr X & FPA1"),
        (0x96d7, 0x96d7, "EXP"),
        (0x96dc, 0x96dc, "RTS"),
        (0x96e5, 0x96e5, "FP constant 1/ln 2"),
        (0x96ea, 0x970e, "EXP series coefficient table"),
        (0x96ea, 0x970e, "values appear to be error compensated"),
        (0x96eb, 0x96eb, "FP constant .0000214987637  (ln2)^7 / 7!"),
        (0x96f0, 0x96f0, "FP constant .0001435231404  (ln2)^6 / 6!"),
        (0x96f5, 0x96f5, "FP constant .001342263483   (ln2)^5 / 5!"),
        (0x96fa, 0x96fa, "FP constant .009614017014   (ln2)^4 / 4!"),
        (0x96ff, 0x96ff, "FP constant .05550512686    (ln2)^3 / 3!"),
        (0x9704, 0x9704, "FP constant .2402263846     (ln2)^2 / 2!"),
        (0x9709, 0x9709, "FP constant .6931471862      ln2"),
        (0x970e, 0x970e, "FP constant 1"),
        (0x9713, 0x9742, "EXP"),
        (0x9713, 0x9742, "calculates exp(x) by first calculating q=x/ln2 such that exp(x) = 2^q"),
        (0x9713, 0x9742, "fractional part of q is used for good convergence"),
        (0x9713, 0x9742, "integer part of q is simply added to FPA1 exponent afterwards"),
        (0x9713, 0x9713, "FP constant 1/ln 2"),
        (0x9716, 0x9716, "multiply FPA1 by varptr X"),
        (0x9718, 0x9718, "assign FPA1 to variable store $40 - $44"),
        (0x9721, 0x9721, "?OV ERROR if FPA1 +ve else FPA1 = 0"),
        (0x9724, 0x9724, "INT"),
        (0x9727, 0x9727, "integer part of argument"),
        (0x972b, 0x972b, "?OV ERROR"),
        (0x9733, 0x9733, "FPA1 = varptr X - FPA1"),
        (0x9736, 0x9736, "EXP coefficient table"),
        (0x9739, 0x9739, "series calculation"),
        (0x973f, 0x973f, "add A to exponent in FPA1"),
        (0x9743, 0x974f, "calculate odd power series"),
        (0x9743, 0x974f, "X points to coefficient table (1st byte is n)"),
        (0x9743, 0x974f, "x in FPA1"),
        (0x9743, 0x974f, "result = (a0xx+a1)xx+a2)xx+a3 ...)xx+an) * x"),
        (0x9743, 0x974f, "( = a0*x^(2n+1) + a1*x^(2n-1) + ... + a(n-1)*x^3 + an*x )"),
        (0x9743, 0x974f, "result in FPA1"),
        (0x9745, 0x9745, "assign FPA1 to variable store $40 - $44"),
        (0x9748, 0x9748, "multiply varptr X & FPA1 (x squared)"),
        (0x974a, 0x974a, "calculate series"),
        (0x974f, 0x974f, "multiply varptr X & FPA1 (odd powers)"),
        (0x9752, 0x9771, "calculate power series (polynomial of nth order)"),
        (0x9752, 0x9771, "X points to coefficient table (1st byte is n)"),
        (0x9752, 0x9771, "x in FPA1"),
        (0x9752, 0x9771, "result = (a0x+a1)x+a2)x+a3 ...)x+an"),
        (0x9752, 0x9771, "( = a0*x^n + a1*x^(n-1) + ... + a(n-1)*x + an )"),
        (0x9752, 0x9771, "result in FPA1"),
        (0x9754, 0x9754, "assign FPA1 to variable store $45 - $49"),
        (0x975f, 0x975f, "multiply varptr X & FPA1"),
        (0x9767, 0x9767, "add varptr X to FPA1"),
        (0x9772, 0x97c4, "RND"),
        (0x9772, 0x9772, "sets B to -1, 0 or 1 as per sign of FPA1"),
        (0x9779, 0x9779, "INT"),
        (0x977b, 0x977b, "assign FPA1 to variable store $40 - $44"),
        (0x9783, 0x9783, "multiply varptr X & FPA1"),
        (0x9785, 0x9785, "FP constant 1"),
        (0x9788, 0x9788, "add varptr X to FPA1"),
        (0x978b, 0x978b, "INT"),
        (0x97a2, 0x97a2, "multiply FPA1 by mantissa in FPA2"),
        (0x97c4, 0x97c4, "normalize FPA1"),
        (0x97c7, 0x97c7, "RND multiplier"),
        (0x97cb, 0x97ce, "COS ... cos x = sin (x+pi/2)"),
        (0x97cb, 0x97cb, "FP constant pi/2"),
        (0x97ce, 0x97ce, "add varptr X to FPA1"),
        (0x97d1, 0x9813, "SIN"),
        (0x97d1, 0x97d1, "copy FPA1 to FPA2"),
        (0x97d4, 0x97d4, "FP constant 2*pi"),
        (0x97d9, 0x97d9, "STB $62 & divide FPA2 by varptr X (result FPA1)"),
        (0x97dc, 0x97dc, "copy FPA1 to FPA2"),
        (0x97df, 0x97df, "INT"),
        (0x97e7, 0x97e7, "subtract FPA1 from FPA2 (B=FPA1 exponent)"),
        (0x97ea, 0x97ea, "FP constant 0.25"),
        (0x97ed, 0x97ed, "FPA1 = varptr X - FPA1"),
        (0x97f4, 0x97f4, "angle is 1st quadrant"),
        (0x97f6, 0x97f6, "add 0.5 to FPA1"),
        (0x97ff, 0x97ff, "COM $54 if FPA1 non zero"),
        (0x9802, 0x9802, "FP constant 0.25"),
        (0x9805, 0x9805, "add varptr X to FPA1"),
        (0x980d, 0x980d, "COM $54 if FPA1 non zero"),
        (0x9810, 0x9810, "series coefficients"),
        (0x9813, 0x9813, "calculate odd power series"),
        (0x9816, 0x9849, "TAN ... tan x = sin x / cos x"),
        (0x9816, 0x9816, "assign FPA1 to variable store $40 - $44"),
        (0x981b, 0x981b, "SIN"),
        (0x9820, 0x9820, "assign FPA1 to varptr in X"),
        (0x9826, 0x9826, "load variable into FPA1 (X is varptr)"),
        (0x982d, 0x982d, "must calculate cos"),
        (0x9831, 0x9831, "?OV ERROR"),
        (0x9838, 0x9838, "FPA1 = varptr X / FPA1"),
        (0x983f, 0x983f, "FP constant pi/2"),
        (0x9844, 0x9844, "FP constant 2*pi"),
        (0x9849, 0x9849, "FP constant 0.25"),
        (0x984e, 0x9872, "sin series coefficient table"),
        (0x984e, 0x9872, "values appear to be error compensated"),
        (0x984f, 0x984f, "FP constant -14.38139067   -(2pi)^11 / 11!"),
        (0x9854, 0x9854, "FP constant  42.00779712    (2pi)^9 / 9!"),
        (0x9859, 0x9859, "FP constant -76.70417025   -(2pi)^7 / 7!"),
        (0x985e, 0x985e, "FP constant  81.60522368    (2pi)^5 / 5!"),
        (0x9863, 0x9863, "FP constant -41.34170211   -(2pi)^3 / 3!"),
        (0x9868, 0x9868, "FP constant  2*pi"),
        (0x986d, 0x986d, "FP constant  7324114470"),
        (0x9872, 0x9872, "FP constant  26913.76914"),
        (0x9877, 0x98a5, "ATN"),
        (0x9877, 0x98a5, "calculates atn(x) or pi/2-atn(1/x)"),
        (0x9877, 0x98a5, "same result either way but series only works -1 < x <= 1"),
        (0x987d, 0x987d, "COM $54 if FPA1 non zero"),
        (0x9887, 0x9887, "FP constant 1"),
        (0x988a, 0x988a, "divide varptr X by FPA1"),
        (0x988c, 0x988c, "series coefficients"),
        (0x988f, 0x988f, "calculate odd power series"),
        (0x9897, 0x9897, "FP constant pi/2"),
        (0x989a, 0x989a, "FPA1 = varptr X - FPA1"),
        (0x98a2, 0x98a2, "COM $54 if FPA1 non zero"),
        (0x98a6, 0x98de, "ATN series coefficients"),
        (0x98a6, 0x98de, "values appear to be error compensated"),
        (0x98a7, 0x98a7, "FP constant -.0006847939119"),
        (0x98ac, 0x98ac, "FP constant  .004850942155"),
        (0x98b1, 0x98b1, "FP constant -.01611170184"),
        (0x98b6, 0x98b6, "FP constant  .03420963805"),
        (0x98bb, 0x98bb, "FP constant -.05427913276"),
        (0x98c0, 0x98c0, "FP constant  .07245719654"),
        (0x98c5, 0x98c5, "FP constant -.08980239538"),
        (0x98ca, 0x98ca, "FP constant  .1109324134"),
        (0x98cf, 0x98cf, "FP constant -.1425398077"),
        (0x98d4, 0x98d4, "FP constant  .1999991205"),
        (0x98d9, 0x98d9, "FP constant -.3333333157"),
        (0x98de, 0x98de, "FP constant 1"),
        (0x98e3, 0x98ff, "part of reset routine: sets up sound & graphics variables"),
        (0x98e6, 0x98e6, "PLAY volume data"),
        (0x98ea, 0x98ea, "PLAY tempo"),
        (0x98ec, 0x98ec, "PLAY octave"),
        (0x98ef, 0x98ef, "PLAY note length"),
        (0x98f1, 0x98f1, "PLAY duration"),
        (0x98f3, 0x98f3, "zero"),
        (0x98f5, 0x98f5, "DRAW angle"),
        (0x98f9, 0x98f9, "graphics X"),
        (0x98fd, 0x98fd, "graphics Y"),
        (0x9900, 0x9948, "called by CSAVE to do CSAVEM"),
        (0x9900, 0x9900, "get next character from BASIC source"),
        (0x9902, 0x9902, "get filename"),
        (0x9905, 0x9905, "get start address"),
        (0x990a, 0x990a, "get end address"),
        (0x990e, 0x990e, "?FC ERROR"),
        (0x9912, 0x9912, "get entry address"),
        (0x9917, 0x9917, "get current character from BASIC source"),
        (0x991b, 0x991b, "file type = 2 = binary"),
        (0x991d, 0x991d, "non-ASCII & ungapped"),
        (0x991f, 0x991f, "write filename block"),
        (0x9922, 0x9922, "cassette status"),
        (0x9924, 0x9924, "block type"),
        (0x9926, 0x9926, "write leader"),
        (0x992b, 0x992b, "IO buffer"),
        (0x992f, 0x992f, "block length"),
        (0x9933, 0x9933, "IO buffer"),
        (0x9939, 0x9939, "NEG $7c CLR $7d & write last block"),
        (0x9943, 0x9943, "block length"),
        (0x9945, 0x9945, "write block to tape"),
        (0x994a, 0x9954, "get a number from command and leave it on stack"),
        (0x994a, 0x994a, "skip comma"),
        (0x994d, 0x994d, "read 16 bit number into X"),
        (0x9956, 0x9962, "FIX"),
        (0x9956, 0x9956, "sets B to -1, 0 or 1 as per sign of FPA1"),
        (0x995b, 0x995b, "INT"),
        (0x9962, 0x9962, "COM $54 if FPA1 non zero"),
        (0x9965, 0x99e5, "EDIT"),
        (0x9965, 0x9965, "get line number in $2b"),
        (0x9968, 0x9968, "lose return address"),
        (0x996e, 0x996e, "search program for line number in <$2b"),
        (0x9971, 0x9971, "?UL ERROR"),
        (0x9975, 0x9975, "detokenize BASIC line"),
        (0x997d, 0x997d, "line length"),
        (0x9981, 0x9981, "print unsigned number in D"),
        (0x9984, 0x9984, "print a space to DEVN"),
        (0x998c, 0x998c, "print entire line"),
        (0x998f, 0x998f, "read keys (carry clear if control key)"),
        (0x9992, 0x9992, "set carry if A is non-numeric character"),
        (0x9997, 0x9997, "accumulate typed digits in B"),
        (0x99a6, 0x99a6, "(A = abandon changes & start again)"),
        (0x99aa, 0x99aa, "send CR to DEVN"),
        (0x99af, 0x99af, "(L = show line in current state)"),
        (0x99b3, 0x99b3, "output ASCIIZ string to DEVN (X is pointer)"),
        (0x99b7, 0x99b7, "send CR to DEVN"),
        (0x99bc, 0x99bc, "lose return address"),
        (0x99be, 0x99be, "(RETURN = save changes, show line & quit)"),
        (0x99c2, 0x99c2, "output ASCIIZ string to DEVN (X is pointer)"),
        (0x99c4, 0x99c4, "send CR to DEVN"),
        (0x99ca, 0x99ca, "BASIC source pointer"),
        (0x99cc, 0x99cc, "enter BASIC line"),
        (0x99cf, 0x99cf, "(E = save changes & quit)"),
        (0x99d3, 0x99d3, "(Q = discard changes & quit)"),
        (0x99d7, 0x99d7, "send CR to DEVN"),
        (0x99da, 0x99da, "command mode"),
        (0x99e1, 0x99e1, "(SPACE = show more characters)"),
        (0x99e8, 0x99f4, "output ASCIIZ string to DEVN (stops at 249 characters)"),
        (0x99e8, 0x99f4, "(99E6 C6F9       LDB   #$F9)"),
        (0x99ec, 0x99ec, "output character to DEVN"),
        (0x99f2, 0x99f2, "show another (in EDIT context)"),
        (0x99f5, 0x9a02, "EDIT: test for Delete"),
        (0x99f5, 0x99f5, "(D = delete a number of characters)"),
        (0x99fd, 0x99fd, "close line up over removed character"),
        (0x9a03, 0x9a0f, "EDIT: close line up over removed character"),
        (0x9a10, 0x9a3f, "EDIT: test for insert mode functions"),
        (0x9a10, 0x9a10, "(I = insert mode)"),
        (0x9a14, 0x9a14, "(X = insert mode at end of line)"),
        (0x9a18, 0x9a18, "(H = wipe rest of line & insert)"),
        (0x9a23, 0x9a23, "updated line length"),
        (0x9a25, 0x9a25, "output ASCIIZ string to DEVN (X is pointer)"),
        (0x9a27, 0x9a27, "read keys (carry clear if control key)"),
        (0x9a2c, 0x9a2c, "RETURN"),
        (0x9a30, 0x9a30, "RTS (escape insert mode)"),
        (0x9a34, 0x9a34, "not backspace"),
        (0x9a39, 0x9a39, "nothing to delete"),
        (0x9a3b, 0x9a3b, "delete it on screen"),
        (0x9a3d, 0x9a3d, "delete it in memory"),
        (0x9a41, 0x9a57, "EDIT: test for Change"),
        (0x9a41, 0x9a41, "(C = change a number of characters)"),
        (0x9a47, 0x9a47, "RTS"),
        (0x9a49, 0x9a49, "read keys (carry clear if control key)"),
        (0x9a52, 0x9a52, "output character to DEVN"),
        (0x9a55, 0x9a55, "change another"),
        (0x9a58, 0x9a76, "EDIT: typed characters in insert mode"),
        (0x9a5e, 0x9a5e, "line full"),
        (0x9a62, 0x9a62, "create a space for character"),
        (0x9a72, 0x9a72, "output character to DEVN"),
        (0x9a78, 0x9a81, "EDIT: backspace over a number of characters"),
        (0x9a7f, 0x9a7f, "backspace again"),
        (0x9a82, 0x9a8b, "EDIT: backspace"),
        (0x9a85, 0x9a85, "RTS"),
        (0x9a8b, 0x9a8b, "output character to DEVN"),
        (0x9a8e, 0x9a96, "EDIT: test for search functions"),
        (0x9a8e, 0x9a8e, "(K = wipe chrs until nth occurrence of chr)"),
        (0x9a92, 0x9a92, "(S = search for nth occurrence of chr)"),
        (0x9a97, 0x9ab7, "EDIT: search functions"),
        (0x9a99, 0x9a99, "read keys (carry clear if control key)"),
        (0x9a9f, 0x9a9f, "PULS Y,PC"),
        (0x9aa3, 0x9aa3, "Kill (not Search)"),
        (0x9aa5, 0x9aa5, "output character to DEVN"),
        (0x9aab, 0x9aab, "close line up over removed character"),
        (0x9ab2, 0x9ab2, "not found"),
        (0x9ab5, 0x9ab5, "find next occurrence"),
        (0x9ab9, 0x9ad8, "read keys (carry clear if control key)"),
        (0x9ab9, 0x9ab9, "read character from DEVN & strip MSB"),
        (0x9abe, 0x9abe, "pointless test!"),
        (0x9ac2, 0x9ac2, "not shift + CU"),
        (0x9ac8, 0x9ac8, "return"),
        (0x9acc, 0x9acc, "escape"),
        (0x9ad0, 0x9ad0, "backspace"),
        (0x9ad4, 0x9ad4, "illegal"),
        (0x9ad9, 0x9ad9, "TRON"),
        (0x9adb, 0x9add, "TROFF"),
        (0x9adb, 0x9add, "(9ADA 4F         CLRA)"),
        (0x9ade, 0x9af1, "POS"),
        (0x9ade, 0x9ade, "DEVN"),
        (0x9ae2, 0x9ae2, "load DEVN from FPA1"),
        (0x9ae5, 0x9ae5, "if DEVN = -1, test cassette OK for output"),
        (0x9ae8, 0x9ae8, "initialise virtual DEVN device"),
        (0x9aeb, 0x9aeb, "device current column"),
        (0x9aef, 0x9aef, "DEVN"),
        (0x9af1, 0x9af1, "assign B to FPA1"),
        (0x9af4, 0x9b09, "VARPTR"),
        (0x9af4, 0x9af4, "skip open bracket"),
        (0x9af7, 0x9af7, "end of BASIC storage"),
        (0x9afb, 0x9afb, "get varptr of variable in X"),
        (0x9afe, 0x9afe, "skip close bracket"),
        (0x9b05, 0x9b05, "not allowed to create new variable"),
        (0x9b07, 0x9b07, "?FC ERROR"),
        (0x9b09, 0x9b09, "assign D to FPA1"),
        (0x9b0c, 0x9b7c, "MID$ on LHS"),
        (0x9b0c, 0x9b0c, "get next character from BASIC source"),
        (0x9b0e, 0x9b0e, "skip open bracket"),
        (0x9b11, 0x9b11, "get varptr of variable in X"),
        (0x9b18, 0x9b18, "stack root / string storage start"),
        (0x9b1d, 0x9b1d, "top of BASIC RAM"),
        (0x9b23, 0x9b23, "reserve B bytes of string space"),
        (0x9b2a, 0x9b2a, "copy string (len B) from varptr X to ($25)+"),
        (0x9b39, 0x9b39, "?FC ERROR"),
        (0x9b46, 0x9b46, "skip close bracket"),
        (0x9b4b, 0x9b4b, "skip character in B"),
        (0x9b4e, 0x9b4e, "get string expression & point X to it"),
        (0x9b5a, 0x9b5a, "?FC ERROR"),
        (0x9b79, 0x9b79, "copy B bytes from X to U"),
        (0x9b7e, 0x9b81, "get string expression & point X to it (B=len)"),
        (0x9b7e, 0x9b7e, "get expression"),
        (0x9b81, 0x9b81, "validate string & point X to it (B=len)"),
        (0x9b84, 0x9bb1, "STRING$"),
        (0x9b84, 0x9b84, "skip open bracket"),
        (0x9b87, 0x9b87, "get number into B"),
        (0x9b8c, 0x9b8c, "skip comma"),
        (0x9b8f, 0x9b8f, "get expression"),
        (0x9b92, 0x9b92, "skip close bracket"),
        (0x9b95, 0x9b95, "numeric / string flag"),
        (0x9b99, 0x9b99, "read 8 bit value into B from FPA1"),
        (0x9b9e, 0x9b9e, "get 1st character of string into B"),
        (0x9ba3, 0x9ba3, "number of copies"),
        (0x9ba5, 0x9ba5, "reserve B bytes of string space"),
        (0x9bb4, 0x9c0e, "INSTR"),
        (0x9bb4, 0x9bb4, "skip open bracket"),
        (0x9bb7, 0x9bb7, "get expression"),
        (0x9bba, 0x9bba, "default start position"),
        (0x9bbe, 0x9bbe, "numeric / string flag"),
        (0x9bc0, 0x9bc0, "start pos not specified"),
        (0x9bc2, 0x9bc2, "read 8 bit value into B from FPA1"),
        (0x9bc7, 0x9bc7, "?FC ERROR"),
        (0x9bc9, 0x9bc9, "skip comma"),
        (0x9bcc, 0x9bcc, "get expression"),
        (0x9bcf, 0x9bcf, "validate string expression"),
        (0x9bd6, 0x9bd6, "skip comma"),
        (0x9bd9, 0x9bd9, "get string expression & point X to it"),
        (0x9bde, 0x9bde, "skip close bracket"),
        (0x9be1, 0x9be1, "varptr of main string"),
        (0x9be3, 0x9be3, "point X to string & length in B"),
        (0x9bea, 0x9bea, "main string is shorter than start pos"),
        (0x9bec, 0x9bec, "target string length"),
        (0x9bf0, 0x9bf0, "start pos"),
        (0x9bf4, 0x9bf4, "Y = X = position to start search"),
        (0x9bf6, 0x9bf6, "U -> target characters"),
        (0x9bf8, 0x9bf8, "B = target length"),
        (0x9bfa, 0x9bfa, "A = main string length"),
        (0x9bfe, 0x9bfe, "A = A - start pos + 1"),
        (0x9c01, 0x9c01, "remaining length is shorter than target"),
        (0x9c07, 0x9c07, "didn't match"),
        (0x9c0a, 0x9c0a, "test next character in target"),
        (0x9c0c, 0x9c0c, "found it"),
        (0x9c10, 0x9c19, "(9C0F 5F         CLRB)"),
        (0x9c12, 0x9c12, "assign B to FPA1"),
        (0x9c17, 0x9c17, "advance start pos & try again"),
        (0x9c1b, 0x9c3c, "read octal or hex number from command into $52 / $53"),
        (0x9c22, 0x9c22, "get next character from BASIC source"),
        (0x9c2c, 0x9c2c, "get current character from BASIC source"),
        (0x9c32, 0x9c32, "?SN ERROR"),
        (0x9c38, 0x9c38, "shift word at ,X left B bits"),
        (0x9c3a, 0x9c3a, "get next character from BASIC source"),
        (0x9c3e, 0x9c4c, "assign contents of $52 / $53 to FPA1"),
        (0x9c42, 0x9c42, "numeric / string flag"),
        (0x9c4c, 0x9c4c, "normalize FPA1"),
        (0x9c4f, 0x9c62, "read hex digits from command into ,X"),
        (0x9c4f, 0x9c4f, "get next character from BASIC source"),
        (0x9c53, 0x9c53, "carry clear if A-Z"),
        (0x9c56, 0x9c56, "assign contents of $52 / $53 to FPA1"),
        (0x9c5a, 0x9c5a, "assign contents of $52 / $53 to FPA1"),
        (0x9c60, 0x9c60, "shift word at ,X left B bits"),
        (0x9c64, 0x9c75, "shift word at ,X left B bits"),
        (0x9c68, 0x9c68, "?OV ERROR"),
        (0x9c76, 0x9c7e, "cause error if in command mode"),
        (0x9c76, 0x9c76, "current line number"),
        (0x9c7a, 0x9c7a, "not in command mode"),
        (0x9c7c, 0x9c7c, "?ID ERROR"),
        (0x9c7e, 0x9c7e, "cause error"),
        (0x9c81, 0x9cff, "DEF"),
        (0x9c85, 0x9c85, "DEF USR"),
        (0x9c8e, 0x9c8e, "test for command mode"),
        (0x9c90, 0x9c90, "skip open bracket"),
        (0x9c95, 0x9c95, "array illegal flag"),
        (0x9c97, 0x9c97, "get varptr of variable in X"),
        (0x9c9c, 0x9c9c, "skip close bracket"),
        (0x9ca1, 0x9ca1, "skip character in B"),
        (0x9ca6, 0x9ca6, "BASIC source pointer"),
        (0x9cae, 0x9cae, "skip to start of next statement"),
        (0x9cb1, 0x9cb1, "token FN"),
        (0x9cb3, 0x9cb3, "skip character in B"),
        (0x9cb8, 0x9cb8, "array illegal flag"),
        (0x9cc1, 0x9cc1, "validate numeric expression"),
        (0x9cc8, 0x9cc8, "get expression inside brackets"),
        (0x9ccf, 0x9ccf, "?UF ERROR"),
        (0x9cd3, 0x9cd3, "cause error"),
        (0x9cd5, 0x9cd5, "BASIC source pointer"),
        (0x9cda, 0x9cda, "BASIC source pointer"),
        (0x9ce6, 0x9ce6, "assign FPA1 to varptr in X"),
        (0x9ce9, 0x9ce9, "read numeric expression into FPA1"),
        (0x9cf6, 0x9cf6, "get current character from BASIC source"),
        (0x9cf8, 0x9cf8, "?SN ERROR"),
        (0x9cfc, 0x9cfc, "BASIC source pointer"),
        (0x9d00, 0x9d0c, "DEF USRx = address"),
        (0x9d00, 0x9d00, "get next character from BASIC source"),
        (0x9d02, 0x9d02, "get next character from BASIC source"),
        (0x9d0d, 0x9d1c, "called by USR: converts following digit into USR table pointer"),
        (0x9d0e, 0x9d0e, "get current character from BASIC source"),
        (0x9d16, 0x9d16, "get next character from BASIC source"),
        (0x9d18, 0x9d18, "address of USR table"),
        (0x9d1d, 0x9d34, "USRx"),
        (0x9d23, 0x9d23, "get expression inside brackets"),
        (0x9d26, 0x9d26, "FPA1"),
        (0x9d29, 0x9d29, "numeric / string flag"),
        (0x9d2d, 0x9d2d, "point X to string just compiled & len in B"),
        (0x9d32, 0x9d32, "numeric / string flag"),
        (0x9d35, 0x9d3a, "skips = sign & reads 16 bit number into X"),
        (0x9d35, 0x9d35, "token ="),
        (0x9d37, 0x9d37, "skip character in B"),
        (0x9d3a, 0x9d3a, "read 16 bit number into X"),
        (0x9d3d, 0x9d4e, "IRQ service routine"),
        (0x9d40, 0x9d40, "vsync"),
        (0x9d46, 0x9d46, "TIMER value"),
        (0x9d4e, 0x9d4e, "...continued"),
        (0x9d51, 0x9d58, "TIMER on LHS"),
        (0x9d51, 0x9d51, "get next character from BASIC source"),
        (0x9d55, 0x9d55, "TIMER value"),
        (0x9d59, 0x9d5e, "TIMER"),
        (0x9d59, 0x9d59, "TIMER value"),
        (0x9d5e, 0x9d5e, "assign contents of $52 / $53 to FPA1"),
        (0x9d61, 0x9d83, "DEL"),
        (0x9d61, 0x9d61, "?FC ERROR"),
        (0x9d65, 0x9d65, "read line number & store in $2b"),
        (0x9d68, 0x9d68, "search program for line number in <$2b"),
        (0x9d6d, 0x9d6d, "get current character from BASIC source"),
        (0x9d71, 0x9d71, "token -"),
        (0x9d75, 0x9d75, "get next character from BASIC source"),
        (0x9d86, 0x9db0, "(9D84 EEC4       LDU   ,U)"),
        (0x9d92, 0x9d92, "move program down from U to X"),
        (0x9d94, 0x9d94, "clear variables and reset stack & cmd ptr"),
        (0x9d99, 0x9d99, "set up next line pointers from X onwards"),
        (0x9d9c, 0x9d9c, "command mode"),
        (0x9d9f, 0x9d9f, "read line number & store in $2b"),
        (0x9da2, 0x9da2, "cause error if next byte is not zero"),
        (0x9da9, 0x9da9, "start of simple variables"),
        (0x9dae, 0x9dae, "start of simple variables"),
        (0x9db1, 0x9dea, "LINE INPUT"),
        (0x9db1, 0x9db1, "test for command mode"),
        (0x9db4, 0x9db4, "get next character from BASIC source"),
        (0x9dba, 0x9dba, "read #-n & set up DEVN"),
        (0x9dbd, 0x9dbd, "test cassette status OK for input"),
        (0x9dc0, 0x9dc0, "skip comma"),
        (0x9dc5, 0x9dc5, "no prompt"),
        (0x9dc7, 0x9dc7, "read literal string"),
        (0x9dcc, 0x9dcc, "skip character in B"),
        (0x9dcf, 0x9dcf, "print string just compiled"),
        (0x9dd9, 0x9dd9, "DEVN"),
        (0x9ddb, 0x9ddb, "get varptr of variable in X"),
        (0x9de0, 0x9de0, "validate string expression"),
        (0x9de7, 0x9de7, "compile literal string at X"),
        (0x9dea, 0x9dea, "assign string variable"),
        (0x9ded, 0x9df2, "read line number into X & $2b"),
        (0x9ded, 0x9ded, "read line number & store in $2b"),
        (0x9df3, 0x9df7, "RENUM: search for start line"),
        (0x9df7, 0x9df7, "search program for line number in <$2b"),
        (0x9dfa, 0x9e55, "RENUM"),
        (0x9dfa, 0x9dfa, "clear variables & reset stack"),
        (0x9e00, 0x9e00, "default RENUM 10,0,10"),
        (0x9e07, 0x9e07, "get current character from BASIC source"),
        (0x9e0b, 0x9e0b, "read line number into X & $2b"),
        (0x9e0d, 0x9e0d, "new start line"),
        (0x9e0f, 0x9e0f, "get current character from BASIC source"),
        (0x9e13, 0x9e13, "skip comma"),
        (0x9e18, 0x9e18, "read line number into X & $2b"),
        (0x9e1a, 0x9e1a, "line to start renumbering at"),
        (0x9e1c, 0x9e1c, "get current character from BASIC source"),
        (0x9e20, 0x9e20, "skip comma"),
        (0x9e25, 0x9e25, "read line number into X & $2b"),
        (0x9e27, 0x9e27, "line increment"),
        (0x9e29, 0x9e29, "?FC ERROR"),
        (0x9e2b, 0x9e2b, "cause error if next byte is not zero"),
        (0x9e2e, 0x9e2e, "search for start line"),
        (0x9e30, 0x9e30, "save address"),
        (0x9e34, 0x9e34, "search for new start line"),
        (0x9e36, 0x9e36, "not allowed to be lower than start line"),
        (0x9e38, 0x9e38, "?FC ERROR"),
        (0x9e3a, 0x9e3a, "dry run - check lines don't get too high"),
        (0x9e3c, 0x9e3c, "prepare line numbers in statements"),
        (0x9e3f, 0x9e3f, "set up next line pointers in BASIC program"),
        (0x9e42, 0x9e42, "search for start line"),
        (0x9e44, 0x9e44, "save address"),
        (0x9e46, 0x9e46, "convert line numbers to addresses"),
        (0x9e48, 0x9e48, "do the actual renumbering"),
        (0x9e4a, 0x9e4a, "convert addresses to line numbers"),
        (0x9e4c, 0x9e4c, "convert line numbers back to ASCII"),
        (0x9e4f, 0x9e4f, "clear variables & reset stack"),
        (0x9e52, 0x9e52, "set up next line pointers in BASIC program"),
        (0x9e55, 0x9e55, "command mode"),
        (0x9e58, 0x9e58, "RENUM: dry run to check that line numbers don't get too high"),
        (0x9e5a, 0x9e74, "RENUM: renumber!"),
        (0x9e5a, 0x9e74, "(9E59 4F         CLRA)"),
        (0x9e5c, 0x9e5c, "start address"),
        (0x9e5e, 0x9e5e, "new start number"),
        (0x9e60, 0x9e60, "test for end of program"),
        (0x9e62, 0x9e62, "dry run flag"),
        (0x9e66, 0x9e66, "store new line number"),
        (0x9e68, 0x9e68, "point X to next line"),
        (0x9e6a, 0x9e6a, "test for end of program"),
        (0x9e6c, 0x9e6c, "increment line number"),
        (0x9e6e, 0x9e6e, "?FC ERROR"),
        (0x9e74, 0x9e74, "?FC ERROR"),
        (0x9e77, 0x9e81, "RENUM: test for end of program"),
        (0x9e7f, 0x9e7f, "return 2 levels if at end of program"),
        (0x9e82, 0x9ecc, "RENUM: on 1st call converts the line numbers in each info block"),
        (0x9e82, 0x9ecc, "into line addresses. On 2nd call converts them back into"),
        (0x9e82, 0x9ecc, "line numbers."),
        (0x9e82, 0x9e82, "start of BASIC program"),
        (0x9e88, 0x9e88, "test for end of program"),
        (0x9e90, 0x9e90, "end of line"),
        (0x9e95, 0x9e95, "1st pass - convert line number to address"),
        (0x9e98, 0x9e98, "2nd pass - convert address to line number"),
        (0x9ea3, 0x9ea3, "reconstruct line number coded in block"),
        (0x9eb5, 0x9eb5, "search program for line number in <$2b"),
        (0x9eba, 0x9eba, "line not found - store a 3 for 'UL'"),
        (0x9ebc, 0x9ebc, "address of line"),
        (0x9ec4, 0x9ec4, "becomes a 1 in a moment"),
        (0x9ec6, 0x9ec6, "address of line"),
        (0x9ec8, 0x9ec8, "actual line number"),
        (0x9ecc, 0x9ecc, "store it in info block"),
        (0x9ece, 0x9f6a, "RENUM: prepare line numbers in statements"),
        (0x9ece, 0x9f6a, "(replaces line number digits with 5 byte info block)"),
        (0x9ece, 0x9ece, "start of BASIC program"),
        (0x9ed2, 0x9ed2, "BASIC source pointer"),
        (0x9ed6, 0x9ed6, "test for end of program"),
        (0x9edc, 0x9edc, "BASIC source pointer"),
        (0x9ede, 0x9ede, "get next character from BASIC source"),
        (0x9ee1, 0x9ee1, "end of line"),
        (0x9ee3, 0x9ee3, "non-token"),
        (0x9ee5, 0x9ee5, "BASIC source pointer"),
        (0x9ee9, 0x9ee9, "skip function token"),
        (0x9eeb, 0x9eeb, "PATCH - CLS GET PUT ???"),
        (0x9eee, 0x9eee, "token THEN"),
        (0x9ef2, 0x9ef2, "token ELSE"),
        (0x9ef6, 0x9ef6, "token GO"),
        (0x9efa, 0x9efa, "get next character from BASIC source"),
        (0x9efc, 0x9efc, "token TO"),
        (0x9f00, 0x9f00, "token SUB"),
        (0x9f02, 0x9f02, "keep looking for interesting stuff"),
        (0x9f04, 0x9f04, "get next character from BASIC source"),
        (0x9f06, 0x9f06, "found digit"),
        (0x9f08, 0x9f08, "get current character from BASIC source"),
        (0x9f0c, 0x9f0c, "BASIC source pointer"),
        (0x9f0e, 0x9f0e, "start of digits"),
        (0x9f10, 0x9f10, "read line number & store in $2b"),
        (0x9f13, 0x9f13, "BASIC source pointer"),
        (0x9f17, 0x9f17, "set carry if A is non-numeric character"),
        (0x9f1c, 0x9f1c, "end of digits"),
        (0x9f24, 0x9f24, "exactly 5 digits"),
        (0x9f26, 0x9f26, "less than 5 digits"),
        (0x9f2d, 0x9f2d, "move program down from U to X"),
        (0x9f34, 0x9f34, "start of simple variables"),
        (0x9f3d, 0x9f3d, "start of simple variables"),
        (0x9f3f, 0x9f3f, "move memory contents up"),
        (0x9f44, 0x9f44, "BASIC source pointer"),
        (0x9f46, 0x9f46, "start of digits"),
        (0x9f4a, 0x9f4a, "replace line number with 5 byte info block"),
        (0x9f4c, 0x9f4c, "line number coded to avoid zeros"),
        (0x9f4e, 0x9f4e, "otherwise world would fall apart"),
        (0x9f64, 0x9f64, "get current character from BASIC source"),
        (0x9f68, 0x9f68, "comma - look for another line number"),
        (0x9f6c, 0x9fca, "RENUM: convert line numbers into ASCII again (also flags UL errors)"),
        (0x9f6c, 0x9f6c, "start of BASIC program"),
        (0x9f74, 0x9f74, "current line number"),
        (0x9f76, 0x9f76, "test for end of program"),
        (0x9f7f, 0x9f7f, "end of line"),
        (0x9f82, 0x9f82, "found an info block"),
        (0x9f8a, 0x9f8a, "/UL /"),
        (0x9f8d, 0x9f8d, "print string to DEVN"),
        (0x9f94, 0x9f94, "print unsigned number in D"),
        (0x9f97, 0x9f97, "print 'IN xxxx' (current line number)"),
        (0x9f9a, 0x9f9a, "send CR to DEVN"),
        (0x9fa1, 0x9fa1, "adjusted line number"),
        (0x9fa5, 0x9fa5, "assign contents of $52 / $53 to FPA1"),
        (0x9fa8, 0x9fa8, "convert FPA1 to string at $3DA"),
        (0x9faf, 0x9faf, "write line number into program"),
        (0x9fbd, 0x9fbd, "exactly 5 digits - no problem"),
        (0x9fc3, 0x9fc3, "move program down from U to X"),
        (0x9fca, 0x9fca, "/UL /"),
        (0x9fce, 0x9fd6, "MEM continued"),
        (0x9fce, 0x9fce, "end of BASIC storage"),
        (0x9fd0, 0x9fd0, "numeric / string flag"),
        (0x9fd4, 0x9fd4, "meaningless"),
        (0x9fd6, 0x9fd6, "assign contents of $52 / $53 to FPA1"),
        (0x9fd9, 0x9fff, "unused"),
        (0xa000, 0xa00c, "($A000 - $BFFF)"),
        (0xa000, 0xa00c, "indirect jump vectors"),
        (0xa000, 0xa000, "scan keyboard"),
        (0xa002, 0xa002, "output character to DEVN"),
        (0xa004, 0xa004, "read leader"),
        (0xa006, 0xa006, "read block"),
        (0xa008, 0xa008, "write block"),
        (0xa00a, 0xa00a, "update joysticks"),
        (0xa00c, 0xa00c, "write leader"),
        (0xa00e, 0xa046, "HEX$"),
        (0xa00e, 0xa00e, "read 16 bit number into X from FPA1 (& $52)"),
        (0xa01b, 0xa01b, "get a nibble into B"),
        (0xa024, 0xa024, "digit non-zero"),
        (0xa029, 0xa029, "at last digit"),
        (0xa02e, 0xa02e, "don't store leading zeroes"),
        (0xa034, 0xa034, "not A - F"),
        (0xa041, 0xa041, "lose return address"),
        (0xa046, 0xa046, "register string at X"),
        (0xa049, 0xa08b, "DLOAD"),
        (0xa049, 0xa08b, "There is a logic bug in the serial system. The routines that call"),
        (0xa049, 0xa08b, "the serial I/O drivers expect to see the Z flag set for success. The"),
        (0xa049, 0xa08b, "serial drivers don't change the flags, however. Either re-write the"),
        (0xa049, 0xa08b, "drivers for correct operation or skip the checks by changing BNE to"),
        (0xa049, 0xa08b, "BRN at locations $a13d, $a16e & $a1ab."),
        (0xa049, 0xa049, "close cassette stream & set DEVN to 0"),
        (0xa04e, 0xa04e, "get current character from BASIC source"),
        (0xa056, 0xa056, "get next character from BASIC source"),
        (0xa058, 0xa058, "get filename"),
        (0xa05b, 0xa05b, "get current character from BASIC source"),
        (0xa05f, 0xa05f, "check comma"),
        (0xa066, 0xa066, "get number in B"),
        (0xa069, 0xa069, "select baud rate"),
        (0xa06c, 0xa06c, "?FC ERROR"),
        (0xa070, 0xa070, "send filename & get 1st block"),
        (0xa077, 0xa077, "DEVN = -3"),
        (0xa07d, 0xa07d, "DLOADM"),
        (0xa07f, 0xa07f, "ensure nothing else on command line"),
        (0xa082, 0xa082, "B must not be 0"),
        (0xa083, 0xa083, "?FM ERROR"),
        (0xa085, 0xa085, "NEW BASIC"),
        (0xa088, 0xa088, "command mode / no device initialise"),
        (0xa08b, 0xa08b, "?FM ERROR"),
        (0xa08e, 0xa0a7, "called by CLOAD to handle CLOADM"),
        (0xa08e, 0xa08e, "cassette IO status"),
        (0xa090, 0xa090, "get next character from BASIC source"),
        (0xa092, 0xa092, "get filename"),
        (0xa095, 0xa095, "find file & set up buffer"),
        (0xa098, 0xa098, "gap flag"),
        (0xa09b, 0xa09b, "continuous file"),
        (0xa09f, 0xa09f, "U = file type & ASCII flag"),
        (0xa0a2, 0xa0a2, "DEVN"),
        (0xa0a4, 0xa0a4, "get block from tape"),
        (0xa0a9, 0xa0e1, "called by DLOAD to handle DLOADM"),
        (0xa0a9, 0xa0e1, "For both CLOADM & DLOADM, this is now a gapped binary file, with data"),
        (0xa0a9, 0xa0e1, "being read on a character by character basis. Note that data blocks do"),
        (0xa0a9, 0xa0e1, "not have to align with physical file blocks; the data is treated as a"),
        (0xa0a9, 0xa0e1, "continuous stream."),
        (0xa0a9, 0xa0e1, "Within the file data itself, the first byte is an end of file marker."),
        (0xa0a9, 0xa0e1, "Next 4 bytes are the data length and the load address, followed by the"),
        (0xa0a9, 0xa0e1, "data. This repeats until the end of file marker is true, whereupon"),
        (0xa0a9, 0xa0e1, "the final load address encountered becomes the EXEC address. There is"),
        (0xa0a9, 0xa0e1, "no data in the EOF block."),
        (0xa0ac, 0xa0ac, "?FM ERROR"),
        (0xa0ae, 0xa0ae, "zero"),
        (0xa0b0, 0xa0b0, "get current character from BASIC source"),
        (0xa0b4, 0xa0b4, "check comma"),
        (0xa0b7, 0xa0b7, "get 16 bit number into X"),
        (0xa0ba, 0xa0ba, "load offset"),
        (0xa0bc, 0xa0bc, "ensure nothing else on command line"),
        (0xa0bf, 0xa0bf, "read character from DEVN"),
        (0xa0c3, 0xa0c3, "read 2 characters from DEVN into D"),
        (0xa0c5, 0xa0c5, "Y = data length"),
        (0xa0c7, 0xa0c7, "read 2 characters from DEVN into D"),
        (0xa0cb, 0xa0cb, "default EXEC address"),
        (0xa0cd, 0xa0cd, "X = load address (inc. offset)"),
        (0xa0d1, 0xa0d1, "close DEVN stream & set DEVN to 0"),
        (0xa0d5, 0xa0d5, "read character from DEVN"),
        (0xa0d9, 0xa0d9, "checks that we are loading into RAM"),
        (0xa0db, 0xa0db, "?IO ERROR"),
        (0xa0e3, 0xa0e9, "read 2 characters from DEVN into D"),
        (0xa0e5, 0xa0e5, "read character from DEVN"),
        (0xa0ea, 0xa0f1, "read character from device DEVN"),
        (0xa0ea, 0xa0f1, "(+cause error if EOF)"),
        (0xa0ed, 0xa0ed, "EOF flag"),
        (0xa0f1, 0xa0f1, "?IO ERROR"),
        (0xa0f4, 0xa103, "send filename & get 1st block"),
        (0xa0f4, 0xa0f4, "send filename to serial port"),
        (0xa0fb, 0xa0fb, "zero"),
        (0xa0fd, 0xa0fd, "get block from serial port"),
        (0xa101, 0xa101, "?NE ERROR"),
        (0xa106, 0xa112, "get block from serial port into IO buffer"),
        (0xa10c, 0xa10c, "IO buffer"),
        (0xa10f, 0xa10f, "get serial block & store at X"),
        (0xa112, 0xa112, "update IO buffer size / reset header address"),
        (0xa115, 0xa147, "send filename to serial port"),
        (0xa11c, 0xa11c, "5 retries only"),
        (0xa120, 0xa120, "clear checksum, write, read & compare"),
        (0xa124, 0xa124, "filename"),
        (0xa129, 0xa129, "update checksum & write serial"),
        (0xa12c, 0xa12c, "IO buffer"),
        (0xa12f, 0xa12f, "filename now sent"),
        (0xa131, 0xa131, "send checksum & clear, read & compare #$c8"),
        (0xa135, 0xa135, "read serial & update checksum"),
        (0xa13b, 0xa13b, "read serial & update checksum"),
        (0xa141, 0xa141, "read serial, update checksum & load A"),
        (0xa149, 0xa156, "retry count - cause error if count reaches 5"),
        (0xa153, 0xa153, "write serial character"),
        (0xa156, 0xa156, "?IO ERROR"),
        (0xa159, 0xa161, "clear checksum, write serial, read & compare"),
        (0xa15b, 0xa15b, "clear checksum, write serial & read"),
        (0xa163, 0xa16b, "send checksum & clear, read & compare #$c8"),
        (0xa165, 0xa165, "clear checksum, write serial & read"),
        (0xa16c, 0xa172, "read serial, update checksum & load A"),
        (0xa16c, 0xa16c, "read serial & update checksum"),
        (0xa173, 0xa17c, "read serial & update checksum"),
        (0xa173, 0xa173, "read serial character"),
        (0xa17e, 0xa1b8, "get block from serial & store starting at X"),
        (0xa18b, 0xa18b, "5 retries only"),
        (0xa18f, 0xa18f, "clear checksum, write, read & compare"),
        (0xa195, 0xa195, "update checksum & write serial"),
        (0xa199, 0xa199, "update checksum & write serial"),
        (0xa19b, 0xa19b, "send checksum & clear, read & compare #$c8"),
        (0xa19f, 0xa19f, "read serial & update checksum"),
        (0xa1a9, 0xa1a9, "read serial & update checksum"),
        (0xa1b2, 0xa1b2, "read serial, update checksum & load A"),
        (0xa1ba, 0xa1be, "clear checksum, write serial & read"),
        (0xa1be, 0xa1be, "read serial character"),
        (0xa1c1, 0xa1c9, "update checksum & write serial"),
        (0xa1c9, 0xa1c9, "write serial character"),
        (0xa1cc, 0xa1fc, "handle ! (PRINT USING 1st character)"),
        (0xa1d1, 0xa1d1, "print a plus sign to DEVN if $DA set"),
        (0xa1d4, 0xa1d4, "get current character from BASIC source"),
        (0xa1dc, 0xa1dc, "get expression"),
        (0xa1df, 0xa1df, "validate string"),
        (0xa1e8, 0xa1e8, "perform left$ of B chrs on varptr X"),
        (0xa1eb, 0xa1eb, "print string just compiled to DEVN"),
        (0xa1f9, 0xa1f9, "send a space to DEVN"),
        (0xa1fe, 0xa223, "handle % (PRINT USING string field)"),
        (0xa21d, 0xa21d, "print a plus sign to DEVN if $DA set"),
        (0xa220, 0xa220, "output character to DEVN"),
        (0xa225, 0xa363, "called by PRINT to handle USING"),
        (0xa225, 0xa225, "get expression"),
        (0xa228, 0xa228, "validate string"),
        (0xa22d, 0xa22d, "skip semicolon"),
        (0xa232, 0xa232, "varptr of USING string"),
        (0xa238, 0xa238, "?FC ERROR"),
        (0xa23c, 0xa23c, "comma counter?"),
        (0xa240, 0xa240, "USING string has a length"),
        (0xa242, 0xa242, "?FC ERROR"),
        (0xa245, 0xa245, "point X to USING string"),
        (0xa24f, 0xa24f, "print 1st character"),
        (0xa255, 0xa255, "numeric field"),
        (0xa25a, 0xa25a, "print a plus sign to DEVN if $DA set"),
        (0xa25d, 0xa25d, "output character to DEVN"),
        (0xa260, 0xa260, "get current character from BASIC source"),
        (0xa268, 0xa268, "send CR to DEVN"),
        (0xa26d, 0xa26d, "point X to string & length in B"),
        (0xa274, 0xa274, "print a plus sign to DEVN if $DA set"),
        (0xa324, 0xa324, "get current character from BASIC source"),
        (0xa335, 0xa335, "?FC ERROR"),
        (0xa33e, 0xa33e, "print string to DEVN"),
        (0xa343, 0xa343, "get current character from BASIC source"),
        (0xa34d, 0xa34d, "check comma"),
        (0xa352, 0xa352, "get next character from BASIC source"),
        (0xa366, 0xa437, "print a plus sign to DEVN if $DA set"),
        (0xa36e, 0xa36e, "output character to DEVN"),
        (0xa394, 0xa394, "FP constant 1000000000"),
        (0xa397, 0xa397, "compare FPA1 - varptr X (of same sign)"),
        (0xa39c, 0xa39c, "convert FPA1 to string at $3da"),
        (0xa3b7, 0xa3b7, "convert FPA1 to sig figs & exponent in $47"),
        (0xa3cb, 0xa3cb, "print number to U (commas & point if reqd)"),
        (0xa420, 0xa420, "carry set if A non-numeric"),
        (0xa438, 0xa55a, "carry clear if A is ASCII digit"),
        (0xa451, 0xa451, "divide FPA1 by 10"),
        (0xa48d, 0xa48d, "print number to U (commas & point if reqd)"),
        (0xa4a1, 0xa4a1, "convert FPA1 to sig figs & exponent in $47"),
        (0xa4c2, 0xa4c2, "divide FPA1 by 10"),
        (0xa4da, 0xa4da, "print number to U (commas & point if reqd)"),
        (0xa55b, 0xa58e, "convert FPA1 to sig figs & exponent in $47"),
        (0xa566, 0xa566, "FP constant 1000000000"),
        (0xa569, 0xa569, "FPA1 = varptr X * FPA1"),
        (0xa572, 0xa572, "divide FPA1 by 10"),
        (0xa577, 0xa577, "FP constant 999999999"),
        (0xa57a, 0xa57a, "compare FPA1 - varptr X (of same sign)"),
        (0xa57f, 0xa57f, "FP constant 99999999.9"),
        (0xa582, 0xa582, "compare FPA1 - varptr X (of same sign)"),
        (0xa587, 0xa587, "multiply FPA1 by 10"),
        (0xa590, 0xa5e3, "print number to U (commas & point if reqd)"),
        (0xa592, 0xa592, "add 0.5 to FPA1"),
        (0xa595, 0xa595, "denormalize FPA1 to an integer"),
        (0xa59a, 0xa59a, "powers of 10 table"),
        (0xa5e4, 0xa61c, "store a comma if required"),
        (0xa61d, 0xa625, "get address of pixel calc routine for current PMODE"),
        (0xa620, 0xa620, "current PMODE"),
        (0xa626, 0xa628, "call relevant pixel calc routine for PMODE"),
        (0xa62a, 0xa62a, "JMP table containing pixel calc routines for each PMODE"),
        (0xa634, 0xa64e, "calculate pixel address & mask for 2 colour modes"),
        (0xa636, 0xa636, "bytes per line in current graphics mode"),
        (0xa63b, 0xa63b, "start of current graphics"),
        (0xa650, 0xa669, "calculate pixel address & mask for 4 colour modes"),
        (0xa652, 0xa652, "bytes per line in current graphics mode"),
        (0xa657, 0xa657, "start of current graphics"),
        (0xa66b, 0xa66b, "pixel mask table for 2 colour modes"),
        (0xa673, 0xa673, "pixel mask table for 4 colour modes"),
        (0xa677, 0xa67a, "move X one line down for all PMODEs"),
        (0xa677, 0xa677, "bytes per line in current graphics mode"),
        (0xa67b, 0xa681, "pixel step routine for 2 colour PMODEs"),
        (0xa67b, 0xa681, "used by LINE"),
        (0xa682, 0xa689, "pixel step routine for 4 colour PMODEs"),
        (0xa682, 0xa689, "used by LINE"),
        (0xa68a, 0xa6a7, "read coordinates into $bd & $bf"),
        (0xa68a, 0xa68a, "read pair of numbers into $2b/$2c & B"),
        (0xa6a8, 0xa6a8, "read coords into $bd & $bf and adjust for PMODE"),
        (0xa6a8, 0xa6a8, "read coordinates into $bd & $bf"),
        (0xa6ab, 0xa6c6, "adjust standard coords into true pixel coords"),
        (0xa6ae, 0xa6ae, "current PMODE"),
        (0xa6b4, 0xa6b4, "adjust Y for PMODEs 0 & 1"),
        (0xa6ba, 0xa6ba, "current PMODE"),
        (0xa6c0, 0xa6c0, "adjust X for PMODEs 0 to 3"),
        (0xa6c7, 0xa6ed, "PPOINT"),
        (0xa6c7, 0xa6c7, "get coords into $bd / $bf"),
        (0xa6ca, 0xa6ca, "adjust coords for PMODE"),
        (0xa6cd, 0xa6cd, "call relevant pixel calc routine for PMODE"),
        (0xa6d2, 0xa6d2, "current PMODE"),
        (0xa6e1, 0xa6e1, "current colour set"),
        (0xa6e6, 0xa6e6, "assign B to FPA1"),
        (0xa6ef, 0xa6f1, "PSET"),
        (0xa6f3, 0xa702, "PRESET"),
        (0xa6f4, 0xa6f4, "PRESET / PSET flag"),
        (0xa6f6, 0xa6f6, "skip open bracket"),
        (0xa6f9, 0xa6f9, "read coords into $bd & $bf and adjust"),
        (0xa6fc, 0xa6fc, "read optional colour"),
        (0xa6ff, 0xa6ff, "skip close bracket"),
        (0xa702, 0xa702, "call relevant pixel calc routine for PMODE"),
        (0xa705, 0xa71c, "called by LINE to plot pixel"),
        (0xa70e, 0xa70e, "byte value of plot colour"),
        (0xa71d, 0xa73e, "reads coordinate pair into $bd / $bf & $c3 / $c5"),
        (0xa71d, 0xa73e, "if first pair is missing then current coords are used"),
        (0xa725, 0xa725, "token -"),
        (0xa731, 0xa731, "skip open bracket"),
        (0xa734, 0xa734, "read pair of numbers into $2b/$2c & B"),
        (0xa73e, 0xa73e, "skip close bracket"),
        (0xa740, 0xa746, "read coordinates inside brackets"),
        (0xa740, 0xa746, "(into $bd & $bf)"),
        (0xa740, 0xa740, "skip open bracket"),
        (0xa743, 0xa743, "read coordinates into $bd & $bf"),
        (0xa746, 0xa746, "skip close bracket"),
        (0xa749, 0xa776, "LINE"),
        (0xa749, 0xa749, "token INPUT"),
        (0xa74b, 0xa74b, "LINE INPUT"),
        (0xa753, 0xa753, "token -"),
        (0xa759, 0xa759, "optional @ before coords"),
        (0xa75c, 0xa75c, "sets up $bd/$bf & $c3/$c5"),
        (0xa75f, 0xa75f, "with coords"),
        (0xa767, 0xa767, "check comma"),
        (0xa76a, 0xa76a, "token PRESET"),
        (0xa76e, 0xa76e, "token PSET"),
        (0xa770, 0xa770, "?SN ERROR"),
        (0xa778, 0xa794, "(A777 5F         CLRB)"),
        (0xa77a, 0xa77a, "get next character from BASIC source"),
        (0xa77c, 0xa77c, "adjust coords for PMODE"),
        (0xa781, 0xa781, "PRESET / PSET flag"),
        (0xa783, 0xa783, "set up current colour"),
        (0xa786, 0xa786, "get current character from BASIC source"),
        (0xa788, 0xa788, "must be a normal line"),
        (0xa78c, 0xa78c, "check comma"),
        (0xa791, 0xa791, "check for 'B'"),
        (0xa796, 0xa7ac, "draw empty rectangle"),
        (0xa7ae, 0xa7b4, "adjust line's coords for current PMODE"),
        (0xa7b7, 0xa7c0, "only 'F' allowed after 'B'"),
        (0xa7c2, 0xa7d1, "draw a solid rectangle"),
        (0xa7c2, 0xa7c2, "draw horizontal line"),
        (0xa7cb, 0xa7cb, "next Y up or down?"),
        (0xa7d2, 0xa7f9, "draw horizontal line from left to right"),
        (0xa7d6, 0xa7d6, "calc +ve difference in x ords"),
        (0xa7dd, 0xa7dd, "store lower of two values for calc"),
        (0xa7e3, 0xa7e3, "calc pixel"),
        (0xa7ea, 0xa7ea, "get address of pixel stepper in U"),
        (0xa7ec, 0xa7ec, "store pixel mask"),
        (0xa7ee, 0xa7ee, "plot"),
        (0xa7f3, 0xa7f3, "next pixel"),
        (0xa7fa, 0xa7fa, "jumped from general line routine"),
        (0xa7fc, 0xa816, "draw vertical line downwards"),
        (0xa800, 0xa800, "+ve difference in Y ords"),
        (0xa80d, 0xa80d, "call relevant pixel calc routine for PMODE"),
        (0xa818, 0xa818, "table of addresses of pixel step routines according to PMODE"),
        (0xa822, 0xa82a, "get address of pixel step routine according to PMODE"),
        (0xa825, 0xa825, "current PMODE"),
        (0xa82b, 0xa82e, "set U up with address of vertical pixel stepper"),
        (0xa82f, 0xa892, "draw general line"),
        (0xa82f, 0xa82f, "increment Y ord"),
        (0xa833, 0xa833, "+ve difference in Y ords"),
        (0xa836, 0xa836, "horizontal line"),
        (0xa83a, 0xa83a, "draw left to right"),
        (0xa83c, 0xa83c, "decrement Y ord"),
        (0xa842, 0xa842, "increment X ord"),
        (0xa845, 0xa845, "+ve difference in X ords"),
        (0xa848, 0xa848, "vertical line"),
        (0xa84a, 0xa84a, "draw top to bottom"),
        (0xa84c, 0xa84c, "decrement X ord"),
        (0xa854, 0xa854, "delta X >= delta Y"),
        (0xa856, 0xa856, "get main stepper in U"),
        (0xa858, 0xa858, "get larger delta in D"),
        (0xa85e, 0xa85e, "make initial total 1/2 of large"),
        (0xa85f, 0xa85f, "delta for equal end segments"),
        (0xa860, 0xa860, "large delta was odd"),
        (0xa866, 0xa866, "main stepper is in +ve direction"),
        (0xa868, 0xa868, "mystery tweak"),
        (0xa86d, 0xa86d, "get pixel calc in U"),
        (0xa872, 0xa872, "plot"),
        (0xa87b, 0xa87b, "dec counter"),
        (0xa87d, 0xa87d, "step pixel in main direction"),
        (0xa882, 0xa882, "add small delta"),
        (0xa884, 0xa884, "to total"),
        (0xa886, 0xa886, "subtract larger delta"),
        (0xa888, 0xa888, "threshold not reached"),
        (0xa88c, 0xa88c, "step pixel in lesser direction"),
        (0xa894, 0xa89a, "increment X ord (LINE / PAINT)"),
        (0xa89b, 0xa8a1, "increment Y ord (LINE)"),
        (0xa8a2, 0xa8a8, "decrement X ord (LINE / PAINT)"),
        (0xa8a9, 0xa8af, "decrement Y ord (LINE)"),
        (0xa8b0, 0xa8bd, "sets up $d3 / $d5 with max coords adjusted for PMODE"),
        (0xa8c0, 0xa8d2, "PCLS"),
        (0xa8c7, 0xa8c7, "start of current graphics"),
        (0xa8cb, 0xa8cb, "1st byte after current graphics"),
        (0xa8d0, 0xa8d0, "current background colour"),
        (0xa8d4, 0xa8e7, "COLOR"),
        (0xa8da, 0xa8da, "current foreground colour"),
        (0xa8dc, 0xa8dc, "get current character from BASIC source"),
        (0xa8e0, 0xa8e0, "check comma"),
        (0xa8e5, 0xa8e5, "current background colour"),
        (0xa8e8, 0xa90d, "read number and interpret as colour"),
        (0xa8e8, 0xa90d, "(returns 0 - 3)"),
        (0xa8e8, 0xa8e8, "get number in B"),
        (0xa8ed, 0xa8ed, "?FC ERROR"),
        (0xa8fc, 0xa8fc, "current PMODE"),
        (0xa90f, 0xa926, "read optional colour & set up $b5 accordingly"),
        (0xa90f, 0xa90f, "set up colours"),
        (0xa912, 0xa912, "get current character from BASIC source"),
        (0xa91a, 0xa91a, "check comma"),
        (0xa926, 0xa926, "get current character from BASIC source"),
        (0xa928, 0xa937, "stores either foreground or background colour"),
        (0xa928, 0xa937, "as current depending on plot flag $c2"),
        (0xa928, 0xa928, "current foreground colour"),
        (0xa92a, 0xa92a, "PRESET / PSET flag"),
        (0xa92e, 0xa92e, "current background colour"),
        (0xa930, 0xa930, "plot colour"),
        (0xa935, 0xa935, "byte value of plot colour"),
        (0xa938, 0xa938, "called by SCREEN: sets up text or graphics according to Z"),
        (0xa93a, 0xa95b, "reset VDU"),
        (0xa95d, 0xa987, "set up graphics display"),
        (0xa95f, 0xa95f, "current PMODE"),
        (0xa968, 0xa968, "current colour set"),
        (0xa976, 0xa976, "start of current graphics"),
        (0xa979, 0xa979, "set up SAM VDG base"),
        (0xa97c, 0xa97c, "current PMODE"),
        (0xa985, 0xa985, "set up SAM VDG mem mode"),
        (0xa989, 0xa99c, "set up SAM VDG mode"),
        (0xa99d, 0xa9a2, "set up VDG offset"),
        (0xa9a4, 0xa9ae, "select VDG colour set"),
        (0xa9a9, 0xa9a9, "current colour set"),
        (0xa9af, 0xa9fb, "PMODE"),
        (0xa9b3, 0xa9b3, "get number in B"),
        (0xa9b8, 0xa9b8, "?FC ERROR"),
        (0xa9ba, 0xa9ba, "MSB of start of graphics page 1"),
        (0xa9bc, 0xa9bc, "start of current graphics"),
        (0xa9bf, 0xa9bf, "PMODE setup table + 1"),
        (0xa9c4, 0xa9c4, "start of BASIC program"),
        (0xa9c6, 0xa9c6, "?FC ERROR"),
        (0xa9c8, 0xa9c8, "1st byte after current graphics"),
        (0xa9ce, 0xa9ce, "bytes per line in current graphics mode"),
        (0xa9d1, 0xa9d1, "current PMODE"),
        (0xa9d4, 0xa9d4, "current background colour"),
        (0xa9d8, 0xa9d8, "current foreground colour"),
        (0xa9da, 0xa9da, "get current character from BASIC source"),
        (0xa9dc, 0xa9dc, "RTS"),
        (0xa9de, 0xa9de, "skip comma & get number in B"),
        (0xa9e2, 0xa9e2, "?FC ERROR"),
        (0xa9e8, 0xa9e8, "MSB of start of graphics page 1"),
        (0xa9ec, 0xa9ec, "1st byte after current graphics"),
        (0xa9ee, 0xa9ee, "start of current graphics"),
        (0xa9f0, 0xa9f0, "start of BASIC program"),
        (0xa9f2, 0xa9f2, "?FC ERROR"),
        (0xa9f4, 0xa9f4, "1st byte after current graphics"),
        (0xa9f8, 0xa9f8, "start of current graphics"),
        (0xa9fb, 0xa9fb, "?FC ERROR"),
        (0xa9fe, 0xaa17, "SCREEN"),
        (0xaa02, 0xaa02, "get number in B"),
        (0xaa09, 0xaa09, "get current character from BASIC source"),
        (0xaa0d, 0xaa0d, "skip comma & get number in B"),
        (0xaa15, 0xaa15, "current colour set"),
        (0xaa19, 0xaa7f, "PCLEAR"),
        (0xaa19, 0xaa19, "get number in B"),
        (0xaa1d, 0xaa1d, "?FC ERROR"),
        (0xaa21, 0xaa21, "?FC ERROR"),
        (0xaa26, 0xaa26, "MSB of start of graphics page 1"),
        (0xaa2e, 0xaa2e, "1st byte after current graphics"),
        (0xaa31, 0xaa31, "?FC ERROR"),
        (0xaa35, 0xaa35, "start of BASIC program"),
        (0xaa37, 0xaa37, "start of simple variables"),
        (0xaa3e, 0xaa3e, "stack root / string storage start"),
        (0xaa40, 0xaa40, "?FC ERROR"),
        (0xaa42, 0xaa42, "current line number"),
        (0xaa49, 0xaa49, "start of BASIC program"),
        (0xaa4b, 0xaa4b, "BASIC source pointer"),
        (0xaa4f, 0xaa4f, "start of simple variables"),
        (0xaa5c, 0xaa5c, "start of BASIC program"),
        (0xaa61, 0xaa61, "start of BASIC program"),
        (0xaa66, 0xaa66, "set up next line pointers in BASIC program"),
        (0xaa69, 0xaa69, "clear variables & reset stack"),
        (0xaa6c, 0xaa6c, "interpreter loop"),
        (0xaa6f, 0xaa6f, "start of BASIC program"),
        (0xaa7a, 0xaa7a, "start of simple variables"),
        (0xaa81, 0xaa9e, "called by reset routine to PCLEAR 4"),
        (0xaa83, 0xaa83, "start of BASIC program"),
        (0xaa87, 0xaa87, "MSB of start of graphics page 1"),
        (0xaa89, 0xaa89, "start of current graphics"),
        (0xaa8c, 0xaa8c, "current PMODE"),
        (0xaa90, 0xaa90, "bytes per line in current graphics mode"),
        (0xaa94, 0xaa94, "current foreground colour"),
        (0xaa98, 0xaa98, "1st byte after current graphics"),
        (0xaa9a, 0xaa9a, "start of BASIC program"),
        (0xaa9e, 0xaa9e, "NEW BASIC"),
        (0xaaa1, 0xaaa1, "PMODE setup table: bytes/line + MSB of display size"),
        (0xaaab, 0xaab6, "calc +ve difference in Y ords"),
        (0xaab3, 0xaab3, "D = -D"),
        (0xaab8, 0xaabc, "calc +ve difference in X ords"),
        (0xaabe, 0xaad9, "PCOPY"),
        (0xaac4, 0xaac4, "check for token TO"),
        (0xaada, 0xaaed, "converts number into graphics page address"),
        (0xaada, 0xaada, "get number in B"),
        (0xaade, 0xaade, "?FC ERROR"),
        (0xaae4, 0xaae4, "MSB of start of graphics page 1"),
        (0xaae6, 0xaae6, "page address must be lower"),
        (0xaae8, 0xaae8, "than BASIC program"),
        (0xaaed, 0xaaed, "?FC ERROR"),
        (0xaaf0, 0xaaf1, "notes concerning GET & PUT:"),
        (0xaaf0, 0xaaf1, "when G is not specified for GET, whole bytes are transferred from the"),
        (0xaaf0, 0xaaf1, "screen to the array. The effective width will therefore be a multiple"),
        (0xaaf0, 0xaaf1, "of 8. Using such an array, PUT with no action will only display correctly"),
        (0xaaf0, 0xaaf1, "on byte boundaries. (although it will be fast)"),
        (0xaaf0, 0xaaf1, "If G is specified for GET then screen bits are packed into the array."),
        (0xaaf0, 0xaaf1, "PUT with no action will only work if the array image width is a multiple"),
        (0xaaf0, 0xaaf1, "of 8 and then only on a screen byte boundary."),
        (0xaaf0, 0xaaf1, "PUT with an action works as long as the effective array image width is"),
        (0xaaf0, 0xaaf1, "observed in the first case of GET. In the second case, the precise width"),
        (0xaaf0, 0xaaf1, "is used as expected."),
        (0xaaf0, 0xaaf1, "GET"),
        (0xaaf3, 0xab50, "PUT"),
        (0xaaf7, 0xaaf7, "PATCH - CLS GET PUT"),
        (0xaafc, 0xaafc, "optional @ before coords"),
        (0xaafe, 0xaafe, "get next character from BASIC source"),
        (0xab00, 0xab00, "get coords into $bd/$bf & $c3/$c5"),
        (0xab03, 0xab03, "check comma"),
        (0xab06, 0xab06, "validate & get varptr of array"),
        (0xab11, 0xab11, "address of last byte of array+1"),
        (0xab15, 0xab15, "no. of dimensions"),
        (0xab19, 0xab19, "address of first byte of array"),
        (0xab1b, 0xab1b, "string arrays not allowed"),
        (0xab1d, 0xab1d, "?FC ERROR"),
        (0xab21, 0xab21, "get current character from BASIC source"),
        (0xab23, 0xab23, "no parameter after array"),
        (0xab27, 0xab27, "check comma"),
        (0xab2c, 0xab2c, "PUT"),
        (0xab30, 0xab30, "skip G"),
        (0xab33, 0xab33, "GET ,G"),
        (0xab3a, 0xab3a, "set up action routines for PUT"),
        (0xab46, 0xab46, "?SN ERROR"),
        (0xab4e, 0xab4e, "get next character from BASIC source"),
        (0xab52, 0xabbd, "bytewise GET / PUT"),
        (0xab54, 0xab54, "current PMODE"),
        (0xab57, 0xab57, "2 colour modes"),
        (0xab5d, 0xab5d, "adjust horizontal coords to align with bytes"),
        (0xab65, 0xab65, "calc +ve difference in x ords"),
        (0xab68, 0xab68, "1st is less than 2nd"),
        (0xab6e, 0xab6e, "x ord difference"),
        (0xab70, 0xab70, "+ve difference in Y ords"),
        (0xab73, 0xab73, "1st is less than 2nd"),
        (0xab79, 0xab79, "y ord difference"),
        (0xab7b, 0xab7b, "current PMODE"),
        (0xab80, 0xab80, "2 colour modes"),
        (0xab86, 0xab86, "adjust coords for PMODE"),
        (0xab8f, 0xab8f, "add 1 to y difference to get height"),
        (0xab93, 0xab93, "action specified"),
        (0xab9e, 0xab9e, "width of image in bytes"),
        (0xaba0, 0xaba0, "call relevant pixel calc routine for PMODE"),
        (0xaba9, 0xaba9, "GET"),
        (0xabab, 0xabab, "increment array pointer (U)"),
        (0xabb2, 0xabb2, "repeat until line done"),
        (0xabb6, 0xabb6, "move X one line down for all PMODEs"),
        (0xabbb, 0xabbb, "another line"),
        (0xabbe, 0xabc9, "increment array pointer (U)"),
        (0xabc7, 0xabc7, "RTS"),
        (0xabc9, 0xabc9, "?FC ERROR"),
        (0xabcc, 0xabd2, "action for GET without G parameter"),
        (0xabce, 0xabce, "increment array pointer (U)"),
        (0xabd4, 0xabe8, "PUT action JMP table"),
        (0xabd4, 0xabe8, "action for a clear array bit / action for a set array bit / token"),
        (0xabd4, 0xabd4, "PSET"),
        (0xabd9, 0xabd9, "PRESET"),
        (0xabde, 0xabde, "OR"),
        (0xabe3, 0xabe3, "AND"),
        (0xabe8, 0xabe8, "NOT"),
        (0xabed, 0xac2b, "GET(G) & PUT(action) - does it bitwise"),
        (0xabf0, 0xabf0, "width of image in bits"),
        (0xabf4, 0xabf4, "PUT"),
        (0xabf8, 0xabf8, "clear array for GET"),
        (0xabff, 0xabff, "call relevant pixel calc routine for PMODE"),
        (0xac02, 0xac02, "current PMODE"),
        (0xac05, 0xac05, "2 colour modes"),
        (0xac07, 0xac07, "reduce mask to single bit"),
        (0xac10, 0xac10, "U = image width in bits"),
        (0xac14, 0xac14, "step array bit pointer"),
        (0xac17, 0xac17, "B = $80"),
        (0xac18, 0xac18, "filled an array byte, so point to next one"),
        (0xac1a, 0xac1a, "test for end of array"),
        (0xac1d, 0xac1d, "?FC ERROR"),
        (0xac21, 0xac21, "GET"),
        (0xac23, 0xac23, "test array bit"),
        (0xac27, 0xac27, "action if array bit set"),
        (0xac2b, 0xac2b, "action if array bit clear"),
        (0xac2f, 0xac34, "action for PSET 0, PRESET 1, AND 0"),
        (0xac32, 0xac32, "clear screen bit"),
        (0xac34, 0xac34, "next bit"),
        (0xac36, 0xac3a, "action for PSET 1, PRESET 0, OR 1"),
        (0xac38, 0xac38, "set screen bit"),
        (0xac3a, 0xac3a, "next bit"),
        (0xac3c, 0xac40, "action for NOT 0, NOT 1"),
        (0xac3e, 0xac3e, "invert screen bit"),
        (0xac40, 0xac40, "next bit"),
        (0xac42, 0xac4a, "GET bit"),
        (0xac42, 0xac42, "test screen bit"),
        (0xac44, 0xac44, "don't set array bit - next pixel"),
        (0xac4a, 0xac4a, "set array bit"),
        (0xac4c, 0xac66, "next bit (also action for OR 0, AND 1)"),
        (0xac4c, 0xac4c, "pixel mask & width counter"),
        (0xac4e, 0xac4e, "step bit one to right"),
        (0xac53, 0xac53, "zero"),
        (0xac56, 0xac56, "not end of line"),
        (0xac5a, 0xac5a, "bytes per line in current graphics mode"),
        (0xac5c, 0xac5c, "point X to next line"),
        (0xac64, 0xac64, "do another line"),
        (0xac67, 0xac86, "called by GET / PUT: get varptr for specified array"),
        (0xac67, 0xac67, "get varptr address"),
        (0xac6e, 0xac6e, "get variable name in U"),
        (0xac74, 0xac74, "?FC ERROR"),
        (0xac78, 0xac78, "search array storage to ensure"),
        (0xac7b, 0xac7b, "that specified variable is an"),
        (0xac7d, 0xac7d, "array"),
        (0xac83, 0xac83, "varptr"),
        (0xac87, 0xaccc, "PAINT"),
        (0xac89, 0xac89, "optional @ before coords"),
        (0xac8b, 0xac8b, "get next character from BASIC source"),
        (0xac8d, 0xac8d, "get coords into $bd / $bf"),
        (0xac90, 0xac90, "adjust coords for PMODE"),
        (0xac95, 0xac95, "PRESET / PSET flag"),
        (0xac97, 0xac97, "read optional colour"),
        (0xac9a, 0xac9a, "plot colour"),
        (0xac9e, 0xac9e, "get current character from BASIC source"),
        (0xaca2, 0xaca2, "read optional colour"),
        (0xaca5, 0xaca5, "byte value of plot colour"),
        (0xacab, 0xacab, "plot colour"),
        (0xacb0, 0xacb0, "set up max coords for PMODE"),
        (0xacb3, 0xacb3, "get address of pixel calc routine"),
        (0xacb6, 0xacb6, "pixel calc"),
        (0xacb8, 0xacb8, "paint left & count pixels in U, D & X"),
        (0xacbb, 0xacbb, "none painted"),
        (0xacbd, 0xacbd, "paint right after previous left"),
        (0xacc4, 0xacc4, "save pos on stack"),
        (0xacc9, 0xacc9, "save pos on stack"),
        (0xaccf, 0xad39, "(main loop)"),
        (0xacd1, 0xacd1, "pixels were painted on previous line"),
        (0xacd8, 0xacd8, "pixel changed flag (updated by plot)"),
        (0xacdf, 0xacdf, "current x pos"),
        (0xace1, 0xace1, "no. of pixels painted on previous line"),
        (0xace3, 0xace3, "up / down flag"),
        (0xace5, 0xace5, "RTS - pulled final stack entry"),
        (0xace7, 0xace7, "paint up"),
        (0xacec, 0xacec, "not off bottom of screen"),
        (0xacf0, 0xacf0, "at top/bottom of screen"),
        (0xacf5, 0xacf5, "paint left & count pixels in U, D & X"),
        (0xacf8, 0xacf8, "none painted"),
        (0xacfe, 0xacfe, "only 1 or 2 pixels painted"),
        (0xad02, 0xad02, "save pos on stack with reverse direction"),
        (0xad04, 0xad04, "paint right after previous left"),
        (0xad07, 0xad07, "save pos on stack"),
        (0xad11, 0xad11, "increment X ord"),
        (0xad14, 0xad14, "calc pixel & test for border colour"),
        (0xad1e, 0xad1e, "decrement X ord"),
        (0xad21, 0xad21, "copy X ord to $c3"),
        (0xad23, 0xad23, "paint right & count pixels in U, D & X"),
        (0xad27, 0xad27, "increment X ord"),
        (0xad37, 0xad37, "save pos on stack with reverse direction"),
        (0xad39, 0xad39, "loop again"),
        (0xad3c, 0xad54, "save pos with reverse direction"),
        (0xad4f, 0xad4f, "memory check"),
        (0xad55, 0xad5f, "save pos on stack"),
        (0xad61, 0xad65, "copy X ord to $c3"),
        (0xad66, 0xad79, "paint right after previous left"),
        (0xad66, 0xad79, "X = total no. of pixels painted left & right"),
        (0xad66, 0xad79, "D = no. of pixels painted right + 1"),
        (0xad6b, 0xad6b, "copy X ord to $c3"),
        (0xad70, 0xad70, "paint right & count pixels in U, D & X"),
        (0xad7a, 0xad81, "paint left & return pixel count in U, D & X"),
        (0xad7a, 0xad7a, "copy X ord to $c3"),
        (0xad7d, 0xad7d, "decrement X ord"),
        (0xad83, 0xadac, "paint right & return pixel count in U, D & X"),
        (0xad83, 0xad83, "increment X ord"),
        (0xad87, 0xad87, "step X ord"),
        (0xad89, 0xad89, "zero"),
        (0xad8d, 0xad8d, "< min X"),
        (0xad91, 0xad91, "> max X"),
        (0xad95, 0xad95, "calc pixel & test for border colour"),
        (0xad99, 0xad99, "plot"),
        (0xada0, 0xada0, "step X ord"),
        (0xadaa, 0xadaa, "CMPD #0"),
        (0xadad, 0xadbb, "calc pixel & test for border colour"),
        (0xadad, 0xadad, "pixel calc"),
        (0xadbd, 0xadf5, "PLAY"),
        (0xadbd, 0xadbd, "zero"),
        (0xadc3, 0xadc3, "get expression"),
        (0xadc7, 0xadc7, "B=0 to select d/a sound"),
        (0xadca, 0xadca, "enable audio"),
        (0xadcd, 0xadcd, "validate string & point X to it (len in B)"),
        (0xadd4, 0xadd4, "string length"),
        (0xadd8, 0xadd8, "1st byte in string"),
        (0xadda, 0xadda, "nothing to do - disable audio & quit"),
        (0xadde, 0xadde, "remaining string length"),
        (0xade2, 0xade2, "get character"),
        (0xadef, 0xadef, "execute substring"),
        (0xadf3, 0xadf3, "interpret meta-command"),
        (0xadf7, 0xae07, "change octave"),
        (0xadfb, 0xadfb, "PLAY octave"),
        (0xadfe, 0xadfe, "modify B according to PLAY parameter"),
        (0xae03, 0xae03, "?FC ERROR"),
        (0xae05, 0xae05, "PLAY octave"),
        (0xae08, 0xae25, "change volume"),
        (0xae0c, 0xae0c, "PLAY d/a high value"),
        (0xae12, 0xae12, "modify B according to PLAY parameter"),
        (0xae16, 0xae16, "?FC ERROR"),
        (0xae23, 0xae23, "PLAY volume data"),
        (0xae26, 0xae4c, "change note length"),
        (0xae2a, 0xae2a, "PLAY note length"),
        (0xae2c, 0xae2c, "modify B according to PLAY parameter"),
        (0xae2f, 0xae2f, "?FC ERROR"),
        (0xae31, 0xae31, "PLAY note length"),
        (0xae33, 0xae33, "duration modifier (no. of dots)"),
        (0xae3a, 0xae3a, "remaining string length"),
        (0xae3e, 0xae3e, "get character"),
        (0xae45, 0xae45, "move string pointer back one"),
        (0xae4a, 0xae4a, "duration modifier (no. of dots)"),
        (0xae4d, 0xae5a, "change tempo"),
        (0xae51, 0xae51, "PLAY tempo"),
        (0xae53, 0xae53, "modify B according to PLAY parameter"),
        (0xae56, 0xae56, "?FC ERROR"),
        (0xae58, 0xae58, "PLAY tempo"),
        (0xae5b, 0xae5b, "change a PLAY parameter (modifies value in B)"),
        (0xae5e, 0xae84, "play a pause"),
        (0xae62, 0xae62, "check for number or =variable (get into B)"),
        (0xae68, 0xae68, "?FC ERROR"),
        (0xae6b, 0xae6b, "duration modifier (no. of dots)"),
        (0xae6d, 0xae6d, "PLAY volume data"),
        (0xae73, 0xae73, "PLAY d/a high value"),
        (0xae75, 0xae75, "PLAY d/a low value"),
        (0xae77, 0xae77, "duration modifier (no. of dots)"),
        (0xae7d, 0xae7d, "duration modifier (no. of dots)"),
        (0xae7f, 0xae7f, "PLAY volume data"),
        (0xae86, 0xaef0, "ignore an N!"),
        (0xae8a, 0xae8a, "get character"),
        (0xae95, 0xae95, "check for number or =variable (get into B)"),
        (0xae9c, 0xae9c, "note number XLAT table"),
        (0xae9f, 0xae9f, "XLAT into number"),
        (0xaea1, 0xaea1, "remaining string length"),
        (0xaea5, 0xaea5, "get character"),
        (0xaeb0, 0xaeb0, "sharpen note"),
        (0xaeb7, 0xaeb7, "flatten note"),
        (0xaeba, 0xaeba, "move string pointer back one"),
        (0xaec0, 0xaec0, "?FC ERROR"),
        (0xaec4, 0xaec4, "PLAY note length"),
        (0xaec6, 0xaec6, "PLAY tempo"),
        (0xaec9, 0xaec9, "PLAY duration decrement value"),
        (0xaecb, 0xaecb, "point U to return address ($ADF5)"),
        (0xaecd, 0xaecd, "PLAY octave"),
        (0xaed3, 0xaed3, "pitch XLAT table for octaves 1 & 2"),
        (0xaede, 0xaede, "XLAT note for octaves 1 & 2"),
        (0xaee0, 0xaee0, "compute PLAY duration"),
        (0xaee2, 0xaee2, "PLAY duration counter"),
        (0xaee4, 0xaee4, "zero d/a"),
        (0xaee6, 0xaee6, "PLAY d/a high value"),
        (0xaee8, 0xaee8, "set d/a"),
        (0xaeea, 0xaeea, "zero d/a"),
        (0xaeec, 0xaeec, "PLAY d/a low value"),
        (0xaeee, 0xaeee, "set d/a"),
        (0xaef0, 0xaef0, "irq routine controls duration"),
        (0xaef2, 0xaf19, ";forces jump to $adf5"),
        (0xaeff, 0xaeff, "XLAT table for octaves 3 - 5 (-$18)"),
        (0xaf08, 0xaf08, "XLAT note for octaves 3 - 5"),
        (0xaf09, 0xaf09, "compute PLAY duration"),
        (0xaf0b, 0xaf0b, "PLAY duration counter"),
        (0xaf0d, 0xaf0d, "zero d/a"),
        (0xaf0f, 0xaf0f, "PLAY d/a high value"),
        (0xaf11, 0xaf11, "set d/a"),
        (0xaf13, 0xaf13, "zero d/a"),
        (0xaf15, 0xaf15, "PLAY d/a low value"),
        (0xaf17, 0xaf17, "set d/a"),
        (0xaf19, 0xaf19, "irq routine controls duration"),
        (0xaf1b, 0xaf26, ";forces jump to $adf5"),
        (0xaf27, 0xaf32, "compute PLAY duration"),
        (0xaf29, 0xaf29, "duration modifier (no. of dots)"),
        (0xaf33, 0xaf45, "get next character in string, skipping over spaces"),
        (0xaf33, 0xaf45, "(called by PLAY & DRAW)"),
        (0xaf35, 0xaf35, "remaining string length"),
        (0xaf39, 0xaf39, "string pointer"),
        (0xaf3d, 0xaf3d, "string pointer"),
        (0xaf3f, 0xaf3f, "remaining string length"),
        (0xaf47, 0xaf86, "change a PLAY parameter (modifies value in B)"),
        (0xaf47, 0xaf47, "get character"),
        (0xaf49, 0xaf49, "inc"),
        (0xaf4d, 0xaf4d, "dec"),
        (0xaf51, 0xaf51, "double"),
        (0xaf55, 0xaf55, "halve"),
        (0xaf59, 0xaf59, "equals a variable"),
        (0xaf5d, 0xaf5d, "carry set if A non-numeric"),
        (0xaf60, 0xaf60, "?FC ERROR"),
        (0xaf6b, 0xaf6b, "?FC ERROR"),
        (0xaf6f, 0xaf6f, "?FC ERROR"),
        (0xaf71, 0xaf71, "remaining string length"),
        (0xaf75, 0xaf75, "get character"),
        (0xaf78, 0xaf78, "carry set if A non-numeric"),
        (0xaf7d, 0xaf7d, "remaining string length"),
        (0xaf7f, 0xaf7f, "string pointer"),
        (0xaf83, 0xaf83, "string pointer"),
        (0xaf86, 0xaf86, "?FC ERROR"),
        (0xaf89, 0xaf8c, "increment PLAY parameter"),
        (0xaf8a, 0xaf8a, "?FC ERROR"),
        (0xaf8d, 0xaf91, "decrement PLAY parameter"),
        (0xaf8e, 0xaf8e, "?FC ERROR"),
        (0xaf92, 0xaf96, "halve PLAY parameter"),
        (0xaf93, 0xaf93, "?FC ERROR"),
        (0xaf97, 0xaf9b, "double PLAY parameter"),
        (0xaf98, 0xaf98, "?FC ERROR"),
        (0xaf9c, 0xafa3, "PLAY parameter equals a variable"),
        (0xaf9e, 0xaf9e, "validate variable"),
        (0xafa0, 0xafa0, "get number in B from FPA1"),
        (0xafa5, 0xafb3, "execute PLAY substring"),
        (0xafa5, 0xafa5, "validate variable"),
        (0xafaa, 0xafaa, "memory check"),
        (0xafad, 0xafad, "remaining string length"),
        (0xafaf, 0xafaf, "string pointer"),
        (0xafb6, 0xafd8, "validate PLAY / DRAW variable"),
        (0xafb6, 0xafb6, "string pointer"),
        (0xafba, 0xafba, "get character"),
        (0xafbd, 0xafbd, "carry clear if A-Z"),
        (0xafc0, 0xafc0, "?FC ERROR"),
        (0xafc2, 0xafc2, "get character"),
        (0xafcb, 0xafcb, "BASIC source pointer"),
        (0xafcf, 0xafcf, "BASIC source pointer"),
        (0xafd6, 0xafd6, "BASIC source pointer"),
        (0xafd9, 0xaff5, "IRQ service routine continued"),
        (0xafdc, 0xafdc, "PLAY duration counter"),
        (0xafe2, 0xafe2, "must be in PLAY loop"),
        (0xafe4, 0xafe4, "therefore calculate"),
        (0xafe6, 0xafe6, "duration remaining"),
        (0xafe8, 0xafe8, "PLAY duration counter"),
        (0xafee, 0xafee, "points S to old U (=$adf5)"),
        (0xaff1, 0xaff1, "mask entire state save"),
        (0xaff3, 0xaff3, "RTI will now return to $adf5"),
        (0xaff6, 0xaff6, "PLAY letter to note number XLAT table"),
        (0xaffd, 0xb021, "PLAY pitch XLAT table for octaves 1 & 2"),
        (0xb02d, 0xb045, "PLAY pitch XLAT table for octaves 3 - 5"),
        (0xb051, 0xb0e7, "DRAW"),
        (0xb051, 0xb051, "zero"),
        (0xb057, 0xb057, "PRESET / PSET flag"),
        (0xb05b, 0xb05b, "set up colours"),
        (0xb05e, 0xb05e, "get expression"),
        (0xb061, 0xb061, "validate string & point X to it (len in B)"),
        (0xb066, 0xb066, "get character"),
        (0xb069, 0xb069, "check for number or =variable (get into B)"),
        (0xb06e, 0xb06e, "remaining string length"),
        (0xb072, 0xb072, "string pointer"),
        (0xb074, 0xb074, "nothing left to do - RTS"),
        (0xb078, 0xb078, "remaining string length"),
        (0xb07c, 0xb07c, "get character"),
        (0xb0a7, 0xb0a7, "remaining string length"),
        (0xb0ab, 0xb0ab, "get character"),
        (0xb0ae, 0xb0ae, "carry clear if A-Z"),
        (0xb0b3, 0xb0b3, "move string pointer back one"),
        (0xb0ba, 0xb0ba, "check for number or =variable (get into B)"),
        (0xb0e7, 0xb0e7, "?FC ERROR"),
        (0xb0ea, 0xb0f2, "DRAW 'C'"),
        (0xb0ea, 0xb0ea, "interpret colour in B"),
        (0xb0ed, 0xb0ed, "foreground colour"),
        (0xb0ef, 0xb0ef, "set up colours"),
        (0xb0f4, 0xb0fa, "DRAW 'A'"),
        (0xb0f6, 0xb0f6, "?FC ERROR"),
        (0xb0f8, 0xb0f8, "angle"),
        (0xb0fc, 0xb102, "DRAW 'S'"),
        (0xb0fe, 0xb0fe, "?FC ERROR"),
        (0xb100, 0xb100, "scale"),
        (0xb104, 0xb107, "DRAW 'H'    (D = X = -B)"),
        (0xb105, 0xb105, "NEGB, A=A-C"),
        (0xb109, 0xb10b, "DRAW 'F'    (D = X = B)"),
        (0xb109, 0xb10b, "(B108 4F         CLRA)"),
        (0xb10d, 0xb114, "DRAW 'E'    (D = B, X = -B)"),
        (0xb110, 0xb110, "NEGB, A=A-C"),
        (0xb116, 0xb11b, "DRAW 'G'    (D = -B, X = B)"),
        (0xb119, 0xb119, "NEGB, A=A-C"),
        (0xb11d, 0xb120, "DRAW 'R'    (D = B, X = 0)"),
        (0xb11e, 0xb11e, "zero"),
        (0xb122, 0xb125, "DRAW 'L'    (D = -B, X = 0)"),
        (0xb123, 0xb123, "NEGB, A=A-C"),
        (0xb127, 0xb128, "DRAW 'D'    (D = 0, X = B)"),
        (0xb12a, 0xb131, "DRAW 'U'    (D = 0, X = -B)"),
        (0xb12b, 0xb12b, "NEGB, A=A-C"),
        (0xb12d, 0xb12d, "zero"),
        (0xb133, 0xb141, "DRAW 'X'"),
        (0xb133, 0xb133, "validate variable"),
        (0xb138, 0xb138, "memory check"),
        (0xb13b, 0xb13b, "remaining string length"),
        (0xb13d, 0xb13d, "string pointer"),
        (0xb13f, 0xb13f, "store current string"),
        (0xb141, 0xb141, "start again with new string"),
        (0xb144, 0xb165, "apply DRAW scale factor to X"),
        (0xb14f, 0xb14f, "D = -D"),
        (0xb151, 0xb151, "Y:U = D * X"),
        (0xb166, 0xb1ca, "apply scale & angle to relative movement vector in D & X,"),
        (0xb166, 0xb1ca, "calculate new pos & draw."),
        (0xb166, 0xb1ca, "(D = horizontal component, X = vertical component)"),
        (0xb168, 0xb168, "scale X into D"),
        (0xb16e, 0xb16e, "scale X into D"),
        (0xb172, 0xb172, "angle"),
        (0xb17b, 0xb17b, "swap vector components"),
        (0xb17d, 0xb17d, "D = -D"),
        (0xb181, 0xb181, "rotate another 90 degrees"),
        (0xb185, 0xb185, "zero"),
        (0xb187, 0xb187, "current X"),
        (0xb18b, 0xb18b, "U = new X"),
        (0xb18f, 0xb18f, "zero"),
        (0xb191, 0xb191, "current Y"),
        (0xb1a5, 0xb1a5, "X = new Y"),
        (0xb1b6, 0xb1b6, "no position update"),
        (0xb1bc, 0xb1bc, "adjust coords for PMODE"),
        (0xb1c1, 0xb1c1, "blank move"),
        (0xb1c3, 0xb1c3, "draw line"),
        (0xb1cd, 0xb1f3, "DRAW 'M'"),
        (0xb1cd, 0xb1cd, "get character"),
        (0xb1d2, 0xb1d2, "get ordinate into D"),
        (0xb1d7, 0xb1d7, "get character"),
        (0xb1e0, 0xb1e0, "get ordinate into D"),
        (0xb1ef, 0xb1ef, "absolute position"),
        (0xb1f3, 0xb1f3, "relative movement"),
        (0xb1f6, 0xb213, "get ordinate for Move"),
        (0xb1f6, 0xb1f6, "get character"),
        (0xb201, 0xb201, "move string pointer back one"),
        (0xb207, 0xb207, "check for number or =variable (get into B)"),
        (0xb214, 0xb234, "CIRCLE trig factor look-up table"),
        (0xb214, 0xb234, "circle is drawn in 8 main sectors with 8 or 9 subdivisions each"),
        (0xb238, 0xb341, "CIRCLE"),
        (0xb23a, 0xb23a, "optional @ before coords"),
        (0xb23c, 0xb23c, "get next character from BASIC source"),
        (0xb23e, 0xb23e, "set up max coords for PMODE"),
        (0xb241, 0xb241, "get coords from command into $bd / $bf"),
        (0xb244, 0xb244, "adjust coords for PMODE"),
        (0xb24f, 0xb24f, "check comma"),
        (0xb252, 0xb252, "get 16 bit number into X"),
        (0xb258, 0xb258, "circle radius"),
        (0xb25a, 0xb25a, "adjust radius correct for PMODE"),
        (0xb25f, 0xb25f, "PRESET / PSET flag"),
        (0xb261, 0xb261, "read optional colour"),
        (0xb267, 0xb267, "get current character from BASIC source"),
        (0xb26b, 0xb26b, "check comma"),
        (0xb26e, 0xb26e, "get FP number (h/w ratio)"),
        (0xb275, 0xb275, "multiply FP number by 256"),
        (0xb277, 0xb277, "read 16 bit number into X from FPA1"),
        (0xb27a, 0xb27a, "current PMODE"),
        (0xb282, 0xb282, "double hw ratio for PMODEs 2 & 3"),
        (0xb288, 0xb288, "PRESET / PSET flag"),
        (0xb28c, 0xb28c, "read optional start value"),
        (0xb291, 0xb291, "read optional end value"),
        (0xb298, 0xb298, "loop starts here"),
        (0xb29a, 0xb29a, "move old end coords to start coords"),
        (0xb2aa, 0xb2aa, "B = 8-B for odd sectors"),
        (0xb2b2, 0xb2b2, "X= (,U) x radius"),
        (0xb2bb, 0xb2bb, "X= (,U) x radius"),
        (0xb2be, 0xb2be, "X & Y now hold circle coord offsets"),
        (0xb2ca, 0xb2ca, "swap X & Y for sectors 1,2,5,6"),
        (0xb2cc, 0xb2cc, "x offset"),
        (0xb2d2, 0xb2d2, "Y:U = D * X"),
        (0xb2d5, 0xb2d5, "D = hw ratio x y ord"),
        (0xb2d8, 0xb2d8, "?FC ERROR"),
        (0xb2dc, 0xb2dc, "MSB of y offset"),
        (0xb2e0, 0xb2e0, "LSB of y offset"),
        (0xb2ee, 0xb2ee, "x = centre - offset"),
        (0xb2f0, 0xb2f0, "for sectors 2,3,4,5"),
        (0xb2f2, 0xb2f2, "keep on screen"),
        (0xb2f8, 0xb2f8, "x = centre + offset"),
        (0xb2fa, 0xb2fa, "for sectors 0,1,6,7"),
        (0xb2fc, 0xb2fc, "keep on screen"),
        (0xb303, 0xb303, "circle x ord now calculated"),
        (0xb30d, 0xb30d, "y = centre - offset"),
        (0xb30f, 0xb30f, "for sectors 4,5,6,7"),
        (0xb311, 0xb311, "keep on screen"),
        (0xb317, 0xb317, "y = centre + offset"),
        (0xb319, 0xb319, "for sectors 0,1,2,3"),
        (0xb31b, 0xb31b, "keep on screen"),
        (0xb322, 0xb322, "circle y ord now calculated"),
        (0xb326, 0xb326, "1st loop - don't draw"),
        (0xb328, 0xb328, "draw line ($bd,$bf)-($c3,$c5)"),
        (0xb32e, 0xb32e, "1st loop - don't test end condition"),
        (0xb330, 0xb330, "reached end angle?"),
        (0xb335, 0xb335, "increment angle counter"),
        (0xb342, 0xb34f, "multiply radius by value pointed to by U"),
        (0xb342, 0xb342, "radius"),
        (0xb34b, 0xb34b, "Y:U = D * X"),
        (0xb350, 0xb378, "multiplies D by X & leaves result in Y:U"),
        (0xb37a, 0xb37a, "called by CIRCLE"),
        (0xb37a, 0xb37a, "draw line"),
        (0xb37d, 0xb39a, "called by CIRCLE: reads optional start/end value"),
        (0xb37d, 0xb39a, "reduces to 6 bits and leaves top 3 bits in A"),
        (0xb37d, 0xb39a, "& bottom 3 bits in B"),
        (0xb37e, 0xb37e, "get current character from BASIC source"),
        (0xb382, 0xb382, "check comma"),
        (0xb385, 0xb385, "get FP number"),
        (0xb38c, 0xb38c, "multiply FP number by 64"),
        (0xb38e, 0xb38e, "get FP number in B"),
        (0xb39b, 0xb3b2, "reset routine continued"),
        (0xb39f, 0xb39f, "enable cart FIRQ"),
        (0xb3a4, 0xb3a4, "cold boot flag"),
        (0xb3a8, 0xb3a8, "cold boot"),
        (0xb3aa, 0xb3aa, "soft reset vector"),
        (0xb3b0, 0xb3b0, "cold boot"),
        (0xb3b2, 0xb3b2, "soft reset"),
        (0xb3b4, 0xb3b7, "reset routine (CPU vector)"),
        (0xb3b7, 0xb3b7, "JMP to $BB3C"),
        (0xb3ba, 0xb44d, "reset routine - invalid soft vector"),
        (0xb3ba, 0xb3ba, "clear 0 - 3ff"),
        (0xb3c3, 0xb3c3, "clear text screen"),
        (0xb3c8, 0xb3c8, "start of BASIC program"),
        (0xb3ca, 0xb3ca, "memory test"),
        (0xb3d9, 0xb3d9, "top of RAM"),
        (0xb3db, 0xb3db, "top of BASIC RAM"),
        (0xb3dd, 0xb3dd, "top of free string space"),
        (0xb3e3, 0xb3e3, "stack root / string storage start"),
        (0xb3e7, 0xb3e7, "calls $BB88"),
        (0xb3ed, 0xb3ed, "initialise system variables"),
        (0xb3f2, 0xb3f2, "copy B bytes from X to U"),
        (0xb3f5, 0xb3f5, "initialise system variables"),
        (0xb3fa, 0xb3fa, "copy B bytes from X to U"),
        (0xb3fd, 0xb3fd, "?SN ERROR"),
        (0xb400, 0xb400, "dummy disk command jump"),
        (0xb402, 0xb402, "dummy disk function jump"),
        (0xb404, 0xb404, "set patch vectors to RTS"),
        (0xb40f, 0xb40f, "mystery RTS"),
        (0xb412, 0xb412, "NEW BASIC"),
        (0xb415, 0xb415, "set up PLAY & graphics variables"),
        (0xb418, 0xb418, "set up USR vectors"),
        (0xb41b, 0xb41b, "address of USR table"),
        (0xb41d, 0xb41d, "?FC ERROR"),
        (0xb427, 0xb427, "PCLEAR 4"),
        (0xb42f, 0xb42f, "enable vsync irq"),
        (0xb432, 0xb432, "check for 'DK' disk"),
        (0xb435, 0xb435, "cartridge sigature"),
        (0xb43c, 0xb43c, "enable interrupts"),
        (0xb441, 0xb441, "display copyright message"),
        (0xb444, 0xb444, "set up soft reset vector"),
        (0xb447, 0xb447, "soft reset vector"),
        (0xb44b, 0xb44b, "cold boot flag"),
        (0xb44d, 0xb44d, "(JMP $8371 - command mode)"),
        (0xb44f, 0xb466, "normal soft reset routine"),
        (0xb450, 0xb450, "clear PLAY duration counter"),
        (0xb454, 0xb454, "enable vsync irq"),
        (0xb45c, 0xb45c, "DEVN = VDU"),
        (0xb45e, 0xb45e, "reset stack"),
        (0xb461, 0xb461, "enable interrupts"),
        (0xb463, 0xb463, "clear screen"),
        (0xb466, 0xb466, "command mode"),
        (0xb469, 0xb47d, "FIRQ service routine"),
        (0xb46c, 0xb46c, "cartridge"),
        (0xb46f, 0xb46f, "delay"),
        (0xb47b, 0xb47b, "cold boot flag"),
        (0xb480, 0xb486, "delay before starting FIRQ cartrige"),
        (0xb480, 0xb480, "zero"),
        (0xb487, 0x7ebb, "copied to $9d - $aa on start up"),
        (0xb487, 0x7ebb, "(default EXEC & get character routine)"),
        (0xb495, 0xb4a9, "copied to $10c - $129 on start up"),
        (0xb495, 0xb4a9, "(IRQ, FIRQ, RND seeds, key delay, command addresses)"),
        (0xb4b3, 0xb503, "copyright message"),
        (0xb505, 0xb509, "read 7 bit character from device DEVN"),
        (0xb50a, 0xb519, "read character from device DEVN"),
        (0xb50a, 0xb519, "(+set EOF file flag if applicable)"),
        (0xb50a, 0xb50a, "PATCH - input character from DEVN"),
        (0xb50d, 0xb50d, "EOF flag"),
        (0xb50f, 0xb50f, "DEVN"),
        (0xb511, 0xb511, "get character from keyboard"),
        (0xb513, 0xb513, "no. of characters in buffer"),
        (0xb515, 0xb515, "get character from file"),
        (0xb517, 0xb517, "set EOF flag"),
        (0xb51a, 0xb536, "read character from file"),
        (0xb51c, 0xb51c, "buffer pointer"),
        (0xb522, 0xb522, "buffer pointer"),
        (0xb524, 0xb524, "no. of characters in buffer"),
        (0xb528, 0xb528, "DEVN"),
        (0xb52c, 0xb52c, "serial"),
        (0xb52e, 0xb52e, "get block from tape"),
        (0xb533, 0xb533, "get block from serial"),
        (0xb538, 0xb548, "wait for character from keyboard"),
        (0xb538, 0xb548, "(with cursor)"),
        (0xb53a, 0xb53a, "blink cursor"),
        (0xb53d, 0xb53d, "scan keyboard"),
        (0xb544, 0xb544, "text cursor address"),
        (0xb54a, 0xb576, "output character to device DEVN"),
        (0xb54a, 0xb54a, "PATCH - output character to DEVN"),
        (0xb54f, 0xb54f, "DEVN"),
        (0xb553, 0xb553, "not -3 (serial output not supported)"),
        (0xb55a, 0xb55a, "send to printer"),
        (0xb55e, 0xb55e, "send to VDU"),
        (0xb560, 0xb560, "send to file"),
        (0xb562, 0xb562, "cassette IO status"),
        (0xb565, 0xb565, "input - quit"),
        (0xb567, 0xb567, "no. of characters in buffer"),
        (0xb56c, 0xb56c, "flush tape buffer"),
        (0xb56e, 0xb56e, "buffer pointer"),
        (0xb572, 0xb572, "buffer pointer"),
        (0xb574, 0xb574, "no. of characters in buffer"),
        (0xb578, 0xb58c, "flush tape buffer"),
        (0xb57a, 0xb57a, "block type"),
        (0xb57c, 0xb57c, "IO buffer"),
        (0xb581, 0xb581, "no. of characters in buffer"),
        (0xb583, 0xb583, "block length"),
        (0xb587, 0xb587, "write leader & block to tape"),
        (0xb58c, 0xb58c, "reset IO buffer"),
        (0xb58f, 0xb592, "send character to VDU"),
        (0xb58f, 0xb58f, "reset VDU"),
        (0xb592, 0xb592, "write to VDU"),
        (0xb595, 0xb5c1, "initialise virtual DEVN device"),
        (0xb595, 0xb595, "PATCH - device initialisation"),
        (0xb59a, 0xb59a, "cassette IO flag"),
        (0xb59c, 0xb59c, "DEVN"),
        (0xb59e, 0xb59e, "VDU"),
        (0xb5a1, 0xb5a1, "cassette"),
        (0xb5a3, 0xb5a3, "printer comma field width / last comma field"),
        (0xb5a5, 0xb5a5, "printer line width / head pos"),
        (0xb5ab, 0xb5ab, "get VDU column number"),
        (0xb5b2, 0xb5b2, "comma field width / last comma field"),
        (0xb5b4, 0xb5b4, "current column number"),
        (0xb5b6, 0xb5b6, "line width"),
        (0xb5ba, 0xb5ba, "set cassette IO flag"),
        (0xb5c3, 0xb5c3, "clear screen"),
        (0xb5c3, 0xb5c3, "clear screen"),
        (0xb5c6, 0xb621, "command mode line input from DEVN"),
        (0xb5c6, 0xb5c6, "PATCH - line input file"),
        (0xb5c9, 0xb5c9, "last key pressed"),
        (0xb5ce, 0xb5ce, "B = character count"),
        (0xb5d0, 0xb5d0, "read 7 bit character from DEVN"),
        (0xb5d3, 0xb5d3, "EOF flag"),
        (0xb5d5, 0xb5d5, "EOF"),
        (0xb5d7, 0xb5d7, "DEVN"),
        (0xb5d9, 0xb5d9, "not keyed input"),
        (0xb5db, 0xb5db, "CLEAR key"),
        (0xb5df, 0xb5df, "backspace"),
        (0xb5e4, 0xb5e4, "nothing to delete"),
        (0xb5ea, 0xb5ea, "shift + backspace"),
        (0xb5ef, 0xb5ef, "nothing to delete"),
        (0xb5f3, 0xb5f3, "output character to DEVN"),
        (0xb5f8, 0xb5f8, "BREAK"),
        (0xb5fe, 0xb5fe, "RETURN"),
        (0xb605, 0xb605, "send CR to DEVN"),
        (0xb60a, 0xb60a, "return with carry set if"),
        (0xb60d, 0xb60d, "input aborted with BREAK"),
        (0xb611, 0xb611, "chr < $20"),
        (0xb615, 0xb615, "chr >= $7b"),
        (0xb619, 0xb619, "max no. of characters = $fa"),
        (0xb61e, 0xb61e, "echo typed character"),
        (0xb623, 0xb639, "test cassette status OK for input"),
        (0xb623, 0xb623, "PATCH - input file"),
        (0xb626, 0xb626, "DEVN"),
        (0xb628, 0xb628, "RTS"),
        (0xb62b, 0xb62b, "?FM ERROR"),
        (0xb62d, 0xb62d, "cassette IO status"),
        (0xb62f, 0xb62f, "open"),
        (0xb631, 0xb631, "?NO ERROR"),
        (0xb637, 0xb637, "input - RTS"),
        (0xb639, 0xb639, "?FM ERROR"),
        (0xb63c, 0xb64b, "if DEVN = -1 test cassette status for output"),
        (0xb63c, 0xb63c, "PATCH - output file"),
        (0xb63f, 0xb63f, "DEVN"),
        (0xb642, 0xb642, "not cassette"),
        (0xb644, 0xb644, "cassette IO status"),
        (0xb646, 0xb646, "?NO ERROR"),
        (0xb649, 0xb649, "?FM ERROR"),
        (0xb64c, 0xb65c, "CLOSE"),
        (0xb64c, 0xb65c, "Format: CLOSE [#-n[,#-n]]"),
        (0xb64c, 0xb64c, "no parameter so close #-1"),
        (0xb64e, 0xb64e, "read #-n & set up DEVN (no skip comma)"),
        (0xb651, 0xb651, "close DEVN stream & set DEVN to 0"),
        (0xb653, 0xb653, "get current character from BASIC source"),
        (0xb655, 0xb655, "RTS"),
        (0xb657, 0xb657, "read #-n & set up DEVN"),
        (0xb65a, 0xb65a, "read next stream no."),
        (0xb65c, 0xb65c, "PATCH - close all files"),
        (0xb65f, 0xb681, "close cassette stream & set DEVN to 0"),
        (0xb661, 0xb661, "DEVN"),
        (0xb663, 0xb663, "PATCH - close file"),
        (0xb666, 0xb666, "DEVN"),
        (0xb668, 0xb668, "DEVN"),
        (0xb66b, 0xb66b, "not cassette"),
        (0xb66d, 0xb66d, "cassette IO status"),
        (0xb671, 0xb671, "not output"),
        (0xb673, 0xb673, "no. of characters in buffer"),
        (0xb677, 0xb677, "flush tape buffer"),
        (0xb67c, 0xb67c, "B = $FF = EOF block"),
        (0xb67f, 0xb67f, "cassette IO status"),
        (0xb682, 0xb6a2, "CSAVE"),
        (0xb684, 0xb684, "CSAVEM"),
        (0xb688, 0xb688, "get filename"),
        (0xb68b, 0xb68b, "get current character from BASIC source"),
        (0xb68d, 0xb68d, "normal CSAVE"),
        (0xb68f, 0xb68f, "check comma"),
        (0xb694, 0xb694, "skip over 'A'"),
        (0xb697, 0xb697, "return if anything else on command line"),
        (0xb699, 0xb699, "file type = 0 = tokenized BASIC"),
        (0xb69a, 0xb69a, "write filename block for gapped ASCII"),
        (0xb69f, 0xb69f, "DEVN = -1"),
        (0xb6a2, 0xb6a2, "LIST to DEVN - very clever!"),
        (0xb6a5, 0xb6d1, "ungapped CSAVE"),
        (0xb6a5, 0xb6a5, "tokenized BASIC"),
        (0xb6a6, 0xb6a6, "non-ASCII & ungapped"),
        (0xb6a8, 0xb6a8, "write filename block"),
        (0xb6ab, 0xb6ab, "cassette IO status"),
        (0xb6ad, 0xb6ad, "block type"),
        (0xb6af, 0xb6af, "write leader"),
        (0xb6b2, 0xb6b2, "start of BASIC program"),
        (0xb6b4, 0xb6b4, "IO buffer"),
        (0xb6b8, 0xb6b8, "block length"),
        (0xb6ba, 0xb6ba, "start of simple variables"),
        (0xb6bc, 0xb6bc, "IO buffer"),
        (0xb6c6, 0xb6c6, "block length"),
        (0xb6c8, 0xb6c8, "write block to tape"),
        (0xb6cd, 0xb6cd, "block type"),
        (0xb6cf, 0xb6cf, "block length"),
        (0xb6d1, 0xb6d1, "write block & cassette relay off"),
        (0xb6d4, 0xb6fa, "CLOAD"),
        (0xb6d4, 0xb6d4, "cassette IO status"),
        (0xb6d8, 0xb6d8, "CLOADM (returns to $b73c if not gapped)"),
        (0xb6de, 0xb6de, "get filename"),
        (0xb6e1, 0xb6e1, "find file & set up buffer"),
        (0xb6e4, 0xb6e4, "gap flag"),
        (0xb6e9, 0xb6e9, "ASCII flag"),
        (0xb6ec, 0xb6ec, "?FM ERROR"),
        (0xb6ee, 0xb6ee, "NEW BASIC"),
        (0xb6f3, 0xb6f3, "DEVN = -1"),
        (0xb6f5, 0xb6f5, "cassette status 1 = input"),
        (0xb6f7, 0xb6f7, "get block from tape"),
        (0xb6fa, 0xb6fa, "command mode / no device initialise"),
        (0xb6fd, 0xb703, "close file & return to command mode"),
        (0xb6fd, 0xb6fd, "PATCH - close ASCII file"),
        (0xb700, 0xb700, "close DEVN stream & set DEVN to 0"),
        (0xb703, 0xb703, "command mode"),
        (0xb706, 0xb739, "ungapped CLOAD"),
        (0xb706, 0xb706, "file type 0 = tokenized BASIC"),
        (0xb70b, 0xb70b, "?FM ERROR"),
        (0xb70e, 0xb70e, "NEW BASIC"),
        (0xb711, 0xb711, "read leader from tape"),
        (0xb714, 0xb714, "start of BASIC program"),
        (0xb716, 0xb716, "IO buffer"),
        (0xb71b, 0xb71b, "memory check"),
        (0xb71e, 0xb71e, "read block from tape"),
        (0xb721, 0xb721, "error"),
        (0xb723, 0xb723, "block type"),
        (0xb725, 0xb725, "error"),
        (0xb729, 0xb729, "start of simple variables"),
        (0xb72b, 0xb72b, "cassette relay off"),
        (0xb730, 0xb730, "print string to DEVN"),
        (0xb733, 0xb733, "set up new BASIC program & go command mode"),
        (0xb736, 0xb736, "NEW BASIC"),
        (0xb739, 0xb739, "?IO ERROR"),
        (0xb73c, 0xb76d, "returned to do ungapped CLOADM"),
        (0xb73c, 0xb73c, "zero"),
        (0xb73e, 0xb73e, "get current character from BASIC source"),
        (0xb742, 0xb742, "check comma"),
        (0xb745, 0xb745, "get 16 bit number into X"),
        (0xb748, 0xb748, "file type"),
        (0xb74b, 0xb74b, "2 = binary"),
        (0xb74d, 0xb74d, "?FM ERROR"),
        (0xb74f, 0xb74f, "entry address"),
        (0xb752, 0xb752, "apply offset"),
        (0xb754, 0xb754, "EXEC address"),
        (0xb756, 0xb756, "load address"),
        (0xb75b, 0xb75b, "IO buffer"),
        (0xb75d, 0xb75d, "read leader from tape"),
        (0xb760, 0xb760, "read block from tape"),
        (0xb763, 0xb763, "?IO ERROR"),
        (0xb765, 0xb765, "IO buffer"),
        (0xb767, 0xb767, "block type"),
        (0xb769, 0xb769, "?IO ERROR"),
        (0xb76d, 0xb76d, "cassette relay off"),
        (0xb770, 0xb777, "EXEC"),
        (0xb772, 0xb772, "get 16 bit number into X"),
        (0xb775, 0xb775, "default EXEC address"),
        (0xb77b, 0xb783, "scan for break & pause if DEVN not -1"),
        (0xb77b, 0xb77b, "PATCH - check break & pause"),
        (0xb77e, 0xb77e, "DEVN"),
        (0xb781, 0xb781, "RTS"),
        (0xb783, 0xb783, "scan keyboard for break & pause"),
        (0xb786, 0xb795, "called by PRINT to handle PRINT@"),
        (0xb786, 0xb786, "get unsigned number into D & $52 from FPA1"),
        (0xb78c, 0xb78c, "?FC ERROR"),
        (0xb793, 0xb793, "text cursor address"),
        (0xb796, 0xb7a7, "INKEY$"),
        (0xb796, 0xb796, "last key pressed"),
        (0xb798, 0xb798, "key ready"),
        (0xb79a, 0xb79a, "scan keyboard"),
        (0xb79d, 0xb79d, "last key pressed"),
        (0xb7a1, 0xb7a1, "set up character & put on varptr stack"),
        (0xb7a7, 0xb7a7, "leas 2,s & put temp string on varptr stack"),
        (0xb7aa, 0xb7c9, "called by get filename routine"),
        (0xb7aa, 0xb7c9, "(reads filename from command into usual location)"),
        (0xb7b3, 0xb7b3, "IO buffer"),
        (0xb7b8, 0xb7b8, "get current character from BASIC source"),
        (0xb7ba, 0xb7ba, "RTS"),
        (0xb7bc, 0xb7bc, "get expression"),
        (0xb7bf, 0xb7bf, "validate string & point X to it (len in B)"),
        (0xb7c5, 0xb7c5, "store length"),
        (0xb7cc, 0xb7d3, "copy 8 bytes from X to U"),
        (0xb7cc, 0xb7d3, "(B7CA C608       LDB   #$08)"),
        (0xb7cc, 0xb7d3, "copy B bytes from X to U"),
        (0xb7d4, 0xb7f6, "read #-n from command and sets up DEVN"),
        (0xb7d4, 0xb7d4, "check comma"),
        (0xb7db, 0xb7db, "get next character from BASIC source"),
        (0xb7dd, 0xb7dd, "get numeric expression into FPA1"),
        (0xb7e0, 0xb7e0, "get 16 bit number into D & $52 from FPA1"),
        (0xb7e6, 0xb7e6, "?DN ERROR"),
        (0xb7e9, 0xb7e9, "DEVN"),
        (0xb7eb, 0xb7eb, "PATCH - check device number"),
        (0xb7f0, 0xb7f0, "?DN ERROR"),
        (0xb7f4, 0xb7f4, "?DN ERROR"),
        (0xb7f7, 0xb7fd, "get filename from command"),
        (0xb7f7, 0xb7fd, "(sets up filename locations)"),
        (0xb7f7, 0xb7f7, "get filename"),
        (0xb7f9, 0xb7f9, "get current character from BASIC source"),
        (0xb7fb, 0xb7fb, "RTS"),
        (0xb7fd, 0xb7fd, "?SN ERROR"),
        (0xb800, 0xb81b, "EOF"),
        (0xb800, 0xb800, "PATCH - check eof"),
        (0xb803, 0xb803, "DEVN"),
        (0xb807, 0xb807, "get device number from command"),
        (0xb809, 0xb809, "test cassette status OK for input"),
        (0xb80d, 0xb80d, "DEVN"),
        (0xb80f, 0xb80f, "VDU"),
        (0xb811, 0xb811, "no. of characters in buffer"),
        (0xb813, 0xb813, "not EOF"),
        (0xb818, 0xb818, "DEVN"),
        (0xb81b, 0xb81b, "assign D to FPA1"),
        (0xb81e, 0xb827, "SKIPF"),
        (0xb81e, 0xb81e, "get filename"),
        (0xb820, 0xb820, "find file & set up buffer"),
        (0xb822, 0xb822, "skip rest of file"),
        (0xb825, 0xb825, "?IO ERROR"),
        (0xb828, 0xb84a, "OPEN"),
        (0xb828, 0xb828, "PATCH - device open"),
        (0xb82b, 0xb82b, "get expression"),
        (0xb82e, 0xb82e, "get 1st character of string into B"),
        (0xb833, 0xb833, "read #-n & set up DEVN"),
        (0xb835, 0xb835, "check comma"),
        (0xb838, 0xb838, "get filename"),
        (0xb83a, 0xb83a, "DEVN"),
        (0xb83c, 0xb83c, "DEVN"),
        (0xb842, 0xb842, "open for input"),
        (0xb846, 0xb846, "write filename block if A = -1"),
        (0xb848, 0xb848, "?FM ERROR"),
        (0xb84d, 0xb84d, "(B84B C62A       LDB   #$2A)    ;?IO ERROR"),
        (0xb850, 0xb850, "(B84E C626       LDB   #$26)    ;?AO ERROR"),
        (0xb853, 0xb878, "(B851 C628       LDB   #$28)    ;?DN ERROR"),
        (0xb856, 0xb856, "input stream must be >= -1"),
        (0xb857, 0xb857, "?FM ERROR"),
        (0xb859, 0xb859, "return if stream <> -1"),
        (0xb85b, 0xb85b, "find file & set up buffer"),
        (0xb85d, 0xb85d, "must be ASCII"),
        (0xb860, 0xb860, "and gapped"),
        (0xb863, 0xb863, "?FM ERROR"),
        (0xb865, 0xb865, "cassette IO status"),
        (0xb867, 0xb867, "read leader & block from tape"),
        (0xb86a, 0xb86a, "?IO ERROR"),
        (0xb86c, 0xb86c, "block must be data or EOF"),
        (0xb86e, 0xb86e, "?IO ERROR"),
        (0xb870, 0xb870, "return if EOF block"),
        (0xb872, 0xb872, "block length"),
        (0xb874, 0xb874, "get another block if zero length"),
        (0xb876, 0xb876, "no. of characters in buffer"),
        (0xb878, 0xb878, "finish setting up buffer"),
        (0xb87a, 0xb889, "find file & set up buffer"),
        (0xb87a, 0xb87a, "cassette IO status"),
        (0xb87c, 0xb87c, "?AO ERROR"),
        (0xb87e, 0xb87e, "find file"),
        (0xb880, 0xb880, "?IO ERROR"),
        (0xb882, 0xb882, "no. of characters in buffer"),
        (0xb884, 0xb884, "IO buffer"),
        (0xb887, 0xb887, "buffer pointer"),
        (0xb88a, 0xb88d, "if A = -1 then write filename block for gapped ASCII"),
        (0xb88b, 0xb88b, "RTS"),
        (0xb88d, 0xb88d, "A = 1"),
        (0xb88e, 0xb8b1, "write filename block for gapped ASCII (file type in A)"),
        (0xb891, 0xb891, "cassette IO status"),
        (0xb893, 0xb893, "?AO ERROR"),
        (0xb895, 0xb895, "IO buffer"),
        (0xb89a, 0xb89a, "file type"),
        (0xb89c, 0xb89c, "ASCII flag & gap flag"),
        (0xb89e, 0xb89e, "filename"),
        (0xb8a1, 0xb8a1, "copy 8 bytes from X to U"),
        (0xb8a4, 0xb8a4, "block type"),
        (0xb8a8, 0xb8a8, "block length"),
        (0xb8aa, 0xb8aa, "write leader & block to tape"),
        (0xb8ad, 0xb8ad, "2 = output"),
        (0xb8af, 0xb8af, "cassette IO status"),
        (0xb8b1, 0xb8b1, "reset IO buffer"),
        (0xb8b3, 0xb902, "find file"),
        (0xb8b3, 0xb8b3, "IO buffer"),
        (0xb8b8, 0xb8b8, "current line number"),
        (0xb8bb, 0xb8bb, "not in command mode"),
        (0xb8bd, 0xb8bd, "clear screen"),
        (0xb8c0, 0xb8c0, "text cursor address"),
        (0xb8c6, 0xb8c6, "text cursor address"),
        (0xb8c8, 0xb8c8, "read leader & block from tape"),
        (0xb8ca, 0xb8ca, "block type"),
        (0xb8cc, 0xb8cc, "keep going until filename block loaded"),
        (0xb8ce, 0xb8ce, "IO buffer"),
        (0xb8d1, 0xb8d1, "filename to find"),
        (0xb8da, 0xb8da, "current line number"),
        (0xb8df, 0xb8df, "not in command mode"),
        (0xb8e1, 0xb8e1, "DEVN"),
        (0xb8e3, 0xb8e3, "output character to DEVN"),
        (0xb8f1, 0xb8f1, "matched filename"),
        (0xb8f5, 0xb8f5, "no filename specified"),
        (0xb8f7, 0xb8f7, "skip rest of file"),
        (0xb8f9, 0xb8f9, "return with error"),
        (0xb8fb, 0xb8fb, "try next file"),
        (0xb8ff, 0xb8ff, "display 'F'"),
        (0xb903, 0xb915, "skip rest of file"),
        (0xb903, 0xb903, "gap flag"),
        (0xb906, 0xb906, "gapped file"),
        (0xb908, 0xb908, "read leader from tape"),
        (0xb90b, 0xb90b, "read block from tape"),
        (0xb90d, 0xb90d, "test file status"),
        (0xb90f, 0xb90f, "do next block"),
        (0xb911, 0xb911, "read leader & block from tape"),
        (0xb913, 0xb913, "test file status"),
        (0xb915, 0xb915, "do next block"),
        (0xb917, 0xb923, "test file status"),
        (0xb919, 0xb919, "block type"),
        (0xb91c, 0xb91c, "normal block - RTS"),
        (0xb91f, 0xb91f, "error status"),
        (0xb923, 0xb923, "cassette relay off & get status in B"),
        (0xb925, 0xb932, "flash loading cursor"),
        (0xb92a, 0xb92a, "current line number"),
        (0xb92d, 0xb92d, "not in command mode"),
        (0xb933, 0xb93d, "read leader & block from tape"),
        (0xb933, 0xb933, "read leader from tape"),
        (0xb936, 0xb936, "read block from tape"),
        (0xb938, 0xb938, "cassette relay off"),
        (0xb93b, 0xb93b, "error status"),
        (0xb93e, 0xb97b, "read block from tape"),
        (0xb93e, 0xb93e, "mask interrupts"),
        (0xb940, 0xb940, "flash loading cursor"),
        (0xb942, 0xb942, "IO buffer"),
        (0xb945, 0xb945, "bit in"),
        (0xb94b, 0xb94b, "wait for sync byte"),
        (0xb94d, 0xb94d, "byte in"),
        (0xb950, 0xb950, "block type"),
        (0xb952, 0xb952, "byte in"),
        (0xb955, 0xb955, "block length"),
        (0xb957, 0xb957, "block type"),
        (0xb959, 0xb959, "checksum"),
        (0xb95b, 0xb95b, "block length"),
        (0xb95d, 0xb95d, "use error status as counter"),
        (0xb95f, 0xb95f, "no data"),
        (0xb961, 0xb961, "byte in"),
        (0xb966, 0xb966, "check that we are loading into RAM"),
        (0xb96c, 0xb96c, "checksum"),
        (0xb970, 0xb970, "get next data byte"),
        (0xb972, 0xb972, "byte in"),
        (0xb975, 0xb975, "checksum"),
        (0xb977, 0xb977, "status = OK"),
        (0xb979, 0xb979, "status = CRC error"),
        (0xb97e, 0xb980, "(B97C 8602       LDA   #$02)    ;status = no RAM"),
        (0xb97e, 0xb97e, "status"),
        (0xb981, 0xb98e, "MOTOR"),
        (0xb983, 0xb983, "get next character from BASIC source"),
        (0xb985, 0xb985, "token OFF"),
        (0xb987, 0xb987, "cassette relay off"),
        (0xb989, 0xb989, "token ON"),
        (0xb98b, 0xb98b, "?SN ERROR if <>0"),
        (0xb98e, 0xb98e, "cassette relay on"),
        (0xb991, 0xb996, "write leader & block to tape"),
        (0xb991, 0xb991, "write leader"),
        (0xb994, 0xb994, "write block to tape"),
        (0xb996, 0xb996, "cassette relay off"),
        (0xb999, 0xb9cf, "write block to tape"),
        (0xb999, 0xb999, "mask interrupts"),
        (0xb99b, 0xb99b, "block length"),
        (0xb99d, 0xb99d, "use error status as counter"),
        (0xb99f, 0xb99f, "block length"),
        (0xb9a1, 0xb9a1, "no data"),
        (0xb9a3, 0xb9a3, "IO buffer address"),
        (0xb9a8, 0xb9a8, "calculate checksum"),
        (0xb9aa, 0xb9aa, "block type"),
        (0xb9ac, 0xb9ac, "checksum"),
        (0xb9ae, 0xb9ae, "IO buffer address"),
        (0xb9b0, 0xb9b0, "write single leader byte"),
        (0xb9b2, 0xb9b2, "sync byte"),
        (0xb9b4, 0xb9b4, "byte out"),
        (0xb9b6, 0xb9b6, "block type"),
        (0xb9b8, 0xb9b8, "byte out"),
        (0xb9ba, 0xb9ba, "block length"),
        (0xb9bc, 0xb9bc, "byte out"),
        (0xb9bf, 0xb9bf, "no data"),
        (0xb9c3, 0xb9c3, "byte out"),
        (0xb9c7, 0xb9c7, "keep going until all data sent"),
        (0xb9c9, 0xb9c9, "checksum"),
        (0xb9cb, 0xb9cb, "byte out"),
        (0xb9cd, 0xb9cd, "leader byte"),
        (0xb9cf, 0xb9cf, "byte out"),
        (0xb9d2, 0xb9ed, "SET"),
        (0xb9d2, 0xb9d2, "read coords & calc pixel"),
        (0xb9d6, 0xb9d6, "skip comma & get number in B"),
        (0xb9dd, 0xb9dd, "?FC ERROR"),
        (0xb9e0, 0xb9e0, "black"),
        (0xb9e9, 0xb9e9, "non-graphics block present"),
        (0xb9ef, 0xba02, "(B9EE 5F         CLRB)"),
        (0xb9f1, 0xb9f1, "skip close bracket"),
        (0xb9f7, 0xb9f7, "non-graphics block present"),
        (0xb9fa, 0xb9fa, "lo-res pixel mask"),
        (0xba03, 0xba12, "RESET"),
        (0xba03, 0xba03, "read coords & calc pixel"),
        (0xba05, 0xba05, "skip close bracket"),
        (0xba0c, 0xba0c, "lo-res pixel mask"),
        (0xba13, 0xba43, "read coords & calc pixel for SET / RESET / POINT"),
        (0xba13, 0xba13, "skip open bracket"),
        (0xba16, 0xba16, "get number in B"),
        (0xba1b, 0xba1b, "?FC ERROR"),
        (0xba1f, 0xba1f, "skip comma & get number in B"),
        (0xba24, 0xba24, "?FC ERROR"),
        (0xba41, 0xba41, "lo-res pixel mask"),
        (0xba44, 0xba5c, "POINT"),
        (0xba44, 0xba44, "read coords"),
        (0xba4a, 0xba4a, "non-graphics block"),
        (0xba4c, 0xba4c, "lo-res pixel mask"),
        (0xba59, 0xba59, "return number to BASIC"),
        (0xba5c, 0xba5c, "skip close bracket"),
        (0xba5f, 0xba76, "CLS"),
        (0xba5f, 0xba5f, "PATCH - CLS GET PUT"),
        (0xba62, 0xba62, "no parameter - clear to spaces"),
        (0xba64, 0xba64, "get number in B"),
        (0xba69, 0xba69, "CLS 9+"),
        (0xba6c, 0xba6c, "CLS 0"),
        (0xba79, 0xba85, "clear text screen"),
        (0xba79, 0xba85, "(BA77 C660       LDB   #$60)"),
        (0xba7c, 0xba7c, "text cursor address"),
        (0xba86, 0xba8b, "clear text screen & print copyright message for CLS9+"),
        (0xba86, 0xba86, "clear screen"),
        (0xba8b, 0xba8b, "print string to DEVN"),
        (0xba8e, 0xba97, "get parameter for SOUND"),
        (0xba8e, 0xba8e, "check comma"),
        (0xba91, 0xba91, "get number in B"),
        (0xba95, 0xba95, "RTS"),
        (0xba97, 0xba97, "?FC ERROR"),
        (0xba9a, 0xbac1, "SOUND"),
        (0xba9a, 0xba9a, "get pitch"),
        (0xba9c, 0xba9c, "pitch"),
        (0xba9e, 0xba9e, "skip comma & get duration"),
        (0xbaa3, 0xbaa3, "duration x 4"),
        (0xbaaa, 0xbaaa, "enable vsync irq"),
        (0xbaaf, 0xbaaf, "B=0 to select d/a sound"),
        (0xbab1, 0xbab1, "enable audio"),
        (0xbab3, 0xbab3, "centre d/a"),
        (0xbab7, 0xbab7, "max d/a"),
        (0xbab9, 0xbab9, "centre d/a"),
        (0xbabd, 0xbabd, "min d/a"),
        (0xbabf, 0xbabf, "loop until irq routine"),
        (0xbac1, 0xbac1, "decrements duration to zero"),
        (0xbac3, 0xbac4, "disable audio"),
        (0xbac7, 0xbad3, "enable audio"),
        (0xbac7, 0xbad3, "(BAC5 8608       LDA #$08)"),
        (0xbad4, 0xbad4, "reset D/A and delay"),
        (0xbad6, 0xbade, "store A in D/A and delay"),
        (0xbad9, 0xbad9, "SOUND pitch value"),
        (0xbadf, 0xbaef, "AUDIO"),
        (0xbae1, 0xbae1, "get next character from BASIC source"),
        (0xbae3, 0xbae3, "token OFF"),
        (0xbae7, 0xbae7, "token ON"),
        (0xbae9, 0xbae9, "?SN ERROR if <>0"),
        (0xbaed, 0xbaed, "B=1 for cassette sound"),
        (0xbaef, 0xbaef, "enable audio"),
        (0xbaf1, 0xbb01, "select sound source"),
        (0xbb02, 0xbb0c, "SOUND duration counter"),
        (0xbb02, 0xbb0c, "(called by IRQ service routine)"),
        (0xbb02, 0xbb02, "SOUND counter"),
        (0xbb09, 0xbb09, "SOUND counter"),
        (0xbb0d, 0xbb23, "JOYSTK"),
        (0xbb0d, 0xbb0d, "get number in B from FPA1"),
        (0xbb12, 0xbb12, "?FC ERROR"),
        (0xbb19, 0xbb19, "update joysticks if B = 0"),
        (0xbb1c, 0xbb1c, "joystick value table"),
        (0xbb1f, 0xbb1f, "get number again"),
        (0xbb23, 0xbb23, "assign B to FPA1"),
        (0xbb26, 0xbb34, "continued from fetch character routine at $9f"),
        (0xbb26, 0xbb34, "skips spaces and returns with carry set if"),
        (0xbb26, 0xbb34, "character is a digit"),
        (0xbb28, 0xbb28, "higher than '9'"),
        (0xbb2c, 0xbb2c, "not a space"),
        (0xbb2e, 0xbb2e, "get next character from BASIC source"),
        (0xbb32, 0xbb32, "set carry if >= '0'"),
        (0xbb35, 0xbb35, "unused"),
        (0xbb3c, 0xbb7e, "reset routine continued"),
        (0xbb3c, 0xbb3c, "initialise PIA0:"),
        (0xbb3f, 0xbb3f, "$FF00 PDR rrrrrrrr"),
        (0xbb42, 0xbb42, "$FF02 PDR wwwwwwww"),
        (0xbb44, 0xbb44, "CA2 bit3 output mode"),
        (0xbb46, 0xbb46, "CB2 bit3 output mode"),
        (0xbb48, 0xbb48, "IRQA disabled (hsync)"),
        (0xbb49, 0xbb49, "IRQB disabled (vsync)"),
        (0xbb4f, 0xbb4f, "initialise PIA1:"),
        (0xbb52, 0xbb52, "$FF20 PDR wwwwwwwr"),
        (0xbb54, 0xbb54, "$FF22 PDR wwwwwrrr"),
        (0xbb56, 0xbb56, "CA2 bit3 output mode"),
        (0xbb57, 0xbb57, "CB2 bit3 output mode"),
        (0xbb59, 0xbb59, "IRQA disabled (ack)"),
        (0xbb5b, 0xbb5b, "IRQB disabled (cart)"),
        (0xbb65, 0xbb65, "initialise serial hardware:"),
        (0xbb68, 0xbb68, "no parity, no IRQ, DTR low"),
        (0xbb6b, 0xbb6b, "1200 baud, 8 data, 2 stop"),
        (0xbb6e, 0xbb6e, "initialise SAM:"),
        (0xbb71, 0xbb71, "512 byte display"),
        (0xbb73, 0xbb73, "display base 1024"),
        (0xbb75, 0xbb75, "mem page 0"),
        (0xbb76, 0xbb76, "slow MPU rate"),
        (0xbb78, 0xbb78, "64K dynamic memory"),
        (0xbb7b, 0xbb7b, "MAP 0"),
        (0xbb80, 0xbb80, "boot 64K BASIC"),
        (0xbb83, 0xbb86, "reset routine continued"),
        (0xbb86, 0xbb86, "JMP to $B39B"),
        (0xbb88, 0xbb9e, "part of start up reset routine"),
        (0xbb90, 0xbb90, "copy B bytes from X to U"),
        (0xbb92, 0xbb92, "set up serial printer parameters"),
        (0xbb9c, 0xbb9c, "copy B bytes from X to U"),
        (0xbb9f, 0xbb9f, "copied to $8f - $9b on start up"),
        (0xbb9f, 0xbb9f, "(cursor counter, leader count, COS timing, motor on delay,"),
        (0xbb9f, 0xbb9f, "key scan delay, printer parameters)"),
        (0xbbac, 0xbbac, "copied to $148 - $150 on start up"),
        (0xbbac, 0xbbac, "(auto LF flag, caps flag, printer EOL sequence)"),
        (0xbbb5, 0xbbcc, "blink cursor"),
        (0xbbb5, 0xbbb5, "cursor flash counter"),
        (0xbbbb, 0xbbbb, "cursor flash counter"),
        (0xbbbd, 0xbbbd, "text cursor address"),
        (0xbbcd, 0xbbd9, "read key matrix & mask SHIFT key"),
        (0xbbd0, 0xbbd0, "mask analogue comp."),
        (0xbbda, 0xbbe4, "test for SHIFT key"),
        (0xbbe5, 0xbc70, "scan keyboard & return ASCII"),
        (0xbbee, 0xbbee, "key rollover table"),
        (0xbbf1, 0xbbf1, "test all keys"),
        (0xbbf7, 0xbbf7, "mask analogue comp."),
        (0xbbfb, 0xbbfb, "nothing changed - return NUL"),
        (0xbbff, 0xbbff, "disable all keys"),
        (0xbc02, 0xbc02, "read matrix & mask shift"),
        (0xbc06, 0xbc06, "joystick button pressed - return NUL"),
        (0xbc08, 0xbc08, "$0151 = keyboard state"),
        (0xbc0a, 0xbc0a, "row counter"),
        (0xbc11, 0xbc11, "read matrix & mask shift"),
        (0xbc17, 0xbc17, "sets bits in B for new keys pressed"),
        (0xbc1b, 0xbc1b, "save new scan code"),
        (0xbc1e, 0xbc1e, "new keys pressed"),
        (0xbc22, 0xbc22, "set carry"),
        (0xbc23, 0xbc23, "next row"),
        (0xbc26, 0xbc26, "more rows to do"),
        (0xbc28, 0xbc28, "no new keys pressed - return NUL"),
        (0xbc2c, 0xbc2c, "debounce delay"),
        (0xbc30, 0xbc30, "read matrix & mask shift"),
        (0xbc36, 0xbc36, "key state changed during delay - return NUL"),
        (0xbc38, 0xbc38, "row number"),
        (0xbc3c, 0xbc3c, "convert scan code into a number"),
        (0xbc3e, 0xbc3e, "between 0 and 54"),
        (0xbc3f, 0xbc3f, "(nb. shift masked out)"),
        (0xbc42, 0xbc42, "zero key"),
        (0xbc46, 0xbc46, "keys 1 to 9 : ;"),
        (0xbc4a, 0xbc4a, "keys , - . / @"),
        (0xbc4e, 0xbc4e, "arrows SPC RET CLR BRK"),
        (0xbc50, 0xbc50, "ASCII A - Z"),
        (0xbc52, 0xbc52, "test for SHIFT key"),
        (0xbc54, 0xbc54, "SHIFT pressed"),
        (0xbc56, 0xbc56, "CAPS flag"),
        (0xbc59, 0xbc59, "upper case"),
        (0xbc5b, 0xbc5b, "convert to lower case"),
        (0xbc5f, 0xbc5f, "ASCII 1 to 9 : ;"),
        (0xbc61, 0xbc61, "test for SHIFT key"),
        (0xbc64, 0xbc64, "SHIFT not pressed"),
        (0xbc6a, 0xbc6a, "not shift + 0"),
        (0xbc6c, 0xbc6c, "CAPS flag"),
        (0xbc72, 0xbc82, "XLAT key scan code to ASCII"),
        (0xbc77, 0xbc77, "test for SHIFT key"),
        (0xbc84, 0xbc9c, "keyboard XLAT table"),
        (0xbc84, 0xbc9c, "(two bytes per entry - unshifted & shifted)"),
        (0xbc84, 0xbc84, "0      ,"),
        (0xbc88, 0xbc88, "-      ."),
        (0xbc8c, 0xbc8c, "/      @"),
        (0xbc90, 0xbc90, "CU     CD"),
        (0xbc94, 0xbc94, "CL     CR"),
        (0xbc98, 0xbc98, "SPC    RET"),
        (0xbc9c, 0xbc9c, "CLR    BRK"),
        (0xbca0, 0xbcaa, "clear VDU line + CR/LF"),
        (0xbcab, 0xbcf3, "write character to VDU"),
        (0xbcad, 0xbcad, "text cursor address"),
        (0xbcb3, 0xbcb3, "backspace"),
        (0xbcbe, 0xbcbe, "return"),
        (0xbcc2, 0xbcc2, "clear VDU line + CR/LF"),
        (0xbcc8, 0xbcc8, "chr < $20"),
        (0xbccb, 0xbccb, "chr >= 128"),
        (0xbccf, 0xbccf, "$20 <= chr < $40"),
        (0xbcd3, 0xbcd3, "$40 <= chr < $60"),
        (0xbcdb, 0xbcdb, "text cursor address"),
        (0xbce2, 0xbce2, "scroll"),
        (0xbcef, 0xbcef, "text cursor address"),
        (0xbcf1, 0xbcf1, "clear VDU line + CR/LF"),
        (0xbcf5, 0xbcfa, "write character direct to printer"),
        (0xbcf7, 0xbcf7, "printer type flag"),
        (0xbcfa, 0xbcfa, "continued..."),
        (0xbcfd, 0xbd08, "write character to parallel port"),
        (0xbd05, 0xbd05, "strobe"),
        (0xbd0a, 0xbd19, "send EOL characters to printer"),
        (0xbd14, 0xbd14, "send character direct to printer"),
        (0xbd16, 0xbd16, "continued..."),
        (0xbd1a, 0xbd3f, "write character to printer"),
        (0xbd22, 0xbd22, "don't advance head pos for CTRL chrs"),
        (0xbd24, 0xbd24, "printer head pos"),
        (0xbd26, 0xbd26, "send character to printer"),
        (0xbd28, 0xbd28, "printer head pos"),
        (0xbd2a, 0xbd2a, "printer line width"),
        (0xbd2e, 0xbd2e, "printer auto LF flag"),
        (0xbd33, 0xbd33, "printer head pos"),
        (0xbd39, 0xbd39, "send character to printer"),
        (0xbd3b, 0xbd3b, "send EOL sequence"),
        (0xbd3d, 0xbd3d, "printer head pos"),
        (0xbd41, 0xbd51, "select joystick source B (0-3)"),
        (0xbd52, 0xbd88, "update joystick values in locations $15a - $15d"),
        (0xbd52, 0xbd88, "(reads each channel up to 10 times until stable result is obtained)"),
        (0xbd54, 0xbd54, "end of joystick table + 1"),
        (0xbd5d, 0xbd5d, "select joystick source B"),
        (0xbd67, 0xbd67, "test analogue comp."),
        (0xbd6a, 0xbd6a, "approximation low"),
        (0xbd6c, 0xbd6c, "try smaller value"),
        (0xbd70, 0xbd70, "try larger value"),
        (0xbd75, 0xbd75, "do finer approximation"),
        (0xbd78, 0xbd78, "convert range to 0-63"),
        (0xbd7b, 0xbd7b, "reading stable"),
        (0xbd7f, 0xbd7f, "do up to 10 readings until stable"),
        (0xbd86, 0xbd86, "do next joystick channel"),
        (0xbd8a, 0xbd90, "read state of cassette input comparator into carry"),
        (0xbd8a, 0xbd90, "(+update wavelength timer)"),
        (0xbd8a, 0xbd8a, "wavelength timer"),
        (0xbd91, 0xbd97, "wave timer"),
        (0xbd91, 0xbd91, "wavelength timer"),
        (0xbd93, 0xbd93, "phase flag"),
        (0xbd95, 0xbd95, "time antiphase wave"),
        (0xbd97, 0xbd97, "time +ve going wave"),
        (0xbd99, 0xbd9d, "time -ve going wave"),
        (0xbd99, 0xbd99, "read cassette input & update timer"),
        (0xbd9e, 0xbd9e, "alternative wave timer (antiphase)"),
        (0xbd9e, 0xbd9e, "time -ve going wave"),
        (0xbda0, 0xbda4, "time +ve going wave"),
        (0xbda0, 0xbda0, "read cassette input & update timer"),
        (0xbda5, 0xbdac, "read bit from tape into carry"),
        (0xbda7, 0xbda7, "wavelength timer"),
        (0xbdaa, 0xbdaa, "wavelength threshold"),
        (0xbdad, 0xbdb8, "read byte from tape into A"),
        (0xbdb1, 0xbdb1, "read bit from tape into carry"),
        (0xbdb3, 0xbdb3, "LSB first"),
        (0xbdb6, 0xbdb6, "do next bit"),
        (0xbdb9, 0xbdbd, "called by read leader routine - test +ve going wave"),
        (0xbdb9, 0xbdb9, "wavelength timer"),
        (0xbdbb, 0xbdbb, "time +ve going wave"),
        (0xbdbf, 0xbdce, "called by read leader routine - test -ve going wave"),
        (0xbdbf, 0xbdbf, "wavelength timer"),
        (0xbdc1, 0xbdc1, "time -ve going wave"),
        (0xbdc3, 0xbdc3, "wavelength timer"),
        (0xbdc5, 0xbdc5, "rejection threshold"),
        (0xbdc7, 0xbdc7, "bad wave - clear counter"),
        (0xbdc9, 0xbdc9, "discrimination threshold"),
        (0xbdcc, 0xbdcc, "phase lock counter"),
        (0xbdcf, 0xbdd9, "turn cassette relay on"),
        (0xbddc, 0xbde6, "turn cassette relay off"),
        (0xbde7, 0xbe11, "read leader from tape"),
        (0xbde7, 0xbe11, "(+determine phase of signal)"),
        (0xbde7, 0xbde7, "mask interrupts"),
        (0xbde9, 0xbde9, "cassette relay on"),
        (0xbdeb, 0xbdeb, "phase lock counter"),
        (0xbded, 0xbded, "synchronise to in-phase wave (+ve then -ve)"),
        (0xbdef, 0xbdef, "test +ve wave"),
        (0xbdf1, 0xbdf1, "0 or bad"),
        (0xbdf3, 0xbdf3, "test -ve wave"),
        (0xbdf5, 0xbdf5, "1 or bad"),
        (0xbdf7, 0xbdf7, "add 1 for each antiphase pair of cycles"),
        (0xbdff, 0xbdff, "test -ve wave"),
        (0xbe01, 0xbe01, "0 or bad"),
        (0xbe03, 0xbe03, "test +ve wave"),
        (0xbe05, 0xbe05, "1 or bad"),
        (0xbe07, 0xbe07, "subtract 1 for each in-phase pair of cycles"),
        (0xbe0b, 0xbe0b, "SUBA #-$60"),
        (0xbe0d, 0xbe0d, "need $60 locks in a row ($18 leader bytes)"),
        (0xbe0f, 0xbe0f, "phase flag"),
        (0xbe12, 0xbe42, "write byte out to tape (A)"),
        (0xbe14, 0xbe14, "send LSB first"),
        (0xbe16, 0xbe16, "wave table"),
        (0xbe1a, 0xbe1a, "inter-wave level"),
        (0xbe21, 0xbe21, "high frequency for 1"),
        (0xbe23, 0xbe23, "low frequency for 0"),
        (0xbe29, 0xbe29, "done 0"),
        (0xbe36, 0xbe36, "done 1"),
        (0xbe3d, 0xbe3d, "inter-wave level"),
        (0xbe40, 0xbe40, "do next bit"),
        (0xbe44, 0xbe64, "wave table for cassette output"),
        (0xbe68, 0xbe79, "write leader to tape"),
        (0xbe6a, 0xbe6a, "mask interrupts"),
        (0xbe6c, 0xbe6c, "cassette relay on"),
        (0xbe71, 0xbe71, "cassette leader byte count"),
        (0xbe73, 0xbe73, "write byte out to tape"),
        (0xbe77, 0xbe77, "do next byte"),
        (0xbe7b, 0xbe96, "read character from serial port into A"),
        (0xbe7d, 0xbe7d, "mask interrupts"),
        (0xbe86, 0xbe86, "set DTR"),
        (0xbe8b, 0xbe8b, "wait until RX full"),
        (0xbe90, 0xbe90, "clear DTR"),
        (0xbe98, 0xbea4, "write character to serial port (A)"),
        (0xbe9c, 0xbe9c, "wait until TX ready"),
        (0xbea6, 0xbebd, "serial baud rate select"),
        (0xbea6, 0xbebd, "(parameter in B is as per DLOAD)"),
        (0xbea8, 0xbea8, "B must be 0 - 6"),
        (0xbeaa, 0xbeaa, "serial baud setup table"),
        (0xbebe, 0xbebe, "serial port baud setup table"),
        (0xbec4, 0xbec4, "odd byte?"),
        (0xbec5, 0xbedd, "printer direct out (continued from $BCF5)"),
        (0xbecb, 0xbecb, "printer busy"),
        (0xbed6, 0xbed6, "wait until keys released"),
        (0xbedd, 0xbedd, "send character to serial port"),
        (0xbee0, 0xbefd, "scan keyboard continued"),
        (0xbee4, 0xbee4, "key pressed"),
        (0xbee6, 0xbee6, "stores a zero"),
        (0xbeea, 0xbeea, "ASCII NUL"),
        (0xbeec, 0xbeec, "repeat delay"),
        (0xbeef, 0xbeef, "current key"),
        (0xbef2, 0xbef2, "same key pressed - use normal repeat rate"),
        (0xbef5, 0xbef5, "set up initial repeat delay"),
        (0xbef7, 0xbef7, "repeat counter"),
        (0xbefa, 0xbefa, "current key"),
        (0xbeff, 0xbf0b, "D64 extension to start up reset routine"),
        (0xbeff, 0xbeff, "printer type flag"),
        (0xbf02, 0xbf02, "serial printer EOL delay"),
        (0xbf0c, 0xbf1f, "send printer EOL characters (continued)"),
        (0xbf12, 0xbf12, "EOL delay"),
        (0xbf18, 0xbf18, "10ms delay"),
        (0xbf20, 0xbf46, "D64 alternative IRQ service routine"),
        (0xbf20, 0xbf46, "(gives autorepeat keys)"),
        (0xbf23, 0xbf23, "not serial interrupt"),
        (0xbf27, 0xbf27, "RX not full"),
        (0xbf2e, 0xbf2e, "set DTR low"),
        (0xbf32, 0xbf32, "force complete keyboard read"),
        (0xbf35, 0xbf35, "key repeat counter"),
        (0xbf38, 0xbf38, "not yet..."),
        (0xbf3a, 0xbf3a, "clear key rollover table"),
        (0xbf46, 0xbf46, "resume with normal IRQ routine"),
        (0xbf49, 0xbf57, "boot 64K BASIC continued"),
        (0xbf49, 0xbf57, "(doubles as 64K BASIC soft reset)"),
        (0xbf4a, 0xbf4a, "mask interrupts"),
        (0xbf4f, 0xbf4f, "IO buffer"),
        (0xbf54, 0xbf54, "copy B bytes from X to U"),
        (0xbf57, 0xbf57, "IO buffer"),
        (0xbf5a, 0xbfe6, "copied to cassette buffer & executed"),
        (0xbf5a, 0xbf5a, "64K BASIC flag"),
        (0xbf71, 0xbf71, "64K BASIC checksum"),
        (0xbfa5, 0xbfa5, "?FC ERROR"),
        (0xbfa8, 0xbfa8, "64K BASIC checksum"),
        (0xbfbc, 0xbfbc, "64K BASIC checksum"),
        (0xbfd0, 0xbfd0, "top of RAM"),
        (0xbfd2, 0xbfd2, "top of BASIC RAM"),
        (0xbfd4, 0xbfd4, "top of free string space"),
        (0xbfda, 0xbfda, "stack root / string storage start"),
        (0xbfe1, 0xbfe1, "soft reset vector"),
        (0xbff2, 0xbffe, "unused"),
        (0xbff2, 0xbffe, "$BFE9 to"),
        (0xbff2, 0xbffe, "$BFF1"),
        (0xbff2, 0xbffe, "interrupt vectors"),
        (0xbff2, 0xbff2, "SWI3"),
        (0xbff4, 0xbff4, "SWI2"),
        (0xbff6, 0xbff6, "FIRQ"),
        (0xbff8, 0xbff8, "IRQ"),
        (0xbffa, 0xbffa, "SWI"),
        (0xbffc, 0xbffc, "NMI"),
        (0xbffe, 0xbffe, "RESET"),
    )


def print_out(txt):
    print(txt)


def get_dragon_meminfo():
    return Dragon64MemInfo(log.debug)


if __name__ == "__main__":
#     mem_info = Dragon64MemInfo(print_out)
#
#     # 0xaf-0xaf - TRON/TROFF trace flag - non zero for TRON
#     mem_info(0xaf)
#     mem_info(0xaf, shortest=False)
#     print
#
#     # 5x entries
#     mem_info(0xbff0)
#     mem_info(0xbff0, shortest=False)
#     print
#
#     # 0xf-0x18 - Temporary results
#     mem_info(0xf)
#     mem_info(0xf, shortest=False)
#     print
#     mem_info(0x10)
#     mem_info(0x10, shortest=False)
#     print
#     mem_info(0x18)
#     mem_info(0x18, shortest=False)
#     print
#
#     for s, e, txt in Dragon64MemInfo.MEM_INFO:
#         if s == e:
#             addr = nice_hex(s)
#         else:
#             addr = "%s-%s" % (nice_hex(s), nice_hex(e))
#
#         print "%-11s ; %s" % (addr, txt)


    for start_addr, end_addr, comment in Dragon64MemInfo.MEM_INFO:
        comment = comment.replace('"', '\\"')
        comment = comment.replace('$', '\\$')
        print('\tcomment=0x%x,"%s" \\' % (
            start_addr, comment
        ))


    print("\n --- END --- \n")
