# Generated by Django 4.2.11 on 2024-03-27 18:01
from django.db import migrations
from django.db.migrations import RunPython
from edc_action_item.create_or_update_action_type import create_or_update_action_type
from edc_action_item.identifiers import ActionIdentifier
from edc_action_item.models import ActionItem, ActionType
from tqdm import tqdm

from effect_consent.action_items import ConsentUpdateV2Action


def create_consent_v2_action_items(apps, schema_editor):
    consent_model_cls = apps.get_model("effect_consent.subjectconsent")
    consent_qs = consent_model_cls.objects.all()
    total = consent_qs.count()

    eos_model_cls = apps.get_model("effect_prn.endofstudy")
    eos_qs = eos_model_cls.objects.all()

    create_or_update_action_type(apps=apps, **ConsentUpdateV2Action.as_dict())
    action_type = ActionType.objects.get(name=ConsentUpdateV2Action.name)

    print(f"Adding '{action_type.name}' to on-schedule subjects ...")
    print(f"\nProcessing {total} Subject Consent instances ...")
    for obj in tqdm(consent_qs, total=total):
        if eos_qs.filter(subject_identifier=obj.subject_identifier).exists():
            print(f" * Skipping '{obj.subject_identifier}'. Subject is off-study.")
        else:
            print(f" * Creating '{action_type.name}' for '{obj.subject_identifier}'.")
            action_identifier = ActionIdentifier(site_id=obj.site.id).identifier
            action_item = ActionItem(
                subject_identifier=obj.subject_identifier,
                action_identifier=action_identifier,
                action_type=action_type,
                site_id=obj.site.id,
            )
            action_item.save()
    print("Done.")


class Migration(migrations.Migration):

    dependencies = [
        ("effect_consent", "0021_alter_historicalsubjectconsent_first_name_and_more"),
    ]

    operations = [RunPython(create_consent_v2_action_items)]
