# Generated by Django 4.1.2 on 2022-10-17 22:26

import django.core.validators
from django.db import migrations, models
import edc_model.validators.date


class Migration(migrations.Migration):
    dependencies = [
        ("effect_screening", "0028_auto_20221009_1711"),
    ]

    operations = [
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="cd4_value",
            field=models.IntegerField(
                help_text="Eligible if CD4 count <100 cells/μL.",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(99),
                ],
                verbose_name="Most recent CD4 count",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="cm_in_csf",
            field=models.CharField(
                choices=[
                    ("Yes", "Yes"),
                    ("No", "No"),
                    ("PENDING", "Pending results"),
                    ("not_tested", "No further testing done"),
                    ("N/A", "Not applicable"),
                ],
                default="N/A",
                help_text="At any time between the CrAg test and screening for eligibility. <BR>If results on tests on CSF are `pending`, report on DAY 1 visit or when available.",
                max_length=25,
                verbose_name="Was CM confirmed in CSF by any other method?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="contraindicated_meds",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("not_evaluated", "Not evaluated")],
                default="not_evaluated",
                help_text="Refer to the protocol for a complete list.",
                max_length=25,
                verbose_name="Is the patient taking any contraindicated concomitant medications?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="lp_date",
            field=models.DateField(
                blank=True,
                help_text="LP should be done AFTER serum/plasma CrAg, but may be done no more than 3 days before the serum/plasma CrAg.",
                null=True,
                verbose_name="LP date",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="lp_done",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If YES, provide date below ...",
                max_length=15,
                null=True,
                verbose_name="Was LP done?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="prior_cm_episode",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("not_evaluated", "Not evaluated")],
                default="not_evaluated",
                max_length=25,
                verbose_name="Has the patient had a prior episode of CM or cryptococcal antigenaemia?",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="serum_crag_date",
            field=models.DateField(
                help_text="Test must have been performed within the last 14 days.",
                null=True,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="Serum/plasma CrAg sample collection date",
            ),
        ),
        migrations.AlterField(
            model_name="historicalsubjectscreening",
            name="unsuitable_for_study",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("not_evaluated", "Not evaluated")],
                default="not_evaluated",
                help_text="If YES, patient NOT eligible, please give reason below ...",
                max_length=15,
                verbose_name="Is there any other reason the patient is deemed to not be suitable for the study?",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="cd4_value",
            field=models.IntegerField(
                help_text="Eligible if CD4 count <100 cells/μL.",
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(99),
                ],
                verbose_name="Most recent CD4 count",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="cm_in_csf",
            field=models.CharField(
                choices=[
                    ("Yes", "Yes"),
                    ("No", "No"),
                    ("PENDING", "Pending results"),
                    ("not_tested", "No further testing done"),
                    ("N/A", "Not applicable"),
                ],
                default="N/A",
                help_text="At any time between the CrAg test and screening for eligibility. <BR>If results on tests on CSF are `pending`, report on DAY 1 visit or when available.",
                max_length=25,
                verbose_name="Was CM confirmed in CSF by any other method?",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="contraindicated_meds",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("not_evaluated", "Not evaluated")],
                default="not_evaluated",
                help_text="Refer to the protocol for a complete list.",
                max_length=25,
                verbose_name="Is the patient taking any contraindicated concomitant medications?",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="lp_date",
            field=models.DateField(
                blank=True,
                help_text="LP should be done AFTER serum/plasma CrAg, but may be done no more than 3 days before the serum/plasma CrAg.",
                null=True,
                verbose_name="LP date",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="lp_done",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No")],
                help_text="If YES, provide date below ...",
                max_length=15,
                null=True,
                verbose_name="Was LP done?",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="prior_cm_episode",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("not_evaluated", "Not evaluated")],
                default="not_evaluated",
                max_length=25,
                verbose_name="Has the patient had a prior episode of CM or cryptococcal antigenaemia?",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="serum_crag_date",
            field=models.DateField(
                help_text="Test must have been performed within the last 14 days.",
                null=True,
                validators=[edc_model.validators.date.date_not_future],
                verbose_name="Serum/plasma CrAg sample collection date",
            ),
        ),
        migrations.AlterField(
            model_name="subjectscreening",
            name="unsuitable_for_study",
            field=models.CharField(
                choices=[("Yes", "Yes"), ("No", "No"), ("not_evaluated", "Not evaluated")],
                default="not_evaluated",
                help_text="If YES, patient NOT eligible, please give reason below ...",
                max_length=15,
                verbose_name="Is there any other reason the patient is deemed to not be suitable for the study?",
            ),
        ),
    ]
