from typing import Any, ClassVar, Iterable, Iterator, List, Optional, Tuple, Union, Sequence

from typing import overload
import os

from . import (
    script as script,
    model as model,
    nwn1 as nwn1,
    kernel as kernel
)

OBJECT_INVALID: ObjectID


class CreatureColors:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    hair: ClassVar[CreatureColors] = ...
    skin: ClassVar[CreatureColors] = ...
    tatooo1: ClassVar[CreatureColors] = ...
    tatooo2: ClassVar[CreatureColors] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class CreatureAppearance:
    body_parts: BodyParts
    colors: List[int]
    id: int
    phenotype: int
    portrait_id: int
    tail: int
    wings: int


class Area(ObjectBase):
    json_archive_version: ClassVar[int] = ...  # read-only
    object_type: ClassVar[ObjectType] = ...  # read-only

    comments: str
    creator_id: int
    flags: AreaFlags
    height: int
    id: int
    listen_check_mod: int
    loadscreen: int
    name: LocString
    no_rest: int
    pvp: int
    shadow_opacity: int
    skybox: int
    spot_check_mod: int
    tileset_resref: str
    version: int
    weather: AreaWeather
    width: int
    def __init__(self) -> None: ...
    @property
    def creatures(self) -> Sequence[Creature]: ...
    @property
    def doors(self) -> List[Door]: ...
    @property
    def encounters(self) -> List[Encounter]: ...
    @property
    def items(self) -> List[Item]: ...
    @property
    def placeables(self) -> List[Placeable]: ...
    @property
    def scripts(self) -> AreaScripts: ...
    @property
    def sounds(self) -> List[Sound]: ...
    @property
    def stores(self) -> List[Store]: ...
    @property
    def tiles(self) -> List[Tile]: ...
    @property
    def triggers(self) -> List[Trigger]: ...
    @property
    def waypoints(self) -> List[Waypoint]: ...


class AreaFlags:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    interior: ClassVar[AreaFlags] = ...
    natural: ClassVar[AreaFlags] = ...
    none: ClassVar[AreaFlags] = ...
    underground: ClassVar[AreaFlags] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class AreaScripts:
    on_enter: str
    on_exit: str
    on_heartbeat: str
    on_user_defined: str
    def __init__(self) -> None: ...


class AreaWeather:
    chance_lightning: int
    chance_rain: int
    chance_snow: int
    color_moon_ambient: int
    color_moon_diffuse: int
    color_moon_fog: int
    color_sun_ambient: int
    color_sun_diffuse: int
    color_sun_fog: int
    day_night_cycle: int
    fog_clip_distance: float
    fog_moon_amount: int
    fog_sun_amount: int
    is_night: int
    lighting_scheme: int
    moon_shadows: int
    sun_shadows: int
    wind_power: int
    def __init__(self) -> None: ...


class AttackData:
    armor_class: int
    attack_bonus: int
    attack_roll: int
    attacker: Creature
    concealment: int
    is_ranged_attack: bool
    iteration_penalty: int
    multiplier: int
    nth_attack: int
    result: AttackResult
    target: ObjectBase
    target_is_creature: bool
    target_state: Any
    threat_range: int
    type: AttackType
    def __init__(self, *args, **kwargs) -> None: ...


class AttackResult:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    hit_by_auto_success: ClassVar[AttackResult] = ...
    hit_by_critical: ClassVar[AttackResult] = ...
    hit_by_roll: ClassVar[AttackResult] = ...
    miss_by_auto_fail: ClassVar[AttackResult] = ...
    miss_by_concealment: ClassVar[AttackResult] = ...
    miss_by_miss_chance: ClassVar[AttackResult] = ...
    miss_by_roll: ClassVar[AttackResult] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class BodyParts:
    belt: int
    bicep_left: int
    bicep_right: int
    foot_left: int
    foot_right: int
    forearm_left: int
    forearm_right: int
    hand_left: int
    hand_right: int
    head: int
    neck: int
    pelvis: int
    shin_left: int
    shin_right: int
    shoulder_left: int
    shoulder_right: int
    thigh_left: int
    thigh_right: int
    def __init__(self) -> None: ...


class ClassEntry:
    id: int
    level: int
    spells: Any
    def __init__(self, *args, **kwargs) -> None: ...


class ClassEntryVector:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: ClassEntryVector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x) -> None: ...
    def clear(self) -> None: ...
    @overload
    def extend(self, L: ClassEntryVector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x) -> None: ...
    def pop(self, *args, **kwargs) -> Any: ...
    def __bool__(self) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __getitem__(self, s: slice) -> ClassEntryVector: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    @overload
    def __setitem__(self, arg0: int, arg1) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: ClassEntryVector) -> None: ...


class CombatInfo:
    ac_armor_base: int
    ac_natural_bonus: int
    ac_shield_base: int
    combat_mode: Any
    size_ab_modifier: int
    size_ac_modifier: int
    target_state: Any
    def __init__(self, *args, **kwargs) -> None: ...


class Common:
    comment: str
    locals: Any
    location: Any
    name: LocString
    palette_id: int
    resref: str
    tag: str
    def __init__(self, *args, **kwargs) -> None: ...


class ResourceData:
    name: str
    bytes: bytes


class Container:
    def __init__(self, *args, **kwargs) -> None: ...
    def all(self) -> List[ResourceDescriptor]: ...
    @overload
    def contains(self, arg0: Resource) -> bool: ...
    @overload
    def contains(self, arg0: str) -> bool: ...
    @overload
    def demand(self, arg0: Resource) -> ResourceData: ...
    @overload
    def demand(self, arg0: str) -> ResourceData: ...
    def extract(self, arg0: str, arg1: os.PathLike) -> int: ...
    def extract_by_glob(self, arg0: str, arg1: os.PathLike) -> int: ...
    def name(self) -> str: ...
    def path(self) -> str: ...
    def size(self) -> int: ...
    def stat(self, arg0: Resource) -> ResourceDescriptor: ...
    def valid(self) -> bool: ...


class Creature(ObjectBase):
    json_archive_version: ClassVar[int] = ...  # read-only
    object_type: ClassVar[ObjectType] = ...  # read-only

    appearance: CreatureAppearance
    bodybag: int
    chunk_death: int
    common: Common
    conversation: str
    cr: float
    cr_adjust: int
    decay_time: int
    deity: str
    description: LocString
    disarmable: int
    faction_id: int
    gender: int
    good_evil: int
    hp: int
    hp_current: int
    hp_max: int
    immortal: int
    interruptable: int
    lawful_chaotic: int
    levels: LevelStats
    lootable: int
    name_first: LocString
    name_last: LocString
    pc: bool
    perception_range: int
    plot: bool
    race: int
    scripts: CreatureScripts
    soundset: int
    starting_package: int
    subrace: str
    walkrate: int

    def handle(self) -> ObjectHandle: ...
    def to_dict(self, arg0) -> dict: ...

    @staticmethod
    def from_dict(dictionary: dict) -> Creature: ...
    @staticmethod
    def from_file(path: str) -> Creature: ...

    @property
    def equipment(self) -> Equips: ...
    @property
    def history(self) -> LevelHistory: ...
    @property
    def inventory(self) -> Inventory: ...
    @property
    def stats(self) -> CreatureStats: ...


class CreatureScripts:
    on_attacked: str
    on_blocked: str
    on_conversation: str
    on_damaged: str
    on_death: str
    on_disturbed: str
    on_endround: str
    on_heartbeat: str
    on_perceived: str
    on_rested: str
    on_spawn: str
    on_spell_cast_at: str
    on_user_defined: str
    def __init__(self, *args, **kwargs) -> None: ...


class CreatureStats:
    def add_feat(self, feat: int) -> bool: ...
    def get_ability_score(self, ability: int) -> int: ...
    def get_skill_rank(self, skill: int) -> int: ...
    def has_feat(self, feat: int) -> bool: ...
    def remove_feat(self, feat: int): ...
    def set_ability_score(self, ability: int, value: int) -> bool: ...
    def set_skill_rank(self, skill: int, value: int) -> bool: ...
    @property
    def save_bonus(self) -> Saves: ...


class DialogNodeType:
    entry: ClassVar[int]
    reply: ClassVar[int]


class DialogAnimation:
    default: ClassVar[int]
    taunt: ClassVar[int]
    greeting: ClassVar[int]
    listen: ClassVar[int]
    worship: ClassVar[int]
    salute: ClassVar[int]
    bow: ClassVar[int]
    steal: ClassVar[int]
    talk_normal: ClassVar[int]
    talk_pleading: ClassVar[int]
    talk_forceful: ClassVar[int]
    talk_laugh: ClassVar[int]
    victory_1: ClassVar[int]
    victory_2: ClassVar[int]
    victory_3: ClassVar[int]
    look_far: ClassVar[int]
    drink: ClassVar[int]
    read: ClassVar[int]
    none: ClassVar[int]


class DialogPtr:
    parent: "Dialog"
    type: DialogNodeType
    node: "DialogNode"
    script_appears: str

    is_start: bool
    is_link: bool
    comment: str

    def add_ptr(self, ptr: "DialogPtr",
                is_link: bool = False) -> "DialogPtr": ...
    def add_string(self, value: str, lang: "LanguageID" = LanguageID.english,
                   feminine: bool = False) -> "DialogPtr": ...

    def add(self) -> "DialogPtr": ...
    def copy(self) -> "DialogPtr": ...
    def get_condition_param(self, key: str) -> Optional[str]: ...
    def remove_condition_param(self, key: str): ...
    def remove_ptr(self, ptr: "DialogPtr"): ...
    def set_condition_param(self, key: str, value: str): ...


class DialogNode:
    parent: "Dialog"
    type: DialogNodeType
    comment: str
    quest: str
    speaker: str
    quest_entry: int = -1
    script_action: str
    sound: str
    text: LocString
    animation: DialogAnimation
    delay: int = -1
    pointers: List[DialogPtr]

    def copy(self) -> "DialogNode": ...
    def get_action_param(self, key: str) -> Optional[str]: ...
    def remove_action_param(self, key: str): ...
    def set_action_param(self, key: str, value: str): ...


class Dialog:
    json_archive_version: ClassVar[int] = ...  # read-only
    restype: ClassVar[ObjectType] = ...  # read-only

    script_abort: str
    script_end: str
    delay_entry: int
    delay_reply: int
    word_count: int
    prevent_zoom: bool

    def __init__(self): ...
    def __len__(self) -> int: ...
    def __getitem__(self, index: int) -> DialogPtr: ...
    def add(self) -> DialogPtr: ...
    def add_ptr(self, ptr: DialogPtr,  is_link: bool = False) -> DialogPtr: ...
    def add_string(self, value: str, lang: LanguageID = LanguageID.english,
                   feminine: bool = False) -> DialogPtr: ...

    def delete_ptr(self, ptr: DialogPtr): ...
    def remove_ptr(self, ptr:  DialogPtr): ...
    def save(self, path: str): ...
    def valid(self) -> bool: ...

    @staticmethod
    def from_file(path: str) -> "Dialog": ...


class DiceRoll:
    bonus: int
    dice: int
    sides: int
    def __init__(self, *args, **kwargs) -> None: ...


class Directory(Container):
    def __init__(self, arg0: os.PathLike) -> None: ...


class Door(ObjectBase):
    json_archive_version: ClassVar[int] = ...  # read-only
    object_type: ClassVar[ObjectType] = ...  # read-only
    animation_state: DoorAnimationState
    appearance: int
    common: Common
    conversation: str
    description: LocString
    faction: int
    generic_type: int
    hardness: int
    hp: int
    hp_current: int
    interruptable: bool
    linked_to: str
    linked_to_flags: int
    loadscreen: int
    lock: Lock
    plot: bool
    portrait_id: int
    saves: Saves
    scripts: DoorScripts
    trap: Trap
    def from_dict(self, dictionary: dict) -> Any: ...
    def from_file(self, path: str) -> Any: ...
    def to_dict(self, arg0) -> dict: ...


class DoorAnimationState:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    closed: ClassVar[DoorAnimationState] = ...
    opened1: ClassVar[DoorAnimationState] = ...
    opened2: ClassVar[DoorAnimationState] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class DoorScripts:
    on_click: str
    on_closed: str
    on_damaged: str
    on_death: str
    on_disarm: str
    on_heartbeat: str
    on_lock: str
    on_melee_attacked: str
    on_open: str
    on_open_failure: str
    on_spell_cast_at: str
    on_trap_triggered: str
    on_unlock: str
    on_user_defined: str


class Effect:
    category: EffectCategory
    creator: ObjectHandle
    duration: float
    expire_day: int
    expire_time: int
    spell_id: int
    subtype: int
    type: int

    def __init__(self, *args, **kwargs) -> None: ...
    def clear(self) -> None: ...
    def get_float(self, arg0: int) -> float: ...
    def get_int(self, arg0: int) -> int: ...
    def get_string(self, arg0: int) -> str: ...
    def handle(self) -> EffectHandle: ...
    def id(self) -> EffectID: ...
    def set_float(self, arg0: int, arg1: float) -> None: ...
    def set_int(self, arg0: int, arg1: int) -> None: ...
    def set_string(self, arg0: int, arg1: str) -> None: ...
    def set_versus(self, arg0) -> None: ...
    def versus(self, *args, **kwargs) -> Any: ...


class EffectCategory:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    extraordinary: ClassVar[EffectCategory] = ...
    innate: ClassVar[EffectCategory] = ...
    item: ClassVar[EffectCategory] = ...
    magical: ClassVar[EffectCategory] = ...
    supernatural: ClassVar[EffectCategory] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class EffectHandle:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def category(self) -> EffectCategory: ...
    @property
    def creator(self) -> ObjectHandle: ...
    @property
    def effect(self) -> Any: ...
    @property
    def spell_id(self) -> int: ...
    @property
    def subtype(self) -> int: ...
    @property
    def type(self) -> int: ...


class EffectID:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def index(self) -> int: ...
    @property
    def version(self) -> int: ...


class Encounter(ObjectBase):
    json_archive_version: ClassVar[int] = ...  # read-only
    object_type: ClassVar[ObjectType] = ...  # read-only
    active: bool
    common: Common
    creatures: List[SpawnCreature]
    creatures_max: int
    creatures_recommended: int
    difficulty: int
    difficulty_index: int
    faction: int
    geometry: Vec3Vector
    player_only: bool
    reset: bool
    reset_time: int
    respawns: int
    spawn_option: int
    spawn_points: List[SpawnPoint]
    def __init__(self) -> None: ...
    def from_dict(self, *args, **kwargs) -> Any: ...
    def from_file(self, *args, **kwargs) -> Any: ...
    def to_dict(self, arg0) -> dict: ...
    @property
    def scripts(self) -> EncounterScripts: ...


class EncounterScripts:
    on_entered: str
    on_exhausted: str
    on_exit: str
    on_heartbeat: str
    on_user_defined: str
    def __init__(self, *args, **kwargs) -> None: ...


class EquipIndex:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    arms: ClassVar[EquipIndex] = ...
    arrows: ClassVar[EquipIndex] = ...
    belt: ClassVar[EquipIndex] = ...
    bolts: ClassVar[EquipIndex] = ...
    boots: ClassVar[EquipIndex] = ...
    bullets: ClassVar[EquipIndex] = ...
    chest: ClassVar[EquipIndex] = ...
    cloak: ClassVar[EquipIndex] = ...
    creature_bite: ClassVar[EquipIndex] = ...
    creature_left: ClassVar[EquipIndex] = ...
    creature_right: ClassVar[EquipIndex] = ...
    creature_skin: ClassVar[EquipIndex] = ...
    head: ClassVar[EquipIndex] = ...
    invalid: ClassVar[EquipIndex] = ...
    lefthand: ClassVar[EquipIndex] = ...
    leftring: ClassVar[EquipIndex] = ...
    neck: ClassVar[EquipIndex] = ...
    righthand: ClassVar[EquipIndex] = ...
    rightring: ClassVar[EquipIndex] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class EquipSlot:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    arms: ClassVar[EquipSlot] = ...
    arrows: ClassVar[EquipSlot] = ...
    belt: ClassVar[EquipSlot] = ...
    bolts: ClassVar[EquipSlot] = ...
    boots: ClassVar[EquipSlot] = ...
    bullets: ClassVar[EquipSlot] = ...
    chest: ClassVar[EquipSlot] = ...
    cloak: ClassVar[EquipSlot] = ...
    creature_bite: ClassVar[EquipSlot] = ...
    creature_left: ClassVar[EquipSlot] = ...
    creature_right: ClassVar[EquipSlot] = ...
    creature_skin: ClassVar[EquipSlot] = ...
    head: ClassVar[EquipSlot] = ...
    lefthand: ClassVar[EquipSlot] = ...
    leftring: ClassVar[EquipSlot] = ...
    neck: ClassVar[EquipSlot] = ...
    righthand: ClassVar[EquipSlot] = ...
    rightring: ClassVar[EquipSlot] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class Equips:
    def __init__(self, *args, **kwargs) -> None: ...
    def instantiate(self) -> bool: ...
    @property
    def equips(self) -> Any: ...


class Erf(Container):
    description: LocString
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: os.PathLike) -> None: ...
    def add(self, arg0: os.PathLike) -> bool: ...
    def erase(self, arg0: Resource) -> int: ...
    def merge(self, arg0: Container) -> bool: ...
    def reload(self) -> bool: ...
    def save(self) -> bool: ...
    def save_as(self, arg0: os.PathLike) -> bool: ...


class GameVersion:
    invalid: ClassVar[GameVersion] = ...
    v1_69: ClassVar[GameVersion] = ...
    vEE: ClassVar[GameVersion] = ...
    nwn2: ClassVar[GameVersion] = ...


class Image:
    def __init__(self, arg0: Path) -> None: ...
    def channels(self) -> int: ...
    def data(self) -> bytes: ...
    def height(self) -> int: ...
    def valid(self) -> bool: ...
    def width(self) -> int: ...
    def write_to(self, arg0: Path) -> bool: ...


class Ini:
    def __init__(self, arg0: Path) -> None: ...
    def get_float(self, arg0: str) -> Optional[float]: ...
    def get_int(self, arg0: str) -> Optional[int]: ...
    def get_str(self, arg0: str) -> Optional[str]: ...
    def valid(self) -> bool: ...


class InstallInfo:
    install: Path
    user: Path
    version: GameVersion
    def __init__(self, *args, **kwargs) -> None: ...


class Inventory:
    owner: ObjectBase

    def __len__(self) -> int: ...
    def instantiate(self) -> bool: ...
    @property
    def items(self) -> List[InventoryItem]: ...

    def add_item(self, item: "Item") -> bool: ...
    def add_page(self) -> bool: ...
    def can_add_item(self, item: "Item") -> bool: ...
    def debug(self) -> str: ...
    def items(self) -> List["Item"]: ...
    def remove_item(self, item: "Item") -> bool: ...
    def size(self) -> int: ...


class InventoryItem:
    infinite: bool
    item: Any
    x: int
    y: int


class Item(ObjectBase):
    json_archive_version: ClassVar[int] = ...  # read-only
    object_type: ClassVar[ObjectType] = ...  # read-only
    additional_cost: int
    baseitem: Any
    charges: int
    common: Common
    cost: int
    cursed: bool
    description: LocString
    description_id: LocString
    identified: bool
    model_colors: List[int[6]]
    model_parts: List[int[19]]
    model_type: ItemModelType
    plot: bool
    properties: List[ItemProperty]
    stacksize: int
    stolen: bool

    @staticmethod
    def from_dict(value: dict) -> Item: ...
    @staticmethod
    def from_file(path: str) -> Item: ...

    def to_dict(self, arg0) -> dict: ...

    @property
    def inventory(self) -> Inventory: ...

    def handle(self) -> ObjectHandle: ...
    def get_icon_by_part(
        self, part: ItemModelParts = ItemModelParts.model1,  female: bool = False) -> Image: ...

    def model_to_plt_colors(self) -> PltColors: ...


class ItemColors:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    cloth1: ClassVar[ItemColors] = ...
    cloth2: ClassVar[ItemColors] = ...
    leather1: ClassVar[ItemColors] = ...
    leather2: ClassVar[ItemColors] = ...
    metal1: ClassVar[ItemColors] = ...
    metal2: ClassVar[ItemColors] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class ItemModelParts:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    armor_belt: ClassVar[ItemModelParts] = ...
    armor_lbicep: ClassVar[ItemModelParts] = ...
    armor_lfarm: ClassVar[ItemModelParts] = ...
    armor_lfoot: ClassVar[ItemModelParts] = ...
    armor_lhand: ClassVar[ItemModelParts] = ...
    armor_lshin: ClassVar[ItemModelParts] = ...
    armor_lshoul: ClassVar[ItemModelParts] = ...
    armor_lthigh: ClassVar[ItemModelParts] = ...
    armor_neck: ClassVar[ItemModelParts] = ...
    armor_pelvis: ClassVar[ItemModelParts] = ...
    armor_rbicep: ClassVar[ItemModelParts] = ...
    armor_rfarm: ClassVar[ItemModelParts] = ...
    armor_rfoot: ClassVar[ItemModelParts] = ...
    armor_rhand: ClassVar[ItemModelParts] = ...
    armor_robe: ClassVar[ItemModelParts] = ...
    armor_rshin: ClassVar[ItemModelParts] = ...
    armor_rshoul: ClassVar[ItemModelParts] = ...
    armor_rthigh: ClassVar[ItemModelParts] = ...
    armor_torso: ClassVar[ItemModelParts] = ...
    model1: ClassVar[ItemModelParts] = ...
    model2: ClassVar[ItemModelParts] = ...
    model3: ClassVar[ItemModelParts] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class ItemModelType:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    armor: ClassVar[ItemModelType] = ...
    composite: ClassVar[ItemModelType] = ...
    layered: ClassVar[ItemModelType] = ...
    simple: ClassVar[ItemModelType] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class ItemProperty:
    cost_table: int
    cost_value: int
    param_table: int
    param_value: int
    subtype: int
    type: int
    def __init__(self, *args, **kwargs) -> None: ...


class Key(Container):
    def __init__(self, arg0: os.PathLike) -> None: ...


class Language:
    @staticmethod
    def encoding(language: LanguageID) -> str: ...
    @staticmethod
    def from_string(string: str) -> LanguageID: ...
    @staticmethod
    def has_feminine(language: LanguageID) -> bool: ...
    @staticmethod
    def to_base_id(id: int) -> Tuple[LanguageID, bool]: ...
    @staticmethod
    def to_runtime_id(language: LanguageID, feminine: bool = False) -> int: ...
    @staticmethod
    def to_string(language: LanguageID, long_name: bool = False) -> str: ...


class LanguageID:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    chinese_simplified: ClassVar[LanguageID] = ...
    chinese_traditional: ClassVar[LanguageID] = ...
    english: ClassVar[LanguageID] = ...
    french: ClassVar[LanguageID] = ...
    german: ClassVar[LanguageID] = ...
    italian: ClassVar[LanguageID] = ...
    japanese: ClassVar[LanguageID] = ...
    korean: ClassVar[LanguageID] = ...
    polish: ClassVar[LanguageID] = ...
    spanish: ClassVar[LanguageID] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class LevelHistory:
    entries: List[LevelUp]
    def __init__(self, *args, **kwargs) -> None: ...


class LevelStats:
    def __init__(self, *args, **kwargs) -> None: ...
    def level(self) -> int: ...
    def level_by_class(self, class_: int) -> int: ...
    @property
    def entries(self) -> List[ClassEntry[8]]: ...


class LevelUp:
    ability: int
    class_: int
    epic: bool
    feats: List[int]
    hitpoints: int
    known_spells: List[Tuple[int, int]]
    skillpoints: int
    skills: List[int]
    def __init__(self, *args, **kwargs) -> None: ...


class LocString:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: int) -> None: ...
    def add(self, language: LanguageID, string: str,
            feminine: bool = ...) -> bool: ...

    def from_dict(self, *args, **kwargs) -> Any: ...
    def get(self, language: LanguageID, feminine: bool = ...) -> str: ...
    def remove(self, language: LanguageID, feminine: bool = ...) -> None: ...
    def set_strref(self, strref: int) -> None: ...
    def size(self) -> int: ...
    def strref(self) -> int: ...
    def to_dict(self) -> dict: ...
    def __getitem__(self, arg0: LanguageID) -> str: ...


class LocalData:
    def __init__(self) -> None: ...
    def clear(self, varname: str, type: int) -> None: ...
    def clear_all(self, type: int): -> None: ...
    def delete_float(self, arg0: str) -> None: ...
    def delete_int(self, arg0: str) -> None: ...
    def delete_location(self, arg0: str) -> None: ...
    def delete_object(self, arg0: str) -> None: ...
    def delete_string(self, arg0: str) -> None: ...
    def get_float(self, arg0: str) -> float: ...
    def get_int(self, arg0: str) -> int: ...
    def get_location(self, *args, **kwargs) -> Any: ...
    def get_object(self, *args, **kwargs) -> Any: ...
    def get_string(self, arg0: str) -> str: ...
    def set_float(self, arg0: str, arg1: float) -> None: ...
    def set_int(self, arg0: str, arg1: int) -> None: ...
    def set_location(self, arg0: str, arg1) -> None: ...
    def set_object(self, arg0: str, arg1) -> None: ...
    def set_string(self, arg0: str, arg1: str) -> None: ...
    def size(self) -> int: ...


class Location:
    area: Any
    orientation: Any
    position: Any
    def __init__(self) -> None: ...


class Lock:
    key_name: str
    key_required: bool
    lock_dc: int
    lockable: bool
    locked: bool
    remove_key: bool
    unlock_dc: int
    def __init__(self, *args, **kwargs) -> None: ...


class Matrix4:
    m00: float
    m01: float
    m02: float
    m03: float
    m10: float
    m11: float
    m12: float
    m13: float
    m20: float
    m21: float
    m22: float
    m23: float
    m30: float
    m31: float
    m32: float
    m33: float
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float, arg3: float, arg4: float, arg5: float, arg6: float, arg7: float,
                 arg8: float, arg9: float, arg10: float, arg11: float, arg12: float, arg13: float, arg14: float, arg15: float) -> None: ...

    def copy(self) -> Matrix4: ...
    def from_orthographic(self, *args, **kwargs) -> Any: ...
    def from_perspective(self, *args, **kwargs) -> Any: ...
    def inverse(self) -> Matrix4: ...
    def mul_scalar(self, arg0: float) -> Matrix4: ...
    def project_point(self, arg0: Vector3) -> Vector3: ...
    def to_transform(self) -> Transform: ...
    def transform_point(self, arg0: Vector3) -> Vector3: ...
    def transform_vector(self, arg0: Vector3) -> Vector3: ...
    def transpose(self) -> Matrix4: ...
    def __add__(self, arg0: Matrix4) -> Matrix4: ...
    def __copy__(self) -> Matrix4: ...
    def __iadd__(self, arg0: Matrix4) -> None: ...
    def __isub__(self, arg0: Matrix4) -> None: ...
    def __mul__(self, arg0: Matrix4) -> Matrix4: ...
    def __sub__(self, arg0: Matrix4) -> Matrix4: ...


class Module(ObjectBase):
    json_archive_version: ClassVar[int] = ...  # read-only
    object_type: ClassVar[ObjectType] = ...  # read-only
    creator: int
    dawn_hour: int
    description: LocString
    dusk_hour: int
    entry_area: str
    entry_orientation: Any
    entry_position: Any
    expansion_pack: int
    haks: Sequence[str]
    id: bytes
    is_save_game: bool
    locals: LocalData
    min_game_version: str
    minutes_per_hour: int
    name: LocString
    scripts: ModuleScripts
    start_day: int
    start_hour: int
    start_month: int
    start_movie: str
    start_year: int
    tag: str
    tlk: str
    version: int
    xpscale: int
    def __init__(self) -> None: ...
    def area_count(self) -> int: ...
    def get_area(self, arg0: int) -> Area: ...
    def to_dict(self) -> dict: ...
    @property
    def uuid(self) -> str: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...


class ModuleScripts:
    on_client_enter: str
    on_client_leave: str
    on_cutsnabort: str
    on_heartbeat: str
    on_item_acquire: str
    on_item_activate: str
    on_item_unaquire: str
    on_load: str
    on_player_chat: str
    on_player_death: str
    on_player_dying: str
    on_player_equip: str
    on_player_level_up: str
    on_player_rest: str
    on_player_uneqiup: str
    on_spawnbtndn: str
    on_start: str
    on_user_defined: str


class NWSync:
    def __init__(self, arg0: os.PathLike) -> None: ...
    def get(self, *args, **kwargs) -> Any: ...
    def is_loaded(self) -> bool: ...
    def manifests(self) -> List[str]: ...
    def shard_count(self) -> int: ...


class NWSyncManifest(Container):
    def __init__(self, *args, **kwargs) -> None: ...


class ObjectBase:
    def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def as_common(self) -> Common: ...
    @overload
    def as_common(self) -> Common: ...
    def as_creature(self, *args, **kwargs) -> Any: ...
    def as_door(self, *args, **kwargs) -> Any: ...
    def as_encounter(self, *args, **kwargs) -> Any: ...
    def as_item(self, *args, **kwargs) -> Any: ...
    def as_module(self, *args, **kwargs) -> Any: ...
    def as_placeable(self, *args, **kwargs) -> Any: ...
    def as_sound(self, *args, **kwargs) -> Any: ...
    def as_trigger(self, *args, **kwargs) -> Any: ...
    def as_waypoint(self, *args, **kwargs) -> Any: ...
    def handle(self) -> ObjectHandle: ...
    def instantiate(self) -> bool: ...


class ObjectHandle:
    def __init__(self) -> None: ...
    def valid(self) -> bool: ...
    @property
    def id(self) -> ObjectID: ...
    @property
    def type(self) -> ObjectType: ...
    @property
    def version(self) -> int: ...


class ObjectID:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class ObjectType:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    area: ClassVar[ObjectType] = ...
    areaofeffect: ClassVar[ObjectType] = ...
    creature: ClassVar[ObjectType] = ...
    door: ClassVar[ObjectType] = ...
    encounter: ClassVar[ObjectType] = ...
    gui: ClassVar[ObjectType] = ...
    invalid: ClassVar[ObjectType] = ...
    item: ClassVar[ObjectType] = ...
    module: ClassVar[ObjectType] = ...
    placeable: ClassVar[ObjectType] = ...
    portal: ClassVar[ObjectType] = ...
    projectile: ClassVar[ObjectType] = ...
    sound: ClassVar[ObjectType] = ...
    store: ClassVar[ObjectType] = ...
    tile: ClassVar[ObjectType] = ...
    trigger: ClassVar[ObjectType] = ...
    waypoint: ClassVar[ObjectType] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class PaletteNodeType:
    branch = ClassVar[PaletteNodeType]
    category = ClassVar[PaletteNodeType]
    blueprint = ClassVar[PaletteNodeType]


class PaletteTreeNode:
    """A node in a palette"""

    def clear(self) -> None: ...
    def remove_node(self, node: "PaletteTreeNode") -> None: ...

    type: PaletteNodeType
    id: int
    display: int

    name: str
    strref: int

    resref: str
    cr: float
    faction: str
    children: List["PaletteTreeNode"]


class Palette:
    resource_type: "ResourceType"
    children: List[PaletteTreeNode]
    tileset: str

    def is_skeleton(self) -> bool: ...
    def save(self, path: str, format: str = "json") -> None: ...
    def to_dict(self) -> dict: ...
    def valid(self) -> bool: ...

    @staticmethod
    def from_dict(value: dict) -> Palette: ...

    @staticmethod
    def from_file(path: str) -> Palette: ...


class Path:
    def __init__(self, arg0: str) -> None: ...


class PathAlias:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    ambient: ClassVar[PathAlias] = ...
    cache: ClassVar[PathAlias] = ...
    currentgame: ClassVar[PathAlias] = ...
    database: ClassVar[PathAlias] = ...
    development: ClassVar[PathAlias] = ...
    dmvault: ClassVar[PathAlias] = ...
    hak: ClassVar[PathAlias] = ...
    hd0: ClassVar[PathAlias] = ...
    localvault: ClassVar[PathAlias] = ...
    logs: ClassVar[PathAlias] = ...
    modelcompiler: ClassVar[PathAlias] = ...
    modules: ClassVar[PathAlias] = ...
    movies: ClassVar[PathAlias] = ...
    music: ClassVar[PathAlias] = ...
    nwsync: ClassVar[PathAlias] = ...
    oldservervault: ClassVar[PathAlias] = ...
    override: ClassVar[PathAlias] = ...
    patch: ClassVar[PathAlias] = ...
    portraits: ClassVar[PathAlias] = ...
    saves: ClassVar[PathAlias] = ...
    screenshots: ClassVar[PathAlias] = ...
    servervault: ClassVar[PathAlias] = ...
    temp: ClassVar[PathAlias] = ...
    tempclient: ClassVar[PathAlias] = ...
    tlk: ClassVar[PathAlias] = ...
    user: ClassVar[PathAlias] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class Placeable(ObjectBase):
    json_archive_version: ClassVar[int] = ...  # read-only
    object_type: ClassVar[ObjectType] = ...  # read-only

    animation_state: PlaceableAnimationState
    appearance: int
    bodybag: int
    common: Common
    conversation: str
    description: LocString
    faction: int
    hardness: int
    has_inventory: bool
    hp: int
    hp_current: int
    interruptable: bool
    lock: Lock
    plot: bool
    portrait_id: int
    saves: Saves
    scripts: PlaceableScripts
    static: bool
    trap: Trap
    useable: bool

    def from_dict(self, *args, **kwargs) -> Any: ...
    def from_file(self, *args, **kwargs) -> Any: ...
    def to_dict(self, arg0) -> dict: ...

    @property
    def inventory(self) -> Inventory: ...


class PlaceableAnimationState:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    activated: ClassVar[PlaceableAnimationState] = ...
    closed: ClassVar[PlaceableAnimationState] = ...
    deactivated: ClassVar[PlaceableAnimationState] = ...
    destroyed: ClassVar[PlaceableAnimationState] = ...
    none: ClassVar[PlaceableAnimationState] = ...
    open: ClassVar[PlaceableAnimationState] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class PlaceableScripts:
    on_click: str
    on_closed: str
    on_damaged: str
    on_death: str
    on_disarm: str
    on_heartbeat: str
    on_inventory_disturbed: str
    on_lock: str
    on_melee_attacked: str
    on_open: str
    on_spell_cast_at: str
    on_trap_triggered: str
    on_unlock: str
    on_used: str
    on_user_defined: str
    def __init__(self, *args, **kwargs) -> None: ...


class Player(Creature):
    json_archive_version: ClassVar[int] = ...  # read-only
    object_type: ClassVar[ObjectType] = ...  # read-only
    def __init__(self, *args, **kwargs) -> None: ...
    def from_dict(self, *args, **kwargs) -> Any: ...
    def from_file(self, *args, **kwargs) -> Any: ...


class Plt:
    def __init__(self, arg0: Path) -> None: ...
    def height(self) -> int: ...
    def pixels(self) -> PltPixel: ...
    def valid(self) -> bool: ...
    def width(self) -> int: ...


class PltColors:
    def __init__(self) -> None: ...
    @property
    def colors(self) -> List[int[10]]: ...


class PltLayer:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    cloth1: ClassVar[PltLayer] = ...
    cloth2: ClassVar[PltLayer] = ...
    hair: ClassVar[PltLayer] = ...
    leather1: ClassVar[PltLayer] = ...
    leather2: ClassVar[PltLayer] = ...
    metal1: ClassVar[PltLayer] = ...
    metal2: ClassVar[PltLayer] = ...
    skin: ClassVar[PltLayer] = ...
    tattoo1: ClassVar[PltLayer] = ...
    tattoo2: ClassVar[PltLayer] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class PltPixel:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def color(self) -> int: ...
    @property
    def layer(self) -> PltLayer: ...


class Quaternion:
    w: float
    x: float
    y: float
    z: float
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, arg0: float, arg1: float,
                 arg2: float, arg3: float) -> None: ...

    def angle_axis(self) -> Tuple[float, Vector3]: ...
    def conjugate(self) -> Quaternion: ...
    def copy(self) -> Quaternion: ...
    def euler_angles(self) -> Vector3: ...
    def from_angle_axis(self, *args, **kwargs) -> Any: ...
    def from_euler_angles(self, *args, **kwargs) -> Any: ...
    def from_from_to_rotation(self, *args, **kwargs) -> Any: ...
    def from_look_rotation(self, *args, **kwargs) -> Any: ...
    def from_matrix3(self, *args, **kwargs) -> Any: ...
    def inverse(self) -> Quaternion: ...
    def length(self) -> float: ...
    def length_squared(self) -> float: ...
    def normalize(self) -> Quaternion: ...
    def normalize_self(self) -> None: ...
    def slerp(self, arg0: Quaternion, arg1: float) -> Quaternion: ...
    def to_matrix3(self) -> List[Vector3]: ...
    def to_matrix4(self, *args, **kwargs) -> Any: ...
    def transform_point(self, arg0: Vector3) -> Vector3: ...
    def transform_vector(self, arg0: Vector3) -> Vector3: ...
    def __copy__(self) -> Quaternion: ...
    def __imul__(self, arg0: Quaternion) -> Quaternion: ...
    def __mul__(self, arg0: Quaternion) -> Quaternion: ...


class Ray:
    direction: Vector3
    position: Vector3
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: Vector3, arg1: Vector3) -> None: ...
    def copy(self) -> Ray: ...
    def __copy__(self) -> Ray: ...


class Resource:
    resref: str
    type: ResourceType
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: str) -> None: ...
    @overload
    def __init__(self, arg0: str, arg1: ResourceType) -> None: ...
    def filename(self) -> str: ...
    def from_filename(self, *args, **kwargs) -> Any: ...
    def valid(self) -> bool: ...


class ResourceDescriptor:
    mtime: int
    name: Resource
    parent: Any
    size: int
    def __init__(self, *args, **kwargs) -> None: ...


class ResourceType:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    are: ClassVar[ResourceType] = ...
    bak: ClassVar[ResourceType] = ...
    bic: ClassVar[ResourceType] = ...
    bif: ClassVar[ResourceType] = ...
    bik: ClassVar[ResourceType] = ...
    bmp: ClassVar[ResourceType] = ...
    bmu: ClassVar[ResourceType] = ...
    btc: ClassVar[ResourceType] = ...
    btd: ClassVar[ResourceType] = ...
    bte: ClassVar[ResourceType] = ...
    btg: ClassVar[ResourceType] = ...
    bti: ClassVar[ResourceType] = ...
    btm: ClassVar[ResourceType] = ...
    btp: ClassVar[ResourceType] = ...
    bts: ClassVar[ResourceType] = ...
    btt: ClassVar[ResourceType] = ...
    caf: ClassVar[ResourceType] = ...
    ccs: ClassVar[ResourceType] = ...
    css: ClassVar[ResourceType] = ...
    dat: ClassVar[ResourceType] = ...
    dds: ClassVar[ResourceType] = ...
    dft: ClassVar[ResourceType] = ...
    dlg: ClassVar[ResourceType] = ...
    dwk: ClassVar[ResourceType] = ...
    erf: ClassVar[ResourceType] = ...
    fac: ClassVar[ResourceType] = ...
    fnt: ClassVar[ResourceType] = ...
    fourpc: ClassVar[ResourceType] = ...
    gff: ClassVar[ResourceType] = ...
    gic: ClassVar[ResourceType] = ...
    gif: ClassVar[ResourceType] = ...
    git: ClassVar[ResourceType] = ...
    gui: ClassVar[ResourceType] = ...
    hak: ClassVar[ResourceType] = ...
    ids: ClassVar[ResourceType] = ...
    ifo: ClassVar[ResourceType] = ...
    ini: ClassVar[ResourceType] = ...
    invalid: ClassVar[ResourceType] = ...
    itp: ClassVar[ResourceType] = ...
    jpg: ClassVar[ResourceType] = ...
    jrl: ClassVar[ResourceType] = ...
    key: ClassVar[ResourceType] = ...
    ktx: ClassVar[ResourceType] = ...
    lod: ClassVar[ResourceType] = ...
    ltr: ClassVar[ResourceType] = ...
    lua: ClassVar[ResourceType] = ...
    mdl: ClassVar[ResourceType] = ...
    mod: ClassVar[ResourceType] = ...
    mpg: ClassVar[ResourceType] = ...
    mtr: ClassVar[ResourceType] = ...
    mve: ClassVar[ResourceType] = ...
    ncs: ClassVar[ResourceType] = ...
    ndb: ClassVar[ResourceType] = ...
    nss: ClassVar[ResourceType] = ...
    nwm: ClassVar[ResourceType] = ...
    plh: ClassVar[ResourceType] = ...
    plt: ClassVar[ResourceType] = ...
    png: ClassVar[ResourceType] = ...
    ptm: ClassVar[ResourceType] = ...
    ptt: ClassVar[ResourceType] = ...
    pwk: ClassVar[ResourceType] = ...
    sav: ClassVar[ResourceType] = ...
    set: ClassVar[ResourceType] = ...
    shd: ClassVar[ResourceType] = ...
    slt: ClassVar[ResourceType] = ...
    sq3: ClassVar[ResourceType] = ...
    sql: ClassVar[ResourceType] = ...
    ssf: ClassVar[ResourceType] = ...
    tex: ClassVar[ResourceType] = ...
    tga: ClassVar[ResourceType] = ...
    thg: ClassVar[ResourceType] = ...
    tlk: ClassVar[ResourceType] = ...
    tml: ClassVar[ResourceType] = ...
    ttf: ClassVar[ResourceType] = ...
    twoda: ClassVar[ResourceType] = ...
    txi: ClassVar[ResourceType] = ...
    txt: ClassVar[ResourceType] = ...
    utc: ClassVar[ResourceType] = ...
    utd: ClassVar[ResourceType] = ...
    ute: ClassVar[ResourceType] = ...
    utg: ClassVar[ResourceType] = ...
    uti: ClassVar[ResourceType] = ...
    utm: ClassVar[ResourceType] = ...
    utp: ClassVar[ResourceType] = ...
    uts: ClassVar[ResourceType] = ...
    utt: ClassVar[ResourceType] = ...
    utw: ClassVar[ResourceType] = ...
    wav: ClassVar[ResourceType] = ...
    wbm: ClassVar[ResourceType] = ...
    wok: ClassVar[ResourceType] = ...
    xbc: ClassVar[ResourceType] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class ResourceVector:
    __hash__: ClassVar[None] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: ResourceVector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x) -> None: ...
    def clear(self) -> None: ...
    def count(self, x) -> int: ...
    @overload
    def extend(self, L: ResourceVector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x) -> None: ...
    def pop(self, *args, **kwargs) -> Any: ...
    def remove(self, x) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: ResourceVector) -> bool: ...
    def __getitem__(self, s: slice) -> ResourceVector: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: ResourceVector) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: ResourceVector) -> None: ...


class Saves:
    fort: int
    reflex: int
    will: int
    def __init__(self, *args, **kwargs) -> None: ...


class SerializationProfile:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    any: ClassVar[SerializationProfile] = ...
    blueprint: ClassVar[SerializationProfile] = ...
    instance: ClassVar[SerializationProfile] = ...
    savegame: ClassVar[SerializationProfile] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class Sound(ObjectBase):
    json_archive_version: ClassVar[int] = ...  # read-only
    object_type: ClassVar[ObjectType] = ...  # read-only
    active: bool
    common: Common
    continuous: bool
    distance_max: float
    distance_min: float
    elevation: float
    generated_type: int
    hours: int
    interval: int
    interval_variation: int
    looping: bool
    pitch_variation: float
    positional: bool
    priority: int
    random: bool
    random_position: bool
    random_x: float
    random_y: float
    sounds: List[str]
    times: int
    volume: int
    volume_variation: int
    def __init__(self) -> None: ...
    def from_dict(self, *args, **kwargs) -> Any: ...
    def from_file(self, *args, **kwargs) -> Any: ...
    def to_dict(self, arg0) -> dict: ...


class SpawnCreature:
    appearance: int
    cr: float
    resref: str
    single_spawn: bool
    def __init__(self, *args, **kwargs) -> None: ...


class SpawnPoint:
    orientation: float
    position: Any
    def __init__(self, *args, **kwargs) -> None: ...


class SpecialAbility:
    flags: Any
    level: int
    spell: int
    def __init__(self, *args, **kwargs) -> None: ...


class SpellBook:
    def __init__(self, *args, **kwargs) -> None: ...
    def add_known_spell(self, arg0: int, arg1: SpellEntry) -> bool: ...
    def add_memorized_spell(self, arg0: int, arg1: SpellEntry) -> bool: ...
    def get_known_spell(self, arg0: int, arg1: int) -> SpellEntry: ...
    def get_known_spell_count(self, arg0: int) -> int: ...
    def get_memorized_spell(self, arg0: int, arg1: int) -> SpellEntry: ...
    def get_memorized_spell_count(self, arg0: int) -> int: ...
    def remove_known_spell(self, arg0: int, arg1: SpellEntry) -> None: ...
    def remove_memorized_spell(self, arg0: int, arg1: SpellEntry) -> None: ...


class SpellEntry:
    flags: SpellFlags
    meta: SpellMetaMagic
    spell: int
    def __init__(self, *args, **kwargs) -> None: ...


class SpellFlags:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    none: ClassVar[SpellFlags] = ...
    readied: ClassVar[SpellFlags] = ...
    spontaneous: ClassVar[SpellFlags] = ...
    unlimited: ClassVar[SpellFlags] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class SpellMetaMagic:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    empower: ClassVar[SpellMetaMagic] = ...
    extend: ClassVar[SpellMetaMagic] = ...
    maximize: ClassVar[SpellMetaMagic] = ...
    none: ClassVar[SpellMetaMagic] = ...
    quicken: ClassVar[SpellMetaMagic] = ...
    silent: ClassVar[SpellMetaMagic] = ...
    still: ClassVar[SpellMetaMagic] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    def __setstate__(self, state: int) -> None: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...


class Store(ObjectBase):
    json_archive_version: ClassVar[int] = ...  # read-only
    object_type: ClassVar[ObjectType] = ...  # read-only
    blackmarket: bool
    blackmarket_markdown: int
    common: Common
    gold: int
    identify_price: int
    markdown: int
    markup: int
    max_price: int
    def __init__(self) -> None: ...
    def from_dict(self, *args, **kwargs) -> Any: ...
    def from_file(self, *args, **kwargs) -> Any: ...
    def to_dict(self, arg0) -> dict: ...
    @property
    def armor(self) -> Inventory: ...
    @property
    def miscellaneous(self) -> Inventory: ...
    @property
    def potions(self) -> Inventory: ...
    @property
    def rings(self) -> Inventory: ...
    @property
    def scripts(self) -> StoreScripts: ...
    @property
    def weapons(self) -> Inventory: ...


class StoreScripts:
    on_closed: str
    on_opened: str
    def __init__(self, *args, **kwargs) -> None: ...


class AreaTile:
    animloop1: int
    animloop2: int
    animloop3: int
    height: int
    id: int
    mainlight1: int
    mainlight2: int
    orientation: int
    srclight1: int
    srclight2: int


class Tlk:
    @overload
    def __init__(self, arg0: Path) -> None: ...
    @overload
    def __init__(self, arg0: LanguageID) -> None: ...
    def get(self, arg0: int) -> str: ...
    def language_id(self) -> LanguageID: ...
    def modified(self) -> bool: ...
    def save(self) -> None: ...
    def save_as(self, arg0: Path) -> None: ...
    def set(self, arg0: int, arg1: str) -> None: ...
    def size(self) -> int: ...
    def valid(self) -> bool: ...
    def __getitem__(self, arg0: int) -> str: ...
    def __len__(self) -> int: ...
    def __setitem__(self, arg0: int, arg1: str) -> None: ...


class Transform:
    rotation: Quaternion
    scale: Vector3
    translation: Vector3
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, arg0: Vector3, arg1: Quaternion,
                 arg2: Vector3) -> None: ...

    def copy(self) -> Transform: ...
    def inverse(self) -> Transform: ...
    def to_matrix4(self) -> Matrix4: ...
    def transform_point(self, arg0: Vector3) -> Vector3: ...
    def transform_vector(self, arg0: Vector3) -> Vector3: ...
    def __copy__(self) -> Transform: ...
    def __mul__(self, arg0: Transform) -> Transform: ...


class Trap:
    detect_dc: int
    detectable: bool
    disarm_dc: int
    disarmable: bool
    is_trapped: bool
    one_shot: bool
    type: int
    def __init__(self) -> None: ...


class Trigger(ObjectBase):
    json_archive_version: ClassVar[int] = ...  # read-only
    object_type: ClassVar[ObjectType] = ...  # read-only
    common: Common
    cursor: int
    faction: int
    geometry: List[Vector3]
    highlight_height: float
    linked_to: str
    linked_to_flags: int
    loadscreen: int
    portrait: int
    scripts: TriggerScripts
    trap: Trap
    type: int
    def __init__(self) -> None: ...
    def from_dict(self, *args, **kwargs) -> Any: ...
    def from_file(self, *args, **kwargs) -> Any: ...
    def to_dict(self, arg0) -> dict: ...


class TriggerScripts:
    on_click: str
    on_disarm: str
    on_enter: str
    on_exit: str
    on_heartbeat: str
    on_trap_triggered: str
    on_user_defined: str
    def __init__(self, *args, **kwargs) -> None: ...


class TwoDA:
    def __init__(self, path: Optional[Path]) -> None: ...
    def add_column(self, name: str) -> bool: ...
    def column_index(self, name: str) -> int: ...
    def column_names(self) -> List[str]: ...
    def columns(self) -> int: ...
    @overload
    def get(self, row: int, col: int) -> Union[int, float, str]: ...
    @overload
    def get(self, row: int, col: str) -> Union[int, float, str]: ...
    def get_raw(self, row: int, column: int) -> str: ...
    def pad(self, count: int) -> None: ...
    def rows(self) -> int: ...

    @overload
    def set(self, row: int, col: str,
            arg2: Union[int, float, str]) -> None: ...

    @overload
    def set(self, row: int, col: int,
            arg2: Union[int, float, str]) -> None: ...

    def valid(self) -> bool: ...

    @staticmethod
    def from_string(string: str) -> TwoDA: ...


class StaticTwoDA:
    def __init__(self, arg0: Path) -> None: ...
    def __getitem__(self, row: int) -> TwoDARowView: ...

    def column_index(self, name: str) -> int: ...
    def columns(self) -> int: ...
    @overload
    def get(self, row: int, arg1: int) -> Union[int, float, str]: ...
    @overload
    def get(self, row: int, arg1: str) -> Union[int, float, str]: ...
    def row(self, row: int) -> TwoDARowView: ...
    def rows(self) -> int: ...
    def valid(self) -> bool: ...

    @staticmethod
    def from_string(string: str) -> StaticTwoDA: ...


class TwoDARowView:
    def size(self) -> int: ...
    def __getitem__(self, col: int | str) -> Union[int, float, str]: ...


class Vector2:
    __hash__: ClassVar[None] = ...
    x: float
    y: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float) -> None: ...
    def copy(self) -> Vector2: ...
    def dot(self, arg0: Vector2) -> float: ...
    def length(self) -> float: ...
    def length_squared(self) -> float: ...
    def normalize(self) -> Vector2: ...
    def normalize_self(self) -> None: ...
    def __add__(self, arg0: Vector2) -> Vector2: ...
    def __copy__(self) -> Vector2: ...
    def __eq__(self, arg0: Vector2) -> bool: ...
    def __iadd__(self, arg0: Vector2) -> Vector2: ...
    def __imul__(self, arg0: float) -> Vector2: ...
    def __isub__(self, arg0: Vector2) -> Vector2: ...
    def __mul__(self, arg0: float) -> Vector2: ...
    def __neg__(self) -> Vector2: ...
    def __rmul__(self, arg0: float) -> Vector2: ...
    def __sub__(self, arg0: Vector2) -> Vector2: ...


class Vector3:
    __hash__: ClassVar[None] = ...
    x: float
    y: float
    z: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float) -> None: ...
    def copy(self) -> Vector3: ...
    def cross(self, arg0: Vector3) -> Vector3: ...
    def dot(self, arg0: Vector3) -> float: ...
    def length(self) -> float: ...
    def length_squared(self) -> float: ...
    def normalize(self) -> Vector3: ...
    def normalize_self(self) -> None: ...
    def __add__(self, arg0: Vector3) -> Vector3: ...
    def __copy__(self) -> Vector3: ...
    def __eq__(self, arg0: Vector3) -> bool: ...
    def __iadd__(self, arg0: Vector3) -> Vector3: ...
    def __imul__(self, arg0: float) -> Vector3: ...
    def __isub__(self, arg0: Vector3) -> Vector3: ...
    def __mul__(self, arg0: float) -> Vector3: ...
    def __neg__(self) -> Vector3: ...
    def __rmul__(self, arg0: float) -> Vector3: ...
    def __sub__(self, arg0: Vector3) -> Vector3: ...


class Vector4:
    __hash__: ClassVar[None] = ...
    w: float
    x: float
    y: float
    z: float
    @overload
    def __init__(self) -> None: ...

    @overload
    def __init__(self, arg0: float, arg1: float,
                 arg2: float, arg3: float) -> None: ...

    def copy(self) -> Vector4: ...
    def dot(self, arg0: Vector4) -> float: ...
    def length(self) -> float: ...
    def length_squared(self) -> float: ...
    def normalize(self) -> Vector4: ...
    def normalize_self(self) -> None: ...
    def __add__(self, arg0: Vector4) -> Vector4: ...
    def __copy__(self) -> Vector4: ...
    def __eq__(self, arg0: Vector4) -> bool: ...
    def __iadd__(self, arg0: Vector4) -> Vector4: ...
    def __imul__(self, arg0: float) -> Vector4: ...
    def __isub__(self, arg0: Vector4) -> Vector4: ...
    def __mul__(self, arg0: float) -> Vector4: ...
    def __neg__(self) -> Vector4: ...
    def __rmul__(self, arg0: float) -> Vector4: ...
    def __sub__(self, arg0: Vector4) -> Vector4: ...


class VertexVector:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VertexVector) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x) -> None: ...
    def clear(self) -> None: ...
    @overload
    def extend(self, L: VertexVector) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x) -> None: ...
    def pop(self, *args, **kwargs) -> Any: ...
    def __bool__(self) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __getitem__(self, s: slice) -> VertexVector: ...
    def __iter__(self) -> Iterator: ...
    def __len__(self) -> int: ...
    @overload
    def __setitem__(self, arg0: int, arg1) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VertexVector) -> None: ...


class Waypoint(ObjectBase):
    json_archive_version: ClassVar[int] = ...  # read-only
    object_type: ClassVar[ObjectType] = ...  # read-only

    appearance: int
    common: Common
    description: LocString
    has_map_note: bool
    linked_to: str
    map_note: LocString
    map_note_enabled: bool

    def to_dict(self, arg0) -> dict: ...

    @staticmethod
    def from_dict(dictionary: dict) -> Waypoint: ...
    @staticmethod
    def from_file(path: str) -> Waypoint: ...


class Zip(Container):
    def __init__(self, arg0: os.PathLike) -> None: ...


def decode_plt_color(plt: Plt, colors: PltColors, x: int, y: int) -> int: ...
def probe_nwn_install(only: GameVersion = ...) -> InstallInfo: ...
def resmatch(arg0, arg1: str) -> bool: ...
def resource_type_to_string(arg0) -> str: ...
