"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsMarketplaceManagement = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [aws-marketplace-management](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacemanagementportal.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class AwsMarketplaceManagement extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [aws-marketplace-management](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacemanagementportal.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'aws-marketplace-management';
        this.accessLevelList = {
            Write: [
                'uploadFiles'
            ],
            List: [
                'viewMarketing',
                'viewReports',
                'viewSettings',
                'viewSupport'
            ]
        };
    }
    /**
     * Allows access to the File Upload page inside the AWS Marketplace Management Portal.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toUploadFiles() {
        return this.to('uploadFiles');
    }
    /**
     * Allows access to the Marketing page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toViewMarketing() {
        return this.to('viewMarketing');
    }
    /**
     * Allows access to the Reports page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toViewReports() {
        return this.to('viewReports');
    }
    /**
     * Allows access to the Settings page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toViewSettings() {
        return this.to('viewSettings');
    }
    /**
     * Allows access to the Customer Support Eligibility page inside the AWS Marketplace Management Portal.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/marketplace/latest/userguide/detailed-management-portal-permissions.html#seller-ammp-permissions
     */
    toViewSupport() {
        return this.to('viewSupport');
    }
}
exports.AwsMarketplaceManagement = AwsMarketplaceManagement;
_a = JSII_RTTI_SYMBOL_1;
AwsMarketplaceManagement[_a] = { fqn: "cdk-iam-floyd.AwsMarketplaceManagement", version: "0.333.0" };
//# sourceMappingURL=data:application/json;base64,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