"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsMarketplaceMeteringService = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [aws-marketplace-metering-service](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacemeteringservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class AwsMarketplaceMeteringService extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [aws-marketplace-metering-service](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplacemeteringservice.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'aws-marketplace';
        this.accessLevelList = {
            Write: [
                'BatchMeterUsage',
                'MeterUsage',
                'RegisterUsage',
                'ResolveCustomer'
            ]
        };
    }
    /**
     * Grants permission to post metering records for a set of customers for SaaS applications
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_BatchMeterUsage.html
     */
    toBatchMeterUsage() {
        return this.to('BatchMeterUsage');
    }
    /**
     * Grants permission to emit metering records
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_MeterUsage.html
     */
    toMeterUsage() {
        return this.to('MeterUsage');
    }
    /**
     * Grants permission to to verify that the customer running your paid software is subscribed to your product on AWS Marketplace, enabling you to guard against unauthorized use. Meters software use per ECS task, per hour, with usage prorated to the second
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_RegisterUsage.html
     */
    toRegisterUsage() {
        return this.to('RegisterUsage');
    }
    /**
     * Grants permission to resolve a registration token to obtain a CustomerIdentifier and product code
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplacemetering/latest/APIReference/API_ResolveCustomer.html
     */
    toResolveCustomer() {
        return this.to('ResolveCustomer');
    }
}
exports.AwsMarketplaceMeteringService = AwsMarketplaceMeteringService;
_a = JSII_RTTI_SYMBOL_1;
AwsMarketplaceMeteringService[_a] = { fqn: "cdk-iam-floyd.AwsMarketplaceMeteringService", version: "0.333.0" };
//# sourceMappingURL=data:application/json;base64,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