"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsMarketplaceProcurementSystemsIntegration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [aws-marketplace-procurement-systems-integration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplaceprocurementsystemsintegration.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class AwsMarketplaceProcurementSystemsIntegration extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [aws-marketplace-procurement-systems-integration](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsmarketplaceprocurementsystemsintegration.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'aws-marketplace';
        this.accessLevelList = {
            Read: [
                'DescribeProcurementSystemConfiguration'
            ],
            Write: [
                'PutProcurementSystemConfiguration'
            ]
        };
    }
    /**
     * Describes the Procurement System integration configuration (e.g. Coupa) for the individual account, or for the entire AWS Organization if one exists. This action can only be performed by the master account if using an AWS Organization.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/procurement-systems-integration.html
     */
    toDescribeProcurementSystemConfiguration() {
        return this.to('DescribeProcurementSystemConfiguration');
    }
    /**
     * Creates or updates the Procurement System integration configuration (e.g. Coupa) for the individual account, or for the entire AWS Organization if one exists. This action can only be performed by the master account if using an AWS Organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/marketplace/latest/buyerguide/procurement-systems-integration.html
     */
    toPutProcurementSystemConfiguration() {
        return this.to('PutProcurementSystemConfiguration');
    }
}
exports.AwsMarketplaceProcurementSystemsIntegration = AwsMarketplaceProcurementSystemsIntegration;
_a = JSII_RTTI_SYMBOL_1;
AwsMarketplaceProcurementSystemsIntegration[_a] = { fqn: "cdk-iam-floyd.AwsMarketplaceProcurementSystemsIntegration", version: "0.333.0" };
//# sourceMappingURL=data:application/json;base64,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