"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mechanicalturk = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [mechanicalturk](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmechanicalturk.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Mechanicalturk extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [mechanicalturk](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonmechanicalturk.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'mechanicalturk';
        this.accessLevelList = {
            Write: [
                'AcceptQualificationRequest',
                'ApproveAssignment',
                'AssociateQualificationWithWorker',
                'CreateAdditionalAssignmentsForHIT',
                'CreateHIT',
                'CreateHITType',
                'CreateHITWithHITType',
                'CreateQualificationType',
                'CreateWorkerBlock',
                'DeleteHIT',
                'DeleteQualificationType',
                'DeleteWorkerBlock',
                'DisassociateQualificationFromWorker',
                'NotifyWorkers',
                'RejectAssignment',
                'RejectQualificationRequest',
                'SendBonus',
                'SendTestEventNotification',
                'UpdateExpirationForHIT',
                'UpdateHITReviewStatus',
                'UpdateHITTypeOfHIT',
                'UpdateNotificationSettings',
                'UpdateQualificationType'
            ],
            Read: [
                'GetAccountBalance',
                'GetAssignment',
                'GetFileUploadURL',
                'GetHIT',
                'GetQualificationScore',
                'GetQualificationType'
            ],
            List: [
                'ListAssignmentsForHIT',
                'ListBonusPayments',
                'ListHITs',
                'ListHITsForQualificationType',
                'ListQualificationRequests',
                'ListQualificationTypes',
                'ListReviewPolicyResultsForHIT',
                'ListReviewableHITs',
                'ListWorkerBlocks',
                'ListWorkersWithQualificationType'
            ]
        };
    }
    /**
     * The AcceptQualificationRequest operation grants a Worker's request for a Qualification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_AcceptQualificationRequestOperation.html
     */
    toAcceptQualificationRequest() {
        return this.to('AcceptQualificationRequest');
    }
    /**
     * The ApproveAssignment operation approves the results of a completed assignment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ApproveAssignmentOperation.html
     */
    toApproveAssignment() {
        return this.to('ApproveAssignment');
    }
    /**
     * The AssociateQualificationWithWorker operation gives a Worker a Qualification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_AssociateQualificationWithWorkerOperation.html
     */
    toAssociateQualificationWithWorker() {
        return this.to('AssociateQualificationWithWorker');
    }
    /**
     * The CreateAdditionalAssignmentsForHIT operation increases the maximum number of assignments of an existing HIT
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateAdditionalAssignmentsForHITOperation.html
     */
    toCreateAdditionalAssignmentsForHIT() {
        return this.to('CreateAdditionalAssignmentsForHIT');
    }
    /**
     * The CreateHIT operation creates a new HIT (Human Intelligence Task)
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITOperation.html
     */
    toCreateHIT() {
        return this.to('CreateHIT');
    }
    /**
     * The CreateHITType operation creates a new HIT type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITTypeOperation.html
     */
    toCreateHITType() {
        return this.to('CreateHITType');
    }
    /**
     * The CreateHITWithHITType operation creates a new Human Intelligence Task (HIT) using an existing HITTypeID generated by the CreateHITType operation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateHITWithHITTypeOperation.html
     */
    toCreateHITWithHITType() {
        return this.to('CreateHITWithHITType');
    }
    /**
     * The CreateQualificationType operation creates a new Qualification type, which is represented by a QualificationType data structure
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateQualificationTypeOperation.html
     */
    toCreateQualificationType() {
        return this.to('CreateQualificationType');
    }
    /**
     * The CreateWorkerBlock operation allows you to prevent a Worker from working on your HITs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_CreateWorkerBlockOperation.html
     */
    toCreateWorkerBlock() {
        return this.to('CreateWorkerBlock');
    }
    /**
     * The DeleteHIT operation disposes of a HIT that is no longer needed
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteHITOperation.html
     */
    toDeleteHIT() {
        return this.to('DeleteHIT');
    }
    /**
     * The DeleteQualificationType disposes a Qualification type and disposes any HIT types that are associated with the Qualification type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteQualificationTypeOperation.html
     */
    toDeleteQualificationType() {
        return this.to('DeleteQualificationType');
    }
    /**
     * The DeleteWorkerBlock operation allows you to reinstate a blocked Worker to work on your HITs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DeleteWorkerBlockOperation.html
     */
    toDeleteWorkerBlock() {
        return this.to('DeleteWorkerBlock');
    }
    /**
     * The DisassociateQualificationFromWorker revokes a previously granted Qualification from a user
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_DisassociateQualificationFromWorkerOperation.html
     */
    toDisassociateQualificationFromWorker() {
        return this.to('DisassociateQualificationFromWorker');
    }
    /**
     * The GetAccountBalance operation retrieves the amount of money in your Amazon Mechanical Turk account
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetAccountBalanceOperation.html
     */
    toGetAccountBalance() {
        return this.to('GetAccountBalance');
    }
    /**
     * The GetAssignment retrieves an assignment with an AssignmentStatus value of Submitted, Approved, or Rejected, using the assignment's ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetAssignmentOperation.html
     */
    toGetAssignment() {
        return this.to('GetAssignment');
    }
    /**
     * The GetFileUploadURL operation generates and returns a temporary URL
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetFileUploadURLOperation.html
     */
    toGetFileUploadURL() {
        return this.to('GetFileUploadURL');
    }
    /**
     * The GetHIT operation retrieves the details of the specified HIT
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetHITOperation.html
     */
    toGetHIT() {
        return this.to('GetHIT');
    }
    /**
     * The GetQualificationScore operation returns the value of a Worker's Qualification for a given Qualification type
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetQualificationScoreOperation.html
     */
    toGetQualificationScore() {
        return this.to('GetQualificationScore');
    }
    /**
     * The GetQualificationType operation retrieves information about a Qualification type using its ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_GetQualificationTypeOperation.html
     */
    toGetQualificationType() {
        return this.to('GetQualificationType');
    }
    /**
     * The ListAssignmentsForHIT operation retrieves completed assignments for a HIT
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListAssignmentsForHITOperation.html
     */
    toListAssignmentsForHIT() {
        return this.to('ListAssignmentsForHIT');
    }
    /**
     * The ListBonusPayments operation retrieves the amounts of bonuses you have paid to Workers for a given HIT or assignment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListBonusPaymentsOperation.html
     */
    toListBonusPayments() {
        return this.to('ListBonusPayments');
    }
    /**
     * The ListHITs operation returns all of a Requester's HITs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListHITsOperation.html
     */
    toListHITs() {
        return this.to('ListHITs');
    }
    /**
     * The ListHITsForQualificationType operation returns the HITs that use the given QualififcationType for a QualificationRequirement
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListHITsForQualificationTypeOperation.html
     */
    toListHITsForQualificationType() {
        return this.to('ListHITsForQualificationType');
    }
    /**
     * The ListQualificationRequests operation retrieves requests for Qualifications of a particular Qualification type
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListQualificationRequestsOperation.html
     */
    toListQualificationRequests() {
        return this.to('ListQualificationRequests');
    }
    /**
     * The ListQualificationTypes operation searches for Qualification types using the specified search query, and returns a list of Qualification types
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListQualificationTypesOperation.html
     */
    toListQualificationTypes() {
        return this.to('ListQualificationTypes');
    }
    /**
     * The ListReviewPolicyResultsForHIT operation retrieves the computed results and the actions taken in the course of executing your Review Policies during a CreateHIT operation
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListReviewPolicyResultsForHITOperation.html
     */
    toListReviewPolicyResultsForHIT() {
        return this.to('ListReviewPolicyResultsForHIT');
    }
    /**
     * The ListReviewableHITs operation returns all of a Requester's HITs that have not been approved or rejected
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListReviewableHITsOperation.html
     */
    toListReviewableHITs() {
        return this.to('ListReviewableHITs');
    }
    /**
     * The ListWorkersBlocks operation retrieves a list of Workers who are blocked from working on your HITs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListWorkerBlocksOperation.html
     */
    toListWorkerBlocks() {
        return this.to('ListWorkerBlocks');
    }
    /**
     * The ListWorkersWithQualificationType operation returns all of the Workers with a given Qualification type
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_ListWorkersWithQualificationTypeOperation.html
     */
    toListWorkersWithQualificationType() {
        return this.to('ListWorkersWithQualificationType');
    }
    /**
     * The NotifyWorkers operation sends an email to one or more Workers that you specify with the Worker ID
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_NotifyWorkersOperation.html
     */
    toNotifyWorkers() {
        return this.to('NotifyWorkers');
    }
    /**
     * The RejectAssignment operation rejects the results of a completed assignment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_RejectAssignmentOperation.html
     */
    toRejectAssignment() {
        return this.to('RejectAssignment');
    }
    /**
     * The RejectQualificationRequest operation rejects a user's request for a Qualification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_RejectQualificationRequestOperation.html
     */
    toRejectQualificationRequest() {
        return this.to('RejectQualificationRequest');
    }
    /**
     * The SendBonus operation issues a payment of money from your account to a Worker
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_SendBonusOperation.html
     */
    toSendBonus() {
        return this.to('SendBonus');
    }
    /**
     * The SendTestEventNotification operation causes Amazon Mechanical Turk to send a notification message as if a HIT event occurred, according to the provided notification specification
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_SendTestEventNotificationOperation.html
     */
    toSendTestEventNotification() {
        return this.to('SendTestEventNotification');
    }
    /**
     * The UpdateExpirationForHIT operation allows you extend the expiration time of a HIT beyond is current expiration or expire a HIT immediately
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateExpirationForHITOperation.html
     */
    toUpdateExpirationForHIT() {
        return this.to('UpdateExpirationForHIT');
    }
    /**
     * The UpdateHITReviewStatus operation toggles the status of a HIT
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateHITReviewStatusOperation.html
     */
    toUpdateHITReviewStatus() {
        return this.to('UpdateHITReviewStatus');
    }
    /**
     * The UpdateHITTypeOfHIT operation allows you to change the HITType properties of a HIT
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateHITTypeOfHITOperation.html
     */
    toUpdateHITTypeOfHIT() {
        return this.to('UpdateHITTypeOfHIT');
    }
    /**
     * The UpdateNotificationSettings operation creates, updates, disables or re-enables notifications for a HIT type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateNotificationSettingsOperation.html
     */
    toUpdateNotificationSettings() {
        return this.to('UpdateNotificationSettings');
    }
    /**
     * The UpdateQualificationType operation modifies the attributes of an existing Qualification type, which is represented by a QualificationType data structure
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/AWSMechTurk/latest/AWSMturkAPI/ApiReference_UpdateQualificationTypeOperation.html
     */
    toUpdateQualificationType() {
        return this.to('UpdateQualificationType');
    }
}
exports.Mechanicalturk = Mechanicalturk;
_a = JSII_RTTI_SYMBOL_1;
Mechanicalturk[_a] = { fqn: "cdk-iam-floyd.Mechanicalturk", version: "0.333.0" };
//# sourceMappingURL=data:application/json;base64,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