/*
 * Decompiled with CFR 0.152.
 */
package io.ray.shaded.com.google.common.collect;

import io.ray.shaded.com.google.common.annotations.GwtIncompatible;
import io.ray.shaded.com.google.common.collect.Range;
import io.ray.shaded.com.google.common.collect.RangeSet;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtIncompatible
abstract class AbstractRangeSet<C extends Comparable>
implements RangeSet<C> {
    AbstractRangeSet() {
    }

    @Override
    public boolean contains(C value) {
        return this.rangeContaining(value) != null;
    }

    @Override
    public abstract Range<C> rangeContaining(C var1);

    @Override
    public boolean isEmpty() {
        return this.asRanges().isEmpty();
    }

    @Override
    public void add(Range<C> range) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(Range<C> range) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.remove(Range.all());
    }

    @Override
    public boolean enclosesAll(RangeSet<C> other) {
        return this.enclosesAll(other.asRanges());
    }

    @Override
    public boolean enclosesAll(Iterable<Range<C>> ranges) {
        for (Range<C> range : ranges) {
            if (this.encloses(range)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addAll(RangeSet<C> other) {
        this.addAll(other.asRanges());
    }

    @Override
    public void addAll(Iterable<Range<C>> ranges) {
        for (Range<C> range : ranges) {
            this.add(range);
        }
    }

    @Override
    public void removeAll(RangeSet<C> other) {
        this.removeAll(other.asRanges());
    }

    @Override
    public void removeAll(Iterable<Range<C>> ranges) {
        for (Range<C> range : ranges) {
            this.remove(range);
        }
    }

    @Override
    public boolean intersects(Range<C> otherRange) {
        return !this.subRangeSet(otherRange).isEmpty();
    }

    @Override
    public abstract boolean encloses(Range<C> var1);

    @Override
    public boolean equals(@NullableDecl Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RangeSet) {
            RangeSet other = (RangeSet)obj;
            return this.asRanges().equals(other.asRanges());
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return this.asRanges().hashCode();
    }

    @Override
    public final String toString() {
        return this.asRanges().toString();
    }
}

