import datetime

from typing import \
    Any, Container, List, Type, Callable, Tuple, Union, ContextManager, \
    Pattern, Optional, Iterable

class AssertRaisesContext:
    exception = ...  # type: Type[BaseException]
    msg = ...  # type: Optional[str]
    def __init__(self, exception: Type[BaseException], msg: Optional[str] = ...) -> None: ...
    def __enter__(self) -> AssertRaisesContext: ...
    def __exit__(self, exc_type: Type[BaseException], exc_val: BaseException, exc_tb: Any) -> None: ...
    def add_test(self, cb: Callable[[BaseException], None]) -> None: ...

def fail(msg: Optional[str] = ...) -> None: ...
def assert_true(expr: Any, msg: Optional[str] = ...) -> None: ...
def assert_false(expr: Any, msg: Optional[str] = ...) -> None: ...
def assert_boolean_true(expr: Any, msg: Optional[str] = ...) -> None: ...
def assert_boolean_false(expr: Any, msg: Optional[str] = ...) -> None: ...
def assert_is_none(expr: Any, msg: Optional[str] = ...) -> None: ...
def assert_is_not_none(expr: Any, msg: Optional[str] = ...) -> None: ...
def assert_equal(first: Any, second: Any, msg: Optional[str] = ...) -> None: ...
def assert_not_equal(first: Any, second: Any, msg: Optional[str] = ...) -> None: ...
def assert_almost_equal(first: float, second: float, places: int = ..., msg: Optional[str] = ..., delta: float = ...) -> None: ...
def assert_less(first: Any, second: Any, msg: Optional[str] = ...) -> None: ...
def assert_less_equal(first: Any, second: Any, msg: Optional[str] = ...) -> None: ...
def assert_greater(first: Any, second: Any, msg: Optional[str] = ...) -> None: ...
def assert_greater_equal(first: Any, second: Any, msg: Optional[str] = ...) -> None: ...
def assert_regex(text: str, regex: Union[str, Pattern[str]], msg: Optional[str] = ...) -> None: ...
def assert_is(first: Any, second: Any, msg: Optional[str] = ...) -> None: ...
def assert_is_not(first: Any, second: Any, msg: Optional[str] = ...) -> None: ...
def assert_in(first: Any, second: Container[Any], msg: Optional[str] = ...) -> None: ...
def assert_not_in(first: Any, second: Container[Any], msg: Optional[str] = ...) -> None: ...
def assert_between(lower_bound: Any, upper_bound: Any, expr: Any, msg: Optional[str] = ...) -> None: ...
def assert_is_instance(obj: Any, cls: Union[type, Tuple[type, ...]], msg: Optional[str] = ...) -> None: ...
def assert_not_is_instance(obj: Any, cls: Union[type, Tuple[type, ...]], msg: Optional[str] = ...) -> None: ...
def assert_count_equal(sequence1: Iterable[Any], sequence2: Iterable[Any]) -> None: ...
def assert_has_attr(obj: Any, attribute: str, msg: Optional[str] = ...) -> None: ...
def assert_datetime_about_now(actual: Optional[datetime.datetime], msg: Optional[str] = ...) -> None: ...
def assert_datetime_about_now_utc(actual: Optional[datetime.datetime], msg: Optional[str] = ...) -> None: ...
def assert_raises(exception: Type[BaseException], msg: Optional[str] = ...) -> AssertRaisesContext: ...
def assert_raises_regex(exception: Type[BaseException], regex:  str, msg: Optional[str] = ...) -> AssertRaisesContext: ...
def assert_raises_errno(exception: Type[BaseException], errno: int, msg: Optional[str] = ...) -> AssertRaisesContext: ...
def assert_succeeds(exception: Type[BaseException], msg: Optional[str] = ...) -> ContextManager: ...
