# Sarmat.

Библиотека для построения решений в сфере пассажирского транспорта.

Основу работы библиотеки составляют объекты для построения рейсов
и шаблонов для них, выполнения диспетчерских операций,
и управления автотранспортом.

## Состав библиотеки

Библиотека состоит из набора тематических модулей, у каждого из которых своя область
применения:

* Сущности для описания справочников
* Сущности для построения рейсов и маршрутов
* Сущности для описания работы транспортной компании.

## Композиция объектов

Каждый из тематических объектов представлен в виде композиции классов.

### Модели и контейнеры

Модель содержит набор атрибутов, присущих объекту класса, 
а также методы создания модели на основе контейнера. Реализована вложенность
моделей. В том числе для описания иерархической модели справочников. Каждая модель
является фабрикой для создания объектов своего типа. Фабричный метод принимает
на вход аргумент, который имеет тип соответствующего контейнера.
Контейнеры также могут быть вложенными.

Контейнеры повторяют набор атрибутов, описанных в модели. Контейнеры предназначены
для получения атрибутов извне и правильного создания модели 
на основе полученных данных. Контейнеры написаны на основе классов `pydantic`.

### Верификация объектов

Основные правила верификации объектов описаны в контейнерах. Все случаи проверки,
которые являются частью бизнес-логики, описаны в специальных классах верификаторах.
Эти классы задействуются перед созданием модели из контейнера. Верификацию
проходят **контейнеры**. Объекты верификации содержат рбязательный метод `verify`,
в котором реализована логика проверки. Верификаторы могут быть вложенными. В этом
случае процесс проверки будет идти от дочернего верификатора к родительскому.
Метод верификации не возвращает значений, но возбуздает исключения 
в случае нарушения правил проверки.

Базовый верификатор проверяет на непустоту указанных атрибутов. Есть возможность
создать верификатор на основе кастомного класса. В нем проверка происходит
на основе встроенного словаря. Ключами словаря могут выступать строковые константы,
а значениями - вызываемые объекты.

### Поведение объектов

Поведение объектов описано в поведенческих классах. Там реализован набор
простейших операций, упрощающих процесс прикладной разработки. Поведенческие
классы позволяют проводить сравнение двух объектов между собой (`==`, `!=`),
выполнять операции проверки на неравенство (`>`, `<`, `>=`, `<=`).
Для объектов, содержащих другие объекты, реализована проверка на вхождение
во множество (`in`). За это ответственны поведенческие классы сравнения. Базовым
поведенческим классом является класс `BhNoAction`, который можно использовать
для переопределения или дополнения модели поведения для того или иного класса
в рамках той или иной роли приложения.
К примеру, сотрудник с правами оператора системы может создавать рейсы и 
проводить с ними прочие операции редактирования. Другой сотрудник с правами
диспетчера может обрабатывать созданные рейсы, но не может их создавать. Для
описания этих различных моделей поведения необходимо создать два поведенческих класса
`Actor` и `Dispatcher`, первый из которых будет содержать методы CRUD для работы
с объектом, а втрой будет иметь набор методов работы с созданныим рейсами. Оба класса
регистрируются в фабрике классов под своими псевдонимами. Потом нужный псевдоним
указывается при вызове фабрики, и для каждой модели ищется соответствующий класс.
Если необходимо совместить для пользователя полномочия, то соответствующие
псевдонимы склеиваются. В качестве разделителя используется точка.

### Действия с объектами

Для объектов реализованы простейшие операции. Такие, как, например, копирование
объекта. Реализованы специфические операции для конкретных объектов.

## Сборка объектов

Сборкой объектов занимаются фабрики классов. Каждая тематическая фабрика обладает
набором методов, каждый из которых создает объект своего типа. Сборка объектов
производится вызовом `type` с последующей инициализацией полученного класса при
помощи данных, которые передаются в контейнере. В фабрике перечисляются
родительские классы, а также указываются дополнительные атрибуты для будущего
объекта: в атрибуте `controller` передается экземпляр фабрики для последующего
использования при создании объектов во время выполнения бизнесс процессов.
Также передается набор тегов доступа, которые были определены пользователю
изначально.
