"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosWebRule = exports.RosSchedulerRule = exports.RosSceneDefensePolicy = exports.RosProInstance = exports.RosPremiumInstance = exports.RosPort = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosPortProps`
 *
 * @param properties - the TypeScript properties of a `RosPortProps`
 *
 * @returns the result of the validation.
 */
function RosPortPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('backendPort', ros.validateString)(properties.backendPort));
    errors.collect(ros.propertyValidator('instanceId', ros.requiredValidator)(properties.instanceId));
    errors.collect(ros.propertyValidator('instanceId', ros.validateString)(properties.instanceId));
    errors.collect(ros.propertyValidator('realServers', ros.requiredValidator)(properties.realServers));
    if (properties.realServers && (Array.isArray(properties.realServers) || (typeof properties.realServers) === 'string')) {
        errors.collect(ros.propertyValidator('realServers', ros.validateLength)({
            data: properties.realServers.length,
            min: 0,
            max: 20,
        }));
    }
    errors.collect(ros.propertyValidator('realServers', ros.listValidator(ros.validateString))(properties.realServers));
    errors.collect(ros.propertyValidator('frontendPort', ros.validateString)(properties.frontendPort));
    errors.collect(ros.propertyValidator('frontendProtocol', ros.requiredValidator)(properties.frontendProtocol));
    if (properties.frontendProtocol && (typeof properties.frontendProtocol) !== 'object') {
        errors.collect(ros.propertyValidator('frontendProtocol', ros.validateAllowedValues)({
            data: properties.frontendProtocol,
            allowedValues: ["tcp", "udp"],
        }));
    }
    errors.collect(ros.propertyValidator('frontendProtocol', ros.validateString)(properties.frontendProtocol));
    return errors.wrap('supplied properties not correct for "RosPortProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::Port` resource
 *
 * @param properties - the TypeScript properties of a `RosPortProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::Port` resource.
 */
// @ts-ignore TS6133
function rosPortPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosPortPropsValidator(properties).assertSuccess();
    }
    return {
        'FrontendProtocol': ros.stringToRosTemplate(properties.frontendProtocol),
        'InstanceId': ros.stringToRosTemplate(properties.instanceId),
        'RealServers': ros.listMapper(ros.stringToRosTemplate)(properties.realServers),
        'BackendPort': ros.stringToRosTemplate(properties.backendPort),
        'FrontendPort': ros.stringToRosTemplate(properties.frontendPort),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::DDoSPro::Port`, which is used to create a port forwarding rule for an Anti-DDoS Proxy instance.
 * @Note This class does not contain additional functions, so it is recommended to use the `Port` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ddospro-port
 */
class RosPort extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosPort.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrFrontendPort = this.getAtt('FrontendPort');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.frontendProtocol = props.frontendProtocol;
        this.instanceId = props.instanceId;
        this.realServers = props.realServers;
        this.backendPort = props.backendPort;
        this.frontendPort = props.frontendPort;
    }
    get rosProperties() {
        return {
            frontendProtocol: this.frontendProtocol,
            instanceId: this.instanceId,
            realServers: this.realServers,
            backendPort: this.backendPort,
            frontendPort: this.frontendPort,
        };
    }
    renderProperties(props) {
        return rosPortPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosPort = RosPort;
/**
 * The resource type name for this resource class.
 */
RosPort.ROS_RESOURCE_TYPE_NAME = "ALIYUN::DDoSPro::Port";
/**
 * Determine whether the given properties match those of a `RosPremiumInstanceProps`
 *
 * @param properties - the TypeScript properties of a `RosPremiumInstanceProps`
 *
 * @returns the result of the validation.
 */
function RosPremiumInstancePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.normalQps && (typeof properties.normalQps) !== 'object') {
        errors.collect(ros.propertyValidator('normalQps', ros.validateRange)({
            data: properties.normalQps,
            min: 500,
            max: 100000,
        }));
    }
    errors.collect(ros.propertyValidator('normalQps', ros.validateNumber)(properties.normalQps));
    if (properties.normalBandwidth && (typeof properties.normalBandwidth) !== 'object') {
        errors.collect(ros.propertyValidator('normalBandwidth', ros.validateRange)({
            data: properties.normalBandwidth,
            min: 10,
            max: 300,
        }));
    }
    errors.collect(ros.propertyValidator('normalBandwidth', ros.validateNumber)(properties.normalBandwidth));
    if (properties.functionVersion && (typeof properties.functionVersion) !== 'object') {
        errors.collect(ros.propertyValidator('functionVersion', ros.validateAllowedValues)({
            data: properties.functionVersion,
            allowedValues: ["0", "1"],
        }));
    }
    errors.collect(ros.propertyValidator('functionVersion', ros.validateString)(properties.functionVersion));
    if (properties.productPlan && (typeof properties.productPlan) !== 'object') {
        errors.collect(ros.propertyValidator('productPlan', ros.validateAllowedValues)({
            data: properties.productPlan,
            allowedValues: ["0", "1", "2", "3"],
        }));
    }
    errors.collect(ros.propertyValidator('productPlan', ros.validateString)(properties.productPlan));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateAllowedValues)({
            data: properties.period,
            allowedValues: [1, 2, 3, 4, 5, 6, 12, 24],
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    if (properties.portCount && (typeof properties.portCount) !== 'object') {
        errors.collect(ros.propertyValidator('portCount', ros.validateRange)({
            data: properties.portCount,
            min: 5,
            max: 400,
        }));
    }
    errors.collect(ros.propertyValidator('portCount', ros.validateNumber)(properties.portCount));
    if (properties.tags && (Array.isArray(properties.tags) || (typeof properties.tags) === 'string')) {
        errors.collect(ros.propertyValidator('tags', ros.validateLength)({
            data: properties.tags.length,
            min: undefined,
            max: 20,
        }));
    }
    errors.collect(ros.propertyValidator('tags', ros.listValidator(RosPremiumInstance_TagsPropertyValidator))(properties.tags));
    if (properties.burstBandwidthMode && (typeof properties.burstBandwidthMode) !== 'object') {
        errors.collect(ros.propertyValidator('burstBandwidthMode', ros.validateAllowedValues)({
            data: properties.burstBandwidthMode,
            allowedValues: ["0", "1", "2"],
        }));
    }
    errors.collect(ros.propertyValidator('burstBandwidthMode', ros.validateString)(properties.burstBandwidthMode));
    if (properties.periodUnit && (typeof properties.periodUnit) !== 'object') {
        errors.collect(ros.propertyValidator('periodUnit', ros.validateAllowedValues)({
            data: properties.periodUnit,
            allowedValues: ["Month", "Year", "month", "year"],
        }));
    }
    errors.collect(ros.propertyValidator('periodUnit', ros.validateString)(properties.periodUnit));
    if (properties.domainCount && (typeof properties.domainCount) !== 'object') {
        errors.collect(ros.propertyValidator('domainCount', ros.validateRange)({
            data: properties.domainCount,
            min: 10,
            max: 200,
        }));
    }
    errors.collect(ros.propertyValidator('domainCount', ros.validateNumber)(properties.domainCount));
    return errors.wrap('supplied properties not correct for "RosPremiumInstanceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::PremiumInstance` resource
 *
 * @param properties - the TypeScript properties of a `RosPremiumInstanceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::PremiumInstance` resource.
 */
// @ts-ignore TS6133
function rosPremiumInstancePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosPremiumInstancePropsValidator(properties).assertSuccess();
    }
    return {
        'BurstBandwidthMode': ros.stringToRosTemplate(properties.burstBandwidthMode),
        'DomainCount': ros.numberToRosTemplate(properties.domainCount),
        'FunctionVersion': ros.stringToRosTemplate(properties.functionVersion),
        'NormalBandwidth': ros.numberToRosTemplate(properties.normalBandwidth),
        'NormalQps': ros.numberToRosTemplate(properties.normalQps),
        'Period': ros.numberToRosTemplate(properties.period),
        'PeriodUnit': ros.stringToRosTemplate(properties.periodUnit),
        'PortCount': ros.numberToRosTemplate(properties.portCount),
        'ProductPlan': ros.stringToRosTemplate(properties.productPlan),
        'Tags': ros.listMapper(rosPremiumInstanceTagsPropertyToRosTemplate)(properties.tags),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::DDoSPro::PremiumInstance`, which is used to create an Anti-DDoS Proxy (Outside Chinese Mainland) instance.
 * @Note This class does not contain additional functions, so it is recommended to use the `PremiumInstance` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ddospro-premiuminstance
 */
class RosPremiumInstance extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosPremiumInstance.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrInstanceId = this.getAtt('InstanceId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.burstBandwidthMode = props.burstBandwidthMode;
        this.domainCount = props.domainCount;
        this.functionVersion = props.functionVersion;
        this.normalBandwidth = props.normalBandwidth;
        this.normalQps = props.normalQps;
        this.period = props.period;
        this.periodUnit = props.periodUnit;
        this.portCount = props.portCount;
        this.productPlan = props.productPlan;
        this.tags = props.tags;
    }
    get rosProperties() {
        return {
            burstBandwidthMode: this.burstBandwidthMode,
            domainCount: this.domainCount,
            functionVersion: this.functionVersion,
            normalBandwidth: this.normalBandwidth,
            normalQps: this.normalQps,
            period: this.period,
            periodUnit: this.periodUnit,
            portCount: this.portCount,
            productPlan: this.productPlan,
            tags: this.tags,
        };
    }
    renderProperties(props) {
        return rosPremiumInstancePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosPremiumInstance = RosPremiumInstance;
/**
 * The resource type name for this resource class.
 */
RosPremiumInstance.ROS_RESOURCE_TYPE_NAME = "ALIYUN::DDoSPro::PremiumInstance";
/**
 * Determine whether the given properties match those of a `TagsProperty`
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the result of the validation.
 */
function RosPremiumInstance_TagsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('value', ros.validateString)(properties.value));
    errors.collect(ros.propertyValidator('key', ros.requiredValidator)(properties.key));
    errors.collect(ros.propertyValidator('key', ros.validateString)(properties.key));
    return errors.wrap('supplied properties not correct for "TagsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::PremiumInstance.Tags` resource
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::PremiumInstance.Tags` resource.
 */
// @ts-ignore TS6133
function rosPremiumInstanceTagsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosPremiumInstance_TagsPropertyValidator(properties).assertSuccess();
    return {
        'Value': ros.stringToRosTemplate(properties.value),
        'Key': ros.stringToRosTemplate(properties.key),
    };
}
/**
 * Determine whether the given properties match those of a `RosProInstanceProps`
 *
 * @param properties - the TypeScript properties of a `RosProInstanceProps`
 *
 * @returns the result of the validation.
 */
function RosProInstancePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    if (properties.normalQps && (typeof properties.normalQps) !== 'object') {
        errors.collect(ros.propertyValidator('normalQps', ros.validateRange)({
            data: properties.normalQps,
            min: 3000,
            max: 100000,
        }));
    }
    errors.collect(ros.propertyValidator('normalQps', ros.validateNumber)(properties.normalQps));
    if (properties.period && (typeof properties.period) !== 'object') {
        errors.collect(ros.propertyValidator('period', ros.validateAllowedValues)({
            data: properties.period,
            allowedValues: [1, 2, 3, 4, 5, 6, 12, 24],
        }));
    }
    errors.collect(ros.propertyValidator('period', ros.validateNumber)(properties.period));
    if (properties.portCount && (typeof properties.portCount) !== 'object') {
        errors.collect(ros.propertyValidator('portCount', ros.validateRange)({
            data: properties.portCount,
            min: 50,
            max: 400,
        }));
    }
    errors.collect(ros.propertyValidator('portCount', ros.validateNumber)(properties.portCount));
    errors.collect(ros.propertyValidator('edition', ros.validateString)(properties.edition));
    if (properties.burstBandwidthMode && (typeof properties.burstBandwidthMode) !== 'object') {
        errors.collect(ros.propertyValidator('burstBandwidthMode', ros.validateAllowedValues)({
            data: properties.burstBandwidthMode,
            allowedValues: ["0", "1", "2"],
        }));
    }
    errors.collect(ros.propertyValidator('burstBandwidthMode', ros.validateString)(properties.burstBandwidthMode));
    if (properties.serviceBandwidth && (typeof properties.serviceBandwidth) !== 'object') {
        errors.collect(ros.propertyValidator('serviceBandwidth', ros.validateRange)({
            data: properties.serviceBandwidth,
            min: 100,
            max: 5000,
        }));
    }
    errors.collect(ros.propertyValidator('serviceBandwidth', ros.validateNumber)(properties.serviceBandwidth));
    errors.collect(ros.propertyValidator('servicePartner', ros.validateString)(properties.servicePartner));
    if (properties.baseBandwidth && (typeof properties.baseBandwidth) !== 'object') {
        errors.collect(ros.propertyValidator('baseBandwidth', ros.validateAllowedValues)({
            data: properties.baseBandwidth,
            allowedValues: [30, 60, 100, 300, 400, 500, 600],
        }));
    }
    errors.collect(ros.propertyValidator('baseBandwidth', ros.validateNumber)(properties.baseBandwidth));
    if (properties.functionVersion && (typeof properties.functionVersion) !== 'object') {
        errors.collect(ros.propertyValidator('functionVersion', ros.validateAllowedValues)({
            data: properties.functionVersion,
            allowedValues: ["0", "1"],
        }));
    }
    errors.collect(ros.propertyValidator('functionVersion', ros.validateString)(properties.functionVersion));
    errors.collect(ros.propertyValidator('bandwidth', ros.validateNumber)(properties.bandwidth));
    if (properties.addressType && (typeof properties.addressType) !== 'object') {
        errors.collect(ros.propertyValidator('addressType', ros.validateAllowedValues)({
            data: properties.addressType,
            allowedValues: ["Ipv4", "Ipv6"],
        }));
    }
    errors.collect(ros.propertyValidator('addressType', ros.validateString)(properties.addressType));
    if (properties.tags && (Array.isArray(properties.tags) || (typeof properties.tags) === 'string')) {
        errors.collect(ros.propertyValidator('tags', ros.validateLength)({
            data: properties.tags.length,
            min: undefined,
            max: 20,
        }));
    }
    errors.collect(ros.propertyValidator('tags', ros.listValidator(RosProInstance_TagsPropertyValidator))(properties.tags));
    if (properties.periodUnit && (typeof properties.periodUnit) !== 'object') {
        errors.collect(ros.propertyValidator('periodUnit', ros.validateAllowedValues)({
            data: properties.periodUnit,
            allowedValues: ["Month", "Year", "month", "year"],
        }));
    }
    errors.collect(ros.propertyValidator('periodUnit', ros.validateString)(properties.periodUnit));
    if (properties.domainCount && (typeof properties.domainCount) !== 'object') {
        errors.collect(ros.propertyValidator('domainCount', ros.validateRange)({
            data: properties.domainCount,
            min: 50,
            max: 2000,
        }));
    }
    errors.collect(ros.propertyValidator('domainCount', ros.validateNumber)(properties.domainCount));
    return errors.wrap('supplied properties not correct for "RosProInstanceProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::ProInstance` resource
 *
 * @param properties - the TypeScript properties of a `RosProInstanceProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::ProInstance` resource.
 */
// @ts-ignore TS6133
function rosProInstancePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosProInstancePropsValidator(properties).assertSuccess();
    }
    return {
        'AddressType': ros.stringToRosTemplate(properties.addressType),
        'Bandwidth': ros.numberToRosTemplate(properties.bandwidth),
        'BaseBandwidth': ros.numberToRosTemplate(properties.baseBandwidth),
        'BurstBandwidthMode': ros.stringToRosTemplate(properties.burstBandwidthMode),
        'DomainCount': ros.numberToRosTemplate(properties.domainCount),
        'Edition': ros.stringToRosTemplate(properties.edition),
        'FunctionVersion': ros.stringToRosTemplate(properties.functionVersion),
        'NormalQps': ros.numberToRosTemplate(properties.normalQps),
        'Period': ros.numberToRosTemplate(properties.period),
        'PeriodUnit': ros.stringToRosTemplate(properties.periodUnit),
        'PortCount': ros.numberToRosTemplate(properties.portCount),
        'ServiceBandwidth': ros.numberToRosTemplate(properties.serviceBandwidth),
        'ServicePartner': ros.stringToRosTemplate(properties.servicePartner),
        'Tags': ros.listMapper(rosProInstanceTagsPropertyToRosTemplate)(properties.tags),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::DDoSPro::ProInstance`, which is used to create an Anti-DDoS Proxy (Chinese Mainland) instance.
 * @Note This class does not contain additional functions, so it is recommended to use the `ProInstance` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ddospro-proinstance
 */
class RosProInstance extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosProInstance.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrInstanceId = this.getAtt('InstanceId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.addressType = props.addressType;
        this.bandwidth = props.bandwidth;
        this.baseBandwidth = props.baseBandwidth;
        this.burstBandwidthMode = props.burstBandwidthMode;
        this.domainCount = props.domainCount;
        this.edition = props.edition;
        this.functionVersion = props.functionVersion;
        this.normalQps = props.normalQps;
        this.period = props.period;
        this.periodUnit = props.periodUnit;
        this.portCount = props.portCount;
        this.serviceBandwidth = props.serviceBandwidth;
        this.servicePartner = props.servicePartner;
        this.tags = props.tags;
    }
    get rosProperties() {
        return {
            addressType: this.addressType,
            bandwidth: this.bandwidth,
            baseBandwidth: this.baseBandwidth,
            burstBandwidthMode: this.burstBandwidthMode,
            domainCount: this.domainCount,
            edition: this.edition,
            functionVersion: this.functionVersion,
            normalQps: this.normalQps,
            period: this.period,
            periodUnit: this.periodUnit,
            portCount: this.portCount,
            serviceBandwidth: this.serviceBandwidth,
            servicePartner: this.servicePartner,
            tags: this.tags,
        };
    }
    renderProperties(props) {
        return rosProInstancePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosProInstance = RosProInstance;
/**
 * The resource type name for this resource class.
 */
RosProInstance.ROS_RESOURCE_TYPE_NAME = "ALIYUN::DDoSPro::ProInstance";
/**
 * Determine whether the given properties match those of a `TagsProperty`
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the result of the validation.
 */
function RosProInstance_TagsPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('value', ros.validateString)(properties.value));
    errors.collect(ros.propertyValidator('key', ros.requiredValidator)(properties.key));
    errors.collect(ros.propertyValidator('key', ros.validateString)(properties.key));
    return errors.wrap('supplied properties not correct for "TagsProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::ProInstance.Tags` resource
 *
 * @param properties - the TypeScript properties of a `TagsProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::ProInstance.Tags` resource.
 */
// @ts-ignore TS6133
function rosProInstanceTagsPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosProInstance_TagsPropertyValidator(properties).assertSuccess();
    return {
        'Value': ros.stringToRosTemplate(properties.value),
        'Key': ros.stringToRosTemplate(properties.key),
    };
}
/**
 * Determine whether the given properties match those of a `RosSceneDefensePolicyProps`
 *
 * @param properties - the TypeScript properties of a `RosSceneDefensePolicyProps`
 *
 * @returns the result of the validation.
 */
function RosSceneDefensePolicyPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('endTime', ros.requiredValidator)(properties.endTime));
    errors.collect(ros.propertyValidator('endTime', ros.validateNumber)(properties.endTime));
    errors.collect(ros.propertyValidator('startTime', ros.requiredValidator)(properties.startTime));
    errors.collect(ros.propertyValidator('startTime', ros.validateNumber)(properties.startTime));
    errors.collect(ros.propertyValidator('name', ros.requiredValidator)(properties.name));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    errors.collect(ros.propertyValidator('template', ros.requiredValidator)(properties.template));
    if (properties.template && (typeof properties.template) !== 'object') {
        errors.collect(ros.propertyValidator('template', ros.validateAllowedValues)({
            data: properties.template,
            allowedValues: ["promotion", "bypass"],
        }));
    }
    errors.collect(ros.propertyValidator('template', ros.validateString)(properties.template));
    return errors.wrap('supplied properties not correct for "RosSceneDefensePolicyProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::SceneDefensePolicy` resource
 *
 * @param properties - the TypeScript properties of a `RosSceneDefensePolicyProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::SceneDefensePolicy` resource.
 */
// @ts-ignore TS6133
function rosSceneDefensePolicyPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosSceneDefensePolicyPropsValidator(properties).assertSuccess();
    }
    return {
        'EndTime': ros.numberToRosTemplate(properties.endTime),
        'Name': ros.stringToRosTemplate(properties.name),
        'StartTime': ros.numberToRosTemplate(properties.startTime),
        'Template': ros.stringToRosTemplate(properties.template),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::DDoSPro::SceneDefensePolicy`, which is used to create a scenario-specific custom policy.
 * @Note This class does not contain additional functions, so it is recommended to use the `SceneDefensePolicy` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ddospro-scenedefensepolicy
 */
class RosSceneDefensePolicy extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosSceneDefensePolicy.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrName = this.getAtt('Name');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.endTime = props.endTime;
        this.name = props.name;
        this.startTime = props.startTime;
        this.template = props.template;
    }
    get rosProperties() {
        return {
            endTime: this.endTime,
            name: this.name,
            startTime: this.startTime,
            template: this.template,
        };
    }
    renderProperties(props) {
        return rosSceneDefensePolicyPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosSceneDefensePolicy = RosSceneDefensePolicy;
/**
 * The resource type name for this resource class.
 */
RosSceneDefensePolicy.ROS_RESOURCE_TYPE_NAME = "ALIYUN::DDoSPro::SceneDefensePolicy";
/**
 * Determine whether the given properties match those of a `RosSchedulerRuleProps`
 *
 * @param properties - the TypeScript properties of a `RosSchedulerRuleProps`
 *
 * @returns the result of the validation.
 */
function RosSchedulerRulePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    errors.collect(ros.propertyValidator('param', ros.validateString)(properties.param));
    errors.collect(ros.propertyValidator('ruleType', ros.requiredValidator)(properties.ruleType));
    if (properties.ruleType && (typeof properties.ruleType) !== 'object') {
        errors.collect(ros.propertyValidator('ruleType', ros.validateAllowedValues)({
            data: properties.ruleType,
            allowedValues: [2, 3, 5, 6, 8],
        }));
    }
    errors.collect(ros.propertyValidator('ruleType', ros.validateNumber)(properties.ruleType));
    errors.collect(ros.propertyValidator('rules', ros.requiredValidator)(properties.rules));
    errors.collect(ros.propertyValidator('rules', ros.validateString)(properties.rules));
    errors.collect(ros.propertyValidator('ruleName', ros.requiredValidator)(properties.ruleName));
    errors.collect(ros.propertyValidator('ruleName', ros.validateString)(properties.ruleName));
    return errors.wrap('supplied properties not correct for "RosSchedulerRuleProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::SchedulerRule` resource
 *
 * @param properties - the TypeScript properties of a `RosSchedulerRuleProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::SchedulerRule` resource.
 */
// @ts-ignore TS6133
function rosSchedulerRulePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosSchedulerRulePropsValidator(properties).assertSuccess();
    }
    return {
        'RuleName': ros.stringToRosTemplate(properties.ruleName),
        'Rules': ros.stringToRosTemplate(properties.rules),
        'RuleType': ros.numberToRosTemplate(properties.ruleType),
        'Param': ros.stringToRosTemplate(properties.param),
        'ResourceGroupId': ros.stringToRosTemplate(properties.resourceGroupId),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::DDoSPro::SchedulerRule`, which is used to create a scheduling rule for Sec-Traffic Manager.
 * @Note This class does not contain additional functions, so it is recommended to use the `SchedulerRule` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ddospro-schedulerrule
 */
class RosSchedulerRule extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosSchedulerRule.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrRuleName = this.getAtt('RuleName');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.ruleName = props.ruleName;
        this.rules = props.rules;
        this.ruleType = props.ruleType;
        this.param = props.param;
        this.resourceGroupId = props.resourceGroupId;
    }
    get rosProperties() {
        return {
            ruleName: this.ruleName,
            rules: this.rules,
            ruleType: this.ruleType,
            param: this.param,
            resourceGroupId: this.resourceGroupId,
        };
    }
    renderProperties(props) {
        return rosSchedulerRulePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosSchedulerRule = RosSchedulerRule;
/**
 * The resource type name for this resource class.
 */
RosSchedulerRule.ROS_RESOURCE_TYPE_NAME = "ALIYUN::DDoSPro::SchedulerRule";
/**
 * Determine whether the given properties match those of a `RosWebRuleProps`
 *
 * @param properties - the TypeScript properties of a `RosWebRuleProps`
 *
 * @returns the result of the validation.
 */
function RosWebRulePropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('rsType', ros.requiredValidator)(properties.rsType));
    if (properties.rsType && (typeof properties.rsType) !== 'object') {
        errors.collect(ros.propertyValidator('rsType', ros.validateAllowedValues)({
            data: properties.rsType,
            allowedValues: [0, 1],
        }));
    }
    errors.collect(ros.propertyValidator('rsType', ros.validateNumber)(properties.rsType));
    errors.collect(ros.propertyValidator('resourceGroupId', ros.validateString)(properties.resourceGroupId));
    errors.collect(ros.propertyValidator('defenseId', ros.validateString)(properties.defenseId));
    errors.collect(ros.propertyValidator('domain', ros.requiredValidator)(properties.domain));
    errors.collect(ros.propertyValidator('domain', ros.validateString)(properties.domain));
    if (properties.instanceIds && (Array.isArray(properties.instanceIds) || (typeof properties.instanceIds) === 'string')) {
        errors.collect(ros.propertyValidator('instanceIds', ros.validateLength)({
            data: properties.instanceIds.length,
            min: 0,
            max: 100,
        }));
    }
    errors.collect(ros.propertyValidator('instanceIds', ros.listValidator(ros.validateString))(properties.instanceIds));
    errors.collect(ros.propertyValidator('rules', ros.requiredValidator)(properties.rules));
    errors.collect(ros.propertyValidator('rules', ros.validateString)(properties.rules));
    errors.collect(ros.propertyValidator('httpsExt', ros.validateString)(properties.httpsExt));
    return errors.wrap('supplied properties not correct for "RosWebRuleProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::WebRule` resource
 *
 * @param properties - the TypeScript properties of a `RosWebRuleProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::DDoSPro::WebRule` resource.
 */
// @ts-ignore TS6133
function rosWebRulePropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosWebRulePropsValidator(properties).assertSuccess();
    }
    return {
        'Domain': ros.stringToRosTemplate(properties.domain),
        'RsType': ros.numberToRosTemplate(properties.rsType),
        'Rules': ros.stringToRosTemplate(properties.rules),
        'DefenseId': ros.stringToRosTemplate(properties.defenseId),
        'HttpsExt': ros.stringToRosTemplate(properties.httpsExt),
        'InstanceIds': ros.listMapper(ros.stringToRosTemplate)(properties.instanceIds),
        'ResourceGroupId': ros.stringToRosTemplate(properties.resourceGroupId),
    };
}
/**
 * This class is a base encapsulation around the ROS resource type `ALIYUN::DDoSPro::WebRule`, which is used to create a forwarding rule for a website.
 * @Note This class does not contain additional functions, so it is recommended to use the `WebRule` class instead of this class for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ddospro-webrule
 */
class RosWebRule extends ros.RosResource {
    /**
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosWebRule.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrDomain = this.getAtt('Domain');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.domain = props.domain;
        this.rsType = props.rsType;
        this.rules = props.rules;
        this.defenseId = props.defenseId;
        this.httpsExt = props.httpsExt;
        this.instanceIds = props.instanceIds;
        this.resourceGroupId = props.resourceGroupId;
    }
    get rosProperties() {
        return {
            domain: this.domain,
            rsType: this.rsType,
            rules: this.rules,
            defenseId: this.defenseId,
            httpsExt: this.httpsExt,
            instanceIds: this.instanceIds,
            resourceGroupId: this.resourceGroupId,
        };
    }
    renderProperties(props) {
        return rosWebRulePropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosWebRule = RosWebRule;
/**
 * The resource type name for this resource class.
 */
RosWebRule.ROS_RESOURCE_TYPE_NAME = "ALIYUN::DDoSPro::WebRule";
//# sourceMappingURL=data:application/json;base64,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