"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PremiumInstance = exports.PremiumInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ddospro_generated_1 = require("./ddospro.generated");
Object.defineProperty(exports, "PremiumInstanceProperty", { enumerable: true, get: function () { return ddospro_generated_1.RosPremiumInstance; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::DDoSPro::PremiumInstance`, which is used to create an Anti-DDoS Proxy (Outside Chinese Mainland) instance.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosPremiumInstance`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ddospro-premiuminstance
 */
class PremiumInstance extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosPremiumInstance = new ddospro_generated_1.RosPremiumInstance(this, id, {
            normalQps: props.normalQps,
            normalBandwidth: props.normalBandwidth,
            functionVersion: props.functionVersion,
            productPlan: props.productPlan,
            period: props.period,
            portCount: props.portCount,
            tags: props.tags,
            burstBandwidthMode: props.burstBandwidthMode,
            periodUnit: props.periodUnit,
            domainCount: props.domainCount,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosPremiumInstance;
        this.attrInstanceId = rosPremiumInstance.attrInstanceId;
    }
}
exports.PremiumInstance = PremiumInstance;
//# sourceMappingURL=data:application/json;base64,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