"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProInstance = exports.ProInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const ddospro_generated_1 = require("./ddospro.generated");
Object.defineProperty(exports, "ProInstanceProperty", { enumerable: true, get: function () { return ddospro_generated_1.RosProInstance; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::DDoSPro::ProInstance`, which is used to create an Anti-DDoS Proxy (Chinese Mainland) instance.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosProInstance`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-ddospro-proinstance
 */
class ProInstance extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosProInstance = new ddospro_generated_1.RosProInstance(this, id, {
            normalQps: props.normalQps,
            period: props.period,
            portCount: props.portCount,
            edition: props.edition,
            burstBandwidthMode: props.burstBandwidthMode,
            serviceBandwidth: props.serviceBandwidth,
            servicePartner: props.servicePartner,
            baseBandwidth: props.baseBandwidth,
            functionVersion: props.functionVersion,
            bandwidth: props.bandwidth,
            addressType: props.addressType,
            tags: props.tags,
            periodUnit: props.periodUnit,
            domainCount: props.domainCount,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosProInstance;
        this.attrInstanceId = rosProInstance.attrInstanceId;
    }
}
exports.ProInstance = ProInstance;
//# sourceMappingURL=data:application/json;base64,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