# This file was automatically generated by scripts/regen-py.pl at 20220627-142751


from numbers import Number

# =======================
# ----- API Methods -----
# =======================


class DerivAPICalls:

    async def account_closure(self, args=None):
        """
        This call allows clients to close all their accounts (including virtual-money account). It is assumed that all their accounts (excluding virtual) have no balance left.

        Parameters:
        -----------
            args : dict with following keys
                account_closure : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                reason : str
                    Reason for closing off accounts.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'account_closure': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'reason': {
                'required': 1,
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'account_closure',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def account_security(self, args=None):
        """
        This call manages two-factor account authentication

        Parameters:
        -----------
            args : dict with following keys
                account_security : int
                    Must be 1
                otp : str
                    [Optional] OTP (one-time passcode) generated by a 2FA application like Authy, Google Authenticator or Yubikey.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                totp_action : str
                    [Optional] Action to be taken for managing TOTP (time-based one-time password, RFC6238). Generate will create a secret key which is then returned in the secret_key response field, you can then enable by using that code in a 2FA application.
        """

        if args is None:
            args = {}

        config = {
            'account_security': {
                'required': 1,
                'type': 'integer'
            },
            'otp': {
                'type': 'string'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'totp_action': {
                'type': 'string'
            }
        }

        all_args = {
            'method': 'account_security',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def account_statistics(self, args=None):
        """
        Send request to get account statistics

        Parameters:
        -----------
            args : dict with following keys
                account_statistics : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'account_statistics': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'account_statistics',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def active_symbols(self, args=None):
        """
        Retrieve a list of all currently active symbols (underlying markets upon which contracts are available for trading).

        Parameters:
        -----------
            args : dict with following keys
                active_symbols : str
                    If you use brief, only a subset of fields will be returned.
                landing_company : str
                    [Optional] If you specify this field, only symbols available for trading by that landing company will be returned. If you are logged in, only symbols available for trading by your landing company will be returned regardless of what you specify in this field.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                product_type : str
                    [Optional] If you specify this field, only symbols that can be traded through that product type will be returned.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'active_symbols': {
                'required': 1,
                'type': 'string'
            },
            'landing_company': {
                'type': 'string'
            },
            'passthrough': {},
            'product_type': {
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'active_symbols',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def affiliate_account_add(self, args=None):
        """
        Register a new affiliate

        Parameters:
        -----------
            args : dict with following keys
                address_city : str
                    City name within 50 characters.
                address_line_1 : str
                    Within 70 characters, with no leading whitespaces and may contain letters/numbers and/or any of following characters '.,:;()@#/-
                address_line_2 : str
                    [Optional] Within 70 characters.
                address_postcode : str
                    Within 20 characters and may not contain '+'.
                address_state : str
                    Possible value receive from states_list call.
                affiliate_account_add : int
                    [Required] Must be 1
                country : str
                    Country of legal citizenship, 2-letter country code.
                first_name : str
                    The official first name of the affiliate. Within 2-50 characters, use only letters, spaces, hyphens, full-stops or apostrophes.
                last_name : str
                    The official last name of the affiliate. Within 2-50 characters, use only letters, spaces, hyphens, full-stops or apostrophes.
                non_pep_declaration : int
                    Indicates client's self-declaration of not being a PEP/RCA (Politically Exposed Person/Relatives and Close Associates).
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                password : str
                    Password for the affiliate account. (Accepts any printable ASCII character. Must be between 6-50 characters, and include numbers, lowercase and uppercase letters.).
                phone : str
                    Registered phone number of the affiliate. Starting with + followed by 8-35 digits, allowing hyphens or space.
                req_id : int
                    [Optional] Used to map request to response.
                tnc_accepted : int
                    Indicates client has agreed to the terms and conditions.
                username : str
                    Desired username for the affiliate account. Within 2-50 characters, use only letters, spaces, hyphens, full-stops or apostrophes.
        """

        if args is None:
            args = {}

        config = {
            'address_city': {
                'required': 1,
                'type': 'string'
            },
            'address_line_1': {
                'required': 1,
                'type': 'string'
            },
            'address_line_2': {
                'type': 'string'
            },
            'address_postcode': {
                'required': 1,
                'type': 'string'
            },
            'address_state': {
                'required': 1,
                'type': 'string'
            },
            'affiliate_account_add': {
                'required': 1,
                'type': 'integer'
            },
            'country': {
                'required': 1,
                'type': 'string'
            },
            'first_name': {
                'required': 1,
                'type': 'string'
            },
            'last_name': {
                'required': 1,
                'type': 'string'
            },
            'non_pep_declaration': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'password': {
                'required': 1,
                'type': 'string'
            },
            'phone': {
                'required': 1,
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            },
            'tnc_accepted': {
                'required': 1,
                'type': 'integer'
            },
            'username': {
                'required': 1,
                'type': 'string'
            }
        }

        all_args = {
            'method': 'affiliate_account_add',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def api_token(self, args=None):
        """
        This call manages API tokens

        Parameters:
        -----------
            args : dict with following keys
                api_token : int
                    Must be 1
                delete_token : str
                    [Optional] The token to remove.
                new_token : str
                    [Optional] The name of the created token.
                new_token_scopes : Any
                    [Optional] List of permission scopes to provide with the token.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                valid_for_current_ip_only : int
                    [Optional] If you set this parameter during token creation, then the token created will only work for the IP address that was used to create the token
        """

        if args is None:
            args = {}

        config = {
            'api_token': {
                'required': 1,
                'type': 'integer'
            },
            'delete_token': {
                'type': 'string'
            },
            'new_token': {
                'type': 'string'
            },
            'new_token_scopes': {},
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'valid_for_current_ip_only': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'api_token',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def app_delete(self, args=None):
        """
        The request for deleting an application.

        Parameters:
        -----------
            args : dict with following keys
                app_delete : int
                    Application app_id
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'app_delete': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'app_delete',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def app_get(self, args=None):
        """
        To get the information of the OAuth application specified by 'app_id'

        Parameters:
        -----------
            args : dict with following keys
                app_get : int
                    Application app_id
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'app_get': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'app_get',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def app_list(self, args=None):
        """
        List all of the account's OAuth applications

        Parameters:
        -----------
            args : dict with following keys
                app_list : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'app_list': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'app_list',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def app_markup_details(self, args=None):
        """
        Retrieve details of `app_markup` according to criteria specified.

        Parameters:
        -----------
            args : dict with following keys
                app_id : int
                    [Optional] Specific application app_id to report on.
                app_markup_details : int
                    Must be 1
                client_loginid : str
                    [Optional] Specific client loginid to report on, like CR12345
                date_from : str
                    Start date (epoch or YYYY-MM-DD HH:MM:SS). Results are inclusive of this time.
                date_to : str
                    End date (epoch or YYYY-MM-DD HH::MM::SS). Results are inclusive of this time.
                description : int
                    [Optional] If set to 1, will return app_markup transaction details.
                limit : Number
                    [Optional] Apply upper limit to count of transactions received.
                offset : Number
                    [Optional] Number of transactions to skip.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                sort : str
                    [Optional] Sort direction on transaction_time. Other fields sort order is ASC.
                sort_fields : Any
                    [Optional] One or more of the specified fields to sort on. Default sort field is by transaction_time.
        """

        if args is None:
            args = {}

        config = {
            'app_id': {
                'type': 'integer'
            },
            'app_markup_details': {
                'required': 1,
                'type': 'integer'
            },
            'client_loginid': {
                'type': 'string'
            },
            'date_from': {
                'required': 1,
                'type': 'string'
            },
            'date_to': {
                'required': 1,
                'type': 'string'
            },
            'description': {
                'type': 'integer'
            },
            'limit': {
                'type': 'numeric'
            },
            'offset': {
                'type': 'numeric'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'sort': {
                'type': 'string'
            },
            'sort_fields': {}
        }

        all_args = {
            'method': 'app_markup_details',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def app_register(self, args=None):
        """
        Register a new OAuth application

        Parameters:
        -----------
            args : dict with following keys
                app_markup_percentage : Number
                    [Optional] Markup to be added to contract prices (as a percentage of contract payout).
                app_register : int
                    Must be 1
                appstore : str
                    [Optional] Application's App Store URL (if applicable).
                github : str
                    [Optional] Application's GitHub page (for open-source projects).
                googleplay : str
                    [Optional] Application's Google Play URL (if applicable).
                homepage : str
                    [Optional] Application's homepage URL.
                name : str
                    Application name.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                redirect_uri : str
                    [Optional] The URL to redirect to after a successful login. Required if charging markup percentage
                req_id : int
                    [Optional] Used to map request to response.
                scopes : Any
                    List of permission scopes to grant the application.
                verification_uri : str
                    [Optional] Used when verify_email called. If available, a URL containing the verification token will be sent to the client's email, otherwise only the token will be sent.
        """

        if args is None:
            args = {}

        config = {
            'app_markup_percentage': {
                'type': 'numeric'
            },
            'app_register': {
                'required': 1,
                'type': 'integer'
            },
            'appstore': {
                'type': 'string'
            },
            'github': {
                'type': 'string'
            },
            'googleplay': {
                'type': 'string'
            },
            'homepage': {
                'type': 'string'
            },
            'name': {
                'required': 1,
                'type': 'string'
            },
            'passthrough': {},
            'redirect_uri': {
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            },
            'scopes': {
                'required': 1
            },
            'verification_uri': {
                'type': 'string'
            }
        }

        all_args = {
            'method': 'app_register',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def app_update(self, args=None):
        """
        Update a new OAuth application

        Parameters:
        -----------
            args : dict with following keys
                app_markup_percentage : Number
                    [Optional] Markup to be added to contract prices (as a percentage of contract payout).
                app_update : int
                    Application app_id.
                appstore : str
                    [Optional] Application's App Store URL (if applicable).
                github : str
                    [Optional] Application's GitHub page (for open-source projects).
                googleplay : str
                    [Optional] Application's Google Play URL (if applicable).
                homepage : str
                    [Optional] Application's homepage URL.
                name : str
                    Application name.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                redirect_uri : str
                    [Optional] The URL to redirect to after a successful login. Required if charging markup percentage.
                req_id : int
                    [Optional] Used to map request to response.
                scopes : Any
                    Change scopes will revoke all user's grants and log them out.
                verification_uri : str
                    [Optional] Used when verify_email called. If available, a URL containing the verification token will send to the client's email, otherwise only the token will be sent.
        """

        if args is None:
            args = {}

        config = {
            'app_markup_percentage': {
                'type': 'numeric'
            },
            'app_update': {
                'required': 1,
                'type': 'integer'
            },
            'appstore': {
                'type': 'string'
            },
            'github': {
                'type': 'string'
            },
            'googleplay': {
                'type': 'string'
            },
            'homepage': {
                'type': 'string'
            },
            'name': {
                'required': 1,
                'type': 'string'
            },
            'passthrough': {},
            'redirect_uri': {
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            },
            'scopes': {
                'required': 1
            },
            'verification_uri': {
                'type': 'string'
            }
        }

        all_args = {
            'method': 'app_update',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def asset_index(self, args=None):
        """
        Retrieve a list of all available underlyings and the corresponding contract types and duration boundaries. If the user is logged in, only the assets available for that user's landing company will be returned.

        Parameters:
        -----------
            args : dict with following keys
                asset_index : int
                    Must be 1
                landing_company : str
                    [Optional] If specified, will return only the underlyings for the specified landing company.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'asset_index': {
                'required': 1,
                'type': 'integer'
            },
            'landing_company': {
                'type': 'string'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'asset_index',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def authorize(self, args=None):
        """
        Authorize current WebSocket session to act on behalf of the owner of a given token. Must precede requests that need to access client account, for example purchasing and selling contracts or viewing portfolio.

        Parameters:
        -----------
            args : dict with following keys
                add_to_login_history : int
                    [Optional] Send this when you use api tokens for authorization and want to track activity using login_history call.
                authorize : str
                    Authentication token. May be retrieved from https://www.binary.com/en/user/security/api_tokenws.html
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'add_to_login_history': {
                'type': 'integer'
            },
            'authorize': {
                'required': 1,
                'type': 'string'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'authorize',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def balance(self, args=None):
        """
        Get user account balance

        Parameters:
        -----------
            args : dict with following keys
                account : str
                    [Optional] If set to all, return the balances of all accounts one by one; if set to current, return the balance of current account; if set as an account id, return the balance of that account.
                balance : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                subscribe : int
                    [Optional] If set to 1, will send updates whenever the balance changes.
        """

        if args is None:
            args = {}

        config = {
            'account': {
                'type': 'string'
            },
            'balance': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'subscribe': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'balance',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def buy(self, args=None):
        """
        Buy a Contract

        Parameters:
        -----------
            args : dict with following keys
                buy : str
                    Either the ID received from a Price Proposal (proposal call), or 1 if contract buy parameters are passed in the parameters field.
                parameters : Any
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                price : Number
                    Maximum price at which to purchase the contract.
                req_id : int
                    [Optional] Used to map request to response.
                subscribe : int
                    [Optional] 1 to stream.
        """

        if args is None:
            args = {}

        config = {
            'buy': {
                'required': 1,
                'type': 'string'
            },
            'parameters': {
                'amount': {
                    'type': 'numeric'
                },
                'app_markup_percentage': {
                    'type': 'numeric'
                },
                'barrier': {
                    'type': 'string'
                },
                'barrier2': {
                    'type': 'string'
                },
                'barrier_range': {
                    'type': 'string'
                },
                'basis': {
                    'type': 'string'
                },
                'cancellation': {
                    'type': 'string'
                },
                'contract_type': {
                    'required': 1,
                    'type': 'string'
                },
                'currency': {
                    'required': 1,
                    'type': 'string'
                },
                'date_expiry': {
                    'type': 'integer'
                },
                'date_start': {
                    'type': 'integer'
                },
                'duration': {
                    'type': 'integer'
                },
                'duration_unit': {
                    'type': 'string'
                },
                'limit_order': {
                    'stop_loss': {
                        'type': 'numeric'
                    },
                    'take_profit': {
                        'type': 'numeric'
                    }
                },
                'multiplier': {
                    'type': 'numeric'
                },
                'product_type': {
                    'type': 'string'
                },
                'selected_tick': {
                    'type': 'integer'
                },
                'symbol': {
                    'required': 1,
                    'type': 'string'
                },
                'trading_period_start': {
                    'type': 'integer'
                }
            },
            'passthrough': {},
            'price': {
                'required': 1,
                'type': 'numeric'
            },
            'req_id': {
                'type': 'integer'
            },
            'subscribe': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'buy',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def buy_contract_for_multiple_accounts(self, args=None):
        """
        Buy a Contract for multiple Accounts specified by the `tokens` parameter. Note, although this is an authorized call, the contract is not bought for the authorized account.

        Parameters:
        -----------
            args : dict with following keys
                buy_contract_for_multiple_accounts : str
                    Either the ID received from a Price Proposal (proposal call), or 1 if contract buy parameters are passed in the parameters field.
                parameters : Any
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                price : Number
                    Maximum price at which to purchase the contract.
                req_id : int
                    [Optional] Used to map request to response.
                tokens : Any
                    List of API tokens identifying the accounts for which the contract is bought. Note: If the same token appears multiple times or if multiple tokens designate the same account, the contract is bought multiple times for this account.
        """

        if args is None:
            args = {}

        config = {
            'buy_contract_for_multiple_accounts': {
                'required': 1,
                'type': 'string'
            },
            'parameters': {
                'amount': {
                    'type': 'numeric'
                },
                'app_markup_percentage': {
                    'type': 'numeric'
                },
                'barrier': {
                    'type': 'string'
                },
                'barrier2': {
                    'type': 'string'
                },
                'basis': {
                    'type': 'string'
                },
                'contract_type': {
                    'required': 1,
                    'type': 'string'
                },
                'currency': {
                    'required': 1,
                    'type': 'string'
                },
                'date_expiry': {
                    'type': 'integer'
                },
                'date_start': {
                    'type': 'integer'
                },
                'duration': {
                    'type': 'integer'
                },
                'duration_unit': {
                    'type': 'string'
                },
                'multiplier': {
                    'type': 'numeric'
                },
                'selected_tick': {
                    'type': 'integer'
                },
                'symbol': {
                    'required': 1,
                    'type': 'string'
                }
            },
            'passthrough': {},
            'price': {
                'required': 1,
                'type': 'numeric'
            },
            'req_id': {
                'type': 'integer'
            },
            'tokens': {
                'required': 1
            }
        }

        all_args = {
            'method': 'buy_contract_for_multiple_accounts',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def cancel(self, args=None):
        """
        Cancel contract with contract id

        Parameters:
        -----------
            args : dict with following keys
                cancel : int
                    Value should be the contract_id which received from the portfolio call.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'cancel': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'cancel',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def cashier(self, args=None):
        """
        Request the cashier info for the specified type.

        Parameters:
        -----------
            args : dict with following keys
                address : str
                    [Optional] Address for crypto withdrawal. Only applicable for api type.
                amount : Number
                    [Optional] Amount for crypto withdrawal. Only applicable for api type.
                cashier : str
                    Operation which needs to be requested from cashier
                dry_run : int
                    [Optional] If set to 1, only validation is performed. Only applicable for withdraw using crypto provider and api type.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                provider : str
                    [Optional] Cashier provider. crypto will be default option for crypto currency accounts.
                req_id : int
                    [Optional] Used to map request to response.
                type : str
                    [Optional] Data need to be returned from cashier. api is supported only for crypto provider.
                verification_code : str
                    [Optional] Email verification code (received from a verify_email call, which must be done first)
        """

        if args is None:
            args = {}

        config = {
            'address': {
                'type': 'string'
            },
            'amount': {
                'type': 'numeric'
            },
            'cashier': {
                'required': 1,
                'type': 'string'
            },
            'dry_run': {
                'type': 'integer'
            },
            'passthrough': {},
            'provider': {
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            },
            'type': {
                'type': 'string'
            },
            'verification_code': {
                'type': 'string'
            }
        }

        all_args = {
            'method': 'cashier',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def cashier_payments(self, args=None):
        """
        List pending transactions. This can only be used for crypto transactions.

        Parameters:
        -----------
            args : dict with following keys
                cashier_payments : Number
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                provider : str
                    [Optional] Cashier provider. crypto will be default option for crypto currency accounts.
                req_id : int
                    [Optional] Used to map request to response.
                subscribe : int
                    [Optional] If set to 1, will send updates whenever there is update to crypto payments.
                transaction_type : str
                    [Optional] Type of transactions to receive.
        """

        if args is None:
            args = {}

        config = {
            'cashier_payments': {
                'required': 1,
                'type': 'numeric'
            },
            'passthrough': {},
            'provider': {
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            },
            'subscribe': {
                'type': 'integer'
            },
            'transaction_type': {
                'type': 'string'
            }
        }

        all_args = {
            'method': 'cashier_payments',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def cashier_withdrawal_cancel(self, args=None):
        """
        Request for cancelling a withdrawal. This can only be used for crypto transactions.

        Parameters:
        -----------
            args : dict with following keys
                cashier_withdrawal_cancel : Number
                    Must be 1
                id : str
                    The unique identifier for the transaction.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'cashier_withdrawal_cancel': {
                'required': 1,
                'type': 'numeric'
            },
            'id': {
                'required': 1,
                'type': 'string'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'cashier_withdrawal_cancel',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def change_email(self, args=None):
        """
        Change Email.

        Parameters:
        -----------
            args : dict with following keys
                change_email : str
                    Must be verify or update.
                new_email : str
                    Email address to be verified.
                new_password : str
                    [Optional] New password (Accepts any printable ASCII character. Must be within 8-25 characters, and include numbers, lowercase and uppercase letters. Must not be the same as the user's email address). Mandatory if change_email is update and user has social login.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                verification_code : str
                    Email verification code (received from a verify_email call, which must be done first)
        """

        if args is None:
            args = {}

        config = {
            'change_email': {
                'required': 1,
                'type': 'string'
            },
            'new_email': {
                'required': 1,
                'type': 'string'
            },
            'new_password': {
                'type': 'string'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'verification_code': {
                'required': 1,
                'type': 'string'
            }
        }

        all_args = {
            'method': 'change_email',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def change_password(self, args=None):
        """
        Change Password. Note: This call is only available when authenticated using an OAuth token.

        Parameters:
        -----------
            args : dict with following keys
                change_password : Number
                    Must be 1
                new_password : str
                    New password (Accepts any printable ASCII character. Must be within 8-25 characters, and include numbers, lowercase and uppercase letters. Must not be the same as the user's email address)
                old_password : str
                    Old password for validation (non-empty string, accepts any printable ASCII character)
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'change_password': {
                'required': 1,
                'type': 'numeric'
            },
            'new_password': {
                'required': 1,
                'type': 'string'
            },
            'old_password': {
                'required': 1,
                'type': 'string'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'change_password',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def contract_update(self, args=None):
        """
        Update a contract condition.

        Parameters:
        -----------
            args : dict with following keys
                contract_id : int
                    Internal unique contract identifier.
                contract_update : int
                    Must be 1
                limit_order : Any
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'contract_id': {
                'required': 1,
                'type': 'integer'
            },
            'contract_update': {
                'required': 1,
                'type': 'integer'
            },
            'limit_order': {
                'stop_loss': {},
                'take_profit': {}
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'contract_update',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def contract_update_history(self, args=None):
        """
        Request for contract update history.

        Parameters:
        -----------
            args : dict with following keys
                contract_id : int
                    Internal unique contract identifier.
                contract_update_history : int
                    Must be 1
                limit : Number
                    [Optional] Maximum number of historical updates to receive.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'contract_id': {
                'required': 1,
                'type': 'integer'
            },
            'contract_update_history': {
                'required': 1,
                'type': 'integer'
            },
            'limit': {
                'type': 'numeric'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'contract_update_history',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def contracts_for(self, args=None):
        """
        For a given symbol, get the list of currently available contracts, and the latest barrier and duration limits for each contract.

        Parameters:
        -----------
            args : dict with following keys
                contracts_for : str
                    The short symbol name (obtained from active_symbols call).
                currency : str
                    [Optional] Currency of the contract's stake and payout (obtained from payout_currencies call).
                landing_company : str
                    [Optional] Indicates which landing company to get a list of contracts for. If you are logged in, your account's landing company will override this field.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                product_type : str
                    [Optional] If you specify this field, only contracts tradable through that contract type will be returned.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'contracts_for': {
                'required': 1,
                'type': 'string'
            },
            'currency': {
                'type': 'string'
            },
            'landing_company': {
                'type': 'string'
            },
            'passthrough': {},
            'product_type': {
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'contracts_for',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def copy_start(self, args=None):
        """
        Start copy trader bets

        Parameters:
        -----------
            args : dict with following keys
                assets : Any
                    [Optional] Used to set assets to be copied. E.x ["frxUSDJPY", "R_50"]
                copy_start : str
                    API tokens identifying the accounts of trader which will be used to copy trades
                max_trade_stake : Number
                    [Optional] Used to set maximum trade stake to be copied.
                min_trade_stake : Number
                    [Optional] Used to set minimal trade stake to be copied.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                trade_types : Any
                    [Optional] Used to set trade types to be copied. E.x ["CALL", "PUT"]
        """

        if args is None:
            args = {}

        config = {
            'assets': {},
            'copy_start': {
                'required': 1,
                'type': 'string'
            },
            'max_trade_stake': {
                'type': 'numeric'
            },
            'min_trade_stake': {
                'type': 'numeric'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'trade_types': {}
        }

        all_args = {
            'method': 'copy_start',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def copy_stop(self, args=None):
        """
        Stop copy trader bets

        Parameters:
        -----------
            args : dict with following keys
                copy_stop : str
                    API tokens identifying the accounts which needs not to be copied
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'copy_stop': {
                'required': 1,
                'type': 'string'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'copy_stop',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def copytrading_list(self, args=None):
        """
        Retrieves a list of active copiers and/or traders for Copy Trading

        Parameters:
        -----------
            args : dict with following keys
                copytrading_list : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'copytrading_list': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'copytrading_list',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def copytrading_statistics(self, args=None):
        """
        Retrieve performance, trading, risk and copiers statistics of trader.

        Parameters:
        -----------
            args : dict with following keys
                copytrading_statistics : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                trader_id : str
                    The ID of the target trader.
        """

        if args is None:
            args = {}

        config = {
            'copytrading_statistics': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'trader_id': {
                'required': 1,
                'type': 'string'
            }
        }

        all_args = {
            'method': 'copytrading_statistics',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def crypto_config(self, args=None):
        """
        The request for cryptocurrencies configuration.

        Parameters:
        -----------
            args : dict with following keys
                crypto_config : int
                    Must be 1
                currency_code : str
                    [Optional] Cryptocurrency code. Sending request with currency_code provides crypto config for the sent cryptocurrency code only.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'crypto_config': {
                'required': 1,
                'type': 'integer'
            },
            'currency_code': {
                'type': 'string'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'crypto_config',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def document_upload(self, args=None):
        """
        Request KYC information from client

        Parameters:
        -----------
            args : dict with following keys
                document_format : str
                    Document file format
                document_id : str
                    [Optional] Document ID (required for Passport, Proof of ID and Driver's License)
                document_issuing_country : str
                    [Optional] 2-letter country code
                document_type : str
                    Document type
                document_upload : int
                    Must be 1
                expected_checksum : str
                    The checksum of the file to be uploaded
                expiration_date : str
                    [Optional] Document expiration date (required for Passport, Proof of ID and Driver's License)
                file_size : int
                    Document size (should be less than 10MB)
                lifetime_valid : int
                    [Optional] Boolean value that indicates whether this document is lifetime valid (only applies to POI document types, cancels out the expiration_date given if any)
                page_type : str
                    [Optional] To determine document side
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                proof_of_ownership : Any
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'document_format': {
                'required': 1,
                'type': 'string'
            },
            'document_id': {
                'type': 'string'
            },
            'document_issuing_country': {
                'type': 'string'
            },
            'document_type': {
                'required': 1,
                'type': 'string'
            },
            'document_upload': {
                'required': 1,
                'type': 'integer'
            },
            'expected_checksum': {
                'required': 1,
                'type': 'string'
            },
            'expiration_date': {
                'type': 'string'
            },
            'file_size': {
                'required': 1,
                'type': 'integer'
            },
            'lifetime_valid': {
                'type': 'integer'
            },
            'page_type': {
                'type': 'string'
            },
            'passthrough': {},
            'proof_of_ownership': {
                'details': {
                    'required': 1
                },
                'id': {
                    'required': 1,
                    'type': 'numeric'
                }
            },
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'document_upload',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def economic_calendar(self, args=None):
        """
        Specify a currency to receive a list of events related to that specific currency. For example, specifying USD will return a list of USD-related events. If the currency is omitted, you will receive a list for all currencies.

        Parameters:
        -----------
            args : dict with following keys
                currency : str
                    [Optional] Currency symbol.
                economic_calendar : int
                    Must be 1
                end_date : int
                    [Optional] End date.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                start_date : int
                    [Optional] Start date.
        """

        if args is None:
            args = {}

        config = {
            'currency': {
                'type': 'string'
            },
            'economic_calendar': {
                'required': 1,
                'type': 'integer'
            },
            'end_date': {
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'start_date': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'economic_calendar',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def exchange_rates(self, args=None):
        """
        Retrieves the exchange rates from a base currency to all currencies supported by the system.

        Parameters:
        -----------
            args : dict with following keys
                base_currency : str
                    Base currency (can be obtained from payout_currencies call)
                exchange_rates : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                subscribe : int
                    [Optional] 1 - to initiate a realtime stream of exchange rates relative to base currency.
                target_currency : str
                    [Optional] Local currency
        """

        if args is None:
            args = {}

        config = {
            'base_currency': {
                'required': 1,
                'type': 'string'
            },
            'exchange_rates': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'subscribe': {
                'type': 'integer'
            },
            'target_currency': {
                'type': 'string'
            }
        }

        all_args = {
            'method': 'exchange_rates',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def forget(self, args=None):
        """
        Immediately cancel the real-time stream of messages with a specific ID.

        Parameters:
        -----------
            args : dict with following keys
                forget : str
                    ID of the real-time stream of messages to cancel.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'forget': {
                'required': 1,
                'type': 'string'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'forget',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def forget_all(self, args=None):
        """
        Immediately cancel the real-time streams of messages of given type.

        Parameters:
        -----------
            args : dict with following keys
                forget_all : Any
                    Cancel all streams by type. The value can be either a single type e.g. "ticks", or an array of multiple types e.g. ["candles", "ticks"].
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'forget_all': {
                'required': 1
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'forget_all',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def get_account_status(self, args=None):
        """
        Get Account Status

        Parameters:
        -----------
            args : dict with following keys
                get_account_status : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'get_account_status': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'get_account_status',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def get_account_types(self, args=None):
        """
        Types of accounts available to create or link to.

        Parameters:
        -----------
            args : dict with following keys
                get_account_types : Number
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'get_account_types': {
                'required': 1,
                'type': 'numeric'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'get_account_types',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def get_available_accounts_to_transfer(self, args=None):
        """
        Get Available Accounts to Transfer.

        Parameters:
        -----------
            args : dict with following keys
                get_available_accounts_to_transfer : Number
                    Must be 1
                loginid : str
                    The unique identifier for this trading/wallet account.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'get_available_accounts_to_transfer': {
                'required': 1,
                'type': 'numeric'
            },
            'loginid': {
                'required': 1,
                'type': 'string'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'get_available_accounts_to_transfer',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def get_financial_assessment(self, args=None):
        """
        This call gets the financial assessment details. The 'financial assessment' is a questionnaire that clients of certain Landing Companies need to complete, due to regulatory and KYC (know your client) requirements.

        Parameters:
        -----------
            args : dict with following keys
                get_financial_assessment : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'get_financial_assessment': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'get_financial_assessment',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def get_limits(self, args=None):
        """
        Trading and Withdrawal Limits for a given user

        Parameters:
        -----------
            args : dict with following keys
                get_limits : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'get_limits': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'get_limits',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def get_self_exclusion(self, args=None):
        """
        Allows users to exclude themselves from the website for certain periods of time, or to set limits on their trading activities. This facility is a regulatory requirement for certain Landing Companies.

        Parameters:
        -----------
            args : dict with following keys
                get_self_exclusion : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'get_self_exclusion': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'get_self_exclusion',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def get_settings(self, args=None):
        """
        Get User Settings (email, date of birth, address etc)

        Parameters:
        -----------
            args : dict with following keys
                get_settings : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'get_settings': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'get_settings',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def identity_verification_document_add(self, args=None):
        """
        Adds document information such as issuing country, id and type for identity verification processes.

        Parameters:
        -----------
            args : dict with following keys
                document_number : str
                    The identification number of the document.
                document_type : str
                    The type of the document based on provided issuing_country (can obtained from residence_list call).
                identity_verification_document_add : int
                    Must be 1
                issuing_country : str
                    2-letter country code (can obtained from residence_list call).
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'document_number': {
                'required': 1,
                'type': 'string'
            },
            'document_type': {
                'required': 1,
                'type': 'string'
            },
            'identity_verification_document_add': {
                'required': 1,
                'type': 'integer'
            },
            'issuing_country': {
                'required': 1,
                'type': 'string'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'identity_verification_document_add',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def landing_company(self, args=None):
        """
        The company has a number of licensed subsidiaries in various jurisdictions, which are called Landing Companies. This call will return the appropriate Landing Company for clients of a given country. The landing company may differ for Gaming contracts (Synthetic Indices) and Financial contracts (Forex, Stock Indices, Commodities).

        Parameters:
        -----------
            args : dict with following keys
                landing_company : str
                    Client's 2-letter country code (obtained from residence_list call).
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'landing_company': {
                'required': 1,
                'type': 'string'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'landing_company',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def landing_company_details(self, args=None):
        """
        The company has a number of licensed subsidiaries in various jurisdictions, which are called Landing Companies (and which are wholly owned subsidiaries of the Deriv Group). This call provides information about each Landing Company.

        Parameters:
        -----------
            args : dict with following keys
                landing_company_details : str
                    Landing company shortcode.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'landing_company_details': {
                'required': 1,
                'type': 'string'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'landing_company_details',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def link_wallet(self, args=None):
        """
        Link a wallet to a trading app.

        Parameters:
        -----------
            args : dict with following keys
                client_id : str
                    The unique identifier for this trading account.
                link_wallet : Number
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                wallet_id : str
                    The unique identifier for this wallet.
        """

        if args is None:
            args = {}

        config = {
            'client_id': {
                'required': 1,
                'type': 'string'
            },
            'link_wallet': {
                'required': 1,
                'type': 'numeric'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'wallet_id': {
                'required': 1,
                'type': 'string'
            }
        }

        all_args = {
            'method': 'link_wallet',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def login_history(self, args=None):
        """
        Retrieve a summary of login history for user.

        Parameters:
        -----------
            args : dict with following keys
                limit : int
                    [Optional] Apply limit to count of login history records.
                login_history : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'limit': {
                'type': 'integer'
            },
            'login_history': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'login_history',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def logout(self, args=None):
        """
        Logout the session

        Parameters:
        -----------
            args : dict with following keys
                logout : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'logout': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'logout',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def mt5_deposit(self, args=None):
        """
        This call allows deposit into MT5 account from Binary account.

        Parameters:
        -----------
            args : dict with following keys
                amount : Number
                    Amount to deposit (in the currency of from_binary); min = $1 or an equivalent amount, max = $20000 or an equivalent amount
                from_binary : str
                    Binary account loginid to transfer money from
                mt5_deposit : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                to_mt5 : str
                    MT5 account login to deposit money to
        """

        if args is None:
            args = {}

        config = {
            'amount': {
                'type': 'numeric'
            },
            'from_binary': {
                'type': 'string'
            },
            'mt5_deposit': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'to_mt5': {
                'required': 1,
                'type': 'string'
            }
        }

        all_args = {
            'method': 'mt5_deposit',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def mt5_get_settings(self, args=None):
        """
        Get MT5 user account settings

        Parameters:
        -----------
            args : dict with following keys
                login : str
                    MT5 user login
                mt5_get_settings : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'login': {
                'required': 1,
                'type': 'string'
            },
            'mt5_get_settings': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'mt5_get_settings',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def mt5_login_list(self, args=None):
        """
        Get list of MT5 accounts for client

        Parameters:
        -----------
            args : dict with following keys
                mt5_login_list : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'mt5_login_list': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'mt5_login_list',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def mt5_new_account(self, args=None):
        """
        This call creates new MT5 user, either demo or real money user.

        Parameters:
        -----------
            args : dict with following keys
                account_type : str
                    Account type. If set to 'financial', setting 'mt5_account_type' is also required.
                address : str
                    [Optional] The address of the user. The maximum length of this address field is 128 characters.
                city : str
                    [Optional] User's city of residence.
                company : str
                    [Optional] Name of the client's company. The maximum length of the company name is 64 characters.
                country : str
                    [Optional] 2-letter country code (value received from residence_list call).
                currency : str
                    [Optional] MT5 account currency, the default value will be the qualified account currency.
                dry_run : int
                    [Optional] If set to 1, only validation is performed.
                email : str
                    Email address
                investPassword : str
                    [Optional] The investor password of the account. For validation (Accepts any printable ASCII character. Must be within 8-25 characters, and include numbers, lowercase and uppercase letters. Must not be the same as the user's email address).
                leverage : Number
                    Client leverage (from 1 to 1000).
                mainPassword : str
                    The master password of the account. For validation (Accepts any printable ASCII character. Must be within 8-25 characters, and include numbers, lowercase and uppercase letters. Must not be the same as the user's email address). This field is required.
                mt5_account_category : str
                    [Optional] To choose whether account is conventional or not. Unavailable for financial_stp MT5_account_type
                mt5_account_type : str
                    [Optional] Financial: Variable spreads, High leverage. Financial STP: Variable spreads, Medium Leverage, more products. If 'account_type' set to 'financial', setting 'mt5_account_type' is also required.
                mt5_new_account : int
                    Must be 1
                name : str
                    Client's name. The maximum length here is 101 characters.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                phone : str
                    [Optional] User's phone number.
                phonePassword : str
                    [Optional] The user's phone password.
                req_id : int
                    [Optional] Used to map request to response.
                server : Any
                    [Optional] Trade server.
                state : str
                    [Optional] User's state (region) of residence.
                zipCode : str
                    [Optional] User's zip code.
        """

        if args is None:
            args = {}

        config = {
            'account_type': {
                'required': 1,
                'type': 'string'
            },
            'address': {
                'type': 'string'
            },
            'city': {
                'type': 'string'
            },
            'company': {
                'type': 'string'
            },
            'country': {
                'type': 'string'
            },
            'currency': {
                'type': 'string'
            },
            'dry_run': {
                'type': 'integer'
            },
            'email': {
                'required': 1,
                'type': 'string'
            },
            'investPassword': {
                'type': 'string'
            },
            'leverage': {
                'required': 1,
                'type': 'numeric'
            },
            'mainPassword': {
                'required': 1,
                'type': 'string'
            },
            'mt5_account_category': {
                'type': 'string'
            },
            'mt5_account_type': {
                'type': 'string'
            },
            'mt5_new_account': {
                'required': 1,
                'type': 'integer'
            },
            'name': {
                'required': 1,
                'type': 'string'
            },
            'passthrough': {},
            'phone': {
                'type': 'string'
            },
            'phonePassword': {
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            },
            'server': {},
            'state': {
                'type': 'string'
            },
            'zipCode': {
                'type': 'string'
            }
        }

        all_args = {
            'method': 'mt5_new_account',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def mt5_password_change(self, args=None):
        """
        To change passwords of the MT5 account.

        Parameters:
        -----------
            args : dict with following keys
                login : str
                    MT5 user login
                mt5_password_change : int
                    Must be 1
                new_password : str
                    New password of the account. For validation (Accepts any printable ASCII character. Must be within 8-25 characters, and include numbers, lowercase and uppercase letters. Must not be the same as the user's email address).
                old_password : str
                    Old password for validation (non-empty string, accepts any printable ASCII character)
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                password_type : str
                    [Optional] Type of the password to change.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'login': {
                'required': 1,
                'type': 'string'
            },
            'mt5_password_change': {
                'required': 1,
                'type': 'integer'
            },
            'new_password': {
                'required': 1,
                'type': 'string'
            },
            'old_password': {
                'required': 1,
                'type': 'string'
            },
            'passthrough': {},
            'password_type': {
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'mt5_password_change',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def mt5_password_check(self, args=None):
        """
        This call validates the main password for the MT5 user

        Parameters:
        -----------
            args : dict with following keys
                login : str
                    MT5 user login
                mt5_password_check : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                password : str
                    The password of the account.
                password_type : str
                    [Optional] Type of the password to check.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'login': {
                'required': 1,
                'type': 'string'
            },
            'mt5_password_check': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'password': {
                'required': 1,
                'type': 'string'
            },
            'password_type': {
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'mt5_password_check',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def mt5_password_reset(self, args=None):
        """
        To reset the password of MT5 account.

        Parameters:
        -----------
            args : dict with following keys
                login : str
                    MT5 user login
                mt5_password_reset : int
                    Must be 1
                new_password : str
                    New password of the account. For validation (Accepts any printable ASCII character. Must be within 8-25 characters, and include numbers, lowercase and uppercase letters. Must not be the same as the user's email address).
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                password_type : str
                    [Optional] Type of the password to reset.
                req_id : int
                    [Optional] Used to map request to response.
                verification_code : str
                    Email verification code (received from a verify_email call, which must be done first)
        """

        if args is None:
            args = {}

        config = {
            'login': {
                'required': 1,
                'type': 'string'
            },
            'mt5_password_reset': {
                'required': 1,
                'type': 'integer'
            },
            'new_password': {
                'required': 1,
                'type': 'string'
            },
            'passthrough': {},
            'password_type': {
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            },
            'verification_code': {
                'required': 1,
                'type': 'string'
            }
        }

        all_args = {
            'method': 'mt5_password_reset',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def mt5_withdrawal(self, args=None):
        """
        This call allows withdrawal from MT5 account to Binary account.

        Parameters:
        -----------
            args : dict with following keys
                amount : Number
                    Amount to withdraw (in the currency of the MT5 account); min = $1 or an equivalent amount, max = $20000 or an equivalent amount.
                from_mt5 : str
                    MT5 account login to withdraw money from
                mt5_withdrawal : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                to_binary : str
                    Binary account loginid to transfer money to
        """

        if args is None:
            args = {}

        config = {
            'amount': {
                'required': 1,
                'type': 'numeric'
            },
            'from_mt5': {
                'required': 1,
                'type': 'string'
            },
            'mt5_withdrawal': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'to_binary': {
                'required': 1,
                'type': 'string'
            }
        }

        all_args = {
            'method': 'mt5_withdrawal',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def new_account_maltainvest(self, args=None):
        """
        This call opens a new real-money account with the `maltainvest` Landing Company. This call can be made from a virtual-money account or real-money account at Deriv (Europe) Limited. If it is the latter, client information fields in this call will be ignored and data from your existing real-money account will be used.

        Parameters:
        -----------
            args : dict with following keys
                accept_risk : int
                    Show whether client has accepted risk disclaimer.
                account_opening_reason : str
                    [Optional] Purpose and reason for requesting the account opening.
                account_turnover : str
                    [Optional] The anticipated account turnover.
                address_city : str
                    Within 100 characters
                address_line_1 : str
                    Within 70 characters, with no leading whitespaces and may contain letters/numbers and/or any of following characters '.,:;()@#/-
                address_line_2 : str
                    [Optional] Within 70 characters.
                address_postcode : str
                    [Optional] Within 20 characters and may not contain '+'.
                address_state : str
                    [Optional] Possible value receive from states_list call.
                affiliate_token : str
                    [Optional] Affiliate token, within 32 characters.
                binary_options_trading_experience : str
                    [Optional] Binary options trading experience.
                binary_options_trading_frequency : str
                    [Optional] Binary options trading frequency.
                cfd_trading_experience : str
                    [Optional] CFDs trading experience.
                cfd_trading_frequency : str
                    [Optional] CFDs trading frequency.
                citizen : str
                    [Optional] Country of legal citizenship, 2-letter country code. Possible value receive from residence_list call.
                client_type : str
                    [Optional] Indicates whether this is for a client requesting an account with professional status.
                currency : str
                    [Optional] To set currency of the account. List of supported currencies can be acquired with payout_currencies call.
                date_of_birth : str
                    Date of birth format: yyyy-mm-dd.
                education_level : str
                    Level of Education
                employment_industry : str
                    Industry of Employment.
                employment_status : str
                    [Optional] Employment Status.
                estimated_worth : str
                    Estimated Net Worth.
                first_name : str
                    Within 2-50 characters, use only letters, spaces, hyphens, full-stops or apostrophes.
                forex_trading_experience : str
                    [Optional] Forex trading experience.
                forex_trading_frequency : str
                    [Optional] Forex trading frequency.
                income_source : str
                    Income Source.
                last_name : str
                    Within 2-50 characters, use only letters, spaces, hyphens, full-stops or apostrophes.
                net_income : str
                    Net Annual Income.
                new_account_maltainvest : int
                    Must be 1
                non_pep_declaration : int
                    [Optional] Indicates client's self-declaration of not being a PEP/RCA.
                occupation : str
                    Occupation.
                other_instruments_trading_experience : str
                    [Optional] Trading experience in other financial instruments.
                other_instruments_trading_frequency : str
                    [Optional] Trading frequency in other financial instruments.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                phone : Any
                    [Optional] Starting with + followed by 9-35 digits, hyphens or space.
                place_of_birth : str
                    [Optional] Place of birth, 2-letter country code.
                req_id : int
                    [Optional] Used to map request to response.
                residence : str
                    2-letter country code, possible value receive from residence_list call.
                salutation : str
                    Accept any value in enum list.
                secret_answer : str
                    [Optional] Answer to secret question, within 4-50 characters.
                secret_question : str
                    [Optional] Accept any value in enum list.
                source_of_wealth : str
                    [Optional] Source of wealth.
                tax_identification_number : str
                    Tax identification number. Only applicable for real money account. Required for maltainvest landing company.
                tax_residence : str
                    Residence for tax purpose. Comma separated iso country code if multiple jurisdictions. Only applicable for real money account. Required for maltainvest landing company.
        """

        if args is None:
            args = {}

        config = {
            'accept_risk': {
                'required': 1,
                'type': 'integer'
            },
            'account_opening_reason': {
                'type': 'string'
            },
            'account_turnover': {
                'type': 'string'
            },
            'address_city': {
                'required': 1,
                'type': 'string'
            },
            'address_line_1': {
                'required': 1,
                'type': 'string'
            },
            'address_line_2': {
                'type': 'string'
            },
            'address_postcode': {
                'type': 'string'
            },
            'address_state': {
                'type': 'string'
            },
            'affiliate_token': {
                'type': 'string'
            },
            'binary_options_trading_experience': {
                'type': 'string'
            },
            'binary_options_trading_frequency': {
                'type': 'string'
            },
            'cfd_trading_experience': {
                'type': 'string'
            },
            'cfd_trading_frequency': {
                'type': 'string'
            },
            'citizen': {
                'type': 'string'
            },
            'client_type': {
                'type': 'string'
            },
            'currency': {
                'type': 'string'
            },
            'date_of_birth': {
                'required': 1,
                'type': 'string'
            },
            'education_level': {
                'required': 1,
                'type': 'string'
            },
            'employment_industry': {
                'required': 1,
                'type': 'string'
            },
            'employment_status': {
                'type': 'string'
            },
            'estimated_worth': {
                'required': 1,
                'type': 'string'
            },
            'first_name': {
                'required': 1,
                'type': 'string'
            },
            'forex_trading_experience': {
                'type': 'string'
            },
            'forex_trading_frequency': {
                'type': 'string'
            },
            'income_source': {
                'required': 1,
                'type': 'string'
            },
            'last_name': {
                'required': 1,
                'type': 'string'
            },
            'net_income': {
                'required': 1,
                'type': 'string'
            },
            'new_account_maltainvest': {
                'required': 1,
                'type': 'integer'
            },
            'non_pep_declaration': {
                'type': 'integer'
            },
            'occupation': {
                'required': 1,
                'type': 'string'
            },
            'other_instruments_trading_experience': {
                'type': 'string'
            },
            'other_instruments_trading_frequency': {
                'type': 'string'
            },
            'passthrough': {},
            'phone': {},
            'place_of_birth': {
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            },
            'residence': {
                'required': 1,
                'type': 'string'
            },
            'salutation': {
                'required': 1,
                'type': 'string'
            },
            'secret_answer': {
                'type': 'string'
            },
            'secret_question': {
                'type': 'string'
            },
            'source_of_wealth': {
                'type': 'string'
            },
            'tax_identification_number': {
                'required': 1,
                'type': 'string'
            },
            'tax_residence': {
                'required': 1,
                'type': 'string'
            }
        }

        all_args = {
            'method': 'new_account_maltainvest',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def new_account_real(self, args=None):
        """
        This call opens a new real-money account. This call can be made from a virtual-money or a real-money account. If it is the latter, client information fields in this call will be ignored and data from your existing real-money account will be used.

        Parameters:
        -----------
            args : dict with following keys
                account_opening_reason : str
                    [Optional] Purpose and reason for requesting the account opening.
                account_turnover : str
                    [Optional] The anticipated account turnover.
                address_city : str
                    [Optional] Within 100 characters.
                address_line_1 : str
                    Within 70 characters, with no leading whitespaces and may contain letters/numbers and/or any of following characters '.,:;()@#/-
                address_line_2 : str
                    [Optional] Within 70 characters.
                address_postcode : str
                    [Optional] Within 20 characters and may not contain '+'.
                address_state : str
                    [Optional] Possible value receive from states_list call.
                affiliate_token : str
                    [Optional] Affiliate token, within 32 characters.
                citizen : Any
                    [Optional] Country of legal citizenship, 2-letter country code.
                client_type : str
                    [Optional] Indicates whether this is for a client requesting an account with professional status.
                currency : str
                    [Optional] To set currency of the account. List of supported currencies can be acquired with payout_currencies call.
                date_of_birth : str
                    Date of birth format: yyyy-mm-dd.
                first_name : str
                    Within 2-50 characters, use only letters, spaces, hyphens, full-stops or apostrophes.
                last_name : str
                    Within 2-50 characters, use only letters, spaces, hyphens, full-stops or apostrophes.
                new_account_real : int
                    Must be 1
                non_pep_declaration : int
                    [Optional] Indicates client's self-declaration of not being a PEP/RCA (Politically Exposed Person/Relatives and Close Associates).
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                phone : Any
                    [Optional] Starting with + followed by 9-35 digits, hyphens or space.
                place_of_birth : str
                    [Optional] Place of birth, 2-letter country code.
                req_id : int
                    [Optional] Used to map request to response.
                residence : str
                    2-letter country code, possible value receive from residence_list call.
                salutation : str
                    [Optional] Accept any value in enum list.
                secret_answer : str
                    [Optional] Answer to secret question, within 4-50 characters. Required for new account and existing client details will be used if client open another account.
                secret_question : str
                    [Optional] Accept any value in enum list. Required for new account and existing client details will be used if client open another account.
                tax_identification_number : str
                    [Optional] Tax identification number. Only applicable for real money account. Required for maltainvest landing company.
                tax_residence : str
                    [Optional] Residence for tax purpose. Comma separated iso country code if multiple jurisdictions. Only applicable for real money account. Required for maltainvest landing company.
        """

        if args is None:
            args = {}

        config = {
            'account_opening_reason': {
                'type': 'string'
            },
            'account_turnover': {
                'type': 'string'
            },
            'address_city': {
                'type': 'string'
            },
            'address_line_1': {
                'type': 'string'
            },
            'address_line_2': {
                'type': 'string'
            },
            'address_postcode': {
                'type': 'string'
            },
            'address_state': {
                'type': 'string'
            },
            'affiliate_token': {
                'type': 'string'
            },
            'citizen': {},
            'client_type': {
                'type': 'string'
            },
            'currency': {
                'type': 'string'
            },
            'date_of_birth': {
                'type': 'string'
            },
            'first_name': {
                'type': 'string'
            },
            'last_name': {
                'type': 'string'
            },
            'new_account_real': {
                'required': 1,
                'type': 'integer'
            },
            'non_pep_declaration': {
                'type': 'integer'
            },
            'passthrough': {},
            'phone': {},
            'place_of_birth': {
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            },
            'residence': {
                'type': 'string'
            },
            'salutation': {
                'type': 'string'
            },
            'secret_answer': {
                'type': 'string'
            },
            'secret_question': {
                'type': 'string'
            },
            'tax_identification_number': {
                'type': 'string'
            },
            'tax_residence': {
                'type': 'string'
            }
        }

        all_args = {
            'method': 'new_account_real',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def new_account_virtual(self, args=None):
        """
        Create a new virtual-money account.

        Parameters:
        -----------
            args : dict with following keys
                affiliate_token : str
                    [Optional] Affiliate token, within 32 characters.
                client_password : str
                    Password (Accepts any printable ASCII character. Must be within 8-25 characters, and include numbers, lowercase and uppercase letters. Must not be the same as the user's email address).
                date_first_contact : str
                    [Optional] Date of first contact, format: yyyy-mm-dd in GMT timezone.
                email_consent : int
                    [Optional] Boolean value: 1 or 0, indicating whether the client has given consent for marketing emails.
                gclid_url : str
                    [Optional] Google Click Identifier to track source.
                new_account_virtual : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                residence : str
                    2-letter country code (obtained from residence_list call).
                signup_device : str
                    [Optional] Show whether user has used mobile or desktop.
                type : str
                    Account type
                utm_ad_id : Any
                    [Optional] Identifier of particular ad. Value must match Regex pattern to be recorded
                utm_adgroup_id : Any
                    [Optional] Identifier of ad group in the campaign. Value must match Regex pattern to be recorded
                utm_adrollclk_id : Any
                    [Optional] Unique identifier of click on AdRoll ads platform. Value must match Regex pattern to be recorded
                utm_campaign : Any
                    [Optional] Identifies a specific product promotion or strategic campaign such as a spring sale or other promotions. Value must match Regex pattern to be recorded
                utm_campaign_id : Any
                    [Optional] Identifier of paid ad campaign. Value must match Regex pattern to be recorded
                utm_content : Any
                    [Optional] Used to differentiate similar content, or links within the same ad. Value must match Regex pattern to be recorded
                utm_fbcl_id : Any
                    [Optional] Unique identifier of click on Facebook ads platform. Value must match Regex pattern to be recorded
                utm_gl_client_id : Any
                    [Optional] Unique visitor identifier on Google Ads platform. Value must match Regex pattern to be recorded
                utm_medium : Any
                    [Optional] Identifies the medium the link was used upon such as: email, CPC, or other methods of sharing. Value must match Regex pattern to be recorded
                utm_msclk_id : Any
                    [Optional] Unique click identifier on Microsoft Bing ads platform. Value must match Regex pattern to be recorded
                utm_source : Any
                    [Optional] Identifies the source of traffic such as: search engine, newsletter, or other referral. Value must match Regex pattern to be recorded
                utm_term : Any
                    [Optional] Used to send information related to the campaign term like paid search keywords. Value must match Regex pattern to be recorded
                verification_code : str
                    Email verification code (received from a verify_email call, which must be done first).
        """

        if args is None:
            args = {}

        config = {
            'affiliate_token': {
                'type': 'string'
            },
            'client_password': {
                'type': 'string'
            },
            'date_first_contact': {
                'type': 'string'
            },
            'email_consent': {
                'type': 'integer'
            },
            'gclid_url': {
                'type': 'string'
            },
            'new_account_virtual': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'residence': {
                'type': 'string'
            },
            'signup_device': {
                'type': 'string'
            },
            'type': {
                'type': 'string'
            },
            'utm_ad_id': {},
            'utm_adgroup_id': {},
            'utm_adrollclk_id': {},
            'utm_campaign': {},
            'utm_campaign_id': {},
            'utm_content': {},
            'utm_fbcl_id': {},
            'utm_gl_client_id': {},
            'utm_medium': {},
            'utm_msclk_id': {},
            'utm_source': {},
            'utm_term': {},
            'verification_code': {
                'type': 'string'
            }
        }

        all_args = {
            'method': 'new_account_virtual',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def new_account_wallet(self, args=None):
        """
        Create a new account real-money wallet account.

        Parameters:
        -----------
            args : dict with following keys
                address_city : str
                    [Optional] Within 35 characters.
                address_line_1 : str
                    [Optional] Mailing address.
                address_line_2 : str
                    [Optional] Within 70 characters.
                address_postcode : str
                    [Optional] Within 20 characters and may not contain '+'.
                address_state : str
                    [Optional] Possible value receive from states_list call.
                currency : str
                    [Optional] To set currency of the account. List of supported currencies can be acquired with payout_currencies call.
                date_of_birth : str
                    [Optional] Date of birth format: yyyy-mm-dd.
                first_name : str
                    [Optional] Within 2-50 characters, use only letters, spaces, hyphens, full-stops or apostrophes.
                last_name : str
                    [Optional] Within 2-50 characters, use only letters, spaces, hyphens, full-stops or apostrophes.
                new_account_wallet : int
                    Must be 1
                non_pep_declaration : int
                    [Optional] Indicates client's self-declaration of not being a PEP/RCA (Politically Exposed Person/Relatives and Close Associates).
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                payment_method : str
                    To set method which is used to transfer to/from wallet.
                phone : str
                    [Optional] Starting with + followed by 8-35 digits, allowing hyphens or space.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'address_city': {
                'type': 'string'
            },
            'address_line_1': {
                'type': 'string'
            },
            'address_line_2': {
                'type': 'string'
            },
            'address_postcode': {
                'type': 'string'
            },
            'address_state': {
                'type': 'string'
            },
            'currency': {
                'required': 1,
                'type': 'string'
            },
            'date_of_birth': {
                'type': 'string'
            },
            'first_name': {
                'type': 'string'
            },
            'last_name': {
                'type': 'string'
            },
            'new_account_wallet': {
                'required': 1,
                'type': 'integer'
            },
            'non_pep_declaration': {
                'type': 'integer'
            },
            'passthrough': {},
            'payment_method': {
                'required': 1,
                'type': 'string'
            },
            'phone': {
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'new_account_wallet',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def notification_event(self, args=None):
        """
        Notify the backend about a specific event.

        Parameters:
        -----------
            args : dict with following keys
                args : Any
                category : str
                    The category or nature of the event.
                event : str
                    The name of the event.
                notification_event : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'args': {
                'documents': {}
            },
            'category': {
                'required': 1,
                'type': 'string'
            },
            'event': {
                'required': 1,
                'type': 'string'
            },
            'notification_event': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'notification_event',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def oauth_apps(self, args=None):
        """
        List all my used OAuth applications.

        Parameters:
        -----------
            args : dict with following keys
                oauth_apps : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'oauth_apps': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'oauth_apps',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def p2p_advert_create(self, args=None):
        """
        Creates a P2P (Peer to Peer) advert. Can only be used by an approved P2P advertiser.

        Parameters:
        -----------
            args : dict with following keys
                amount : Number
                    The total amount of the advert, in advertiser's account currency.
                contact_info : str
                    [Optional] Advertiser contact information.
                description : str
                    [Optional] General information about the advert.
                local_currency : str
                    [Optional] Local currency for this advert. If not provided, will use the currency of client's residence by default.
                max_order_amount : Number
                    Maximum allowed amount for the orders of this advert, in advertiser's account_currency. Should be more than or equal to min_order_amount
                min_order_amount : Number
                    Minimum allowed amount for the orders of this advert, in advertiser's account_currency. Should be less than or equal to max_order_amount.
                p2p_advert_create : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                payment_info : str
                    [Optional] Payment instructions.
                payment_method : str
                    [Optional] Payment method name (deprecated).
                payment_method_ids : Any
                    IDs of previously saved payment methods as returned from p2p_advertiser_payment_methods, only applicable for sell ads.
                payment_method_names : Any
                    Payment method identifiers as returned from p2p_payment_methods, only applicable for buy ads.
                rate : Number
                    Conversion rate from advertiser's account currency to local_currency. An absolute rate value (fixed), or percentage offset from current market rate (floating).
                rate_type : str
                    Type of rate, fixed or floating.
                req_id : int
                    [Optional] Used to map request to response.
                type : str
                    The advertisement represents the intention to perform this action on your Deriv account funds.
        """

        if args is None:
            args = {}

        config = {
            'amount': {
                'required': 1,
                'type': 'numeric'
            },
            'contact_info': {
                'type': 'string'
            },
            'description': {
                'type': 'string'
            },
            'local_currency': {
                'type': 'string'
            },
            'max_order_amount': {
                'required': 1,
                'type': 'numeric'
            },
            'min_order_amount': {
                'required': 1,
                'type': 'numeric'
            },
            'p2p_advert_create': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'payment_info': {
                'type': 'string'
            },
            'payment_method': {
                'type': 'string'
            },
            'payment_method_ids': {},
            'payment_method_names': {},
            'rate': {
                'required': 1,
                'type': 'numeric'
            },
            'rate_type': {
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            },
            'type': {
                'required': 1,
                'type': 'string'
            }
        }

        all_args = {
            'method': 'p2p_advert_create',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def p2p_advert_info(self, args=None):
        """
        Retrieve information about a P2P advert.

        Parameters:
        -----------
            args : dict with following keys
                id : str
                    [Optional] The unique identifier for this advert. Optional when subscribe is 1. If not provided, all advertiser adverts will be subscribed.
                p2p_advert_info : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                subscribe : int
                    [Optional] If set to 1, will send updates when changes occur. Optional when id is provided.
                use_client_limits : int
                    [Optional] If set to 1, the maximum order amount will be adjusted to the current balance and turnover limits of the account.
        """

        if args is None:
            args = {}

        config = {
            'id': {
                'type': 'string'
            },
            'p2p_advert_info': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'subscribe': {
                'type': 'integer'
            },
            'use_client_limits': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'p2p_advert_info',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def p2p_advert_list(self, args=None):
        """
        Returns available adverts for use with `p2p_order_create` .

        Parameters:
        -----------
            args : dict with following keys
                advertiser_id : str
                    [Optional] ID of the advertiser to list adverts for.
                advertiser_name : str
                    [Optional] Search for advertiser by name. Partial matches will be returned.
                amount : Number
                    [Optional] How much to buy or sell, used to calculate prices.
                counterparty_type : str
                    [Optional] Filter the adverts by counterparty_type.
                favourites_only : int
                    [Optional] Only show adverts from favourite advertisers. Default is 0.
                limit : int
                    [Optional] Used for paging.
                local_currency : str
                    [Optional] Currency to conduct payment transaction in, defaults to the main currency for the client's country.
                offset : int
                    [Optional] Used for paging.
                p2p_advert_list : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                payment_method : Any
                    [Optional] Search by supported payment methods.
                req_id : int
                    [Optional] Used to map request to response.
                sort_by : str
                    [Optional] How the results are sorted.
                use_client_limits : int
                    [Optional] If set to 1, ads that exceed this account's balance or turnover limits will not be shown.
        """

        if args is None:
            args = {}

        config = {
            'advertiser_id': {
                'type': 'string'
            },
            'advertiser_name': {
                'type': 'string'
            },
            'amount': {
                'type': 'numeric'
            },
            'counterparty_type': {
                'type': 'string'
            },
            'favourites_only': {
                'type': 'integer'
            },
            'limit': {
                'type': 'integer'
            },
            'local_currency': {
                'type': 'string'
            },
            'offset': {
                'type': 'integer'
            },
            'p2p_advert_list': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'payment_method': {},
            'req_id': {
                'type': 'integer'
            },
            'sort_by': {
                'type': 'string'
            },
            'use_client_limits': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'p2p_advert_list',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def p2p_advert_update(self, args=None):
        """
        Updates a P2P advert. Can only be used by the advertiser.

        Parameters:
        -----------
            args : dict with following keys
                contact_info : str
                    [Optional] Advertiser contact information.
                delete : int
                    [Optional] If set to 1, permanently deletes the advert.
                description : str
                    [Optional] General information about the advert.
                id : str
                    The unique identifier for this advert.
                is_active : int
                    [Optional] Activate or deactivate the advert.
                local_currency : str
                    [Optional] Local currency for this advert.
                max_order_amount : Number
                    [Optional] Maximum allowed amount for the orders of this advert, in advertiser's account_currency. Should be more than or equal to min_order_amount.
                min_order_amount : Number
                    [Optional] Minimum allowed amount for the orders of this advert, in advertiser's account_currency. Should be less than or equal to max_order_amount.
                p2p_advert_update : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                payment_info : str
                    [Optional] Payment instructions.
                payment_method_ids : Any
                    [Optional] IDs of previously saved payment methods as returned from p2p_advertiser_payment_methods, only applicable for sell ads. Exisiting methods will be replaced.
                payment_method_names : Any
                    [Optional] Payment method identifiers as returned from p2p_payment_methods, only applicable for buy ads. Exisiting methods will be replaced.
                rate : Number
                    [Optional] Conversion rate from advertiser's account currency to local_currency. An absolute rate value (fixed), or percentage offset from current market rate (floating).
                rate_type : str
                    [Optional] Type of rate, fixed or floating.
                remaining_amount : Number
                    [Optional] The total available amount of the advert, in advertiser's account currency.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'contact_info': {
                'type': 'string'
            },
            'delete': {
                'type': 'integer'
            },
            'description': {
                'type': 'string'
            },
            'id': {
                'required': 1,
                'type': 'string'
            },
            'is_active': {
                'type': 'integer'
            },
            'local_currency': {
                'type': 'string'
            },
            'max_order_amount': {
                'type': 'numeric'
            },
            'min_order_amount': {
                'type': 'numeric'
            },
            'p2p_advert_update': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'payment_info': {
                'type': 'string'
            },
            'payment_method_ids': {},
            'payment_method_names': {},
            'rate': {
                'type': 'numeric'
            },
            'rate_type': {
                'type': 'string'
            },
            'remaining_amount': {
                'type': 'numeric'
            },
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'p2p_advert_update',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def p2p_advertiser_adverts(self, args=None):
        """
        Returns all P2P adverts created by the authorized client. Can only be used by a registered P2P advertiser.

        Parameters:
        -----------
            args : dict with following keys
                limit : int
                    [Optional] Used for paging. This value will also apply to subsription responses.
                offset : int
                    [Optional] Used for paging. This value will also apply to subsription responses.
                p2p_advertiser_adverts : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'limit': {
                'type': 'integer'
            },
            'offset': {
                'type': 'integer'
            },
            'p2p_advertiser_adverts': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'p2p_advertiser_adverts',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def p2p_advertiser_create(self, args=None):
        """
        Registers the client as a P2P advertiser.

        Parameters:
        -----------
            args : dict with following keys
                contact_info : str
                    [Optional] Advertiser's contact information, to be used as a default for new sell adverts.
                default_advert_description : str
                    [Optional] Default description that can be used every time an advert is created.
                name : str
                    The advertiser's displayed name.
                p2p_advertiser_create : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                payment_info : str
                    [Optional] Advertiser's payment information, to be used as a default for new sell adverts.
                req_id : int
                    [Optional] Used to map request to response.
                subscribe : int
                    [Optional] If set to 1, will send updates whenever there is an update to advertiser
        """

        if args is None:
            args = {}

        config = {
            'contact_info': {
                'type': 'string'
            },
            'default_advert_description': {
                'type': 'string'
            },
            'name': {
                'required': 1,
                'type': 'string'
            },
            'p2p_advertiser_create': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'payment_info': {
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            },
            'subscribe': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'p2p_advertiser_create',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def p2p_advertiser_info(self, args=None):
        """
        Retrieve information about a P2P advertiser.

        Parameters:
        -----------
            args : dict with following keys
                id : str
                    [Optional] The unique identifier for this advertiser. If not provided, returns advertiser information about the current account.
                p2p_advertiser_info : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                subscribe : int
                    [Optional] If set to 1, will send updates whenever there is an update to advertiser
        """

        if args is None:
            args = {}

        config = {
            'id': {
                'type': 'string'
            },
            'p2p_advertiser_info': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'subscribe': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'p2p_advertiser_info',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def p2p_advertiser_payment_methods(self, args=None):
        """
        Manage or list P2P advertiser payment methods.

        Parameters:
        -----------
            args : dict with following keys
                create : Any
                    Contains new payment method entries.
                delete : Any
                    Contains payment methods to delete.
                p2p_advertiser_payment_methods : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                update : Any
                    Contains payment methods to update.
        """

        if args is None:
            args = {}

        config = {
            'create': {},
            'delete': {},
            'p2p_advertiser_payment_methods': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'update': {}
        }

        all_args = {
            'method': 'p2p_advertiser_payment_methods',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def p2p_advertiser_relations(self, args=None):
        """
        Updates and returns favourite and blocked advertisers of the current user.

        Parameters:
        -----------
            args : dict with following keys
                add_blocked : Any
                    IDs of advertisers to block.
                add_favourites : Any
                    IDs of advertisers to add as favourites.
                p2p_advertiser_relations : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                remove_blocked : Any
                    IDs of advertisers to remove from blocked.
                remove_favourites : Any
                    IDs of advertisers to remove from favourites.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'add_blocked': {},
            'add_favourites': {},
            'p2p_advertiser_relations': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'remove_blocked': {},
            'remove_favourites': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'p2p_advertiser_relations',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def p2p_advertiser_update(self, args=None):
        """
        Update the information of the P2P advertiser for the current account. Can only be used by an approved P2P advertiser.

        Parameters:
        -----------
            args : dict with following keys
                contact_info : str
                    [Optional] Advertiser's contact information, to be used as a default for new sell adverts.
                default_advert_description : str
                    [Optional] Default description that can be used every time an advert is created.
                is_listed : int
                    [Optional] Used to set if the advertiser's adverts could be listed. When 0, adverts won't be listed regardless of they are active or not. This doesn't change the is_active of each individual advert.
                p2p_advertiser_update : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                payment_info : str
                    [Optional] Advertiser's payment information, to be used as a default for new sell adverts.
                req_id : int
                    [Optional] Used to map request to response.
                show_name : int
                    [Optional] When 1, the advertiser's real name will be displayed on to other users on adverts and orders.
        """

        if args is None:
            args = {}

        config = {
            'contact_info': {
                'type': 'string'
            },
            'default_advert_description': {
                'type': 'string'
            },
            'is_listed': {
                'type': 'integer'
            },
            'p2p_advertiser_update': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'payment_info': {
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            },
            'show_name': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'p2p_advertiser_update',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def p2p_chat_create(self, args=None):
        """
        Creates a P2P chat for the specified order.

        Parameters:
        -----------
            args : dict with following keys
                order_id : str
                    The unique identifier for the order to create the chat for.
                p2p_chat_create : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'order_id': {
                'required': 1,
                'type': 'string'
            },
            'p2p_chat_create': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'p2p_chat_create',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def p2p_order_cancel(self, args=None):
        """
        Cancel a P2P order.

        Parameters:
        -----------
            args : dict with following keys
                id : str
                    The unique identifier for this order.
                p2p_order_cancel : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'id': {
                'required': 1,
                'type': 'string'
            },
            'p2p_order_cancel': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'p2p_order_cancel',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def p2p_order_confirm(self, args=None):
        """
        Confirm a P2P order.

        Parameters:
        -----------
            args : dict with following keys
                id : str
                    The unique identifier for this order.
                p2p_order_confirm : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'id': {
                'required': 1,
                'type': 'string'
            },
            'p2p_order_confirm': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'p2p_order_confirm',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def p2p_order_create(self, args=None):
        """
        Creates a P2P order for the specified advert.

        Parameters:
        -----------
            args : dict with following keys
                advert_id : str
                    The unique identifier for the advert to create an order against.
                amount : Number
                    The amount of currency to be bought or sold.
                contact_info : str
                    [Optional] Seller contact information. Only applicable for 'sell orders'.
                p2p_order_create : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                payment_info : str
                    [Optional] Payment instructions, only applicable for sell orders.
                payment_method_ids : Any
                    IDs of payment methods, only applicable for sell orders.
                rate : Number
                    [Optional] Conversion rate from account currency to local currency, only applicable for floating rate adverts.
                req_id : int
                    [Optional] Used to map request to response.
                subscribe : int
                    [Optional] If set to 1, will send updates whenever there is an update to the order.
        """

        if args is None:
            args = {}

        config = {
            'advert_id': {
                'required': 1,
                'type': 'string'
            },
            'amount': {
                'required': 1,
                'type': 'numeric'
            },
            'contact_info': {
                'type': 'string'
            },
            'p2p_order_create': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'payment_info': {
                'type': 'string'
            },
            'payment_method_ids': {},
            'rate': {
                'type': 'numeric'
            },
            'req_id': {
                'type': 'integer'
            },
            'subscribe': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'p2p_order_create',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def p2p_order_dispute(self, args=None):
        """
        Dispute a P2P order.

        Parameters:
        -----------
            args : dict with following keys
                dispute_reason : str
                    The predefined dispute reason
                id : str
                    The unique identifier for this order.
                p2p_order_dispute : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'dispute_reason': {
                'required': 1,
                'type': 'string'
            },
            'id': {
                'required': 1,
                'type': 'string'
            },
            'p2p_order_dispute': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'p2p_order_dispute',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def p2p_order_info(self, args=None):
        """
        Retrieves the information about a P2P order.

        Parameters:
        -----------
            args : dict with following keys
                id : str
                    The unique identifier for the order.
                p2p_order_info : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                subscribe : int
                    [Optional] If set to 1, will send updates whenever there is an update to order
        """

        if args is None:
            args = {}

        config = {
            'id': {
                'required': 1,
                'type': 'string'
            },
            'p2p_order_info': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'subscribe': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'p2p_order_info',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def p2p_order_list(self, args=None):
        """
        List active orders.

        Parameters:
        -----------
            args : dict with following keys
                active : Number
                    [Optional] Should be 1 to list active, 0 to list inactive (historical).
                advert_id : str
                    [Optional] If present, lists orders applying to a specific advert.
                limit : int
                    [Optional] Used for paging.
                offset : int
                    [Optional] Used for paging.
                p2p_order_list : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                subscribe : int
                    [Optional] If set to 1, will send updates whenever there is a change to any order belonging to you.
        """

        if args is None:
            args = {}

        config = {
            'active': {
                'type': 'numeric'
            },
            'advert_id': {
                'type': 'string'
            },
            'limit': {
                'type': 'integer'
            },
            'offset': {
                'type': 'integer'
            },
            'p2p_order_list': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'subscribe': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'p2p_order_list',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def p2p_order_review(self, args=None):
        """
        Creates a review for the specified order.

        Parameters:
        -----------
            args : dict with following keys
                order_id : str
                    The order identification number.
                p2p_order_review : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                rating : int
                    Rating for the transaction, 1 to 5.
                recommended : Any
                    [Optional] 1 if the counterparty is recommendable to others, otherwise 0.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'order_id': {
                'required': 1,
                'type': 'string'
            },
            'p2p_order_review': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'rating': {
                'required': 1,
                'type': 'integer'
            },
            'recommended': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'p2p_order_review',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def p2p_payment_methods(self, args=None):
        """
        List all P2P payment methods.

        Parameters:
        -----------
            args : dict with following keys
                p2p_payment_methods : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'p2p_payment_methods': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'p2p_payment_methods',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def p2p_ping(self, args=None):
        """
        Keeps the connection alive and updates the P2P advertiser's online status. The advertiser will be considered offline 60 seconds after a call is made.

        Parameters:
        -----------
            args : dict with following keys
                p2p_ping : int
                    Must be 1
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'p2p_ping': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'p2p_ping',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def payment_methods(self, args=None):
        """
        Will return a list payment methods available for the given country. If the request is authenticated the client's residence country will be used.

        Parameters:
        -----------
            args : dict with following keys
                country : str
                    [Optional] 2-letter country code (ISO standard).
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                payment_methods : int
                    Must be 1
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'country': {
                'type': 'string'
            },
            'passthrough': {},
            'payment_methods': {
                'required': 1,
                'type': 'integer'
            },
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'payment_methods',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def paymentagent_create(self, args=None):
        """
        Saves client's payment agent details.

        Parameters:
        -----------
            args : dict with following keys
                affiliate_id : str
                    [Optional] Client's My Affiliate id, if exists.
                code_of_conduct_approval : int
                    Indicates client's agreement with the Code of Conduct.
                commission_deposit : Number
                    Commission  (%) the agent wants to take on deposits
                commission_withdrawal : Number
                    Commission  (%) the agent wants to take on withdrawals
                email : str
                    Payment agent's email address.
                information : str
                    [Optional] Information about payment agent and their proposed service.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                payment_agent_name : str
                    The name with which the payment agent is going to be identified.
                paymentagent_create : int
                    Must be 1
                phone_numbers : Any
                    Payment agent's phone number(s) with country code.
                req_id : int
                    [Optional] Used to map request to response.
                supported_payment_methods : Any
                    A list of supported payment methods.
                urls : Any
                    The URL(s) of payment agent's website(s).
        """

        if args is None:
            args = {}

        config = {
            'affiliate_id': {
                'type': 'string'
            },
            'code_of_conduct_approval': {
                'required': 1,
                'type': 'integer'
            },
            'commission_deposit': {
                'required': 1,
                'type': 'numeric'
            },
            'commission_withdrawal': {
                'required': 1,
                'type': 'numeric'
            },
            'email': {
                'required': 1,
                'type': 'string'
            },
            'information': {
                'required': 1,
                'type': 'string'
            },
            'passthrough': {},
            'payment_agent_name': {
                'required': 1,
                'type': 'string'
            },
            'paymentagent_create': {
                'required': 1,
                'type': 'integer'
            },
            'phone_numbers': {},
            'req_id': {
                'type': 'integer'
            },
            'supported_payment_methods': {
                'required': 1
            },
            'urls': {
                'required': 1
            }
        }

        all_args = {
            'method': 'paymentagent_create',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def paymentagent_details(self, args=None):
        """
        Gets client's payment agent details.

        Parameters:
        -----------
            args : dict with following keys
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                paymentagent_details : int
                    Must be 1
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'passthrough': {},
            'paymentagent_details': {
                'required': 1,
                'type': 'integer'
            },
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'paymentagent_details',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def paymentagent_list(self, args=None):
        """
        Will return a list of Payment Agents for a given country for a given currency. Payment agents allow users to deposit and withdraw funds using local payment methods that might not be available via the main website's cashier system.

        Parameters:
        -----------
            args : dict with following keys
                currency : str
                    [Optional] If specified, only payment agents that supports that currency will be returned (obtained from payout_currencies call).
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                paymentagent_list : str
                    Client's 2-letter country code (obtained from residence_list call).
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'currency': {
                'type': 'string'
            },
            'passthrough': {},
            'paymentagent_list': {
                'required': 1,
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'paymentagent_list',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def paymentagent_transfer(self, args=None):
        """
        Payment Agent Transfer - this call is available only to accounts that are approved Payment Agents.

        Parameters:
        -----------
            args : dict with following keys
                amount : Number
                    The amount to transfer.
                currency : str
                    Currency code.
                description : str
                    [Optional] Remarks about the transfer.
                dry_run : int
                    [Optional] If set to 1, just do validation.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                paymentagent_transfer : int
                    Must be 1
                req_id : int
                    [Optional] Used to map request to response.
                transfer_to : str
                    The loginid of the recipient account.
        """

        if args is None:
            args = {}

        config = {
            'amount': {
                'required': 1,
                'type': 'numeric'
            },
            'currency': {
                'required': 1,
                'type': 'string'
            },
            'description': {
                'type': 'string'
            },
            'dry_run': {
                'type': 'integer'
            },
            'passthrough': {},
            'paymentagent_transfer': {
                'required': 1,
                'type': 'integer'
            },
            'req_id': {
                'type': 'integer'
            },
            'transfer_to': {
                'required': 1,
                'type': 'string'
            }
        }

        all_args = {
            'method': 'paymentagent_transfer',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def paymentagent_withdraw(self, args=None):
        """
        Initiate a withdrawal to an approved Payment Agent.

        Parameters:
        -----------
            args : dict with following keys
                amount : Number
                    The amount to withdraw to the payment agent.
                currency : str
                    The currency code.
                description : str
                    [Optional] Remarks about the withdraw. Only letters, numbers, space, period, comma, - ' are allowed.
                dry_run : int
                    [Optional] If set to 1, just do validation.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                paymentagent_loginid : str
                    The payment agent loginid received from the paymentagent_list call.
                paymentagent_withdraw : int
                    Must be 1
                req_id : int
                    [Optional] Used to map request to response.
                verification_code : str
                    Email verification code (received from a verify_email call, which must be done first)
        """

        if args is None:
            args = {}

        config = {
            'amount': {
                'required': 1,
                'type': 'numeric'
            },
            'currency': {
                'required': 1,
                'type': 'string'
            },
            'description': {
                'type': 'string'
            },
            'dry_run': {
                'type': 'integer'
            },
            'passthrough': {},
            'paymentagent_loginid': {
                'required': 1,
                'type': 'string'
            },
            'paymentagent_withdraw': {
                'required': 1,
                'type': 'integer'
            },
            'req_id': {
                'type': 'integer'
            },
            'verification_code': {
                'required': 1,
                'type': 'string'
            }
        }

        all_args = {
            'method': 'paymentagent_withdraw',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def payout_currencies(self, args=None):
        """
        Retrieve a list of available option payout currencies. If a user is logged in, only the currencies available for the account will be returned.

        Parameters:
        -----------
            args : dict with following keys
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                payout_currencies : int
                    Must be 1
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'passthrough': {},
            'payout_currencies': {
                'required': 1,
                'type': 'integer'
            },
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'payout_currencies',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def ping(self, args=None):
        """
        To send the ping request to the server. Mostly used to test the connection or to keep it alive.

        Parameters:
        -----------
            args : dict with following keys
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                ping : int
                    Must be 1
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'passthrough': {},
            'ping': {
                'required': 1,
                'type': 'integer'
            },
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'ping',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def portfolio(self, args=None):
        """
        Receive information about my current portfolio of outstanding options

        Parameters:
        -----------
            args : dict with following keys
                contract_type : Any
                    Return only contracts of the specified types
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                portfolio : int
                    Must be 1
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'contract_type': {},
            'passthrough': {},
            'portfolio': {
                'required': 1,
                'type': 'integer'
            },
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'portfolio',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def profit_table(self, args=None):
        """
        Retrieve a summary of account Profit Table, according to given search criteria

        Parameters:
        -----------
            args : dict with following keys
                contract_type : Any
                    Return only contracts of the specified types
                date_from : str
                    [Optional] Start date (epoch or YYYY-MM-DD)
                date_to : str
                    [Optional] End date (epoch or YYYY-MM-DD)
                description : int
                    [Optional] If set to 1, will return full contracts description.
                limit : Number
                    [Optional] Apply upper limit to count of transactions received.
                offset : Number
                    [Optional] Number of transactions to skip.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                profit_table : int
                    Must be 1
                req_id : int
                    [Optional] Used to map request to response.
                sort : str
                    [Optional] Sort direction.
        """

        if args is None:
            args = {}

        config = {
            'contract_type': {},
            'date_from': {
                'type': 'string'
            },
            'date_to': {
                'type': 'string'
            },
            'description': {
                'type': 'integer'
            },
            'limit': {
                'type': 'numeric'
            },
            'offset': {
                'type': 'numeric'
            },
            'passthrough': {},
            'profit_table': {
                'required': 1,
                'type': 'integer'
            },
            'req_id': {
                'type': 'integer'
            },
            'sort': {
                'type': 'string'
            }
        }

        all_args = {
            'method': 'profit_table',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def proposal(self, args=None):
        """
        Gets latest price for a specific contract.

        Parameters:
        -----------
            args : dict with following keys
                amount : Number
                    [Optional] Proposed contract payout or stake, or multiplier (for lookbacks).
                barrier : str
                    [Optional] Barrier for the contract (or last digit prediction for digit contracts). Contracts less than 24 hours in duration would need a relative barrier (barriers which need +/-), where entry spot would be adjusted accordingly with that amount to define a barrier, except for Synthetic Indices as they support both relative and absolute barriers. Not needed for lookbacks.
                barrier2 : str
                    [Optional] Low barrier for the contract (for contracts with two barriers). Contracts less than 24 hours in duration would need a relative barrier (barriers which need +/-), where entry spot would be adjusted accordingly with that amount to define a barrier, except for Synthetic Indices as they support both relative and absolute barriers. Not needed for lookbacks.
                barrier_range : str
                    [Optional] Barrier range for callputspread.
                basis : str
                    [Optional] Indicates type of the amount.
                cancellation : str
                    Cancellation duration option (only for MULTUP and MULTDOWN contracts).
                contract_type : str
                    The proposed contract type
                currency : str
                    This can only be the account-holder's currency (obtained from payout_currencies call).
                date_expiry : int
                    [Optional] Epoch value of the expiry time of the contract. Either date_expiry or duration is required.
                date_start : int
                    [Optional] Indicates epoch value of the starting time of the contract. If left empty, the start time of the contract is now.
                duration : int
                    [Optional] Duration quantity. Either date_expiry or duration is required.
                duration_unit : str
                    [Optional] Duration unit - s: seconds, m: minutes, h: hours, d: days, t: ticks.
                limit_order : Any
                multiplier : Number
                    [Optional] The multiplier for non-binary options. E.g. lookbacks.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                product_type : str
                    [Optional] The product type.
                proposal : int
                    Must be 1
                req_id : int
                    [Optional] Used to map request to response.
                selected_tick : int
                    [Optional] The tick that is predicted to have the highest/lowest value - for TICKHIGH and TICKLOW contracts.
                subscribe : int
                    [Optional] 1 - to initiate a realtime stream of prices. Note that tick trades (without a user-defined barrier), digit trades and less than 24 hours at-the-money contracts for the following underlying symbols are not streamed: R_10, R_25, R_50, R_75, R_100, RDBULL, RDBEAR (this is because their price is constant).
                symbol : str
                    The short symbol name (obtained from active_symbols call).
                trading_period_start : int
                    [Optional] Required only for multi-barrier trading. Defines the epoch value of the trading period start time.
        """

        if args is None:
            args = {}

        config = {
            'amount': {
                'type': 'numeric'
            },
            'barrier': {
                'type': 'string'
            },
            'barrier2': {
                'type': 'string'
            },
            'barrier_range': {
                'type': 'string'
            },
            'basis': {
                'type': 'string'
            },
            'cancellation': {
                'type': 'string'
            },
            'contract_type': {
                'required': 1,
                'type': 'string'
            },
            'currency': {
                'required': 1,
                'type': 'string'
            },
            'date_expiry': {
                'type': 'integer'
            },
            'date_start': {
                'type': 'integer'
            },
            'duration': {
                'type': 'integer'
            },
            'duration_unit': {
                'type': 'string'
            },
            'limit_order': {
                'stop_loss': {
                    'type': 'numeric'
                },
                'take_profit': {
                    'type': 'numeric'
                }
            },
            'multiplier': {
                'type': 'numeric'
            },
            'passthrough': {},
            'product_type': {
                'type': 'string'
            },
            'proposal': {
                'required': 1,
                'type': 'integer'
            },
            'req_id': {
                'type': 'integer'
            },
            'selected_tick': {
                'type': 'integer'
            },
            'subscribe': {
                'type': 'integer'
            },
            'symbol': {
                'required': 1,
                'type': 'string'
            },
            'trading_period_start': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'proposal',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def proposal_open_contract(self, args=None):
        """
        Get latest price (and other information) for a contract in the user's portfolio

        Parameters:
        -----------
            args : dict with following keys
                contract_id : int
                    [Optional] Contract ID received from a portfolio request. If not set, you will receive stream of all open contracts.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                proposal_open_contract : int
                    Must be 1
                req_id : int
                    [Optional] Used to map request to response.
                subscribe : int
                    [Optional] 1 to stream.
        """

        if args is None:
            args = {}

        config = {
            'contract_id': {
                'type': 'integer'
            },
            'passthrough': {},
            'proposal_open_contract': {
                'required': 1,
                'type': 'integer'
            },
            'req_id': {
                'type': 'integer'
            },
            'subscribe': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'proposal_open_contract',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def reality_check(self, args=None):
        """
        Retrieve summary of client's trades and account for the Reality Check facility. A 'reality check' means a display of time elapsed since the session began, and associated client profit/loss. The Reality Check facility is a regulatory requirement for certain landing companies.

        Parameters:
        -----------
            args : dict with following keys
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                reality_check : int
                    Must be 1
                req_id : int
                    [Optional] Used to map request to response.
        """

        if args is None:
            args = {}

        config = {
            'passthrough': {},
            'reality_check': {
                'required': 1,
                'type': 'integer'
            },
            'req_id': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'reality_check',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def request_report(self, args=None):
        """
        Send report to client's registered e-mail

        Parameters:
        -----------
            args : dict with following keys
                date_from : int
                    Start date of the report
                date_to : int
                    End date of the report
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                report_type : str
                    Type of report to be sent to client's registered e-mail address
                req_id : int
                    [Optional] Used to map request to response.
                request_report : int
                    Must be 1
        """

        if args is None:
            args = {}

        config = {
            'date_from': {
                'required': 1,
                'type': 'integer'
            },
            'date_to': {
                'required': 1,
                'type': 'integer'
            },
            'passthrough': {},
            'report_type': {
                'required': 1,
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            },
            'request_report': {
                'required': 1,
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'request_report',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def reset_password(self, args=None):
        """
        Reset Password.

        Parameters:
        -----------
            args : dict with following keys
                date_of_birth : str
                    [Optional] Date of birth format: yyyy-mm-dd. Only required for clients with real-money accounts.
                new_password : str
                    New password. For validation (Accepts any printable ASCII character. Must be within 8-25 characters, and include numbers, lowercase and uppercase letters. Must not be the same as the user's email address).
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                reset_password : int
                    Must be 1
                verification_code : str
                    Email verification code (received from a verify_email call, which must be done first)
        """

        if args is None:
            args = {}

        config = {
            'date_of_birth': {
                'type': 'string'
            },
            'new_password': {
                'required': 1,
                'type': 'string'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'reset_password': {
                'required': 1,
                'type': 'integer'
            },
            'verification_code': {
                'required': 1,
                'type': 'string'
            }
        }

        all_args = {
            'method': 'reset_password',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def residence_list(self, args=None):
        """
        This call returns a list of countries and 2-letter country codes, suitable for populating the account opening form.

        Parameters:
        -----------
            args : dict with following keys
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                residence_list : int
                    Must be 1
        """

        if args is None:
            args = {}

        config = {
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'residence_list': {
                'required': 1,
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'residence_list',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def revoke_oauth_app(self, args=None):
        """
        Used for revoking access of particular app.

        Parameters:
        -----------
            args : dict with following keys
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                revoke_oauth_app : int
                    The application ID to revoke.
        """

        if args is None:
            args = {}

        config = {
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'revoke_oauth_app': {
                'required': 1,
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'revoke_oauth_app',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def sell(self, args=None):
        """
        Sell a Contract as identified from a previous `portfolio` call.

        Parameters:
        -----------
            args : dict with following keys
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                price : Number
                    Minimum price at which to sell the contract, or 0 for 'sell at market'.
                req_id : int
                    [Optional] Used to map request to response.
                sell : int
                    Pass contract_id received from the portfolio call.
        """

        if args is None:
            args = {}

        config = {
            'passthrough': {},
            'price': {
                'required': 1,
                'type': 'numeric'
            },
            'req_id': {
                'type': 'integer'
            },
            'sell': {
                'required': 1,
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'sell',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def sell_contract_for_multiple_accounts(self, args=None):
        """
        Sell contracts for multiple accounts simultaneously. Uses the shortcode response from `buy_contract_for_multiple_accounts` to identify the contract, and authorisation tokens to select which accounts to sell those contracts on. Note that only the accounts identified by the tokens will be affected. This will not sell the contract on the currently-authorised account unless you include the token for the current account.

        Parameters:
        -----------
            args : dict with following keys
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                price : Number
                    Minimum price at which to sell the contract, or 0 for 'sell at market'.
                req_id : int
                    [Optional] Used to map request to response.
                sell_contract_for_multiple_accounts : int
                    Must be 1
                shortcode : str
                    An internal ID used to identify the contract which was originally bought. This is returned from the buy and buy_contract_for_multiple_accounts calls.
                tokens : Any
                    Authorisation tokens which select the accounts to sell use for the affected accounts.
        """

        if args is None:
            args = {}

        config = {
            'passthrough': {},
            'price': {
                'required': 1,
                'type': 'numeric'
            },
            'req_id': {
                'type': 'integer'
            },
            'sell_contract_for_multiple_accounts': {
                'required': 1,
                'type': 'integer'
            },
            'shortcode': {
                'required': 1,
                'type': 'string'
            },
            'tokens': {
                'required': 1
            }
        }

        all_args = {
            'method': 'sell_contract_for_multiple_accounts',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def sell_expired(self, args=None):
        """
        This call will try to sell any expired contracts and return the number of sold contracts.

        Parameters:
        -----------
            args : dict with following keys
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                sell_expired : int
                    Must be 1
        """

        if args is None:
            args = {}

        config = {
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'sell_expired': {
                'required': 1,
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'sell_expired',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def service_token(self, args=None):
        """
        Retrieves the authorization token for the specified service.

        Parameters:
        -----------
            args : dict with following keys
                country : str
                    [Optional] The 2-letter country code.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                referrer : str
                    [Optional] The URL of the web page where the Web SDK will be used.
                req_id : int
                    [Optional] Used to map request to response.
                server : str
                    Server (dxtrade only).
                service : Any
                    The service(s) to retrieve token(s) for.
                service_token : int
                    Must be 1
        """

        if args is None:
            args = {}

        config = {
            'country': {
                'type': 'string'
            },
            'passthrough': {},
            'referrer': {
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            },
            'server': {
                'type': 'string'
            },
            'service': {
                'required': 1
            },
            'service_token': {
                'required': 1,
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'service_token',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def set_account_currency(self, args=None):
        """
        Set account currency, this will be default currency for your account i.e currency for trading, deposit. Please note that account currency can only be set once, and then can never be changed.

        Parameters:
        -----------
            args : dict with following keys
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                set_account_currency : str
                    Currency of the account. List of supported currencies can be acquired with payout_currencies call.
        """

        if args is None:
            args = {}

        config = {
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'set_account_currency': {
                'required': 1,
                'type': 'string'
            }
        }

        all_args = {
            'method': 'set_account_currency',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def set_financial_assessment(self, args=None):
        """
        This call sets the financial assessment details based on the client's answers to analyze whether they possess the experience and knowledge to understand the risks involved with binary options trading.

        Parameters:
        -----------
            args : dict with following keys
                account_turnover : str
                    [Optional] The anticipated account turnover.
                binary_options_trading_experience : str
                    [Optional] Binary options trading experience.
                binary_options_trading_frequency : str
                    [Optional] Binary options trading frequency.
                cfd_trading_experience : str
                    [Optional] CFDs trading experience.
                cfd_trading_frequency : str
                    [Optional] CFDs trading frequency.
                education_level : str
                    Level of Education.
                employment_industry : str
                    Industry of Employment.
                employment_status : str
                    [Optional] Employment Status.
                estimated_worth : str
                    Estimated Net Worth.
                forex_trading_experience : str
                    [Optional] Forex trading experience.
                forex_trading_frequency : str
                    [Optional] Forex trading frequency.
                income_source : str
                    Income Source.
                net_income : str
                    Net Annual Income.
                occupation : str
                    Occupation.
                other_instruments_trading_experience : str
                    [Optional] Trading experience in other financial instruments.
                other_instruments_trading_frequency : str
                    [Optional] Trading frequency in other financial instruments.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                set_financial_assessment : int
                    Must be 1
                source_of_wealth : str
                    [Optional] Source of wealth.
        """

        if args is None:
            args = {}

        config = {
            'account_turnover': {
                'type': 'string'
            },
            'binary_options_trading_experience': {
                'type': 'string'
            },
            'binary_options_trading_frequency': {
                'type': 'string'
            },
            'cfd_trading_experience': {
                'type': 'string'
            },
            'cfd_trading_frequency': {
                'type': 'string'
            },
            'education_level': {
                'required': 1,
                'type': 'string'
            },
            'employment_industry': {
                'required': 1,
                'type': 'string'
            },
            'employment_status': {
                'type': 'string'
            },
            'estimated_worth': {
                'required': 1,
                'type': 'string'
            },
            'forex_trading_experience': {
                'type': 'string'
            },
            'forex_trading_frequency': {
                'type': 'string'
            },
            'income_source': {
                'required': 1,
                'type': 'string'
            },
            'net_income': {
                'required': 1,
                'type': 'string'
            },
            'occupation': {
                'required': 1,
                'type': 'string'
            },
            'other_instruments_trading_experience': {
                'type': 'string'
            },
            'other_instruments_trading_frequency': {
                'type': 'string'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'set_financial_assessment': {
                'required': 1,
                'type': 'integer'
            },
            'source_of_wealth': {
                'type': 'string'
            }
        }

        all_args = {
            'method': 'set_financial_assessment',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def set_self_exclusion(self, args=None):
        """
        Set Self-Exclusion (this call should be used in conjunction with `get_self_exclusion`)

        Parameters:
        -----------
            args : dict with following keys
                exclude_until : Any
                    [Optional] Exclude me from the website (for a minimum of 6 months, up to a maximum of 5 years). Note: uplifting this self-exclusion may require contacting the company.
                max_30day_deposit : Any
                    [Optional] 7-day limit on deposits.
                max_30day_losses : Any
                    [Optional] 30-day limit on losses.
                max_30day_turnover : Any
                    [Optional] 30-day turnover limit.
                max_7day_deposit : Any
                    [Optional] 7-day limit on deposits.
                max_7day_losses : Any
                    [Optional] 7-day limit on losses.
                max_7day_turnover : Any
                    [Optional] 7-day turnover limit.
                max_balance : Any
                    [Optional] Maximum account cash balance.
                max_deposit : Any
                    [Optional] Daily deposit limit.
                max_losses : Any
                    [Optional] Daily limit on losses.
                max_open_bets : Any
                    [Optional] Maximum number of open positions.
                max_turnover : Any
                    [Optional] Daily turnover limit.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                session_duration_limit : Any
                    [Optional] Session duration limit, in minutes.
                set_self_exclusion : int
                    Must be 1
                timeout_until : Any
                    [Optional] Exclude me from the website (for up to 6 weeks). Requires time in epoch format. Note: unlike exclude_until, this self-exclusion will be lifted automatically at the expiry of the timeout period.
        """

        if args is None:
            args = {}

        config = {
            'exclude_until': {},
            'max_30day_deposit': {},
            'max_30day_losses': {},
            'max_30day_turnover': {},
            'max_7day_deposit': {},
            'max_7day_losses': {},
            'max_7day_turnover': {},
            'max_balance': {},
            'max_deposit': {},
            'max_losses': {},
            'max_open_bets': {},
            'max_turnover': {},
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'session_duration_limit': {},
            'set_self_exclusion': {
                'required': 1,
                'type': 'integer'
            },
            'timeout_until': {}
        }

        all_args = {
            'method': 'set_self_exclusion',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def set_settings(self, args=None):
        """
        Set User Settings (this call should be used in conjunction with `get_settings`)

        Parameters:
        -----------
            args : dict with following keys
                account_opening_reason : str
                    [Optional] Purpose and reason for requesting the account opening. Only applicable for real money account. Required for clients that have not set it yet. Can only be set once.
                address_city : str
                    [Optional] Note: not applicable for virtual account. Required field for real money account.
                address_line_1 : str
                    [Optional] Note: not applicable for virtual account. Required field for real money account.
                address_line_2 : Any
                    [Optional] Note: not applicable for virtual account. Optional field for real money account.
                address_postcode : str
                    [Optional] Note: not applicable for virtual account. Optional field for real money account.
                address_state : str
                    [Optional] Note: not applicable for virtual account. Optional field for real money account.
                allow_copiers : int
                    [Optional] Boolean value 1 or 0, indicating permission to allow others to follow your trades. Note: not applicable for Virtual account. Only allow for real money account.
                citizen : Any
                    [Optional] Country of legal citizenship, 2-letter country code.
                date_of_birth : str
                    [Optional] Date of birth format: yyyy-mm-dd (can only be changed on unauthenticated svg accounts).
                email_consent : int
                    [Optional] Boolean value 1 or 0, indicating permission to use email address for any contact which may include marketing
                feature_flag : Any
                first_name : str
                    [Optional] Within 2-50 characters, use only letters, spaces, hyphens, full-stops or apostrophes (can only be changed on unauthenticated svg accounts).
                last_name : str
                    [Optional] Within 2-50 characters, use only letters, spaces, hyphens, full-stops or apostrophes (can only be changed on unauthenticated svg accounts).
                non_pep_declaration : int
                    [Optional] Indicates client's self-declaration of not being a PEP/RCA (Politically Exposed Person/Relatives and Close Associates). Effective for real accounts only.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                phone : Any
                    [Optional] Note: not applicable for virtual account. Starting with + followed by 9-35 digits, hyphens or space.
                place_of_birth : str
                    [Optional] Place of birth, 2-letter country code.
                preferred_language : Any
                    [Optional] User's preferred language, ISO standard language code
                req_id : int
                    [Optional] Used to map request to response.
                request_professional_status : int
                    [Optional] Required when client wants to be treated as professional. Applicable for financial accounts only.
                residence : Any
                    [Optional] 2-letter country code. Note: not applicable for real money account. Only allow for Virtual account without residence set.
                salutation : str
                    [Optional] Accept any value in enum list (can only be changed on unauthenticated svg accounts).
                secret_answer : str
                    [Optional] Answer to secret question, within 4-50 characters. Required for new account and existing client details will be used if client opens another account.
                secret_question : str
                    [Optional] Accept any value in enum list. Required for new account and existing client details will be used if client opens another account.
                set_settings : int
                    Must be 1
                tax_identification_number : str
                    [Optional] Tax identification number. Only applicable for real money account. Required for maltainvest landing company.
                tax_residence : str
                    [Optional] Residence for tax purpose. Comma separated iso country code if multiple jurisdictions. Only applicable for real money account. Required for maltainvest landing company.
        """

        if args is None:
            args = {}

        config = {
            'account_opening_reason': {
                'type': 'string'
            },
            'address_city': {
                'type': 'string'
            },
            'address_line_1': {
                'type': 'string'
            },
            'address_line_2': {},
            'address_postcode': {
                'type': 'string'
            },
            'address_state': {
                'type': 'string'
            },
            'allow_copiers': {
                'type': 'integer'
            },
            'citizen': {},
            'date_of_birth': {
                'type': 'string'
            },
            'email_consent': {
                'type': 'integer'
            },
            'feature_flag': {
                'wallet': {
                    'type': 'integer'
                }
            },
            'first_name': {
                'type': 'string'
            },
            'last_name': {
                'type': 'string'
            },
            'non_pep_declaration': {
                'type': 'integer'
            },
            'passthrough': {},
            'phone': {},
            'place_of_birth': {
                'type': 'string'
            },
            'preferred_language': {},
            'req_id': {
                'type': 'integer'
            },
            'request_professional_status': {
                'type': 'integer'
            },
            'residence': {},
            'salutation': {
                'type': 'string'
            },
            'secret_answer': {
                'type': 'string'
            },
            'secret_question': {
                'type': 'string'
            },
            'set_settings': {
                'required': 1,
                'type': 'integer'
            },
            'tax_identification_number': {
                'type': 'string'
            },
            'tax_residence': {
                'type': 'string'
            }
        }

        all_args = {
            'method': 'set_settings',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def statement(self, args=None):
        """
        Retrieve a summary of account transactions, according to given search criteria

        Parameters:
        -----------
            args : dict with following keys
                action_type : str
                    [Optional] To filter the statement according to the type of transaction.
                date_from : int
                    [Optional] Start date (epoch)
                date_to : int
                    [Optional] End date (epoch)
                description : int
                    [Optional] If set to 1, will return full contracts description.
                limit : Number
                    [Optional] Maximum number of transactions to receive.
                offset : Number
                    [Optional] Number of transactions to skip.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                statement : int
                    Must be 1
        """

        if args is None:
            args = {}

        config = {
            'action_type': {
                'type': 'string'
            },
            'date_from': {
                'type': 'integer'
            },
            'date_to': {
                'type': 'integer'
            },
            'description': {
                'type': 'integer'
            },
            'limit': {
                'type': 'numeric'
            },
            'offset': {
                'type': 'numeric'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'statement': {
                'required': 1,
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'statement',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def states_list(self, args=None):
        """
        For a given country, returns a list of States of that country. This is useful to populate the account opening form.

        Parameters:
        -----------
            args : dict with following keys
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                states_list : str
                    Client's 2-letter country code (obtained from residence_list call)
        """

        if args is None:
            args = {}

        config = {
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'states_list': {
                'required': 1,
                'type': 'string'
            }
        }

        all_args = {
            'method': 'states_list',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def ticks(self, args=None):
        """
        Initiate a continuous stream of spot price updates for a given symbol.

        Parameters:
        -----------
            args : dict with following keys
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                subscribe : int
                    [Optional] If set to 1, will send updates whenever a new tick is received.
                ticks : Any
                    The short symbol name or array of symbols (obtained from active_symbols call).
        """

        if args is None:
            args = {}

        config = {
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'subscribe': {
                'type': 'integer'
            },
            'ticks': {
                'required': 1
            }
        }

        all_args = {
            'method': 'ticks',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def ticks_history(self, args=None):
        """
        Get historic tick data for a given symbol.

        Parameters:
        -----------
            args : dict with following keys
                adjust_start_time : int
                    [Optional] 1 - if the market is closed at the end time, or license limit is before end time, adjust interval backwards to compensate.
                count : int
                    [Optional] An upper limit on ticks to receive.
                end : str
                    Epoch value representing the latest boundary of the returned ticks. If latest is specified, this will be the latest available timestamp.
                granularity : int
                    [Optional] Only applicable for style: candles. Candle time-dimension width setting. (default: 60).
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                start : int
                    [Optional] Epoch value representing the earliest boundary of the returned ticks. 
- For "style": "ticks": this will default to 1 day ago.
- For "style": "candles": it will default to 1 day ago if count or granularity is undefined.
                style : str
                    [Optional] The tick-output style.
                subscribe : int
                    [Optional] 1 - to send updates whenever a new tick is received.
                ticks_history : str
                    Short symbol name (obtained from the active_symbols call).
        """

        if args is None:
            args = {}

        config = {
            'adjust_start_time': {
                'type': 'integer'
            },
            'count': {
                'type': 'integer'
            },
            'end': {
                'required': 1,
                'type': 'string'
            },
            'granularity': {
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'start': {
                'type': 'integer'
            },
            'style': {
                'type': 'string'
            },
            'subscribe': {
                'type': 'integer'
            },
            'ticks_history': {
                'required': 1,
                'type': 'string'
            }
        }

        all_args = {
            'method': 'ticks_history',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def time(self, args=None):
        """
        Request back-end server epoch time.

        Parameters:
        -----------
            args : dict with following keys
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                time : int
                    Must be 1
        """

        if args is None:
            args = {}

        config = {
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'time': {
                'required': 1,
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'time',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def tnc_approval(self, args=None):
        """
        To approve the latest version of terms and conditions.

        Parameters:
        -----------
            args : dict with following keys
                affiliate_coc_agreement : int
                    [Optional] For Affiliate's Code of Conduct Agreement.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                tnc_approval : Number
                    Must be 1
                ukgc_funds_protection : int
                    [Optional] For ASK_UK_FUNDS_PROTECTION in cashier.
        """

        if args is None:
            args = {}

        config = {
            'affiliate_coc_agreement': {
                'type': 'integer'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'tnc_approval': {
                'required': 1,
                'type': 'numeric'
            },
            'ukgc_funds_protection': {
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'tnc_approval',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def topup_virtual(self, args=None):
        """
        When a virtual-money's account balance becomes low, it can be topped up using this call.

        Parameters:
        -----------
            args : dict with following keys
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                topup_virtual : int
                    Must be 1
        """

        if args is None:
            args = {}

        config = {
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'topup_virtual': {
                'required': 1,
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'topup_virtual',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def trading_durations(self, args=None):
        """
        Retrieve a list of all available underlyings and the corresponding contract types and trading duration boundaries. If the user is logged in, only the assets available for that user's landing company will be returned.

        Parameters:
        -----------
            args : dict with following keys
                landing_company : str
                    [Optional] If specified, will return only the underlyings for the specified landing company.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                trading_durations : int
                    Must be 1
        """

        if args is None:
            args = {}

        config = {
            'landing_company': {
                'type': 'string'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'trading_durations': {
                'required': 1,
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'trading_durations',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def trading_platform_accounts(self, args=None):
        """
        Get list of Trading Platform accounts for client

        Parameters:
        -----------
            args : dict with following keys
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                platform : str
                    Trading platform name
                req_id : int
                    [Optional] Used to map request to response.
                trading_platform_accounts : int
                    Must be 1
        """

        if args is None:
            args = {}

        config = {
            'passthrough': {},
            'platform': {
                'required': 1,
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            },
            'trading_platform_accounts': {
                'required': 1,
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'trading_platform_accounts',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def trading_platform_deposit(self, args=None):
        """
        Deposit funds from wallet account to trading platform account

        Parameters:
        -----------
            args : dict with following keys
                amount : Number
                    Amount to deposit (in the currency of from_wallet).
                from_account : str
                    Wallet account to transfer money from.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                platform : str
                    Name of trading platform.
                req_id : int
                    [Optional] Used to map request to response.
                to_account : str
                    Trading account login to deposit money to.
                trading_platform_deposit : int
                    Must be 1
        """

        if args is None:
            args = {}

        config = {
            'amount': {
                'type': 'numeric'
            },
            'from_account': {
                'type': 'string'
            },
            'passthrough': {},
            'platform': {
                'required': 1,
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            },
            'to_account': {
                'required': 1,
                'type': 'string'
            },
            'trading_platform_deposit': {
                'required': 1,
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'trading_platform_deposit',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def trading_platform_investor_password_change(self, args=None):
        """
        Change the Trading Platform investor password

        Parameters:
        -----------
            args : dict with following keys
                account_id : str
                    Trading account ID.
                new_password : str
                    New investor password. Accepts any printable ASCII character. Must be within 8-25 characters, and include numbers, lowercase and uppercase letters. Must not be the same as the user's email address.
                old_password : str
                    Old investor password for validation (non-empty string, accepts any printable ASCII character)
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                platform : str
                    Name of trading platform.
                req_id : int
                    [Optional] Used to map request to response.
                trading_platform_investor_password_change : Number
                    Must be 1
        """

        if args is None:
            args = {}

        config = {
            'account_id': {
                'required': 1,
                'type': 'string'
            },
            'new_password': {
                'required': 1,
                'type': 'string'
            },
            'old_password': {
                'required': 1,
                'type': 'string'
            },
            'passthrough': {},
            'platform': {
                'required': 1,
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            },
            'trading_platform_investor_password_change': {
                'required': 1,
                'type': 'numeric'
            }
        }

        all_args = {
            'method': 'trading_platform_investor_password_change',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def trading_platform_investor_password_reset(self, args=None):
        """
        Reset the investor password of a Trading Platform Account

        Parameters:
        -----------
            args : dict with following keys
                account_id : str
                    Trading account ID.
                new_password : str
                    New password of the account. For validation (Accepts any printable ASCII character. Must be within 8-25 characters, and include numbers, lowercase and uppercase letters. Must not be the same as the user's email address).
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                platform : str
                    Name of trading platform.
                req_id : int
                    [Optional] Used to map request to response.
                trading_platform_investor_password_reset : int
                    Must be 1
                verification_code : str
                    Email verification code (received from a verify_email call, which must be done first)
        """

        if args is None:
            args = {}

        config = {
            'account_id': {
                'required': 1,
                'type': 'string'
            },
            'new_password': {
                'required': 1,
                'type': 'string'
            },
            'passthrough': {},
            'platform': {
                'required': 1,
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            },
            'trading_platform_investor_password_reset': {
                'required': 1,
                'type': 'integer'
            },
            'verification_code': {
                'required': 1,
                'type': 'string'
            }
        }

        all_args = {
            'method': 'trading_platform_investor_password_reset',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def trading_platform_new_account(self, args=None):
        """
        This call creates new Trading account, either demo or real money.

        Parameters:
        -----------
            args : dict with following keys
                account_type : str
                    Account type.
                currency : str
                    [Optional] Trading account currency, the default value will be the qualified account currency.
                dry_run : int
                    [Optional] If set to 1, only validation is performed.
                market_type : str
                    Market type
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                password : str
                    The master password of the account. For validation (Accepts any printable ASCII character. Must be within 8-25 characters, and include numbers, lowercase and uppercase letters. Must not be the same as the user's email address). This field is required.
                platform : str
                    Name of trading platform.
                req_id : int
                    [Optional] Used to map request to response.
                sub_account_type : str
                    [Optional] Sub account type.
                trading_platform_new_account : int
                    Must be 1
        """

        if args is None:
            args = {}

        config = {
            'account_type': {
                'required': 1,
                'type': 'string'
            },
            'currency': {
                'type': 'string'
            },
            'dry_run': {
                'type': 'integer'
            },
            'market_type': {
                'required': 1,
                'type': 'string'
            },
            'passthrough': {},
            'password': {
                'required': 1,
                'type': 'string'
            },
            'platform': {
                'required': 1,
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            },
            'sub_account_type': {
                'type': 'string'
            },
            'trading_platform_new_account': {
                'required': 1,
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'trading_platform_new_account',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def trading_platform_password_change(self, args=None):
        """
        Change the Trading Platform password

        Parameters:
        -----------
            args : dict with following keys
                new_password : str
                    New trading password. Accepts any printable ASCII character. Must be within 8-25 characters, and include numbers, lowercase and uppercase letters. Must not be the same as the user's email address.
                old_password : str
                    Old password for validation. Must be empty if a password has not been set yet.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                platform : str
                    Name of trading platform.
                req_id : int
                    [Optional] Used to map request to response.
                trading_platform_password_change : Number
                    Must be 1
        """

        if args is None:
            args = {}

        config = {
            'new_password': {
                'required': 1,
                'type': 'string'
            },
            'old_password': {
                'type': 'string'
            },
            'passthrough': {},
            'platform': {
                'required': 1,
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            },
            'trading_platform_password_change': {
                'required': 1,
                'type': 'numeric'
            }
        }

        all_args = {
            'method': 'trading_platform_password_change',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def trading_platform_password_reset(self, args=None):
        """
        Reset the password of a Trading Platform Account

        Parameters:
        -----------
            args : dict with following keys
                new_password : str
                    New password of the account. For validation (Accepts any printable ASCII character. Must be within 8-25 characters, and include numbers, lowercase and uppercase letters. Must not be the same as the user's email address).
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                platform : str
                    Name of trading platform.
                req_id : int
                    [Optional] Used to map request to response.
                trading_platform_password_reset : int
                    Must be 1
                verification_code : str
                    Email verification code (received from a verify_email call, which must be done first)
        """

        if args is None:
            args = {}

        config = {
            'new_password': {
                'required': 1,
                'type': 'string'
            },
            'passthrough': {},
            'platform': {
                'required': 1,
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            },
            'trading_platform_password_reset': {
                'required': 1,
                'type': 'integer'
            },
            'verification_code': {
                'required': 1,
                'type': 'string'
            }
        }

        all_args = {
            'method': 'trading_platform_password_reset',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def trading_platform_product_listing(self, args=None):
        """
        Get list of Trading Platform products for client

        Parameters:
        -----------
            args : dict with following keys
                app_id : Any
                    [Optional] Specific application app_id.
                country_code : str
                    [Optional] Country of legal citizenship, 2-letter country code.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                trading_platform_product_listing : int
                    Must be 1.
        """

        if args is None:
            args = {}

        config = {
            'app_id': {},
            'country_code': {
                'required': 1,
                'type': 'string'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'trading_platform_product_listing': {
                'required': 1,
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'trading_platform_product_listing',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def trading_platform_withdrawal(self, args=None):
        """
        This call allows withdrawal from Trading account to a wallet account.

        Parameters:
        -----------
            args : dict with following keys
                amount : Number
                    Amount to withdraw (in the currency of the Trading account).
                from_account : str
                    Trading account login to withdraw money from.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                platform : str
                    Name of trading platform.
                req_id : int
                    [Optional] Used to map request to response.
                to_account : str
                    Wallet account loginid to transfer money to.
                trading_platform_withdrawal : int
                    Must be 1
        """

        if args is None:
            args = {}

        config = {
            'amount': {
                'required': 1,
                'type': 'numeric'
            },
            'from_account': {
                'required': 1,
                'type': 'string'
            },
            'passthrough': {},
            'platform': {
                'required': 1,
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            },
            'to_account': {
                'required': 1,
                'type': 'string'
            },
            'trading_platform_withdrawal': {
                'required': 1,
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'trading_platform_withdrawal',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def trading_servers(self, args=None):
        """
        Get the list of servers for a trading platform.

        Parameters:
        -----------
            args : dict with following keys
                account_type : str
                    [Optional] Trading account type.
                environment : str
                    [Optional] Pass the environment (installation) instance. Currently, there are one demo and two real environments. Defaults to 'all'.
                market_type : str
                    [Optional] Market type.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                platform : str
                    [Optional] Pass the trading platform name, default to mt5
                req_id : int
                    [Optional] Used to map request to response.
                trading_servers : int
                    Must be 1
        """

        if args is None:
            args = {}

        config = {
            'account_type': {
                'type': 'string'
            },
            'environment': {
                'type': 'string'
            },
            'market_type': {
                'type': 'string'
            },
            'passthrough': {},
            'platform': {
                'type': 'string'
            },
            'req_id': {
                'type': 'integer'
            },
            'trading_servers': {
                'required': 1,
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'trading_servers',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def trading_times(self, args=None):
        """
        Receive a list of market opening times for a given date.

        Parameters:
        -----------
            args : dict with following keys
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                trading_times : str
                    Date to receive market opening times for. (yyyy-mm-dd format. today can also be specified).
        """

        if args is None:
            args = {}

        config = {
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'trading_times': {
                'required': 1,
                'type': 'string'
            }
        }

        all_args = {
            'method': 'trading_times',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def transaction(self, args=None):
        """
        Subscribe to transaction notifications

        Parameters:
        -----------
            args : dict with following keys
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                subscribe : int
                    If set to 1, will send updates whenever there is an update to transactions. If not to 1 then it will not return any records.
                transaction : int
                    Must be 1
        """

        if args is None:
            args = {}

        config = {
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'subscribe': {
                'required': 1,
                'type': 'integer'
            },
            'transaction': {
                'required': 1,
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'transaction',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def transfer_between_accounts(self, args=None):
        """
        This call allows transfers between accounts held by a given user. Transfer funds between your fiat and cryptocurrency accounts (for a fee). Please note that account_from should be same as current authorized account.

        Parameters:
        -----------
            args : dict with following keys
                account_from : str
                    [Optional] The loginid of the account to transfer funds from.
                account_to : str
                    [Optional] The loginid of the account to transfer funds to.
                accounts : str
                    [Optional] To control the list of accounts returned when account_from or account_to is not provided. brief (default value) means that accounts with mt5 account_type will be excluded; it will run faster. all means that all accounts with any account_type (including mt5) will be returned.
                amount : Number
                    [Optional] The amount to transfer.
                currency : str
                    [Optional] Currency code.
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                transfer_between_accounts : int
                    If account_from or account_to is not provided, it just returns the available accounts.
        """

        if args is None:
            args = {}

        config = {
            'account_from': {
                'type': 'string'
            },
            'account_to': {
                'type': 'string'
            },
            'accounts': {
                'type': 'string'
            },
            'amount': {
                'type': 'numeric'
            },
            'currency': {
                'type': 'string'
            },
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'transfer_between_accounts': {
                'required': 1,
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'transfer_between_accounts',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def verify_email(self, args=None):
        """
        Verify an email address for various purposes. The system will send an email to the address containing a security code for verification.

        Parameters:
        -----------
            args : dict with following keys
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                type : str
                    Purpose of the email verification call.
                url_parameters : Any
                verify_email : str
                    Email address to be verified.
        """

        if args is None:
            args = {}

        config = {
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'type': {
                'required': 1,
                'type': 'string'
            },
            'url_parameters': {
                'affiliate_token': {
                    'type': 'string'
                },
                'date_first_contact': {
                    'type': 'string'
                },
                'gclid_url': {
                    'type': 'string'
                },
                'pa_amount': {
                    'type': 'numeric'
                },
                'pa_currency': {
                    'type': 'string'
                },
                'pa_loginid': {
                    'type': 'string'
                },
                'pa_remarks': {
                    'type': 'string'
                },
                'redirect_to': {
                    'type': 'integer'
                },
                'signup_device': {
                    'type': 'string'
                },
                'utm_ad_id': {},
                'utm_adgroup_id': {},
                'utm_adrollclk_id': {},
                'utm_campaign': {},
                'utm_campaign_id': {},
                'utm_content': {},
                'utm_fbcl_id': {},
                'utm_gl_client_id': {},
                'utm_medium': {},
                'utm_msclk_id': {},
                'utm_source': {},
                'utm_term': {}
            },
            'verify_email': {
                'required': 1,
                'type': 'string'
            }
        }

        all_args = {
            'method': 'verify_email',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def website_status(self, args=None):
        """
        Request server status.

        Parameters:
        -----------
            args : dict with following keys
                passthrough : Any
                    [Optional] Used to pass data through the websocket, which may be retrieved via the echo_req output field.
                req_id : int
                    [Optional] Used to map request to response.
                subscribe : int
                    [Optional] 1 to stream the server/website status updates.
                website_status : int
                    Must be 1
        """

        if args is None:
            args = {}

        config = {
            'passthrough': {},
            'req_id': {
                'type': 'integer'
            },
            'subscribe': {
                'type': 'integer'
            },
            'website_status': {
                'required': 1,
                'type': 'integer'
            }
        }

        all_args = {
            'method': 'website_status',
            'needs_method_arg': '1',
            'args': args,
            'config': config,
        }

        return await self.process_request(all_args)

    async def process_request(self, all_args):
        """
        Process request
        """

        config = all_args['config']
        parsed_args = parse_args(all_args)
        error = validate_args(config=config, args=parsed_args)
        if error:
            raise ValueError(error)
        return await self.send(parsed_args)

__pdoc__ = {
    'parse_args' : False,
    'validate_args' : False,
    'deriv_api.deriv_api_calls.DerivAPICalls.process_request' : False
}

def parse_args(all_args):
    """
    Parse request args
    """

    parsed_args = all_args['args']
    method = all_args['method']
    
    if all_args['needs_method_arg'] and not(isinstance(parsed_args, dict)):
        parsed_args = {method: parsed_args}

    parsed_args[method] = parsed_args.get(method, 1)
    
    config = all_args['config']
    for param in parsed_args:
        value = parsed_args[param]
        if not (param in config):
            return

        ptype = config[param].get('type')
        if ptype and ptype == 'string':
            parsed_args[param] = f'{value}'
        elif ptype and (ptype == 'numeric' or ptype == 'boolean'):
            parsed_args[param] = int(float(value))
            
    return parsed_args


type_checkers = {
    'dict': lambda value: isinstance(value, dict),
    'numeric': lambda value: isinstance(value, Number),
    'string': lambda value: isinstance(value, str),
    'boolean': lambda value: value in [True, False, 0, 1],
    'integer': lambda value: isinstance(value, int)
}


def validate_args(config, args):
    """
    Validate request args
    """

    if not isinstance(args, dict):
        return f"Requires an dict but a {type(args)} is passed."

    error_messages = []
    missing = [k for k in config.keys() if (config.get(k) or {}).get('required') and not (k in args)]
    if len(missing):
        error_messages.append(f'Required parameters missing: {", ".join(missing)}')

    for param in args.keys():
        value = args[param]
        if param not in config:
            continue
        expected_type = config[param].get('type')

        if not expected_type:
            continue

        checker = type_checkers.get(expected_type)
        if not checker or not checker(value):
            error_messages.append(f'{expected_type} value expected but found {type(value)}: {param}')

    return ' - '.join(error_messages) if len(error_messages) else ''
