# generated by datamodel-codegen:
#   filename:  analytics/reportDataType/aggregatedCostAnalysisReportData.json
#   timestamp: 2025-09-05T11:33:06+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class DataAssetValues(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    threeDays: Annotated[
        Optional[float], Field(None, description='Data Asset Count or Size for 3 days')
    ]
    sevenDays: Annotated[
        Optional[float], Field(None, description='Data Asset Count or Size for 7 days')
    ]
    fourteenDays: Annotated[
        Optional[float], Field(None, description='Data Asset Count or Size for 14 days')
    ]
    thirtyDays: Annotated[
        Optional[float], Field(None, description='Data Asset Count or Size for 30 days')
    ]
    sixtyDays: Annotated[
        Optional[float], Field(None, description='Data Asset Count or Size for 60 days')
    ]


class DataAssetMetrics(BaseModel):
    size: Annotated[
        Optional[DataAssetValues],
        Field(None, description='Size of the Data Assets over a period of time'),
    ]
    count: Annotated[
        Optional[DataAssetValues],
        Field(None, description='Count of the Data Assets over a period of time'),
    ]
    totalSize: Annotated[
        Optional[float], Field(None, description='Total Size based in Bytes')
    ]
    totalCount: Annotated[Optional[float], Field(None, description='Total Count')]


class AggregatedCostAnalysisReportData(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    unusedDataAssets: Annotated[
        Optional[DataAssetMetrics],
        Field(
            None,
            description='Count and Size of the unused Data Assets over a period of time',
        ),
    ]
    frequentlyUsedDataAssets: Annotated[
        Optional[DataAssetMetrics],
        Field(
            None,
            description='Count and Size of the frequently used Data Assets over a period of time',
        ),
    ]
    totalSize: Annotated[
        Optional[float], Field(None, description='Total Size based in Bytes')
    ]
    totalCount: Annotated[Optional[float], Field(None, description='Total Count')]
    serviceName: Annotated[
        Optional[str], Field(None, description='Name of the service')
    ]
    serviceType: Annotated[
        Optional[str], Field(None, description='Type of the service')
    ]
    entityType: Annotated[Optional[str], Field(None, description='Type of the entity')]
    serviceOwner: Annotated[
        Optional[str], Field(None, description='Name of the service owner')
    ]
