# generated by datamodel-codegen:
#   filename:  api/data/createDirectory.json
#   timestamp: 2025-09-05T11:33:06+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.data import directory
from ...type import basic, entityReferenceList, lifeCycle, tagLabel


class CreateDirectoryRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName, Field(description='Name that identifies this directory.')
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this directory.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the directory.'),
    ]
    service: Annotated[
        basic.FullyQualifiedEntityName,
        Field(
            description='Link to the drive service fully qualified name where this directory is hosted in'
        ),
    ]
    parent: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(
            None,
            description='Link to the parent directory fully qualified name. If not provided, this is a root directory.',
        ),
    ]
    directoryType: Annotated[
        Optional[directory.DirectoryType], Field(None, description='Type of directory')
    ]
    path: Annotated[
        Optional[str], Field(None, description='Full path to the directory')
    ]
    isShared: Annotated[
        Optional[bool], Field(False, description='Whether this directory is shared')
    ]
    numberOfFiles: Annotated[
        Optional[int], Field(None, description='Number of files in this directory')
    ]
    numberOfSubDirectories: Annotated[
        Optional[int], Field(None, description='Number of subdirectories')
    ]
    totalSize: Annotated[
        Optional[int], Field(None, description='Total size of all files in bytes')
    ]
    sourceUrl: Annotated[
        Optional[basic.SourceUrl], Field(None, description='Source URL of directory.')
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this Directory.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this directory'),
    ]
    dataProducts: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='List of fully qualified names of data products this entity is part of.',
        ),
    ]
    domains: Annotated[
        Optional[List[basic.FullyQualifiedEntityName]],
        Field(
            None,
            description='Fully qualified names of the domains the Directory belongs to.',
        ),
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle of the entity'),
    ]
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
