# generated by datamodel-codegen:
#   filename:  api/dataInsight/kpi/createKpiRequest.json
#   timestamp: 2025-09-05T11:33:06+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ....dataInsight.kpi import basic as basic_1
from ....type import basic, entityReferenceList


class DataInsightChart(Enum):
    percentage_of_data_asset_with_description_kpi = (
        'percentage_of_data_asset_with_description_kpi'
    )
    percentage_of_data_asset_with_owner_kpi = 'percentage_of_data_asset_with_owner_kpi'
    number_of_data_asset_with_description_kpi = (
        'number_of_data_asset_with_description_kpi'
    )
    number_of_data_asset_with_owner_kpi = 'number_of_data_asset_with_owner_kpi'


class CreateKpiRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName, Field(description='Name that identifies this Kpi.')
    ]
    displayName: Annotated[
        Optional[str], Field(None, description='Display Name that identifies this Kpi.')
    ]
    description: Annotated[basic.Markdown, Field(description='Description of the Kpi.')]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owner of this Kpi'),
    ]
    dataInsightChart: Annotated[
        DataInsightChart,
        Field(description='Fully qualified name of the Chart this kpi refers to'),
    ]
    startDate: Annotated[basic.Timestamp, Field(description='Start Date for the KPIs')]
    endDate: Annotated[basic.Timestamp, Field(description='End Date for the KPIs')]
    targetValue: Annotated[
        float,
        Field(
            description='Metrics from the chart and the target to achieve the result.'
        ),
    ]
    metricType: basic_1.KpiTargetType
    domains: Annotated[
        Optional[List[str]],
        Field(
            None, description='Fully qualified names of the domains the KPI belongs to.'
        ),
    ]
