# generated by datamodel-codegen:
#   filename:  api/entityRelationship/searchEntityRelationshipRequest.json
#   timestamp: 2025-09-05T11:33:06+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from . import entityRelationshipDirection


class SearchEntityRelationshipRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    fqn: Annotated[str, Field(description='Entity Fqn to search entity relationships')]
    direction: entityRelationshipDirection.EntityRelationshipDirection
    directionValue: Annotated[
        Optional[List[str]],
        Field(None, description='Entity Relationship Direction Value.'),
    ]
    upstreamDepth: Annotated[
        Optional[int],
        Field(3, description='The upstream depth of the entity relationship'),
    ]
    downstreamDepth: Annotated[
        Optional[int],
        Field(3, description='The downstream depth of the entity relationship'),
    ]
    layerFrom: Annotated[
        Optional[int], Field(0, description='Layer to start the search from.')
    ]
    layerSize: Annotated[
        Optional[int], Field(1000, description='Size of the search result.')
    ]
    queryFilter: Annotated[Optional[str], Field(None, description='Query Filter')]
    includeDeleted: Annotated[
        Optional[bool], Field(None, description='Include deleted entities')
    ]
    includeSourceFields: Annotated[
        Optional[List[str]], Field(None, description='Include source fields')
    ]
