# generated by datamodel-codegen:
#   filename:  api/services/ingestionPipelines/createIngestionPipeline.json
#   timestamp: 2025-09-05T11:33:06+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ....entity.services.ingestionPipelines import ingestionPipeline
from ....metadataIngestion import workflow
from ....type import basic, entityReference, entityReferenceList


class CreateIngestionPipelineRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName,
        Field(description='Name that identifies this pipeline instance uniquely.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None, description='Display Name that identifies this ingestion pipeline.'
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the pipeline.'),
    ]
    pipelineType: ingestionPipeline.PipelineType
    sourceConfig: workflow.SourceConfig
    airflowConfig: ingestionPipeline.AirflowConfig
    loggerLevel: Annotated[
        Optional[workflow.LogLevels],
        Field(
            workflow.LogLevels.INFO,
            description='Set the logging level for the workflow.',
        ),
    ]
    raiseOnError: Annotated[
        Optional[bool],
        Field(
            True,
            description='Control if we want to flag the workflow as failed if we encounter any processing errors.',
        ),
    ]
    service: Annotated[
        entityReference.EntityReference,
        Field(
            description='Link to the service for which ingestion pipeline is ingesting the metadata.'
        ),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owner of this Ingestion Pipeline.'),
    ]
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    domains: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='Fully qualified names of the domains the Ingestion Pipeline belongs to.',
        ),
    ]
    processingEngine: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='The processing engine responsible for executing the ingestion pipeline logic.',
        ),
    ]
