# generated by datamodel-codegen:
#   filename:  entity/applications/configuration/external/collateAIAppConfig.json
#   timestamp: 2025-09-05T11:33:06+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel


class CollateAIAppType(Enum):
    CollateAI = 'CollateAI'


class CollateAIAppConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[CollateAIAppType],
        Field(
            CollateAIAppType.CollateAI,
            description='Application Type',
            title='Application Type',
        ),
    ]
    filter: Annotated[
        str,
        Field(
            description='Query filter to be passed to ES. E.g., `{"query":{"bool":{"must":[{"bool":{"should":[{"term":{"domain.displayName.keyword":"DG Anim"}}]}}]}}}`. This is the same payload as in the Explore page.',
            title='Filter',
        ),
    ]
    patchIfEmpty: Annotated[
        Optional[bool],
        Field(
            False,
            description='Patch the description if it is empty, instead of raising a suggestion',
            title='Patch Description If Empty',
        ),
    ]
