# generated by datamodel-codegen:
#   filename:  entity/data/dashboard.json
#   timestamp: 2025-09-05T11:33:06+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import (
    assetCertification,
    basic,
    entityHistory,
    entityReference,
    entityReferenceList,
    lifeCycle,
    tagLabel,
    usageDetails,
    votes,
)
from ..services import dashboardService


class DashboardType(Enum):
    Dashboard = 'Dashboard'
    Report = 'Report'


class Dashboard(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid,
        Field(description='Unique identifier that identifies a dashboard instance.'),
    ]
    name: Annotated[
        basic.EntityName, Field(description='Name that identifies this dashboard.')
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description='Display Name that identifies this Dashboard. It could be title or label from the source services.',
        ),
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(
            None,
            description="A unique name that identifies a dashboard in the format 'ServiceName.DashboardName'.",
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(
            None,
            description='Description of the dashboard, what it is, and how to use it.',
        ),
    ]
    project: Annotated[
        Optional[str],
        Field(
            None,
            description='Name of the project / workspace / collection in which the dashboard is contained',
        ),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    dashboardType: Optional[DashboardType] = DashboardType.Dashboard
    sourceUrl: Annotated[
        Optional[basic.SourceUrl],
        Field(None, description='Dashboard URL suffix from its service.'),
    ]
    charts: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='All the charts included in this Dashboard.'),
    ]
    dataModels: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='List of data models used by this dashboard or the charts contained on it.',
        ),
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this dashboard.'),
    ]
    followers: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Followers of this dashboard.'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field([], description='Tags for this dashboard.'),
    ]
    service: Annotated[
        entityReference.EntityReference,
        Field(description='Link to service where this dashboard is hosted in.'),
    ]
    serviceType: Annotated[
        Optional[dashboardService.DashboardServiceType],
        Field(None, description='Service type where this dashboard is hosted in.'),
    ]
    usageSummary: Annotated[
        Optional[usageDetails.UsageDetails],
        Field(None, description='Latest usage information for this dashboard.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
    domains: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='Domains the Dashboard belongs to. When not set, the Dashboard inherits the domain from the dashboard service it belongs to.',
        ),
    ]
    dataProducts: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of data products this entity is part of.'),
    ]
    votes: Annotated[
        Optional[votes.Votes], Field(None, description='Votes on the entity.')
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle properties of the entity'),
    ]
    certification: Optional[assetCertification.AssetCertification] = None
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
