# generated by datamodel-codegen:
#   filename:  entity/data/dataContract.json
#   timestamp: 2025-09-05T11:33:06+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import (
    basic,
    contractExecutionStatus,
    entityHistory,
    entityReference,
    entityReferenceList,
)
from . import table


class LatestResult(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    timestamp: Optional[basic.Timestamp] = None
    status: Optional[contractExecutionStatus.ContractExecutionStatus] = None
    message: Optional[str] = None
    resultId: Optional[basic.Uuid] = None


class ContractStatus(Enum):
    Draft = 'Draft'
    Active = 'Active'
    Deprecated = 'Deprecated'


class ContractUpdate(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    timestamp: Annotated[
        basic.Timestamp, Field(description='Timestamp when the contract was updated.')
    ]
    updatedBy: Annotated[str, Field(description='User who updated the contract.')]
    changeDescription: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of changes made to the contract.'),
    ]
    version: Annotated[
        str, Field(description='Version number of the contract after the update.')
    ]


class DataContract(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid,
        Field(description='Unique identifier of this data contract instance.'),
    ]
    name: Annotated[basic.EntityName, Field(description='Name of the data contract.')]
    displayName: Annotated[
        Optional[str], Field(None, description='Display name of the data contract.')
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='Fully qualified name of the data contract.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the data contract.'),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to this data contract resource.'),
    ]
    status: Optional[ContractStatus] = ContractStatus.Draft
    entity: Annotated[
        entityReference.EntityReference,
        Field(
            description='Reference to the data entity (table, topic, etc.) this contract applies to.'
        ),
    ]
    testSuite: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Reference to the test suite that contains tests related to this data contract.',
        ),
    ]
    schema_: Annotated[
        Optional[List[table.Column]],
        Field(
            None, alias='schema', description='Schema definition for the data contract.'
        ),
    ]
    semantics: Annotated[
        Optional[List[basic.SemanticsRule]],
        Field(None, description='Semantics rules defined in the data contract.'),
    ]
    qualityExpectations: Annotated[
        Optional[List[entityReference.EntityReference]],
        Field(None, description='Quality expectations defined in the data contract.'),
    ]
    contractUpdates: Annotated[
        Optional[List[ContractUpdate]],
        Field(None, description='History of updates to the data contract.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this data contract.'),
    ]
    reviewers: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None, description='User references of the reviewers for this data contract.'
        ),
    ]
    effectiveFrom: Annotated[
        Optional[basic.DateTime],
        Field(None, description='Date from which this data contract is effective.'),
    ]
    effectiveUntil: Annotated[
        Optional[basic.DateTime],
        Field(None, description='Date until which this data contract is effective.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that led to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Incremental change description of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    sourceUrl: Annotated[
        Optional[basic.SourceUrl],
        Field(None, description='Source URL of the data contract.'),
    ]
    latestResult: Annotated[
        Optional[LatestResult],
        Field(None, description='Latest validation result for this data contract.'),
    ]
