# generated by datamodel-codegen:
#   filename:  entity/data/directory.json
#   timestamp: 2025-09-05T11:33:06+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import (
    assetCertification,
    basic,
    entityHistory,
    entityReference,
    entityReferenceList,
    lifeCycle,
    tagLabel,
    usageDetails,
    votes,
)
from ..services import driveService


class DirectoryType(Enum):
    Root = 'Root'
    MyDrive = 'MyDrive'
    SharedDrive = 'SharedDrive'
    TeamDrive = 'TeamDrive'
    Folder = 'Folder'
    SharePointSite = 'SharePointSite'
    SharePointLibrary = 'SharePointLibrary'


class Directory(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid, Field(description='Unique identifier of this directory instance.')
    ]
    name: Annotated[basic.EntityName, Field(description='Name of the directory.')]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='Fully qualified name of the directory.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this directory.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the directory.'),
    ]
    service: Annotated[
        entityReference.EntityReference,
        Field(description='Link to the drive service this directory belongs to'),
    ]
    serviceType: Annotated[
        Optional[driveService.DriveServiceType],
        Field(None, description='Type of drive service'),
    ]
    parent: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='Parent directory reference'),
    ]
    children: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Child directories and files'),
    ]
    directoryType: Optional[DirectoryType] = None
    path: Annotated[
        Optional[str], Field(None, description='Full path to the directory')
    ]
    isShared: Annotated[
        Optional[bool], Field(False, description='Whether this directory is shared')
    ]
    numberOfFiles: Annotated[
        Optional[int], Field(None, description='Number of files in this directory')
    ]
    numberOfSubDirectories: Annotated[
        Optional[int], Field(None, description='Number of subdirectories')
    ]
    totalSize: Annotated[
        Optional[int], Field(None, description='Total size of all files in bytes')
    ]
    sourceUrl: Annotated[
        Optional[basic.SourceUrl],
        Field(None, description='Link to this directory in the source system.'),
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(
            None, description='Link to the resource corresponding to this directory.'
        ),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this directory.'),
    ]
    followers: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Followers of this entity.'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags associated with this directory.'),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    domains: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Domains the Directory belongs to.'),
    ]
    dataProducts: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of data products this entity is part of.'),
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle of the entity'),
    ]
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
    votes: Annotated[
        Optional[votes.Votes], Field(None, description='Votes on the entity.')
    ]
    certification: Optional[assetCertification.AssetCertification] = None
    usageSummary: Annotated[
        Optional[usageDetails.UsageDetails],
        Field(None, description='Latest usage information for this directory.'),
    ]
