# generated by datamodel-codegen:
#   filename:  entity/data/pipeline.json
#   timestamp: 2025-09-05T11:33:06+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import (
    assetCertification,
    basic,
    entityHistory,
    entityReference,
    entityReferenceList,
    lifeCycle,
    tagLabel,
    usageDetails,
    votes,
)
from ..services import pipelineService


class StatusType(Enum):
    Successful = 'Successful'
    Failed = 'Failed'
    Pending = 'Pending'
    Skipped = 'Skipped'


class PipelineState(Enum):
    Active = 'Active'
    Inactive = 'Inactive'


class TaskStatus(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[str, Field(description='Name of the Task.')]
    executionStatus: Annotated[
        StatusType, Field(description='Status at a specific execution date.')
    ]
    startTime: Annotated[
        Optional[basic.Timestamp], Field(None, description='Task start time')
    ]
    endTime: Annotated[
        Optional[basic.Timestamp], Field(None, description='Task end time')
    ]
    logLink: Annotated[Optional[AnyUrl], Field(None, description='Task end time')]


class PipelineStatus(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    timestamp: Annotated[
        basic.Timestamp, Field(description='Timestamp where the job was executed.')
    ]
    executionStatus: Annotated[
        StatusType, Field(description='Status at a specific execution date.')
    ]
    taskStatus: Annotated[
        Optional[List[TaskStatus]],
        Field(None, description='Series of task executions and its status.'),
    ]


class Task(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        str, Field(description='Name that identifies this task instance uniquely.')
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description='Display Name that identifies this Task. It could be title or label from the pipeline services.',
        ),
    ]
    fullyQualifiedName: Annotated[
        Optional[str],
        Field(
            None,
            description="A unique name that identifies a pipeline in the format 'ServiceName.PipelineName.TaskName'.",
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown], Field(None, description='Description of this Task.')
    ]
    sourceUrl: Annotated[
        Optional[basic.SourceUrl],
        Field(
            None,
            description='Task URL to visit/manage. This URL points to respective pipeline service UI.',
        ),
    ]
    downstreamTasks: Annotated[
        Optional[List[str]],
        Field(None, description='All the tasks that are downstream of this task.'),
    ]
    taskType: Annotated[
        Optional[str],
        Field(
            None,
            description='Type of the Task. Usually refers to the class it implements.',
        ),
    ]
    taskSQL: Annotated[
        Optional[basic.SqlQuery],
        Field(
            None,
            description='SQL used in the task. Can be used to determine the lineage.',
        ),
    ]
    startDate: Annotated[
        Optional[str], Field(None, description='start date for the task.')
    ]
    endDate: Annotated[Optional[str], Field(None, description='end date for the task.')]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]], Field([], description='Tags for this task.')
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this task.'),
    ]


class Pipeline(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid,
        Field(description='Unique identifier that identifies a pipeline instance.'),
    ]
    name: Annotated[
        basic.EntityName,
        Field(description='Name that identifies this pipeline instance uniquely.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(
            None,
            description='Display Name that identifies this Pipeline. It could be title or label from the source services.',
        ),
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(
            None,
            description="A unique name that identifies a pipeline in the format 'ServiceName.PipelineName'.",
        ),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of this Pipeline.'),
    ]
    dataProducts: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of data products this entity is part of.'),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    sourceUrl: Annotated[
        Optional[basic.SourceUrl],
        Field(
            None,
            description='Pipeline  URL to visit/manage. This URL points to respective pipeline service UI.',
        ),
    ]
    concurrency: Annotated[
        Optional[int], Field(None, description='Concurrency of the Pipeline.')
    ]
    pipelineLocation: Annotated[
        Optional[str], Field(None, description='Pipeline Code Location.')
    ]
    startDate: Annotated[
        Optional[basic.DateTime], Field(None, description='Start date of the workflow.')
    ]
    tasks: Annotated[
        Optional[List[Task]],
        Field(None, description='All the tasks that are part of pipeline.'),
    ]
    pipelineStatus: Annotated[
        Optional[PipelineStatus], Field(None, description='Latest Pipeline Status.')
    ]
    state: Annotated[
        Optional[PipelineState], Field(None, description='State of the Pipeline.')
    ]
    followers: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Followers of this Pipeline.'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this Pipeline.'),
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this pipeline.'),
    ]
    service: Annotated[
        entityReference.EntityReference,
        Field(description='Link to service where this pipeline is hosted in.'),
    ]
    serviceType: Annotated[
        Optional[pipelineService.PipelineServiceType],
        Field(None, description='Service type where this pipeline is hosted in.'),
    ]
    usageSummary: Annotated[
        Optional[usageDetails.UsageDetails],
        Field(None, description='Latest usage information for this pipeline.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
    scheduleInterval: Annotated[
        Optional[str],
        Field(None, description='Scheduler Interval for the pipeline in cron format.'),
    ]
    domains: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='Domains the Pipeline belongs to. When not set, the pipeline inherits the domain from the Pipeline service it belongs to.',
        ),
    ]
    votes: Annotated[
        Optional[votes.Votes], Field(None, description='Votes on the entity.')
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle properties of the entity'),
    ]
    certification: Optional[assetCertification.AssetCertification] = None
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
