# generated by datamodel-codegen:
#   filename:  entity/data/spreadsheet.json
#   timestamp: 2025-09-05T11:33:06+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import (
    assetCertification,
    basic,
    entityHistory,
    entityReference,
    entityReferenceList,
    lifeCycle,
    tagLabel,
    usageDetails,
    votes,
)
from ..services import driveService


class SpreadsheetMimeType(Enum):
    application_vnd_google_apps_spreadsheet = 'application/vnd.google-apps.spreadsheet'
    application_vnd_openxmlformats_officedocument_spreadsheetml_sheet = (
        'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
    )
    application_vnd_ms_excel = 'application/vnd.ms-excel'
    application_vnd_oasis_opendocument_spreadsheet = (
        'application/vnd.oasis.opendocument.spreadsheet'
    )
    text_csv = 'text/csv'
    text_tab_separated_values = 'text/tab-separated-values'
    Other = 'Other'


class Spreadsheet(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid,
        Field(
            description='Unique identifier that identifies this spreadsheet instance.'
        ),
    ]
    name: Annotated[
        basic.EntityName, Field(description='Name that identifies the spreadsheet.')
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(
            None,
            description="Name that uniquely identifies a spreadsheet in the format 'ServiceName.DirectoryPath.SpreadsheetName'.",
        ),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this spreadsheet.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the spreadsheet instance.'),
    ]
    service: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Link to the drive service where this spreadsheet is hosted.',
        ),
    ]
    serviceType: Annotated[
        Optional[driveService.DriveServiceType],
        Field(None, description='Service type where this spreadsheet is hosted.'),
    ]
    directory: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None, description='Reference to Directory that contains this spreadsheet.'
        ),
    ]
    worksheets: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='References to worksheets/tabs in the spreadsheet.'),
    ]
    mimeType: Annotated[
        Optional[SpreadsheetMimeType],
        Field(None, description='MIME type of the spreadsheet file'),
    ]
    path: Annotated[
        Optional[str], Field(None, description='Full path to the spreadsheet file')
    ]
    driveFileId: Annotated[
        Optional[str], Field(None, description='Native file ID in the source system')
    ]
    size: Annotated[
        Optional[int],
        Field(
            None,
            description='File size in bytes (may be null for cloud-native files like Google Sheets)',
        ),
    ]
    fileVersion: Annotated[
        Optional[str], Field(None, description='File version information')
    ]
    createdTime: Annotated[
        Optional[basic.Timestamp],
        Field(None, description='Spreadsheet creation timestamp'),
    ]
    modifiedTime: Annotated[
        Optional[basic.Timestamp],
        Field(None, description='Last modification timestamp'),
    ]
    lastModifiedBy: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='User who last modified the spreadsheet'),
    ]
    usageSummary: Annotated[
        Optional[usageDetails.UsageDetails],
        Field(None, description='Latest usage information for this spreadsheet.'),
    ]
    sourceUrl: Annotated[
        Optional[basic.SourceUrl],
        Field(
            None,
            description='Link to view/edit this spreadsheet in the source system (e.g., Google Sheets URL, SharePoint URL).',
        ),
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(
            None, description='Link to the resource corresponding to this spreadsheet.'
        ),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this spreadsheet.'),
    ]
    followers: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Followers of this entity.'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags associated with this spreadsheet.'),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    domains: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Domains the Spreadsheet belongs to.'),
    ]
    dataProducts: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of data products this entity is part of.'),
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle of the entity'),
    ]
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
    votes: Annotated[
        Optional[votes.Votes], Field(None, description='Votes on the entity.')
    ]
    certification: Optional[assetCertification.AssetCertification] = None
