# generated by datamodel-codegen:
#   filename:  entity/docStore/document.json
#   timestamp: 2025-09-05T11:33:06+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic, entityHistory, entityReferenceList


class Data(BaseModel):
    pass
    model_config = ConfigDict(
        extra='allow',
    )


class Document(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Optional[basic.Uuid] = None
    name: Annotated[basic.EntityName, Field(description='Name of the DocStore')]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this column name.'),
    ]
    fullyQualifiedName: basic.FullyQualifiedEntityName
    description: Annotated[
        Optional[str], Field(None, description='Description of the DocStore Entity.')
    ]
    entityType: Annotated[
        str, Field(description='Type of the Entity stored in DocStore.')
    ]
    data: Data
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    domains: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='Domains the asset belongs to. When not set, the asset inherits the domain from the parent it belongs to.',
        ),
    ]
