# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/powerbi/azureConfig.json
#   timestamp: 2025-09-05T11:33:06+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ......security.credentials import azureCredentials
from . import bucketDetails


class PbitFileConfigType(Enum):
    azure = 'azure'


class AzureConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    pbitFileConfigType: Annotated[
        Optional[PbitFileConfigType],
        Field(PbitFileConfigType.azure, description='pbit File Configuration type'),
    ]
    securityConfig: Annotated[
        azureCredentials.AzureCredentials, Field(title='Azure Config Source')
    ]
    prefixConfig: Annotated[
        Optional[bucketDetails.BucketDetails], Field(None, title='Prefix Config')
    ]
    pbitFilesExtractDir: Annotated[
        Optional[str],
        Field(
            '/tmp/pbitFiles',
            description='Path of the folder where the .pbit files will be unzipped and datamodel schema will be extracted',
            title='pbit Files Extraction Directory',
        ),
    ]
