# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/qlikCloudConnection.json
#   timestamp: 2025-09-05T11:33:06+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....type import filterPattern
from .. import connectionBasicType


class SpaceType(Enum):
    Managed = 'Managed'
    Shared = 'Shared'
    Personal = 'Personal'
    Data = 'Data'


class QlikCloudType(Enum):
    QlikCloud = 'QlikCloud'


class QlikCloudConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[QlikCloudType],
        Field(
            QlikCloudType.QlikCloud, description='Service Type', title='Service Type'
        ),
    ]
    token: Annotated[
        CustomSecretStr,
        Field(description='token to connect to Qlik Cloud.', title='token'),
    ]
    hostPort: Annotated[
        AnyUrl,
        Field(
            description='Host and Port of the Qlik Cloud instance.',
            title='Host and Port',
        ),
    ]
    spaceTypes: Annotated[
        Optional[List[SpaceType]],
        Field(
            [SpaceType.Managed, SpaceType.Shared, SpaceType.Personal, SpaceType.Data],
            description='Space types of Qlik Cloud to filter the dashboards ingested into the platform.',
            min_length=1,
            title='Space Types',
        ),
    ]
    dashboardFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to exclude or include dashboards that matches the pattern.',
            title='Default Dashboard Filter Pattern',
        ),
    ]
    chartFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude or include charts that matches the pattern.',
            title='Default Chart Filter Pattern',
        ),
    ]
    dataModelFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude or include data models that matches the pattern.',
            title='Default Data Model Filter Pattern',
        ),
    ]
    projectFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to exclude or include projects that matches the pattern.',
            title='Default Project Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
