# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/hiveConnection.json
#   timestamp: 2025-09-05T11:33:06+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, Optional, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....security.ssl import verifySSLConfig
from .....type import filterPattern
from .. import connectionBasicType
from . import mysqlConnection, postgresConnection


class Auth(Enum):
    NONE = 'NONE'
    LDAP = 'LDAP'
    KERBEROS = 'KERBEROS'
    CUSTOM = 'CUSTOM'
    NOSASL = 'NOSASL'
    BASIC = 'BASIC'
    GSSAPI = 'GSSAPI'
    JWT = 'JWT'
    PLAIN = 'PLAIN'


class HiveType(Enum):
    Hive = 'Hive'


class HiveScheme(Enum):
    hive = 'hive'
    hive_http = 'hive+http'
    hive_https = 'hive+https'


class HiveConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[HiveType],
        Field(HiveType.Hive, description='Service Type', title='Service Type'),
    ]
    scheme: Annotated[
        Optional[HiveScheme],
        Field(
            HiveScheme.hive,
            description='SQLAlchemy driver scheme options.',
            title='Connection Scheme',
        ),
    ]
    username: Annotated[
        Optional[str],
        Field(
            None,
            description='Username to connect to Hive. This user should have privileges to read all the metadata in Hive.',
            title='Username',
        ),
    ]
    password: Annotated[
        Optional[CustomSecretStr],
        Field(None, description='Password to connect to Hive.', title='Password'),
    ]
    hostPort: Annotated[
        str,
        Field(description='Host and port of the Hive service.', title='Host and Port'),
    ]
    auth: Annotated[
        Optional[Auth],
        Field(
            Auth.NONE,
            description='Authentication mode to connect to hive.',
            title='Authentication Mode',
        ),
    ]
    kerberosServiceName: Annotated[
        Optional[str],
        Field(
            None,
            description='If authenticating with Kerberos specify the Kerberos service name',
            title='Kerberos Service Name',
        ),
    ]
    databaseSchema: Annotated[
        Optional[str],
        Field(
            None,
            description='Database Schema of the data source. This is optional parameter, if you would like to restrict the metadata reading to a single schema. When left blank, OpenMetadata Ingestion attempts to scan all the schemas.',
            title='Database Schema',
        ),
    ]
    databaseName: Annotated[
        Optional[str],
        Field(
            None,
            description='Optional name to give to the database in OpenMetadata. If left blank, we will use default as the database name.',
            title='Database Name',
        ),
    ]
    authOptions: Annotated[
        Optional[str],
        Field(
            None,
            description='Authentication options to pass to Hive connector. These options are based on SQLAlchemy.',
            title='URL Authentication Options',
        ),
    ]
    useSSL: Annotated[
        Optional[bool],
        Field(
            False,
            description='Enable SSL connection to Hive server. When enabled, SSL transport will be used for secure communication.',
            title='Use SSL',
        ),
    ]
    sslConfig: Annotated[
        Optional[verifySSLConfig.SslConfig],
        Field(
            None, description='SSL Configuration details.', title='SSL Configuration'
        ),
    ]
    metastoreConnection: Annotated[
        Optional[
            Union[
                postgresConnection.PostgresConnection,
                mysqlConnection.MysqlConnection,
                Dict[str, Any],
            ]
        ],
        Field(
            None,
            description='Hive Metastore Connection Details',
            title='Hive Metastore Connection Details',
        ),
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    schemaFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude schemas that matches the pattern.',
            title='Default Schema Filter Pattern',
        ),
    ]
    tableFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude tables that matches the pattern.',
            title='Default Table Filter Pattern',
        ),
    ]
    databaseFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude databases that matches the pattern.',
            title='Default Database Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
    supportsDBTExtraction: Optional[connectionBasicType.SupportsDBTExtraction] = None
    supportsProfiler: Annotated[
        Optional[connectionBasicType.SupportsProfiler],
        Field(None, title='Supports Profiler'),
    ]
    sampleDataStorageConfig: Annotated[
        Optional[connectionBasicType.SampleDataStorageConfig],
        Field(None, title='Storage Config for Sample Data'),
    ]
    supportsViewLineageExtraction: Optional[
        connectionBasicType.SupportsViewLineageExtraction
    ] = None
