# generated by datamodel-codegen:
#   filename:  entity/services/connections/drive/sharePointConnection.json
#   timestamp: 2025-09-05T11:33:06+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .. import connectionBasicType


class SharePointType(Enum):
    SharePoint = 'SharePoint'


class SharePointConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[SharePointType],
        Field(
            SharePointType.SharePoint, description='Service Type', title='Service Type'
        ),
    ]
    clientId: Annotated[
        str,
        Field(
            description='Application (client) ID from Azure Active Directory',
            title='Client ID',
        ),
    ]
    clientSecret: Annotated[
        CustomSecretStr,
        Field(
            description='Application (client) secret from Azure Active Directory',
            title='Client Secret',
        ),
    ]
    tenantId: Annotated[
        str,
        Field(
            description='Directory (tenant) ID from Azure Active Directory',
            title='Tenant ID',
        ),
    ]
    siteUrl: Annotated[
        AnyUrl, Field(description='SharePoint site URL', title='Site URL')
    ]
    siteName: Annotated[
        Optional[str],
        Field(None, description='SharePoint site name', title='Site Name'),
    ]
    driveId: Annotated[
        Optional[str],
        Field(
            None,
            description='SharePoint drive ID. If not provided, default document library will be used',
            title='Drive ID',
        ),
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
