# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/airbyteConnection.json
#   timestamp: 2025-09-05T11:33:06+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....type import filterPattern
from .. import connectionBasicType


class AirbyteType(Enum):
    Airbyte = 'Airbyte'


class AirbyteConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[AirbyteType],
        Field(AirbyteType.Airbyte, description='Service Type', title='Service Type'),
    ]
    hostPort: Annotated[
        AnyUrl, Field(description='Pipeline Service Management/UI URL.')
    ]
    username: Annotated[
        Optional[str],
        Field(None, description='Username to connect to Airbyte.', title='Username'),
    ]
    password: Annotated[
        Optional[CustomSecretStr],
        Field(None, description='Password to connect to Airbyte.', title='Password'),
    ]
    apiVersion: Annotated[
        Optional[str],
        Field('api/v1', description='Airbyte API version.', title='API Version'),
    ]
    pipelineFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude pipelines.',
            title='Default Pipeline Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
