# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/gluePipelineConnection.json
#   timestamp: 2025-09-05T11:33:06+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....security.credentials import awsCredentials
from .....type import filterPattern
from .. import connectionBasicType


class GlueType(Enum):
    GluePipeline = 'GluePipeline'


class GluePipelineConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[GlueType],
        Field(GlueType.GluePipeline, description='Service Type', title='Service Type'),
    ]
    awsConfig: Annotated[
        awsCredentials.AWSCredentials, Field(title='AWS Credentials Configuration')
    ]
    pipelineFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude pipelines.',
            title='Default Pipeline Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
