# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/ssisConnection.json
#   timestamp: 2025-09-05T11:33:06+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import ConfigDict, Field, RootModel
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .. import connectionBasicType
from ..database import mssqlConnection
from ..storage import s3Connection


class SSISType(Enum):
    SSIS = 'SSIS'


class LocalProjectsPath(RootModel[str]):
    root: Annotated[
        str,
        Field(description='Path leading to your projects', title='Local Projects Path'),
    ]


class SSISConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[SSISType],
        Field(SSISType.SSIS, description='Service Type', title='Service Type'),
    ]
    databaseConnection: Annotated[
        mssqlConnection.MssqlConnection,
        Field(
            description='Underlying database connection',
            title='Metadata Database Connection',
        ),
    ]
    packageConnection: Annotated[
        Union[s3Connection.S3Connection, LocalProjectsPath],
        Field(
            description='Underlying storage connection',
            title='SSIS Projects Location (Local Path or S3 Bucket)',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
