# generated by datamodel-codegen:
#   filename:  events/api/typedEvent.json
#   timestamp: 2025-09-05T11:33:06+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import changeEvent
from .. import failedEventResponse


class Status(Enum):
    failed = 'failed'
    successful = 'successful'
    unprocessed = 'unprocessed'


class TypedEvent(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    status: Annotated[
        Status,
        Field(
            description="The status of the event, such as 'failed', 'successful', or 'unprocessed'."
        ),
    ]
    data: Annotated[
        List[Union[changeEvent.ChangeEvent, failedEventResponse.FailedEvents]],
        Field(
            description='The event data, which can be of different types depending on the status.'
        ),
    ]
    timestamp: Annotated[
        float,
        Field(
            description='The timestamp when the event occurred, represented as a long.'
        ),
    ]
