# generated by datamodel-codegen:
#   filename:  metadataIngestion/application.json
#   timestamp: 2025-09-05T11:33:06+00:00

from __future__ import annotations

from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..entity.applications.configuration import applicationConfig
from ..type import basic
from . import workflow


class OpenMetadataApplicationConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    workflowConfig: Annotated[
        workflow.WorkflowConfig,
        Field(
            description='General Workflow configuration, such as the OpenMetadata server connection and logging level'
        ),
    ]
    sourcePythonClass: Annotated[
        Optional[str],
        Field(None, description='Source Python Class Name to run the application'),
    ]
    appConfig: Annotated[
        Optional[applicationConfig.AppConfig],
        Field(None, description='External Application configuration'),
    ]
    appPrivateConfig: Annotated[
        Optional[applicationConfig.PrivateConfig],
        Field(None, description='External Application Private configuration'),
    ]
    ingestionPipelineFQN: Annotated[
        Optional[str],
        Field(
            None,
            description='Fully qualified name of ingestion pipeline, used to identify the current ingestion pipeline',
        ),
    ]
    pipelineRunId: Annotated[
        Optional[basic.Uuid],
        Field(
            None,
            description='Unique identifier of pipeline run, used to identify the current pipeline run',
        ),
    ]
