# generated by datamodel-codegen:
#   filename:  metadataIngestion/dbtconfig/dbtCloudConfig.json
#   timestamp: 2025-09-05T11:33:06+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr


class DbtConfigType(Enum):
    cloud = 'cloud'


class DbtCloudConfig(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    dbtConfigType: Annotated[DbtConfigType, Field(description='dbt Configuration type')]
    dbtCloudAuthToken: Annotated[
        CustomSecretStr,
        Field(
            description='dbt cloud account authentication token',
            title='dbt Cloud Authentication Token',
        ),
    ]
    dbtCloudAccountId: Annotated[
        str, Field(description='dbt cloud account Id', title='dbt Cloud Account Id')
    ]
    dbtCloudProjectId: Annotated[
        Optional[str],
        Field(
            None,
            description="In case of multiple projects in a dbt cloud account, specify the project's id from which you want to extract the dbt run artifacts",
            title='dbt Cloud Project Id',
        ),
    ]
    dbtCloudJobId: Annotated[
        Optional[str],
        Field(None, description='dbt cloud job id.', title='dbt Cloud Job Id'),
    ]
    dbtCloudUrl: Annotated[
        AnyUrl,
        Field(
            description='URL to connect to your dbt cloud instance. E.g., https://cloud.getdbt.com or https://emea.dbt.com/',
            title='dbt Cloud URL',
        ),
    ]
