# generated by datamodel-codegen:
#   filename:  metadataIngestion/reverseIngestionPipeline.json
#   timestamp: 2025-09-05T11:33:06+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..type import basic, entityReference
from .reverseingestionconfig import descriptionConfig, ownerConfig, tagsConfig


class ReverseIngestionType(Enum):
    ReverseIngestion = 'ReverseIngestion'


class Type(Enum):
    UPDATE_DESCRIPTION = 'UPDATE_DESCRIPTION'
    UPDATE_OWNER = 'UPDATE_OWNER'
    UPDATE_TAGS = 'UPDATE_TAGS'


class Operation(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[basic.Uuid, Field(description='The id of the operation')]
    entityLink: Annotated[basic.EntityLink, Field(description='Entity to be modified')]
    type: Annotated[Type, Field(description='Type of operation to perform')]
    SQLTemplate: Annotated[
        Optional[str],
        Field(
            None,
            description='Templated SQL command to be used for the operation. Context parameters will be populated based on the event type.',
        ),
    ]
    parameters: Annotated[
        Union[
            descriptionConfig.ReverseIngestionDescriptionConfig,
            ownerConfig.ReverseIngestionOwnerConfig,
            tagsConfig.ReverseIngestionTagsConfig,
        ],
        Field(description='The configuration for the operation to be applied'),
    ]


class ReverseIngestionPipeline(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[ReverseIngestionType, Field(description='Pipeline type')]
    service: Annotated[
        entityReference.EntityReference, Field(description='Service to be modified')
    ]
    operations: Annotated[
        List[Operation],
        Field(description='List of operations to be performed on the service'),
    ]
    ingestionRunner: Annotated[
        Optional[str],
        Field(
            None,
            description='Optional value of the ingestion runner name responsible for running the workflow',
        ),
    ]
