# generated by datamodel-codegen:
#   filename:  security/credentials/gcpValues.json
#   timestamp: 2025-09-05T11:33:06+00:00

from __future__ import annotations

from typing import List, Optional, Union

from pydantic import AnyUrl, ConfigDict, Field, RootModel
from typing_extensions import Annotated, Literal

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr


class SingleProjectId(RootModel[str]):
    root: Annotated[str, Field(title='Single Project ID')]


class MultipleProjectId(RootModel[List[str]]):
    root: Annotated[List[str], Field(title='Multiple Project ID')]


class GcpCredentialsValues(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Literal['service_account'],
        Field(
            'service_account',
            description='Google Cloud Platform account type.',
            title='Credentials Type',
        ),
    ]
    projectId: Annotated[
        Optional[Union[SingleProjectId, MultipleProjectId]],
        Field(None, description='Project ID', title='Project ID'),
    ]
    privateKeyId: Annotated[
        Optional[str],
        Field(None, description='Google Cloud private key id.', title='Private Key ID'),
    ]
    privateKey: Annotated[
        Optional[CustomSecretStr],
        Field(None, description='Google Cloud private key.', title='Private Key'),
    ]
    clientEmail: Annotated[
        Optional[str],
        Field(None, description='Google Cloud email.', title='Client Email'),
    ]
    clientId: Annotated[
        Optional[str],
        Field(None, description='Google Cloud Client ID.', title='Client ID'),
    ]
    authUri: Annotated[
        Optional[AnyUrl],
        Field(
            'https://accounts.google.com/o/oauth2/auth',
            description='Google Cloud auth uri.',
            title='Authentication URI',
        ),
    ]
    tokenUri: Annotated[
        Optional[AnyUrl],
        Field(
            'https://oauth2.googleapis.com/token',
            description='Google Cloud token uri.',
            title='Token URI',
        ),
    ]
    authProviderX509CertUrl: Annotated[
        Optional[AnyUrl],
        Field(
            'https://www.googleapis.com/oauth2/v1/certs',
            description='Google Cloud auth provider certificate.',
            title='Authentication Provider x509 Certificate URL',
        ),
    ]
    clientX509CertUrl: Annotated[
        Optional[AnyUrl],
        Field(
            None,
            description='Google Cloud client certificate uri.',
            title='Client x509 Certificate URL',
        ),
    ]
