# generated by datamodel-codegen:
#   filename:  system/ui/uiCustomization.json
#   timestamp: 2025-09-05T11:33:06+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic, entityHistory, personaPreferences
from . import navigationItem, page


class UICustomization(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: basic.Uuid
    name: Annotated[
        basic.EntityName,
        Field(description='A unique name for the UI customization configuration.'),
    ]
    displayName: Annotated[
        Optional[str], Field(None, description='Name used for display purposes.')
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the UI customization.'),
    ]
    pages: Annotated[
        List[page.Team], Field(description='List of Pages in the UI customization.')
    ]
    navigation: Annotated[
        Optional[List[navigationItem.NavigationItem]],
        Field(None, description='Site-wide navigation configuration.'),
    ]
    personaPreferences: Annotated[
        Optional[List[personaPreferences.PersonaPreferences]],
        Field(
            [],
            description='Persona default preferences. Admin can customize certain UI elements per persona as base configuration.',
        ),
    ]
    updatedAt: Optional[basic.Timestamp] = None
    updatedBy: Optional[str] = None
    version: Optional[entityHistory.EntityVersion] = None
    changeDescription: Optional[entityHistory.ChangeDescription] = None
    href: Optional[basic.Href] = None
