/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.ManufacturerSpec;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.Correction;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.Immersion;
import ome.xml.model.primitives.PositiveInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Objective
extends ManufacturerSpec {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2011-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Objective.class);
    private Boolean iris;
    private Double workingDistance;
    private Immersion immersion;
    private Correction correction;
    private Double lensNA;
    private PositiveInteger nominalMagnification;
    private Double calibratedMagnification;
    private String id;

    public Objective() {
    }

    public Objective(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Objective".equals(tagName)) {
            LOGGER.debug("Expecting node name of Objective got {}", (Object)tagName);
        }
        if (element.hasAttribute("Iris")) {
            this.setIris(Boolean.valueOf(element.getAttribute("Iris")));
        }
        if (element.hasAttribute("WorkingDistance")) {
            this.setWorkingDistance(Double.valueOf(element.getAttribute("WorkingDistance")));
        }
        if (element.hasAttribute("Immersion")) {
            this.setImmersion(Immersion.fromString(element.getAttribute("Immersion")));
        }
        if (element.hasAttribute("Correction")) {
            this.setCorrection(Correction.fromString(element.getAttribute("Correction")));
        }
        if (element.hasAttribute("LensNA")) {
            this.setLensNA(Double.valueOf(element.getAttribute("LensNA")));
        }
        if (element.hasAttribute("NominalMagnification")) {
            this.setNominalMagnification(PositiveInteger.valueOf(element.getAttribute("NominalMagnification")));
        }
        if (element.hasAttribute("CalibratedMagnification")) {
            this.setCalibratedMagnification(Double.valueOf(element.getAttribute("CalibratedMagnification")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException(String.format("Objective missing required ID property.", new Object[0]));
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
    }

    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public Boolean getIris() {
        return this.iris;
    }

    public void setIris(Boolean iris) {
        this.iris = iris;
    }

    public Double getWorkingDistance() {
        return this.workingDistance;
    }

    public void setWorkingDistance(Double workingDistance) {
        this.workingDistance = workingDistance;
    }

    public Immersion getImmersion() {
        return this.immersion;
    }

    public void setImmersion(Immersion immersion) {
        this.immersion = immersion;
    }

    public Correction getCorrection() {
        return this.correction;
    }

    public void setCorrection(Correction correction) {
        this.correction = correction;
    }

    public Double getLensNA() {
        return this.lensNA;
    }

    public void setLensNA(Double lensNA) {
        this.lensNA = lensNA;
    }

    public PositiveInteger getNominalMagnification() {
        return this.nominalMagnification;
    }

    public void setNominalMagnification(PositiveInteger nominalMagnification) {
        this.nominalMagnification = nominalMagnification;
    }

    public Double getCalibratedMagnification() {
        return this.calibratedMagnification;
    }

    public void setCalibratedMagnification(Double calibratedMagnification) {
        this.calibratedMagnification = calibratedMagnification;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    protected Element asXMLElement(Document document, Element Objective_element) {
        if (Objective_element == null) {
            Objective_element = document.createElementNS(NAMESPACE, "Objective");
        }
        if (this.iris != null) {
            Objective_element.setAttribute("Iris", this.iris.toString());
        }
        if (this.workingDistance != null) {
            Objective_element.setAttribute("WorkingDistance", this.workingDistance.toString());
        }
        if (this.immersion != null) {
            Objective_element.setAttribute("Immersion", this.immersion.toString());
        }
        if (this.correction != null) {
            Objective_element.setAttribute("Correction", this.correction.toString());
        }
        if (this.lensNA != null) {
            Objective_element.setAttribute("LensNA", this.lensNA.toString());
        }
        if (this.nominalMagnification != null) {
            Objective_element.setAttribute("NominalMagnification", this.nominalMagnification.toString());
        }
        if (this.calibratedMagnification != null) {
            Objective_element.setAttribute("CalibratedMagnification", this.calibratedMagnification.toString());
        }
        if (this.id != null) {
            Objective_element.setAttribute("ID", this.id.toString());
        }
        return super.asXMLElement(document, Objective_element);
    }
}

