/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.net.URI;
import java.net.URISyntaxException;
import thredds.catalog.InvAccess;
import thredds.catalog.InvDataset;
import thredds.catalog.InvService;

public class InvAccessImpl
extends InvAccess {
    private StringBuffer log = new StringBuffer();
    protected String serviceName;
    private String serviceTypeName;
    private String dataFormatName;
    private volatile int hashCode = 0;

    public InvAccessImpl(InvDataset dataset, String urlPath, InvService service) {
        this.dataset = dataset;
        this.urlPath = urlPath.trim();
        this.service = service;
    }

    protected InvAccessImpl(InvDataset dataset, String urlPath) {
        this.dataset = dataset;
        this.urlPath = urlPath.trim();
    }

    public InvAccessImpl(InvDataset dataset, String urlPath, String serviceName, String typeName, String dataFormatName, double dataSize) {
        this.dataset = dataset;
        this.urlPath = urlPath;
        this.serviceName = serviceName;
        this.serviceTypeName = typeName;
        this.dataFormatName = dataFormatName;
        this.dataSize = dataSize;
        if (typeName != null) {
            if (serviceName != null) {
                this.log.append("**InvAccess in (").append(dataset.getFullName()).append("):cannot declare both service (").append(serviceName).append(") and serviceType <").append(typeName).append(">\n");
            } else {
                this.service = new InvService("", typeName, "", "", null);
            }
        }
    }

    public boolean finish() {
        if (this.serviceName != null) {
            this.service = this.dataset.findService(this.serviceName);
            if (this.service == null) {
                this.log.append("**InvAccess in (").append(this.dataset.getFullName()).append("): has unknown service named (").append(this.serviceName).append(")\n");
            }
        }
        try {
            new URI(this.urlPath);
        }
        catch (URISyntaxException e) {
            this.log.append("**InvAccess in (").append(this.dataset.getFullName()).append("):\n   urlPath= ").append(this.urlPath).append(")\n  URISyntaxException=").append(e.getMessage());
        }
        return true;
    }

    public String toString() {
        return "service:(" + this.service.getName() + ") path:(" + this.urlPath + ")";
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceType() {
        return this.serviceTypeName;
    }

    public String getDataFormatName() {
        return this.dataFormatName;
    }

    public void setSize(double dataSize) {
        this.dataSize = dataSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvAccessImpl)) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            if (this.urlPath != null) {
                result = 37 * result + this.urlPath.hashCode();
            }
            if (this.service != null) {
                result = 37 * result + this.service.hashCode();
            }
            if (this.hasDataSize()) {
                result = 37 * result + (int)this.getDataSize();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    boolean check(StringBuffer out, boolean show) {
        boolean isValid = true;
        if (this.log.length() > 0) {
            isValid = false;
            out.append(this.log);
        }
        if (this.getService() == null) {
            out.append("**InvAccess in (").append(this.dataset.getFullName()).append("): with urlPath= (").append(this.urlPath).append(") has no valid service\n");
            isValid = false;
        } else if (this.getStandardUrlName() == null) {
            out.append("**InvAccess in (").append(this.dataset.getFullName()).append("): with urlPath= (").append(this.urlPath).append(") has invalid URL\n");
            isValid = false;
        }
        if (show) {
            System.out.println("   access " + this.urlPath + " valid = " + isValid);
        }
        return isValid;
    }
}

