/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.vertical;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VerticalCT;
import ucar.unidata.geoloc.vertical.VerticalTransformImpl;
import ucar.unidata.util.SpecialMathFunction;

public class OceanS
extends VerticalTransformImpl {
    public static final String ETA = "Eta_variableName";
    public static final String S = "S_variableName";
    public static final String DEPTH = "Depth_variableName";
    public static final String DEPTH_C = "Depth_c_variableName";
    public static final String A = "A_variableName";
    public static final String B = "B_variableName";
    private double depth_c;
    private Variable etaVar;
    private Variable sVar;
    private Variable depthVar;
    private Variable aVar;
    private Variable bVar;
    private Variable depthCVar;
    private Array c = null;

    public OceanS(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        super(timeDim);
        String etaName = vCT.findParameterIgnoreCase(ETA).getStringValue();
        String sName = vCT.findParameterIgnoreCase(S).getStringValue();
        String depthName = vCT.findParameterIgnoreCase(DEPTH).getStringValue();
        String aName = vCT.findParameterIgnoreCase(A).getStringValue();
        String bName = vCT.findParameterIgnoreCase(B).getStringValue();
        String depthCName = vCT.findParameterIgnoreCase(DEPTH_C).getStringValue();
        this.etaVar = ds.findStandardVariable(etaName);
        this.sVar = ds.findStandardVariable(sName);
        this.depthVar = ds.findStandardVariable(depthName);
        this.aVar = ds.findStandardVariable(aName);
        this.bVar = ds.findStandardVariable(bName);
        this.depthCVar = ds.findStandardVariable(depthCName);
        this.units = ds.findAttValueIgnoreCase(this.depthVar, "units", "none");
    }

    public ArrayDouble.D3 getCoordinateArray(int timeIndex) throws IOException, InvalidRangeException {
        Array etaArray = this.readArray(this.etaVar, timeIndex);
        Array sArray = this.readArray(this.sVar, timeIndex);
        Array depthArray = this.readArray(this.depthVar, timeIndex);
        if (null == this.c) {
            double a = this.aVar.readScalarDouble();
            double b = this.bVar.readScalarDouble();
            this.depth_c = this.depthCVar.readScalarDouble();
            this.c = this.makeC(sArray, a, b);
        }
        return this.makeHeight(etaArray, sArray, depthArray, this.c, this.depth_c);
    }

    private Array makeC(Array s, double a, double b) {
        int nz = (int)s.getSize();
        Index sIndex = s.getIndex();
        if (a == 0.0) {
            return s;
        }
        ArrayDouble.D1 c = new ArrayDouble.D1(nz);
        double fac1 = 1.0 - b;
        double denom1 = 1.0 / SpecialMathFunction.sinh(a);
        double denom2 = 1.0 / (2.0 * SpecialMathFunction.tanh(0.5 * a));
        for (int i = 0; i < nz; ++i) {
            double sz = s.getDouble(sIndex.set(i));
            double term1 = fac1 * SpecialMathFunction.sinh(a * sz) * denom1;
            double term2 = b * (SpecialMathFunction.tanh(a * (sz + 0.5)) * denom2 - 0.5);
            c.set(i, term1 + term2);
        }
        return c;
    }

    private ArrayDouble.D3 makeHeight(Array eta, Array s, Array depth, Array c, double depth_c) {
        int nz = (int)s.getSize();
        Index sIndex = s.getIndex();
        Index cIndex = c.getIndex();
        int[] shape2D = eta.getShape();
        int ny = shape2D[0];
        int nx = shape2D[1];
        Index etaIndex = eta.getIndex();
        Index depthIndex = depth.getIndex();
        ArrayDouble.D3 height = new ArrayDouble.D3(nz, ny, nx);
        for (int z = 0; z < nz; ++z) {
            double sz = s.getDouble(sIndex.set(z));
            double cz = c.getDouble(cIndex.set(z));
            double fac1 = 1.0 + sz;
            double term2 = depth_c * sz;
            for (int y = 0; y < ny; ++y) {
                for (int x = 0; x < nx; ++x) {
                    double term1 = fac1 * eta.getDouble(etaIndex.set(y, x));
                    double term3 = (depth.getDouble(depthIndex.set(y, x)) - depth_c) * cz;
                    height.set(z, y, x, term1 + term2 + term3);
                }
            }
        }
        return height;
    }
}

