# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SettingsArgs', 'Settings']

@pulumi.input_type
class SettingsArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[str],
                 local_status_page: Optional[pulumi.Input['SettingsLocalStatusPageArgs']] = None,
                 local_status_page_enabled: Optional[pulumi.Input[bool]] = None,
                 named_vlans: Optional[pulumi.Input['SettingsNamedVlansArgs']] = None,
                 remote_status_page_enabled: Optional[pulumi.Input[bool]] = None,
                 secure_port: Optional[pulumi.Input['SettingsSecurePortArgs']] = None):
        """
        The set of arguments for constructing a Settings resource.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input['SettingsLocalStatusPageArgs'] local_status_page: A hash of Local Status page(s)' authentication options applied to the Network.
        :param pulumi.Input[bool] local_status_page_enabled: Enables / disables the local device status pages (\\n\\nmy.meraki.com, \\n\\n\\n\\nap.meraki.com, \\n\\n\\n\\nswitch.meraki.com, \\n\\n\\n\\nwired.meraki.com\\n\\n). Optional (defaults to false)
        :param pulumi.Input['SettingsNamedVlansArgs'] named_vlans: A hash of Named VLANs options applied to the Network.
        :param pulumi.Input[bool] remote_status_page_enabled: Enables / disables access to the device status page (\\n\\nhttp://[device's LAN IP])\\n\\n. Optional. Can only be set if localStatusPageEnabled is set to true
        :param pulumi.Input['SettingsSecurePortArgs'] secure_port: A hash of SecureConnect options applied to the Network.
        """
        pulumi.set(__self__, "network_id", network_id)
        if local_status_page is not None:
            pulumi.set(__self__, "local_status_page", local_status_page)
        if local_status_page_enabled is not None:
            pulumi.set(__self__, "local_status_page_enabled", local_status_page_enabled)
        if named_vlans is not None:
            pulumi.set(__self__, "named_vlans", named_vlans)
        if remote_status_page_enabled is not None:
            pulumi.set(__self__, "remote_status_page_enabled", remote_status_page_enabled)
        if secure_port is not None:
            pulumi.set(__self__, "secure_port", secure_port)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="localStatusPage")
    def local_status_page(self) -> Optional[pulumi.Input['SettingsLocalStatusPageArgs']]:
        """
        A hash of Local Status page(s)' authentication options applied to the Network.
        """
        return pulumi.get(self, "local_status_page")

    @local_status_page.setter
    def local_status_page(self, value: Optional[pulumi.Input['SettingsLocalStatusPageArgs']]):
        pulumi.set(self, "local_status_page", value)

    @property
    @pulumi.getter(name="localStatusPageEnabled")
    def local_status_page_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables / disables the local device status pages (\\n\\nmy.meraki.com, \\n\\n\\n\\nap.meraki.com, \\n\\n\\n\\nswitch.meraki.com, \\n\\n\\n\\nwired.meraki.com\\n\\n). Optional (defaults to false)
        """
        return pulumi.get(self, "local_status_page_enabled")

    @local_status_page_enabled.setter
    def local_status_page_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "local_status_page_enabled", value)

    @property
    @pulumi.getter(name="namedVlans")
    def named_vlans(self) -> Optional[pulumi.Input['SettingsNamedVlansArgs']]:
        """
        A hash of Named VLANs options applied to the Network.
        """
        return pulumi.get(self, "named_vlans")

    @named_vlans.setter
    def named_vlans(self, value: Optional[pulumi.Input['SettingsNamedVlansArgs']]):
        pulumi.set(self, "named_vlans", value)

    @property
    @pulumi.getter(name="remoteStatusPageEnabled")
    def remote_status_page_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables / disables access to the device status page (\\n\\nhttp://[device's LAN IP])\\n\\n. Optional. Can only be set if localStatusPageEnabled is set to true
        """
        return pulumi.get(self, "remote_status_page_enabled")

    @remote_status_page_enabled.setter
    def remote_status_page_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remote_status_page_enabled", value)

    @property
    @pulumi.getter(name="securePort")
    def secure_port(self) -> Optional[pulumi.Input['SettingsSecurePortArgs']]:
        """
        A hash of SecureConnect options applied to the Network.
        """
        return pulumi.get(self, "secure_port")

    @secure_port.setter
    def secure_port(self, value: Optional[pulumi.Input['SettingsSecurePortArgs']]):
        pulumi.set(self, "secure_port", value)


@pulumi.input_type
class _SettingsState:
    def __init__(__self__, *,
                 fips: Optional[pulumi.Input['SettingsFipsArgs']] = None,
                 local_status_page: Optional[pulumi.Input['SettingsLocalStatusPageArgs']] = None,
                 local_status_page_enabled: Optional[pulumi.Input[bool]] = None,
                 named_vlans: Optional[pulumi.Input['SettingsNamedVlansArgs']] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 remote_status_page_enabled: Optional[pulumi.Input[bool]] = None,
                 secure_port: Optional[pulumi.Input['SettingsSecurePortArgs']] = None):
        """
        Input properties used for looking up and filtering Settings resources.
        :param pulumi.Input['SettingsFipsArgs'] fips: A hash of FIPS options applied to the Network
        :param pulumi.Input['SettingsLocalStatusPageArgs'] local_status_page: A hash of Local Status page(s)' authentication options applied to the Network.
        :param pulumi.Input[bool] local_status_page_enabled: Enables / disables the local device status pages (\\n\\nmy.meraki.com, \\n\\n\\n\\nap.meraki.com, \\n\\n\\n\\nswitch.meraki.com, \\n\\n\\n\\nwired.meraki.com\\n\\n). Optional (defaults to false)
        :param pulumi.Input['SettingsNamedVlansArgs'] named_vlans: A hash of Named VLANs options applied to the Network.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[bool] remote_status_page_enabled: Enables / disables access to the device status page (\\n\\nhttp://[device's LAN IP])\\n\\n. Optional. Can only be set if localStatusPageEnabled is set to true
        :param pulumi.Input['SettingsSecurePortArgs'] secure_port: A hash of SecureConnect options applied to the Network.
        """
        if fips is not None:
            pulumi.set(__self__, "fips", fips)
        if local_status_page is not None:
            pulumi.set(__self__, "local_status_page", local_status_page)
        if local_status_page_enabled is not None:
            pulumi.set(__self__, "local_status_page_enabled", local_status_page_enabled)
        if named_vlans is not None:
            pulumi.set(__self__, "named_vlans", named_vlans)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if remote_status_page_enabled is not None:
            pulumi.set(__self__, "remote_status_page_enabled", remote_status_page_enabled)
        if secure_port is not None:
            pulumi.set(__self__, "secure_port", secure_port)

    @property
    @pulumi.getter
    def fips(self) -> Optional[pulumi.Input['SettingsFipsArgs']]:
        """
        A hash of FIPS options applied to the Network
        """
        return pulumi.get(self, "fips")

    @fips.setter
    def fips(self, value: Optional[pulumi.Input['SettingsFipsArgs']]):
        pulumi.set(self, "fips", value)

    @property
    @pulumi.getter(name="localStatusPage")
    def local_status_page(self) -> Optional[pulumi.Input['SettingsLocalStatusPageArgs']]:
        """
        A hash of Local Status page(s)' authentication options applied to the Network.
        """
        return pulumi.get(self, "local_status_page")

    @local_status_page.setter
    def local_status_page(self, value: Optional[pulumi.Input['SettingsLocalStatusPageArgs']]):
        pulumi.set(self, "local_status_page", value)

    @property
    @pulumi.getter(name="localStatusPageEnabled")
    def local_status_page_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables / disables the local device status pages (\\n\\nmy.meraki.com, \\n\\n\\n\\nap.meraki.com, \\n\\n\\n\\nswitch.meraki.com, \\n\\n\\n\\nwired.meraki.com\\n\\n). Optional (defaults to false)
        """
        return pulumi.get(self, "local_status_page_enabled")

    @local_status_page_enabled.setter
    def local_status_page_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "local_status_page_enabled", value)

    @property
    @pulumi.getter(name="namedVlans")
    def named_vlans(self) -> Optional[pulumi.Input['SettingsNamedVlansArgs']]:
        """
        A hash of Named VLANs options applied to the Network.
        """
        return pulumi.get(self, "named_vlans")

    @named_vlans.setter
    def named_vlans(self, value: Optional[pulumi.Input['SettingsNamedVlansArgs']]):
        pulumi.set(self, "named_vlans", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="remoteStatusPageEnabled")
    def remote_status_page_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables / disables access to the device status page (\\n\\nhttp://[device's LAN IP])\\n\\n. Optional. Can only be set if localStatusPageEnabled is set to true
        """
        return pulumi.get(self, "remote_status_page_enabled")

    @remote_status_page_enabled.setter
    def remote_status_page_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "remote_status_page_enabled", value)

    @property
    @pulumi.getter(name="securePort")
    def secure_port(self) -> Optional[pulumi.Input['SettingsSecurePortArgs']]:
        """
        A hash of SecureConnect options applied to the Network.
        """
        return pulumi.get(self, "secure_port")

    @secure_port.setter
    def secure_port(self, value: Optional[pulumi.Input['SettingsSecurePortArgs']]):
        pulumi.set(self, "secure_port", value)


class Settings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 local_status_page: Optional[pulumi.Input[Union['SettingsLocalStatusPageArgs', 'SettingsLocalStatusPageArgsDict']]] = None,
                 local_status_page_enabled: Optional[pulumi.Input[bool]] = None,
                 named_vlans: Optional[pulumi.Input[Union['SettingsNamedVlansArgs', 'SettingsNamedVlansArgsDict']]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 remote_status_page_enabled: Optional[pulumi.Input[bool]] = None,
                 secure_port: Optional[pulumi.Input[Union['SettingsSecurePortArgs', 'SettingsSecurePortArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.Settings("example",
            local_status_page={
                "authentication": {
                    "enabled": False,
                    "password": "miles123",
                },
            },
            local_status_page_enabled=True,
            named_vlans={
                "enabled": True,
            },
            network_id="string",
            remote_status_page_enabled=True,
            secure_port={
                "enabled": False,
            })
        pulumi.export("merakiNetworksSettingsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/settings:Settings example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SettingsLocalStatusPageArgs', 'SettingsLocalStatusPageArgsDict']] local_status_page: A hash of Local Status page(s)' authentication options applied to the Network.
        :param pulumi.Input[bool] local_status_page_enabled: Enables / disables the local device status pages (\\n\\nmy.meraki.com, \\n\\n\\n\\nap.meraki.com, \\n\\n\\n\\nswitch.meraki.com, \\n\\n\\n\\nwired.meraki.com\\n\\n). Optional (defaults to false)
        :param pulumi.Input[Union['SettingsNamedVlansArgs', 'SettingsNamedVlansArgsDict']] named_vlans: A hash of Named VLANs options applied to the Network.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[bool] remote_status_page_enabled: Enables / disables access to the device status page (\\n\\nhttp://[device's LAN IP])\\n\\n. Optional. Can only be set if localStatusPageEnabled is set to true
        :param pulumi.Input[Union['SettingsSecurePortArgs', 'SettingsSecurePortArgsDict']] secure_port: A hash of SecureConnect options applied to the Network.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.Settings("example",
            local_status_page={
                "authentication": {
                    "enabled": False,
                    "password": "miles123",
                },
            },
            local_status_page_enabled=True,
            named_vlans={
                "enabled": True,
            },
            network_id="string",
            remote_status_page_enabled=True,
            secure_port={
                "enabled": False,
            })
        pulumi.export("merakiNetworksSettingsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/settings:Settings example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param SettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 local_status_page: Optional[pulumi.Input[Union['SettingsLocalStatusPageArgs', 'SettingsLocalStatusPageArgsDict']]] = None,
                 local_status_page_enabled: Optional[pulumi.Input[bool]] = None,
                 named_vlans: Optional[pulumi.Input[Union['SettingsNamedVlansArgs', 'SettingsNamedVlansArgsDict']]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 remote_status_page_enabled: Optional[pulumi.Input[bool]] = None,
                 secure_port: Optional[pulumi.Input[Union['SettingsSecurePortArgs', 'SettingsSecurePortArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SettingsArgs.__new__(SettingsArgs)

            __props__.__dict__["local_status_page"] = local_status_page
            __props__.__dict__["local_status_page_enabled"] = local_status_page_enabled
            __props__.__dict__["named_vlans"] = named_vlans
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["remote_status_page_enabled"] = remote_status_page_enabled
            __props__.__dict__["secure_port"] = secure_port
            __props__.__dict__["fips"] = None
        super(Settings, __self__).__init__(
            'meraki:networks/settings:Settings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            fips: Optional[pulumi.Input[Union['SettingsFipsArgs', 'SettingsFipsArgsDict']]] = None,
            local_status_page: Optional[pulumi.Input[Union['SettingsLocalStatusPageArgs', 'SettingsLocalStatusPageArgsDict']]] = None,
            local_status_page_enabled: Optional[pulumi.Input[bool]] = None,
            named_vlans: Optional[pulumi.Input[Union['SettingsNamedVlansArgs', 'SettingsNamedVlansArgsDict']]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            remote_status_page_enabled: Optional[pulumi.Input[bool]] = None,
            secure_port: Optional[pulumi.Input[Union['SettingsSecurePortArgs', 'SettingsSecurePortArgsDict']]] = None) -> 'Settings':
        """
        Get an existing Settings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SettingsFipsArgs', 'SettingsFipsArgsDict']] fips: A hash of FIPS options applied to the Network
        :param pulumi.Input[Union['SettingsLocalStatusPageArgs', 'SettingsLocalStatusPageArgsDict']] local_status_page: A hash of Local Status page(s)' authentication options applied to the Network.
        :param pulumi.Input[bool] local_status_page_enabled: Enables / disables the local device status pages (\\n\\nmy.meraki.com, \\n\\n\\n\\nap.meraki.com, \\n\\n\\n\\nswitch.meraki.com, \\n\\n\\n\\nwired.meraki.com\\n\\n). Optional (defaults to false)
        :param pulumi.Input[Union['SettingsNamedVlansArgs', 'SettingsNamedVlansArgsDict']] named_vlans: A hash of Named VLANs options applied to the Network.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[bool] remote_status_page_enabled: Enables / disables access to the device status page (\\n\\nhttp://[device's LAN IP])\\n\\n. Optional. Can only be set if localStatusPageEnabled is set to true
        :param pulumi.Input[Union['SettingsSecurePortArgs', 'SettingsSecurePortArgsDict']] secure_port: A hash of SecureConnect options applied to the Network.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SettingsState.__new__(_SettingsState)

        __props__.__dict__["fips"] = fips
        __props__.__dict__["local_status_page"] = local_status_page
        __props__.__dict__["local_status_page_enabled"] = local_status_page_enabled
        __props__.__dict__["named_vlans"] = named_vlans
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["remote_status_page_enabled"] = remote_status_page_enabled
        __props__.__dict__["secure_port"] = secure_port
        return Settings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def fips(self) -> pulumi.Output['outputs.SettingsFips']:
        """
        A hash of FIPS options applied to the Network
        """
        return pulumi.get(self, "fips")

    @property
    @pulumi.getter(name="localStatusPage")
    def local_status_page(self) -> pulumi.Output['outputs.SettingsLocalStatusPage']:
        """
        A hash of Local Status page(s)' authentication options applied to the Network.
        """
        return pulumi.get(self, "local_status_page")

    @property
    @pulumi.getter(name="localStatusPageEnabled")
    def local_status_page_enabled(self) -> pulumi.Output[bool]:
        """
        Enables / disables the local device status pages (\\n\\nmy.meraki.com, \\n\\n\\n\\nap.meraki.com, \\n\\n\\n\\nswitch.meraki.com, \\n\\n\\n\\nwired.meraki.com\\n\\n). Optional (defaults to false)
        """
        return pulumi.get(self, "local_status_page_enabled")

    @property
    @pulumi.getter(name="namedVlans")
    def named_vlans(self) -> pulumi.Output['outputs.SettingsNamedVlans']:
        """
        A hash of Named VLANs options applied to the Network.
        """
        return pulumi.get(self, "named_vlans")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="remoteStatusPageEnabled")
    def remote_status_page_enabled(self) -> pulumi.Output[bool]:
        """
        Enables / disables access to the device status page (\\n\\nhttp://[device's LAN IP])\\n\\n. Optional. Can only be set if localStatusPageEnabled is set to true
        """
        return pulumi.get(self, "remote_status_page_enabled")

    @property
    @pulumi.getter(name="securePort")
    def secure_port(self) -> pulumi.Output['outputs.SettingsSecurePort']:
        """
        A hash of SecureConnect options applied to the Network.
        """
        return pulumi.get(self, "secure_port")

