# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['PolicyObjectsGroupsArgs', 'PolicyObjectsGroups']

@pulumi.input_type
class PolicyObjectsGroupsArgs:
    def __init__(__self__, *,
                 organization_id: pulumi.Input[str],
                 category: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 policy_object_group_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a PolicyObjectsGroups resource.
        :param pulumi.Input[str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[str] category: Category of a policy object group (one of: NetworkObjectGroup, GeoLocationGroup, PortObjectGroup, ApplicationGroup)
        :param pulumi.Input[str] name: A name for the group of network addresses, unique within the organization (alphanumeric, space, dash, or underscore characters only)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] object_ids: A list of Policy Object ID's that this NetworkObjectGroup should be associated to (note: these ID's will replace the existing associated Policy Objects)
        :param pulumi.Input[str] policy_object_group_id: policyObjectGroupId path parameter. Policy object group ID
        """
        pulumi.set(__self__, "organization_id", organization_id)
        if category is not None:
            pulumi.set(__self__, "category", category)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if object_ids is not None:
            pulumi.set(__self__, "object_ids", object_ids)
        if policy_object_group_id is not None:
            pulumi.set(__self__, "policy_object_group_id", policy_object_group_id)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        Category of a policy object group (one of: NetworkObjectGroup, GeoLocationGroup, PortObjectGroup, ApplicationGroup)
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for the group of network addresses, unique within the organization (alphanumeric, space, dash, or underscore characters only)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="objectIds")
    def object_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of Policy Object ID's that this NetworkObjectGroup should be associated to (note: these ID's will replace the existing associated Policy Objects)
        """
        return pulumi.get(self, "object_ids")

    @object_ids.setter
    def object_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "object_ids", value)

    @property
    @pulumi.getter(name="policyObjectGroupId")
    def policy_object_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        policyObjectGroupId path parameter. Policy object group ID
        """
        return pulumi.get(self, "policy_object_group_id")

    @policy_object_group_id.setter
    def policy_object_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_object_group_id", value)


@pulumi.input_type
class _PolicyObjectsGroupsState:
    def __init__(__self__, *,
                 category: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 object_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 policy_object_group_id: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering PolicyObjectsGroups resources.
        :param pulumi.Input[str] category: Category of a policy object group (one of: NetworkObjectGroup, GeoLocationGroup, PortObjectGroup, ApplicationGroup)
        :param pulumi.Input[str] name: A name for the group of network addresses, unique within the organization (alphanumeric, space, dash, or underscore characters only)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] object_ids: A list of Policy Object ID's that this NetworkObjectGroup should be associated to (note: these ID's will replace the existing associated Policy Objects)
        :param pulumi.Input[str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[str] policy_object_group_id: policyObjectGroupId path parameter. Policy object group ID
        """
        if category is not None:
            pulumi.set(__self__, "category", category)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_ids is not None:
            pulumi.set(__self__, "network_ids", network_ids)
        if object_ids is not None:
            pulumi.set(__self__, "object_ids", object_ids)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if policy_object_group_id is not None:
            pulumi.set(__self__, "policy_object_group_id", policy_object_group_id)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter
    def category(self) -> Optional[pulumi.Input[str]]:
        """
        Category of a policy object group (one of: NetworkObjectGroup, GeoLocationGroup, PortObjectGroup, ApplicationGroup)
        """
        return pulumi.get(self, "category")

    @category.setter
    def category(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for the group of network addresses, unique within the organization (alphanumeric, space, dash, or underscore characters only)
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkIds")
    def network_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "network_ids")

    @network_ids.setter
    def network_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_ids", value)

    @property
    @pulumi.getter(name="objectIds")
    def object_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of Policy Object ID's that this NetworkObjectGroup should be associated to (note: these ID's will replace the existing associated Policy Objects)
        """
        return pulumi.get(self, "object_ids")

    @object_ids.setter
    def object_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "object_ids", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="policyObjectGroupId")
    def policy_object_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        policyObjectGroupId path parameter. Policy object group ID
        """
        return pulumi.get(self, "policy_object_group_id")

    @policy_object_group_id.setter
    def policy_object_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_object_group_id", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)


class PolicyObjectsGroups(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 policy_object_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.organizations.PolicyObjectsGroups("example",
            category="NetworkObjectGroup",
            name="Web Servers - Datacenter 10",
            object_ids=["100"],
            organization_id="string")
        pulumi.export("merakiOrganizationsPolicyObjectsGroupsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:organizations/policyObjectsGroups:PolicyObjectsGroups example "organization_id,policy_object_group_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] category: Category of a policy object group (one of: NetworkObjectGroup, GeoLocationGroup, PortObjectGroup, ApplicationGroup)
        :param pulumi.Input[str] name: A name for the group of network addresses, unique within the organization (alphanumeric, space, dash, or underscore characters only)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] object_ids: A list of Policy Object ID's that this NetworkObjectGroup should be associated to (note: these ID's will replace the existing associated Policy Objects)
        :param pulumi.Input[str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[str] policy_object_group_id: policyObjectGroupId path parameter. Policy object group ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyObjectsGroupsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.organizations.PolicyObjectsGroups("example",
            category="NetworkObjectGroup",
            name="Web Servers - Datacenter 10",
            object_ids=["100"],
            organization_id="string")
        pulumi.export("merakiOrganizationsPolicyObjectsGroupsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:organizations/policyObjectsGroups:PolicyObjectsGroups example "organization_id,policy_object_group_id"
        ```

        :param str resource_name: The name of the resource.
        :param PolicyObjectsGroupsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyObjectsGroupsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 category: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 object_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 policy_object_group_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyObjectsGroupsArgs.__new__(PolicyObjectsGroupsArgs)

            __props__.__dict__["category"] = category
            __props__.__dict__["name"] = name
            __props__.__dict__["object_ids"] = object_ids
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["policy_object_group_id"] = policy_object_group_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["network_ids"] = None
            __props__.__dict__["updated_at"] = None
        super(PolicyObjectsGroups, __self__).__init__(
            'meraki:organizations/policyObjectsGroups:PolicyObjectsGroups',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            category: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            object_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            organization_id: Optional[pulumi.Input[str]] = None,
            policy_object_group_id: Optional[pulumi.Input[str]] = None,
            updated_at: Optional[pulumi.Input[str]] = None) -> 'PolicyObjectsGroups':
        """
        Get an existing PolicyObjectsGroups resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] category: Category of a policy object group (one of: NetworkObjectGroup, GeoLocationGroup, PortObjectGroup, ApplicationGroup)
        :param pulumi.Input[str] name: A name for the group of network addresses, unique within the organization (alphanumeric, space, dash, or underscore characters only)
        :param pulumi.Input[Sequence[pulumi.Input[str]]] object_ids: A list of Policy Object ID's that this NetworkObjectGroup should be associated to (note: these ID's will replace the existing associated Policy Objects)
        :param pulumi.Input[str] organization_id: organizationId path parameter. Organization ID
        :param pulumi.Input[str] policy_object_group_id: policyObjectGroupId path parameter. Policy object group ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyObjectsGroupsState.__new__(_PolicyObjectsGroupsState)

        __props__.__dict__["category"] = category
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["name"] = name
        __props__.__dict__["network_ids"] = network_ids
        __props__.__dict__["object_ids"] = object_ids
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["policy_object_group_id"] = policy_object_group_id
        __props__.__dict__["updated_at"] = updated_at
        return PolicyObjectsGroups(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def category(self) -> pulumi.Output[str]:
        """
        Category of a policy object group (one of: NetworkObjectGroup, GeoLocationGroup, PortObjectGroup, ApplicationGroup)
        """
        return pulumi.get(self, "category")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A name for the group of network addresses, unique within the organization (alphanumeric, space, dash, or underscore characters only)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkIds")
    def network_ids(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "network_ids")

    @property
    @pulumi.getter(name="objectIds")
    def object_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of Policy Object ID's that this NetworkObjectGroup should be associated to (note: these ID's will replace the existing associated Policy Objects)
        """
        return pulumi.get(self, "object_ids")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="policyObjectGroupId")
    def policy_object_group_id(self) -> pulumi.Output[str]:
        """
        policyObjectGroupId path parameter. Policy object group ID
        """
        return pulumi.get(self, "policy_object_group_id")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "updated_at")

