# Pyrogram - Telegram MTProto API Client Library for Python
# Copyright (C) 2017-2019 Dan Tès <https://github.com/delivrance>
#
# This file is part of Pyrogram.
#
# Pyrogram is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published
# by the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Pyrogram is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with Pyrogram.  If not, see <http://www.gnu.org/licenses/>.

from io import BytesIO

from pyrogram.api.core import *


class ReplyKeyboardForceReply(TLObject):
    """Attributes:
        LAYER: ``102``

    Attributes:
        ID: ``0xf4108aa0``

    Parameters:
        single_use (optional): ``bool``
        selective (optional): ``bool``
    """

    __slots__ = ["single_use", "selective"]

    ID = 0xf4108aa0
    QUALNAME = "types.ReplyKeyboardForceReply"

    def __init__(self, *, single_use: bool = None, selective: bool = None):
        self.single_use = single_use  # flags.1?true
        self.selective = selective  # flags.2?true

    @staticmethod
    def read(b: BytesIO, *args) -> "ReplyKeyboardForceReply":
        flags = Int.read(b)
        
        single_use = True if flags & (1 << 1) else False
        selective = True if flags & (1 << 2) else False
        return ReplyKeyboardForceReply(single_use=single_use, selective=selective)

    def write(self) -> bytes:
        b = BytesIO()
        b.write(Int(self.ID, False))

        flags = 0
        flags |= (1 << 1) if self.single_use is not None else 0
        flags |= (1 << 2) if self.selective is not None else 0
        b.write(Int(flags))
        
        return b.getvalue()
