"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .amount_nullable import AmountNullable, AmountNullableTypedDict
from .balance_transaction_type import BalanceTransactionType
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PaymentTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]


class Payment(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None


class CaptureTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    capture_id: NotRequired[str]
    capture_description: NotRequired[str]


class Capture(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    capture_id: Annotated[Optional[str], pydantic.Field(alias="captureId")] = None

    capture_description: Annotated[
        Optional[str], pydantic.Field(alias="captureDescription")
    ] = None


class CaptureCommisionTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    capture_id: NotRequired[str]
    capture_description: NotRequired[str]


class CaptureCommision(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    capture_id: Annotated[Optional[str], pydantic.Field(alias="captureId")] = None

    capture_description: Annotated[
        Optional[str], pydantic.Field(alias="captureDescription")
    ] = None


class CaptureRollingReserveReleaseTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    capture_id: NotRequired[str]
    capture_description: NotRequired[str]


class CaptureRollingReserveRelease(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    capture_id: Annotated[Optional[str], pydantic.Field(alias="captureId")] = None

    capture_description: Annotated[
        Optional[str], pydantic.Field(alias="captureDescription")
    ] = None


class UnauthorizedDirectDebitTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]


class UnauthorizedDirectDebit(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None


class FailedPaymentTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]


class FailedPayment(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None


class RefundTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    refund_id: NotRequired[str]
    refund_description: NotRequired[str]


class Refund(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    refund_id: Annotated[Optional[str], pydantic.Field(alias="refundId")] = None

    refund_description: Annotated[
        Optional[str], pydantic.Field(alias="refundDescription")
    ] = None


class RefundCompensationTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    refund_id: NotRequired[str]
    refund_description: NotRequired[str]


class RefundCompensation(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    refund_id: Annotated[Optional[str], pydantic.Field(alias="refundId")] = None

    refund_description: Annotated[
        Optional[str], pydantic.Field(alias="refundDescription")
    ] = None


class ReturnedRefundTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    refund_id: NotRequired[str]
    refund_description: NotRequired[str]


class ReturnedRefund(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    refund_id: Annotated[Optional[str], pydantic.Field(alias="refundId")] = None

    refund_description: Annotated[
        Optional[str], pydantic.Field(alias="refundDescription")
    ] = None


class ReturnedRefundCompensationTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    refund_id: NotRequired[str]
    refund_description: NotRequired[str]


class ReturnedRefundCompensation(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    refund_id: Annotated[Optional[str], pydantic.Field(alias="refundId")] = None

    refund_description: Annotated[
        Optional[str], pydantic.Field(alias="refundDescription")
    ] = None


class ChargebackTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    chargeback_id: NotRequired[str]
    chargeback_description: NotRequired[str]


class Chargeback(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    chargeback_id: Annotated[Optional[str], pydantic.Field(alias="chargebackId")] = None

    chargeback_description: Annotated[
        Optional[str], pydantic.Field(alias="chargebackDescription")
    ] = None


class ChargebackReversalTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    chargeback_id: NotRequired[str]
    chargeback_description: NotRequired[str]


class ChargebackReversal(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    chargeback_id: Annotated[Optional[str], pydantic.Field(alias="chargebackId")] = None

    chargeback_description: Annotated[
        Optional[str], pydantic.Field(alias="chargebackDescription")
    ] = None


class ChargebackCompensationTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    chargeback_id: NotRequired[str]
    chargeback_description: NotRequired[str]


class ChargebackCompensation(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    chargeback_id: Annotated[Optional[str], pydantic.Field(alias="chargebackId")] = None

    chargeback_description: Annotated[
        Optional[str], pydantic.Field(alias="chargebackDescription")
    ] = None


class ReversedChargebackCompensationTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    chargeback_id: NotRequired[str]
    chargeback_description: NotRequired[str]


class ReversedChargebackCompensation(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    chargeback_id: Annotated[Optional[str], pydantic.Field(alias="chargebackId")] = None

    chargeback_description: Annotated[
        Optional[str], pydantic.Field(alias="chargebackDescription")
    ] = None


class OutgoingTransferTypedDict(TypedDict):
    transfer_id: NotRequired[str]
    settlement_id: NotRequired[str]


class OutgoingTransfer(BaseModel):
    transfer_id: Annotated[Optional[str], pydantic.Field(alias="transferId")] = None

    settlement_id: Annotated[Optional[str], pydantic.Field(alias="settlementId")] = None


class CanceledOutgoingTransferTypedDict(TypedDict):
    transfer_id: NotRequired[str]
    settlement_id: NotRequired[str]


class CanceledOutgoingTransfer(BaseModel):
    transfer_id: Annotated[Optional[str], pydantic.Field(alias="transferId")] = None

    settlement_id: Annotated[Optional[str], pydantic.Field(alias="settlementId")] = None


class ReturnedTransferTypedDict(TypedDict):
    transfer_id: NotRequired[str]
    settlement_id: NotRequired[str]


class ReturnedTransfer(BaseModel):
    transfer_id: Annotated[Optional[str], pydantic.Field(alias="transferId")] = None

    settlement_id: Annotated[Optional[str], pydantic.Field(alias="settlementId")] = None


class InvoiceCompensationTypedDict(TypedDict):
    invoice_id: NotRequired[str]


class InvoiceCompensation(BaseModel):
    invoice_id: Annotated[Optional[str], pydantic.Field(alias="invoiceId")] = None


class EntityBalanceTransactionApplicationFeeTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    paying_owner: NotRequired[str]


class EntityBalanceTransactionApplicationFee(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    paying_owner: Annotated[Optional[str], pydantic.Field(alias="payingOwner")] = None


class SplitPaymentTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    payment_onwer: NotRequired[str]


class SplitPayment(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    payment_onwer: Annotated[Optional[str], pydantic.Field(alias="paymentOnwer")] = None


class PlatformPaymentRefundTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    refund_id: NotRequired[str]
    refund_description: NotRequired[str]


class PlatformPaymentRefund(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    refund_id: Annotated[Optional[str], pydantic.Field(alias="refundId")] = None

    refund_description: Annotated[
        Optional[str], pydantic.Field(alias="refundDescription")
    ] = None


class ReturnedPlatformPaymentRefundTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    refund_id: NotRequired[str]
    refund_description: NotRequired[str]


class ReturnedPlatformPaymentRefund(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    refund_id: Annotated[Optional[str], pydantic.Field(alias="refundId")] = None

    refund_description: Annotated[
        Optional[str], pydantic.Field(alias="refundDescription")
    ] = None


class PlatformPaymentChargebackTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    chargeback_id: NotRequired[str]
    chargeback_description: NotRequired[str]


class PlatformPaymentChargeback(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    chargeback_id: Annotated[Optional[str], pydantic.Field(alias="chargebackId")] = None

    chargeback_description: Annotated[
        Optional[str], pydantic.Field(alias="chargebackDescription")
    ] = None


class ReversedPlatformPaymentChargebackTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    chargeback_id: NotRequired[str]
    chargeback_description: NotRequired[str]


class ReversedPlatformPaymentChargeback(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    chargeback_id: Annotated[Optional[str], pydantic.Field(alias="chargebackId")] = None

    chargeback_description: Annotated[
        Optional[str], pydantic.Field(alias="chargebackDescription")
    ] = None


class PaymentCommissionTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]
    organization_id: NotRequired[str]


class PaymentCommission(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None

    organization_id: Annotated[
        Optional[str], pydantic.Field(alias="organizationId")
    ] = None


class ReimbursementFeeTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]


class ReimbursementFee(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None


class FailedPaymentFeeTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]


class FailedPaymentFee(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None


class PaymentFeeTypedDict(TypedDict):
    payment_id: NotRequired[str]
    payment_description: NotRequired[str]


class PaymentFee(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None

    payment_description: Annotated[
        Optional[str], pydantic.Field(alias="paymentDescription")
    ] = None


class ManagedFeeTypedDict(TypedDict):
    fee_type: NotRequired[str]
    fee_id: NotRequired[str]


class ManagedFee(BaseModel):
    fee_type: Annotated[Optional[str], pydantic.Field(alias="feeType")] = None

    fee_id: Annotated[Optional[str], pydantic.Field(alias="feeId")] = None


class ReturnedManagedFeeTypedDict(TypedDict):
    fee_type: NotRequired[str]
    fee_id: NotRequired[str]


class ReturnedManagedFee(BaseModel):
    fee_type: Annotated[Optional[str], pydantic.Field(alias="feeType")] = None

    fee_id: Annotated[Optional[str], pydantic.Field(alias="feeId")] = None


class PostPaymentSplitPaymentTypedDict(TypedDict):
    payment_id: NotRequired[str]


class PostPaymentSplitPayment(BaseModel):
    payment_id: Annotated[Optional[str], pydantic.Field(alias="paymentId")] = None


class ContextTypedDict(TypedDict):
    r"""Depending on the type of the balance transaction, we will try to give more context about the specific event that
    triggered it. For example, the context object for a payment transaction will look like
    `{\"paymentId\": \"tr_5B8cwPMGnU6qLbRvo7qEZo\", \"paymentDescription\": \"Description\"}`.

    Below is a complete list of the context values that each type of transaction will have.

    * Type `payment`: `paymentId`, `paymentDescription`
    * Type `capture`: `paymentId` `captureId`, `paymentDescription`, `captureDescription`
    * Type `capture-commission`: `paymentId`, `paymentDescription`, `organizationId`
    * Type `capture-rolling-reserve-release`: `paymentId`, `paymentDescription`, `captureId`, `captureDescription`
    * Type `unauthorized-direct-debit`: `paymentId`, `paymentDescription`
    * Type `failed-payment`: `paymentId`, `paymentDescription`
    * Type `refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `refund-compensation`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `returned-refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `returned-refund-compensation`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `chargeback`: `paymentId` `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `chargeback-reversal`: `paymentId`, `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `chargeback-compensation`: `paymentId`, `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `reversed-chargeback-compensation`: `paymentId`, `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `outgoing-transfer`: `settlementId` `transferId`
    * Type `canceled-outgoing-transfer`: `settlementId` `transferId`
    * Type `returned-transfer`: `settlementId` `transferId`
    * Type `invoice-compensation`: `invoiceId`
    * Type `balance-correction`: none
    * Type `application-fee`: `paymentId`, `paymentDescription`, `payingOwner`
    * Type `split-payment`: `paymentId`, `paymentDescription`, `paymentOwner`
    * Type `platform-payment-refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `returned-platform-payment-refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `platform-payment-chargeback`: `paymentId` `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `reversed-platform-payment-chargeback`: `paymentId` `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `payment-commission`: `paymentId`, `paymentDescription`, `organizationId`
    * Type `reimbursement-fee`: `paymentId`, `paymentDescription`
    * Type `failed-payment-fee`: `paymentId`, `paymentDescription`
    * Type `payment-fee`: `paymentId`, `paymentDescription`
    * Type `cash-advance-loan`: none
    * Type `platform-connected-organizations-fee`: none
    * Type `managed-fee`: `feeType`, `<name of the fee>Id`
    * Type `returned-managed-fee`:  `feeType`, `<name of the fee>Id`
    * Type `topup`: none
    * Type `balance-reserve`: none
    * Type `balance-reserve-return`: none
    * Type `movement`: none
    * Type `post-payment-split-payment`: `paymentId`
    * Type `cash-collateral-issuance`: none
    * Type `cash-collateral-release`: none
    """

    payment: NotRequired[Nullable[PaymentTypedDict]]
    capture: NotRequired[Nullable[CaptureTypedDict]]
    capture_commision: NotRequired[Nullable[CaptureCommisionTypedDict]]
    capture_rolling_reserve_release: NotRequired[
        Nullable[CaptureRollingReserveReleaseTypedDict]
    ]
    unauthorized_direct_debit: NotRequired[Nullable[UnauthorizedDirectDebitTypedDict]]
    failed_payment: NotRequired[Nullable[FailedPaymentTypedDict]]
    refund: NotRequired[Nullable[RefundTypedDict]]
    refund_compensation: NotRequired[Nullable[RefundCompensationTypedDict]]
    returned_refund: NotRequired[Nullable[ReturnedRefundTypedDict]]
    returned_refund_compensation: NotRequired[
        Nullable[ReturnedRefundCompensationTypedDict]
    ]
    chargeback: NotRequired[Nullable[ChargebackTypedDict]]
    chargeback_reversal: NotRequired[Nullable[ChargebackReversalTypedDict]]
    chargeback_compensation: NotRequired[Nullable[ChargebackCompensationTypedDict]]
    reversed_chargeback_compensation: NotRequired[
        Nullable[ReversedChargebackCompensationTypedDict]
    ]
    outgoing_transfer: NotRequired[Nullable[OutgoingTransferTypedDict]]
    canceled_outgoing_transfer: NotRequired[Nullable[CanceledOutgoingTransferTypedDict]]
    returned_transfer: NotRequired[Nullable[ReturnedTransferTypedDict]]
    invoice_compensation: NotRequired[Nullable[InvoiceCompensationTypedDict]]
    application_fee: NotRequired[
        Nullable[EntityBalanceTransactionApplicationFeeTypedDict]
    ]
    split_payment: NotRequired[Nullable[SplitPaymentTypedDict]]
    platform_payment_refund: NotRequired[Nullable[PlatformPaymentRefundTypedDict]]
    returned_platform_payment_refund: NotRequired[
        Nullable[ReturnedPlatformPaymentRefundTypedDict]
    ]
    platform_payment_chargeback: NotRequired[
        Nullable[PlatformPaymentChargebackTypedDict]
    ]
    reversed_platform_payment_chargeback: NotRequired[
        Nullable[ReversedPlatformPaymentChargebackTypedDict]
    ]
    payment_commission: NotRequired[Nullable[PaymentCommissionTypedDict]]
    reimbursement_fee: NotRequired[Nullable[ReimbursementFeeTypedDict]]
    failed_payment_fee: NotRequired[Nullable[FailedPaymentFeeTypedDict]]
    payment_fee: NotRequired[Nullable[PaymentFeeTypedDict]]
    managed_fee: NotRequired[Nullable[ManagedFeeTypedDict]]
    returned_managed_fee: NotRequired[Nullable[ReturnedManagedFeeTypedDict]]
    post_payment_split_payment: NotRequired[Nullable[PostPaymentSplitPaymentTypedDict]]


class Context(BaseModel):
    r"""Depending on the type of the balance transaction, we will try to give more context about the specific event that
    triggered it. For example, the context object for a payment transaction will look like
    `{\"paymentId\": \"tr_5B8cwPMGnU6qLbRvo7qEZo\", \"paymentDescription\": \"Description\"}`.

    Below is a complete list of the context values that each type of transaction will have.

    * Type `payment`: `paymentId`, `paymentDescription`
    * Type `capture`: `paymentId` `captureId`, `paymentDescription`, `captureDescription`
    * Type `capture-commission`: `paymentId`, `paymentDescription`, `organizationId`
    * Type `capture-rolling-reserve-release`: `paymentId`, `paymentDescription`, `captureId`, `captureDescription`
    * Type `unauthorized-direct-debit`: `paymentId`, `paymentDescription`
    * Type `failed-payment`: `paymentId`, `paymentDescription`
    * Type `refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `refund-compensation`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `returned-refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `returned-refund-compensation`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `chargeback`: `paymentId` `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `chargeback-reversal`: `paymentId`, `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `chargeback-compensation`: `paymentId`, `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `reversed-chargeback-compensation`: `paymentId`, `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `outgoing-transfer`: `settlementId` `transferId`
    * Type `canceled-outgoing-transfer`: `settlementId` `transferId`
    * Type `returned-transfer`: `settlementId` `transferId`
    * Type `invoice-compensation`: `invoiceId`
    * Type `balance-correction`: none
    * Type `application-fee`: `paymentId`, `paymentDescription`, `payingOwner`
    * Type `split-payment`: `paymentId`, `paymentDescription`, `paymentOwner`
    * Type `platform-payment-refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `returned-platform-payment-refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `platform-payment-chargeback`: `paymentId` `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `reversed-platform-payment-chargeback`: `paymentId` `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `payment-commission`: `paymentId`, `paymentDescription`, `organizationId`
    * Type `reimbursement-fee`: `paymentId`, `paymentDescription`
    * Type `failed-payment-fee`: `paymentId`, `paymentDescription`
    * Type `payment-fee`: `paymentId`, `paymentDescription`
    * Type `cash-advance-loan`: none
    * Type `platform-connected-organizations-fee`: none
    * Type `managed-fee`: `feeType`, `<name of the fee>Id`
    * Type `returned-managed-fee`:  `feeType`, `<name of the fee>Id`
    * Type `topup`: none
    * Type `balance-reserve`: none
    * Type `balance-reserve-return`: none
    * Type `movement`: none
    * Type `post-payment-split-payment`: `paymentId`
    * Type `cash-collateral-issuance`: none
    * Type `cash-collateral-release`: none
    """

    payment: OptionalNullable[Payment] = UNSET

    capture: OptionalNullable[Capture] = UNSET

    capture_commision: Annotated[
        OptionalNullable[CaptureCommision], pydantic.Field(alias="capture-commision")
    ] = UNSET

    capture_rolling_reserve_release: Annotated[
        OptionalNullable[CaptureRollingReserveRelease],
        pydantic.Field(alias="capture-rolling-reserve-release"),
    ] = UNSET

    unauthorized_direct_debit: Annotated[
        OptionalNullable[UnauthorizedDirectDebit],
        pydantic.Field(alias="unauthorized-direct-debit"),
    ] = UNSET

    failed_payment: Annotated[
        OptionalNullable[FailedPayment], pydantic.Field(alias="failed-payment")
    ] = UNSET

    refund: OptionalNullable[Refund] = UNSET

    refund_compensation: Annotated[
        OptionalNullable[RefundCompensation],
        pydantic.Field(alias="refund-compensation"),
    ] = UNSET

    returned_refund: Annotated[
        OptionalNullable[ReturnedRefund], pydantic.Field(alias="returned-refund")
    ] = UNSET

    returned_refund_compensation: Annotated[
        OptionalNullable[ReturnedRefundCompensation],
        pydantic.Field(alias="returned-refund-compensation"),
    ] = UNSET

    chargeback: OptionalNullable[Chargeback] = UNSET

    chargeback_reversal: Annotated[
        OptionalNullable[ChargebackReversal],
        pydantic.Field(alias="chargeback-reversal"),
    ] = UNSET

    chargeback_compensation: Annotated[
        OptionalNullable[ChargebackCompensation],
        pydantic.Field(alias="chargeback-compensation"),
    ] = UNSET

    reversed_chargeback_compensation: Annotated[
        OptionalNullable[ReversedChargebackCompensation],
        pydantic.Field(alias="reversed-chargeback-compensation"),
    ] = UNSET

    outgoing_transfer: Annotated[
        OptionalNullable[OutgoingTransfer], pydantic.Field(alias="outgoing-transfer")
    ] = UNSET

    canceled_outgoing_transfer: Annotated[
        OptionalNullable[CanceledOutgoingTransfer],
        pydantic.Field(alias="canceled-outgoing-transfer"),
    ] = UNSET

    returned_transfer: Annotated[
        OptionalNullable[ReturnedTransfer], pydantic.Field(alias="returned-transfer")
    ] = UNSET

    invoice_compensation: Annotated[
        OptionalNullable[InvoiceCompensation],
        pydantic.Field(alias="invoice-compensation"),
    ] = UNSET

    application_fee: Annotated[
        OptionalNullable[EntityBalanceTransactionApplicationFee],
        pydantic.Field(alias="application-fee"),
    ] = UNSET

    split_payment: Annotated[
        OptionalNullable[SplitPayment], pydantic.Field(alias="split-payment")
    ] = UNSET

    platform_payment_refund: Annotated[
        OptionalNullable[PlatformPaymentRefund],
        pydantic.Field(alias="platform-payment-refund"),
    ] = UNSET

    returned_platform_payment_refund: Annotated[
        OptionalNullable[ReturnedPlatformPaymentRefund],
        pydantic.Field(alias="returned-platform-payment-refund"),
    ] = UNSET

    platform_payment_chargeback: Annotated[
        OptionalNullable[PlatformPaymentChargeback],
        pydantic.Field(alias="platform-payment-chargeback"),
    ] = UNSET

    reversed_platform_payment_chargeback: Annotated[
        OptionalNullable[ReversedPlatformPaymentChargeback],
        pydantic.Field(alias="reversed-platform-payment-chargeback"),
    ] = UNSET

    payment_commission: Annotated[
        OptionalNullable[PaymentCommission], pydantic.Field(alias="payment-commission")
    ] = UNSET

    reimbursement_fee: Annotated[
        OptionalNullable[ReimbursementFee], pydantic.Field(alias="reimbursement-fee")
    ] = UNSET

    failed_payment_fee: Annotated[
        OptionalNullable[FailedPaymentFee], pydantic.Field(alias="failed-payment-fee")
    ] = UNSET

    payment_fee: Annotated[
        OptionalNullable[PaymentFee], pydantic.Field(alias="payment-fee")
    ] = UNSET

    managed_fee: Annotated[
        OptionalNullable[ManagedFee], pydantic.Field(alias="managed-fee")
    ] = UNSET

    returned_managed_fee: Annotated[
        OptionalNullable[ReturnedManagedFee],
        pydantic.Field(alias="returned-managed-fee"),
    ] = UNSET

    post_payment_split_payment: Annotated[
        OptionalNullable[PostPaymentSplitPayment],
        pydantic.Field(alias="post-payment-split-payment"),
    ] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "payment",
            "capture",
            "capture-commision",
            "capture-rolling-reserve-release",
            "unauthorized-direct-debit",
            "failed-payment",
            "refund",
            "refund-compensation",
            "returned-refund",
            "returned-refund-compensation",
            "chargeback",
            "chargeback-reversal",
            "chargeback-compensation",
            "reversed-chargeback-compensation",
            "outgoing-transfer",
            "canceled-outgoing-transfer",
            "returned-transfer",
            "invoice-compensation",
            "application-fee",
            "split-payment",
            "platform-payment-refund",
            "returned-platform-payment-refund",
            "platform-payment-chargeback",
            "reversed-platform-payment-chargeback",
            "payment-commission",
            "reimbursement-fee",
            "failed-payment-fee",
            "payment-fee",
            "managed-fee",
            "returned-managed-fee",
            "post-payment-split-payment",
        ]
        nullable_fields = [
            "payment",
            "capture",
            "capture-commision",
            "capture-rolling-reserve-release",
            "unauthorized-direct-debit",
            "failed-payment",
            "refund",
            "refund-compensation",
            "returned-refund",
            "returned-refund-compensation",
            "chargeback",
            "chargeback-reversal",
            "chargeback-compensation",
            "reversed-chargeback-compensation",
            "outgoing-transfer",
            "canceled-outgoing-transfer",
            "returned-transfer",
            "invoice-compensation",
            "application-fee",
            "split-payment",
            "platform-payment-refund",
            "returned-platform-payment-refund",
            "platform-payment-chargeback",
            "reversed-platform-payment-chargeback",
            "payment-commission",
            "reimbursement-fee",
            "failed-payment-fee",
            "payment-fee",
            "managed-fee",
            "returned-managed-fee",
            "post-payment-split-payment",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EntityBalanceTransactionTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a balance transaction object. Will always contain the string `balance-transaction`
    for this endpoint.
    """
    id: str
    type: BalanceTransactionType
    result_amount: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    initial_amount: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    deductions: NotRequired[Nullable[AmountNullableTypedDict]]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    context: NotRequired[ContextTypedDict]
    r"""Depending on the type of the balance transaction, we will try to give more context about the specific event that
    triggered it. For example, the context object for a payment transaction will look like
    `{\"paymentId\": \"tr_5B8cwPMGnU6qLbRvo7qEZo\", \"paymentDescription\": \"Description\"}`.

    Below is a complete list of the context values that each type of transaction will have.

    * Type `payment`: `paymentId`, `paymentDescription`
    * Type `capture`: `paymentId` `captureId`, `paymentDescription`, `captureDescription`
    * Type `capture-commission`: `paymentId`, `paymentDescription`, `organizationId`
    * Type `capture-rolling-reserve-release`: `paymentId`, `paymentDescription`, `captureId`, `captureDescription`
    * Type `unauthorized-direct-debit`: `paymentId`, `paymentDescription`
    * Type `failed-payment`: `paymentId`, `paymentDescription`
    * Type `refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `refund-compensation`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `returned-refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `returned-refund-compensation`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `chargeback`: `paymentId` `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `chargeback-reversal`: `paymentId`, `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `chargeback-compensation`: `paymentId`, `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `reversed-chargeback-compensation`: `paymentId`, `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `outgoing-transfer`: `settlementId` `transferId`
    * Type `canceled-outgoing-transfer`: `settlementId` `transferId`
    * Type `returned-transfer`: `settlementId` `transferId`
    * Type `invoice-compensation`: `invoiceId`
    * Type `balance-correction`: none
    * Type `application-fee`: `paymentId`, `paymentDescription`, `payingOwner`
    * Type `split-payment`: `paymentId`, `paymentDescription`, `paymentOwner`
    * Type `platform-payment-refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `returned-platform-payment-refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `platform-payment-chargeback`: `paymentId` `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `reversed-platform-payment-chargeback`: `paymentId` `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `payment-commission`: `paymentId`, `paymentDescription`, `organizationId`
    * Type `reimbursement-fee`: `paymentId`, `paymentDescription`
    * Type `failed-payment-fee`: `paymentId`, `paymentDescription`
    * Type `payment-fee`: `paymentId`, `paymentDescription`
    * Type `cash-advance-loan`: none
    * Type `platform-connected-organizations-fee`: none
    * Type `managed-fee`: `feeType`, `<name of the fee>Id`
    * Type `returned-managed-fee`:  `feeType`, `<name of the fee>Id`
    * Type `topup`: none
    * Type `balance-reserve`: none
    * Type `balance-reserve-return`: none
    * Type `movement`: none
    * Type `post-payment-split-payment`: `paymentId`
    * Type `cash-collateral-issuance`: none
    * Type `cash-collateral-release`: none
    """


class EntityBalanceTransaction(BaseModel):
    resource: str
    r"""Indicates the response contains a balance transaction object. Will always contain the string `balance-transaction`
    for this endpoint.
    """

    id: str

    type: Annotated[BalanceTransactionType, PlainValidator(validate_open_enum(False))]

    result_amount: Annotated[Amount, pydantic.Field(alias="resultAmount")]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    initial_amount: Annotated[Amount, pydantic.Field(alias="initialAmount")]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    deductions: OptionalNullable[AmountNullable] = UNSET
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    context: Optional[Context] = None
    r"""Depending on the type of the balance transaction, we will try to give more context about the specific event that
    triggered it. For example, the context object for a payment transaction will look like
    `{\"paymentId\": \"tr_5B8cwPMGnU6qLbRvo7qEZo\", \"paymentDescription\": \"Description\"}`.

    Below is a complete list of the context values that each type of transaction will have.

    * Type `payment`: `paymentId`, `paymentDescription`
    * Type `capture`: `paymentId` `captureId`, `paymentDescription`, `captureDescription`
    * Type `capture-commission`: `paymentId`, `paymentDescription`, `organizationId`
    * Type `capture-rolling-reserve-release`: `paymentId`, `paymentDescription`, `captureId`, `captureDescription`
    * Type `unauthorized-direct-debit`: `paymentId`, `paymentDescription`
    * Type `failed-payment`: `paymentId`, `paymentDescription`
    * Type `refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `refund-compensation`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `returned-refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `returned-refund-compensation`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `chargeback`: `paymentId` `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `chargeback-reversal`: `paymentId`, `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `chargeback-compensation`: `paymentId`, `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `reversed-chargeback-compensation`: `paymentId`, `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `outgoing-transfer`: `settlementId` `transferId`
    * Type `canceled-outgoing-transfer`: `settlementId` `transferId`
    * Type `returned-transfer`: `settlementId` `transferId`
    * Type `invoice-compensation`: `invoiceId`
    * Type `balance-correction`: none
    * Type `application-fee`: `paymentId`, `paymentDescription`, `payingOwner`
    * Type `split-payment`: `paymentId`, `paymentDescription`, `paymentOwner`
    * Type `platform-payment-refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `returned-platform-payment-refund`: `paymentId` `refundId`, `paymentDescription`, `refundDescription`
    * Type `platform-payment-chargeback`: `paymentId` `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `reversed-platform-payment-chargeback`: `paymentId` `chargebackId`, `paymentDescription`, `chargebackDescription`
    * Type `payment-commission`: `paymentId`, `paymentDescription`, `organizationId`
    * Type `reimbursement-fee`: `paymentId`, `paymentDescription`
    * Type `failed-payment-fee`: `paymentId`, `paymentDescription`
    * Type `payment-fee`: `paymentId`, `paymentDescription`
    * Type `cash-advance-loan`: none
    * Type `platform-connected-organizations-fee`: none
    * Type `managed-fee`: `feeType`, `<name of the fee>Id`
    * Type `returned-managed-fee`:  `feeType`, `<name of the fee>Id`
    * Type `topup`: none
    * Type `balance-reserve`: none
    * Type `balance-reserve-return`: none
    * Type `movement`: none
    * Type `post-payment-split-payment`: `paymentId`
    * Type `cash-collateral-issuance`: none
    * Type `cash-collateral-release`: none
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["deductions", "context"]
        nullable_fields = ["deductions"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
