"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .mode import Mode
from .route_destination_type_response import RouteDestinationTypeResponse
from .url import URL, URLTypedDict
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing_extensions import Annotated, NotRequired, TypedDict


class EntityPaymentRouteResponseDestinationTypedDict(TypedDict):
    r"""The destination of this portion of the payment."""

    type: RouteDestinationTypeResponse
    r"""The type of destination. Currently only the destination type `organization` is supported."""
    organization_id: str


class EntityPaymentRouteResponseDestination(BaseModel):
    r"""The destination of this portion of the payment."""

    type: Annotated[
        RouteDestinationTypeResponse, PlainValidator(validate_open_enum(False))
    ]
    r"""The type of destination. Currently only the destination type `organization` is supported."""

    organization_id: Annotated[str, pydantic.Field(alias="organizationId")]


class EntityPaymentRouteResponseLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payment: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityPaymentRouteResponseLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[URL, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payment: URL
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityPaymentRouteResponseTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a route object. Will always contain the string `route` for this endpoint."""
    id: str
    mode: Mode
    r"""Whether this entity was created in live mode or in test mode."""
    amount: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    destination: EntityPaymentRouteResponseDestinationTypedDict
    r"""The destination of this portion of the payment."""
    created_at: str
    r"""The date and time when the route was created. The date is given in ISO 8601 format."""
    links: EntityPaymentRouteResponseLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    release_date: NotRequired[Nullable[str]]
    r"""Optionally, schedule this portion of the payment to be transferred to its destination on a later date. The
    date must be given in `YYYY-MM-DD` format.

    If no date is given, the funds become available to the connected merchant as soon as the payment succeeds.
    """


class EntityPaymentRouteResponse(BaseModel):
    resource: str
    r"""Indicates the response contains a route object. Will always contain the string `route` for this endpoint."""

    id: str

    mode: Annotated[Mode, PlainValidator(validate_open_enum(False))]
    r"""Whether this entity was created in live mode or in test mode."""

    amount: Amount
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    destination: EntityPaymentRouteResponseDestination
    r"""The destination of this portion of the payment."""

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The date and time when the route was created. The date is given in ISO 8601 format."""

    links: Annotated[EntityPaymentRouteResponseLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    release_date: Annotated[
        OptionalNullable[str], pydantic.Field(alias="releaseDate")
    ] = UNSET
    r"""Optionally, schedule this portion of the payment to be transferred to its destination on a later date. The
    date must be given in `YYYY-MM-DD` format.

    If no date is given, the funds become available to the connected merchant as soon as the payment succeeds.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["releaseDate"]
        nullable_fields = ["releaseDate"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
