"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .payment_method import PaymentMethod
from enum import Enum
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SubTotalsCardIssuer(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class SubTotalsCardAudience(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class SubTotalsCardRegion(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class SubTotalsFeeType(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class SubTotalsPrepaymentPartType(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class SubTotalsTransactionType(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class SubTotalsTypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[PaymentMethod]]
    r"""The payment method, if applicable"""
    card_issuer: NotRequired[Nullable[SubTotalsCardIssuer]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[SubTotalsCardAudience]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[SubTotalsCardRegion]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[SubTotalsFeeType]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[Nullable[SubTotalsPrepaymentPartType]]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[SubTotalsTransactionType]]
    r"""Represents the transaction type"""


class SubTotals(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: Annotated[
        OptionalNullable[PaymentMethod], PlainValidator(validate_open_enum(False))
    ] = UNSET
    r"""The payment method, if applicable"""

    card_issuer: Annotated[
        OptionalNullable[SubTotalsCardIssuer], pydantic.Field(alias="cardIssuer")
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[SubTotalsCardAudience], pydantic.Field(alias="cardAudience")
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[SubTotalsCardRegion], pydantic.Field(alias="cardRegion")
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[SubTotalsFeeType], pydantic.Field(alias="feeType")
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[SubTotalsPrepaymentPartType],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[SubTotalsTransactionType],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
