import * as assets from '@aws-cdk/assets';
import * as ecr from '@aws-cdk/aws-ecr';
import { Construct as CoreConstruct } from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * (experimental) Options for DockerImageAsset.
 *
 * @experimental
 */
export interface DockerImageAssetOptions extends assets.FingerprintOptions {
    /**
     * (deprecated) ECR repository name.
     *
     * Specify this property if you need to statically address the image, e.g.
     * from a Kubernetes Pod. Note, this is only the repository name, without the
     * registry and the tag parts.
     *
     * @default - the default ECR repository for CDK assets
     * @deprecated to control the location of docker image assets, please override
     * `Stack.addDockerImageAsset`. this feature will be removed in future
     * releases.
     */
    readonly repositoryName?: string;
    /**
     * (experimental) Build args to pass to the `docker build` command.
     *
     * Since Docker build arguments are resolved before deployment, keys and
     * values cannot refer to unresolved tokens (such as `lambda.functionArn` or
     * `queue.queueUrl`).
     *
     * @default - no build args are passed
     * @experimental
     */
    readonly buildArgs?: {
        [key: string]: string;
    };
    /**
     * (experimental) Docker target to build to.
     *
     * @default - no target
     * @experimental
     */
    readonly target?: string;
    /**
     * (experimental) Path to the Dockerfile (relative to the directory).
     *
     * @default 'Dockerfile'
     * @experimental
     */
    readonly file?: string;
}
/**
 * (experimental) Props for DockerImageAssets.
 *
 * @experimental
 */
export interface DockerImageAssetProps extends DockerImageAssetOptions {
    /**
     * (experimental) The directory where the Dockerfile is stored.
     *
     * @experimental
     */
    readonly directory: string;
}
/**
 * (experimental) An asset that represents a Docker image.
 *
 * The image will be created in build time and uploaded to an ECR repository.
 *
 * @experimental
 */
export declare class DockerImageAsset extends CoreConstruct implements assets.IAsset {
    /**
     * (experimental) The full URI of the image (including a tag).
     *
     * Use this reference to pull
     * the asset.
     *
     * @experimental
     */
    imageUri: string;
    /**
     * (experimental) Repository where the image is stored.
     *
     * @experimental
     */
    repository: ecr.IRepository;
    /**
     * (experimental) (deprecated) A hash of the source of this asset, which is available at construction time.
     *
     * As this is a plain
     * string, it can be used in construct IDs in order to enforce creation of a new resource when
     * the content hash has changed.
     *
     * @experimental
     */
    readonly sourceHash: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: DockerImageAssetProps);
}
